/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.uploadslots;

import com.aelitis.azureus.core.peermanager.control.PeerControlInstance;
import com.aelitis.azureus.core.peermanager.control.PeerControlSchedulerFactory;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadHelper;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSession;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSessionPicker;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSlot;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class UploadSlotManager {
    private static final int EXPIRE_NORMAL = 1;
    private static final int EXPIRE_OPTIMISTIC = 3;
    private static final int EXPIRE_SEED = 6;
    public static boolean AUTO_SLOT_ENABLE = false;
    private long last_process_time;
    private static final UploadSlotManager instance = new UploadSlotManager();
    private final UploadSessionPicker picker = new UploadSessionPicker();
    private final UploadSlot[] slots = new UploadSlot[]{new UploadSlot(1), new UploadSlot(0), new UploadSlot(0), new UploadSlot(0)};
    private long current_round = 0L;
    int count = 0;

    public static UploadSlotManager getSingleton() {
        return instance;
    }

    private UploadSlotManager() {
        if (AUTO_SLOT_ENABLE) {
            System.out.println("UPLOAD_SLOT_MANAGER SCHEDULAR STARTED");
            PeerControlSchedulerFactory.getSingleton().register(new PeerControlInstance(){

                public void schedule() {
                    long now = SystemTime.getCurrentTime();
                    if (now - UploadSlotManager.this.last_process_time >= 10000L) {
                        UploadSlotManager.this.process();
                        UploadSlotManager.this.last_process_time = now;
                    } else if (UploadSlotManager.this.last_process_time > now) {
                        Debug.out("OOPS, time went backwards!");
                        UploadSlotManager.this.last_process_time = now;
                    }
                }

                public int getSchedulePriority() {
                    return 0;
                }
            });
        }
    }

    public void registerHelper(UploadHelper helper) {
        if (AUTO_SLOT_ENABLE) {
            this.picker.registerHelper(helper);
        }
    }

    public void deregisterHelper(UploadHelper helper) {
        if (AUTO_SLOT_ENABLE) {
            this.picker.deregisterHelper(helper);
        }
    }

    public void updateHelper(UploadHelper helper) {
        if (AUTO_SLOT_ENABLE) {
            this.picker.updateHelper(helper);
        }
    }

    private void process() {
        if (!AUTO_SLOT_ENABLE) {
            return;
        }
        ++this.current_round;
        ArrayList<UploadSession> to_stop = new ArrayList<UploadSession>();
        LinkedList best_sessions = this.picker.pickBestDownloadSessions(this.slots.length);
        int best_size = best_sessions.size();
        for (int i = 0; i < this.slots.length; ++i) {
            UploadSlot slot = this.slots[i];
            if (slot.getExpireRound() > this.current_round) continue;
            UploadSession session = slot.getSession();
            if (session != null) {
                to_stop.add(session);
                slot.setSession(null);
            }
            if (slot.getSlotType() == 1) {
                session = this.pickOptSession();
                if (session == null) continue;
                if (session.getSessionType() == 1) {
                    best_sessions.addFirst(session);
                    session = this.pickOptSession();
                    if (session == null) continue;
                }
                slot.setSession(session);
                slot.setExpireRound(this.current_round + 3L);
                continue;
            }
            session = this.getNextBestSession(best_sessions);
            if (session == null && best_size == this.slots.length) {
                Debug.out("session == null && best_size == slots.length");
            }
            if (session == null && (session = this.pickOptSession()) == null) continue;
            slot.setSession(session);
            slot.setExpireRound(this.current_round + (long)(session.getSessionType() == 1 ? 6 : 1));
        }
        Iterator it = to_stop.iterator();
        block1: while (it.hasNext()) {
            UploadSession stop_s = (UploadSession)it.next();
            for (int i = 0; i < this.slots.length; ++i) {
                if (!stop_s.isSameSession(this.slots[i].getSession())) continue;
                it.remove();
                continue block1;
            }
        }
        for (UploadSession session : to_stop) {
            session.stop();
        }
        for (int i = 0; i < this.slots.length; ++i) {
            UploadSession s = this.slots[i].getSession();
            if (s == null) continue;
            s.start();
        }
        this.printSlotStats();
    }

    private UploadSession getNextBestSession(LinkedList best) {
        ++this.count;
        System.out.print("getNextBestSession [" + this.count + "] best.size=" + best.size() + "  ");
        if (!best.isEmpty()) {
            UploadSession session = (UploadSession)best.removeFirst();
            if (!this.isAlreadySlotted(session)) {
                System.out.println("OK found session [" + session.getStatsTrace() + "]");
                return session;
            }
            System.out.println("FAIL already-slotted session [" + session.getStatsTrace() + "]");
            return this.getNextBestSession(best);
        }
        return null;
    }

    private UploadSession pickOptSession() {
        int max = this.picker.getHelperCount();
        for (int i = 0; i < max; ++i) {
            UploadSession session = this.picker.pickNextOptimisticSession();
            if (session == null || this.isAlreadySlotted(session)) continue;
            return session;
        }
        return null;
    }

    private boolean isAlreadySlotted(UploadSession session) {
        for (int i = 0; i < this.slots.length; ++i) {
            UploadSession s = this.slots[i].getSession();
            if (s == null || !s.isSameSession(session)) continue;
            return true;
        }
        return false;
    }

    private void printSlotStats() {
        System.out.println("\nUPLOAD SLOTS [" + this.current_round + "x]:");
        for (int i = 0; i < this.slots.length; ++i) {
            UploadSlot slot = this.slots[i];
            System.out.print("[" + i + "]: ");
            String slot_type = slot.getSlotType() == 0 ? "NORM" : "OPTI";
            long rem = slot.getExpireRound() - this.current_round;
            String remaining = rem < 0L ? "" : " [" + rem + "]rr";
            String ses_trace = slot.getSession() == null ? "EMPTY" : slot.getSession().getStatsTrace();
            System.out.println(slot_type + remaining + " : " + ses_trace);
        }
    }
}

