/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

public class SubscriptionResultFilter {
    String[] textFilters;
    String[] excludeTextFilters;
    String regexFilter;
    long minSeeds = -1L;
    long minSize = -1L;
    long maxSize = -1L;
    String categoryFilter = null;

    public String getString() {
        String res = this.addString("", "+", this.getString(this.textFilters));
        res = this.addString(res, "-", this.getString(this.excludeTextFilters));
        res = this.addString(res, "regex=", this.regexFilter);
        res = this.addString(res, "cat=", this.categoryFilter);
        return res;
    }

    private String addString(String existing, String key, String rest) {
        if (rest == null || rest.length() == 0) {
            return existing;
        }
        String str = key + rest;
        if (existing == null || existing.length() == 0) {
            return str;
        }
        return existing + "," + str;
    }

    private String getString(String[] strs) {
        String res = "";
        for (int i = 0; i < strs.length; ++i) {
            res = res + (i == 0 ? "" : "&") + strs[i];
        }
        return res;
    }

    public SubscriptionResultFilter(Map filters) {
        try {
            this.textFilters = this.importStrings(filters, "text_filter", " ");
            this.excludeTextFilters = this.importStrings(filters, "text_filter_out", " ");
            this.regexFilter = ImportExportUtils.importString(filters, "text_filter_regex");
            this.minSize = ImportExportUtils.importLong(filters, "min_size", -1L);
            this.maxSize = ImportExportUtils.importLong(filters, "max_size", -1L);
            this.minSeeds = ImportExportUtils.importLong(filters, "min_seeds", -1L);
            String rawCategory = ImportExportUtils.importString(filters, "category");
            if (rawCategory != null) {
                this.categoryFilter = rawCategory.toLowerCase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String[] importStrings(Map filters, String key, String separator) throws IOException {
        String rawStringFilter = ImportExportUtils.importString(filters, key);
        if (rawStringFilter != null) {
            StringTokenizer st = new StringTokenizer(rawStringFilter, separator);
            String[] stringFilter = new String[st.countTokens()];
            for (int i = 0; i < stringFilter.length; ++i) {
                stringFilter[i] = st.nextToken().toLowerCase();
            }
            return stringFilter;
        }
        return new String[0];
    }

    public Result[] filter(Result[] results) {
        ArrayList<Result> filteredResults = new ArrayList<Result>(results.length);
        for (int i = 0; i < results.length; ++i) {
            String category;
            int j;
            Result result = results[i];
            String name = result.getName();
            if (name == null) continue;
            name = name.toLowerCase();
            boolean valid = true;
            for (j = 0; j < this.textFilters.length; ++j) {
                if (name.indexOf(this.textFilters[j]) != -1) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            for (j = 0; j < this.excludeTextFilters.length; ++j) {
                if (name.indexOf(this.excludeTextFilters[j]) == -1) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            long size = result.getSize();
            if (this.minSize > -1L && this.minSize > size || this.maxSize > -1L && this.maxSize < size || this.minSeeds > -1L && this.minSeeds < (long)result.getNbSeeds() || this.categoryFilter != null && ((category = result.getCategory()) == null || !category.equalsIgnoreCase(this.categoryFilter))) continue;
            filteredResults.add(result);
        }
        Result[] fResults = filteredResults.toArray(new Result[filteredResults.size()]);
        return fResults;
    }
}

