/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.average;

import com.aelitis.azureus.core.util.average.Average;

public class MovingImmediateAverage
implements Average {
    private final int periods;
    private double[] data;
    private int pos = 0;

    public MovingImmediateAverage(int periods) {
        this.periods = periods;
        this.data = new double[periods];
        for (int i = 0; i < periods; ++i) {
            this.data[i] = 0.0;
        }
    }

    public void reset() {
        this.pos = 0;
    }

    public double update(double newValue) {
        this.data[this.pos++ % this.periods] = newValue;
        if (this.pos == Integer.MAX_VALUE) {
            this.pos %= this.periods;
        }
        return this.calculateAve();
    }

    public double[] getValues() {
        double[] res = new double[this.periods];
        int p = this.pos;
        for (int i = 0; i < this.periods; ++i) {
            res[i] = this.data[p++ % this.periods];
        }
        return res;
    }

    public double getAverage() {
        return this.calculateAve();
    }

    private double calculateAve() {
        double sum = 0.0;
        int lim = this.pos > this.periods ? this.periods : this.pos;
        for (int i = 0; i < lim; ++i) {
            sum += this.data[i];
        }
        return sum / (double)lim;
    }
}

