/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.bloom.impl;

import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.impl.BloomFilterAddRemove8Bit;
import java.util.Random;

public abstract class BloomFilterImpl
implements BloomFilter {
    private static final int HASH_NUM = 5;
    private static final int a2 = 2;
    private static final int a3 = 3;
    private static final int a4 = 5;
    private static final int b2 = 51;
    private static final int b3 = 145;
    private static final int b4 = 216;
    private int max_entries;
    private int entry_count;

    public BloomFilterImpl(int _max_entries) {
        this.max_entries = _max_entries / 2 * 2 + 1;
    }

    protected int getMaxEntries() {
        return this.max_entries;
    }

    public int add(byte[] value) {
        return this.add(this.bytesToInteger(value));
    }

    public int remove(byte[] value) {
        return this.remove(this.bytesToInteger(value));
    }

    public int count(byte[] value) {
        return this.count(this.bytesToInteger(value));
    }

    public boolean contains(byte[] value) {
        return this.contains(this.bytesToInteger(value));
    }

    protected int add(int value) {
        int count = 65535;
        for (int i = 0; i < 5; ++i) {
            int index = this.getHash(i, value);
            int v = this.incValue(index);
            if (v >= count) continue;
            count = v;
        }
        if (count == 0) {
            ++this.entry_count;
        }
        return this.trimValue(count + 1);
    }

    protected int remove(int value) {
        int count = 65535;
        for (int i = 0; i < 5; ++i) {
            int index = this.getHash(i, value);
            int v = this.decValue(index);
            if (v >= count) continue;
            count = v;
        }
        if (count == 1 && this.entry_count > 0) {
            --this.entry_count;
        }
        return this.trimValue(count - 1);
    }

    protected int count(int value) {
        int count = 65535;
        for (int i = 0; i < 5; ++i) {
            int index = this.getHash(i, value);
            int v = this.getValue(index);
            if (v >= count) continue;
            count = v;
        }
        return count;
    }

    protected boolean contains(int value) {
        for (int i = 0; i < 5; ++i) {
            int index = this.getHash(i, value);
            int v = this.getValue(index);
            if (v != 0) continue;
            return false;
        }
        return true;
    }

    protected abstract int getValue(int var1);

    protected abstract int incValue(int var1);

    protected abstract int decValue(int var1);

    protected abstract int trimValue(int var1);

    protected int getHash(int function, int value) {
        long res;
        switch (function) {
            case 0: {
                res = value;
                break;
            }
            case 1: {
                res = value * value;
                break;
            }
            case 2: {
                res = value * 2 + 51;
                break;
            }
            case 3: {
                res = value * 3 + 145;
                break;
            }
            case 4: {
                res = value * 5 + 216;
                break;
            }
            default: {
                System.out.println("**** BloomFilter hash function doesn't exist ****");
                res = 0L;
            }
        }
        return Math.abs((int)res % this.max_entries);
    }

    protected int bytesToInteger(byte[] data) {
        int res = 1375186049;
        for (int i = 0; i < data.length; ++i) {
            res = res * 191 + (data[i] & 0xFF);
        }
        return res;
    }

    public int getEntryCount() {
        return this.entry_count;
    }

    public int getSize() {
        return this.max_entries;
    }

    protected static byte[] getSerialization(byte[] address, int port) {
        byte[] full_address = new byte[address.length + 2];
        System.arraycopy(address, 0, full_address, 0, address.length);
        full_address[address.length] = (byte)(port >> 8);
        full_address[address.length + 1] = (byte)(port & 0xFF);
        return full_address;
    }

    public String getString() {
        return "ent=" + this.entry_count + ",max=" + this.max_entries;
    }

    public static void main(String[] args) {
        Random rand = new Random();
        int fp_count = 0;
        for (int j = 0; j < 1000; ++j) {
            long start = System.currentTimeMillis();
            BloomFilterAddRemove8Bit b = new BloomFilterAddRemove8Bit(10000);
            int fp = 0;
            for (int i = 0; i < 1000; ++i) {
                byte[] key = new byte[6];
                rand.nextBytes(key);
                if (i % 2 == 0) {
                    b.add(key);
                    if (b.contains(key)) continue;
                    System.out.println("false negative on add!!!!");
                    continue;
                }
                if (!b.contains(key)) continue;
                ++fp;
            }
            System.out.println("" + (System.currentTimeMillis() - start) + ", fp = " + fp);
            if (fp <= 0) continue;
            ++fp_count;
        }
        System.out.println(fp_count);
    }
}

