/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.bloom.impl;

import com.aelitis.azureus.core.util.bloom.BloomFilter;

public class BloomFilterRotator
implements BloomFilter {
    private volatile BloomFilter current_filter;
    private int current_filter_index;
    private final BloomFilter[] filters;

    public BloomFilterRotator(BloomFilter _target, int _num) {
        this.filters = new BloomFilter[_num];
        this.filters[0] = _target;
        for (int i = 1; i < this.filters.length; ++i) {
            this.filters[i] = _target.getReplica();
        }
        this.current_filter = _target;
        this.current_filter_index = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(byte[] value) {
        BloomFilter[] bloomFilterArray = this.filters;
        synchronized (this.filters) {
            int update_chunk;
            int num_to_update;
            int filter_size = this.current_filter.getSize();
            int filter_entries = this.current_filter.getEntryCount();
            int limit = filter_size / 8;
            if (filter_entries > limit) {
                filter_entries = limit;
            }
            if ((num_to_update = filter_entries / (update_chunk = limit / this.filters.length) + 1) > this.filters.length) {
                num_to_update = this.filters.length;
            }
            int res = 0;
            for (int i = this.current_filter_index; i < this.current_filter_index + num_to_update; ++i) {
                int r = this.filters[i % this.filters.length].add(value);
                if (i != this.current_filter_index) continue;
                res = r;
            }
            if (this.current_filter.getEntryCount() > limit) {
                this.filters[this.current_filter_index] = this.current_filter.getReplica();
                this.current_filter_index = (this.current_filter_index + 1) % this.filters.length;
                this.current_filter = this.filters[this.current_filter_index];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return res;
        }
    }

    public int remove(byte[] value) {
        int res = 0;
        for (int i = 0; i < this.filters.length; ++i) {
            BloomFilter filter = this.filters[i];
            int r = filter.remove(value);
            if (filter != this.current_filter) continue;
            res = r;
        }
        return res;
    }

    public boolean contains(byte[] value) {
        return this.current_filter.contains(value);
    }

    public int count(byte[] value) {
        return this.current_filter.count(value);
    }

    public int getEntryCount() {
        return this.current_filter.getEntryCount();
    }

    public int getSize() {
        return this.current_filter.getSize();
    }

    public BloomFilter getReplica() {
        return new BloomFilterRotator(this.current_filter, this.filters.length);
    }

    public String getString() {
        return "ind=" + this.current_filter_index + ",filt=" + this.current_filter.getString();
    }
}

