/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl.getright;

import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReaderFactory;
import com.aelitis.azureus.plugins.extseed.impl.getright.ExternalSeedReaderGetRight;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;

public class ExternalSeedReaderFactoryGetRight
implements ExternalSeedReaderFactory {
    public ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, Download download) {
        Torrent torrent = download.getTorrent();
        try {
            HashMap<String, Object> config = new HashMap<String, Object>();
            Object obj = torrent.getAdditionalProperty("url-list");
            if (obj != null) {
                config.put("url-list", obj);
            }
            return this.getSeedReaders(plugin, download, config);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new ExternalSeedReader[0];
        }
    }

    public ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, Download download, Map config) {
        try {
            Object obj = config.get("url-list");
            if (obj instanceof byte[]) {
                ArrayList l = new ArrayList();
                l.add(obj);
                obj = l;
            }
            if (obj instanceof List) {
                List urls = (List)obj;
                ArrayList<ExternalSeedReaderGetRight> readers = new ArrayList<ExternalSeedReaderGetRight>();
                Object _params = config.get("url-list-params");
                Map params = _params instanceof Map ? (Map)_params : new HashMap();
                for (int i = 0; i < urls.size(); ++i) {
                    try {
                        String url_str = new String((byte[])urls.get(i));
                        url_str = url_str.replaceAll(" ", "%20");
                        URL url = new URL(url_str);
                        String protocol = url.getProtocol().toLowerCase();
                        if (protocol.equals("http")) {
                            readers.add(new ExternalSeedReaderGetRight(plugin, download.getTorrent(), url, params));
                            continue;
                        }
                        plugin.log(download.getName() + ": GR unsupported protocol: " + url);
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                ExternalSeedReader[] res = new ExternalSeedReader[readers.size()];
                readers.toArray(res);
                return res;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return new ExternalSeedReader[0];
    }

    public static void main(String[] args) {
        try {
            COConfigurationManager.preInitialise();
            File file = new File("C:\\temp\\httpseed.torrent");
            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedFile(file);
            Map map = torrent.serialiseToMap();
            ArrayList<String> urls = new ArrayList<String>();
            urls.add("http://127.0.0.1:888/files/%DF%26%5B7w%C9%13I%88%8D%EC%E5b%2C9%0F%8D%0Co%BC/");
            map.put("url-list", urls);
            HashMap params = new HashMap();
            map.put("url-list-params", params);
            torrent = TOTorrentFactory.deserialiseFromMap(map);
            torrent.serialiseToBEncodedFile(file);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

