/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessage;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessageListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyReplyListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginException;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginPasswordException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class BuddyPluginBuddyMessageHandler {
    private BuddyPluginBuddy buddy;
    private File store;
    private Map config_map;
    private int message_count;
    private int pending_deletes;
    private int next_message_id;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private BuddyPluginBuddyMessage active_message;
    private long last_failure;
    private long last_pending_success;

    protected BuddyPluginBuddyMessageHandler(BuddyPluginBuddy _buddy, File _store) {
        this.buddy = _buddy;
        this.store = _store;
        this.loadConfig();
        if (this.message_count > 0) {
            this.buddy.persistentDispatchPending();
        }
    }

    public BuddyPluginBuddy getBuddy() {
        return this.buddy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuddyPluginBuddyMessage queueMessage(int subsystem, Map content, int timeout_millis) throws BuddyPluginException {
        boolean dispatch_pending;
        BuddyPluginBuddyMessage message;
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            int id = this.next_message_id++;
            message = new BuddyPluginBuddyMessage(this, id, subsystem, content, timeout_millis, SystemTime.getCurrentTime());
            this.storeMessage(message);
            dispatch_pending = this.message_count == 1;
        }
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((BuddyPluginBuddyMessageListener)it.next()).messageQueued(message);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (dispatch_pending) {
            this.buddy.persistentDispatchPending();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPersistentDispatch() {
        boolean request_dispatch = false;
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            long now = SystemTime.getCurrentTime();
            if (now < this.last_failure) {
                this.last_failure = now;
            }
            if (now < this.last_pending_success) {
                this.last_pending_success = now;
            }
            if (this.last_pending_success > 0L && now - this.last_pending_success >= 300000L) {
                request_dispatch = true;
            } else if (this.active_message == null && this.message_count != 0 && this.last_failure != 0L) {
                request_dispatch = now - this.last_failure >= 300000L;
            }
        }
        if (request_dispatch) {
            this.buddy.persistentDispatchPending();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistentDispatch() {
        this.checkPendingSuccess();
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            if (this.active_message != null || this.message_count == 0) {
                return;
            }
            List messages = (List)this.config_map.get("messages");
            Map map = (Map)messages.get(0);
            try {
                this.active_message = this.restoreMessage(map);
            }
            catch (Throwable e) {
                Debug.out("Failed to restore message, deleting it", e);
                messages.remove(0);
                try {
                    this.saveConfig();
                }
                catch (Throwable f) {
                    this.buddy.log("Config save failed during delete of bad message", f);
                }
            }
        }
        boolean request_ok = false;
        try {
            Map request2 = this.active_message.getRequest();
            request_ok = true;
            this.buddy.sendMessage(this.active_message.getSubsystem(), request2, this.active_message.getTimeout(), new BuddyPluginBuddyReplyListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void replyReceived(BuddyPluginBuddy from_buddy, Map reply) {
                    boolean messages_queued;
                    BuddyPluginBuddyMessageHandler e2;
                    BuddyPluginBuddyMessage message = BuddyPluginBuddyMessageHandler.this.active_message;
                    Iterator it = BuddyPluginBuddyMessageHandler.this.listeners.iterator();
                    boolean processing_ok = true;
                    try {
                        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = BuddyPluginBuddyMessageHandler.this;
                        synchronized (buddyPluginBuddyMessageHandler) {
                            BuddyPluginBuddyMessageHandler.this.pending_deletes++;
                        }
                        while (it.hasNext()) {
                            try {
                                if (((BuddyPluginBuddyMessageListener)it.next()).deliverySucceeded(message, reply)) continue;
                                processing_ok = false;
                            }
                            catch (Throwable e2) {
                                Debug.printStackTrace(e2);
                            }
                        }
                    }
                    finally {
                        e2 = BuddyPluginBuddyMessageHandler.this;
                        synchronized (e2) {
                            BuddyPluginBuddyMessageHandler.this.pending_deletes--;
                        }
                    }
                    if (processing_ok) {
                        message.delete();
                    } else {
                        e2 = BuddyPluginBuddyMessageHandler.this;
                        synchronized (e2) {
                            boolean found = false;
                            List messages = (List)BuddyPluginBuddyMessageHandler.this.config_map.get("messages");
                            if (messages != null) {
                                for (int i = 0; i < messages.size(); ++i) {
                                    Map msg = (Map)messages.get(i);
                                    if (message.getID() != ((Long)msg.get("id")).intValue()) continue;
                                    found = true;
                                    messages.remove(i);
                                    try {
                                        BuddyPluginBuddyMessageHandler.this.writeReply(message, reply);
                                        ArrayList<Map> pending_success = (ArrayList<Map>)BuddyPluginBuddyMessageHandler.this.config_map.get("pending_success");
                                        if (pending_success == null) {
                                            pending_success = new ArrayList<Map>();
                                            BuddyPluginBuddyMessageHandler.this.config_map.put("pending_success", pending_success);
                                        }
                                        pending_success.add(msg);
                                        BuddyPluginBuddyMessageHandler.this.last_pending_success = SystemTime.getCurrentTime();
                                        BuddyPluginBuddyMessageHandler.this.buddy.log("Message moved to pending success queue after listener failed");
                                        BuddyPluginBuddyMessageHandler.this.saveConfig();
                                    }
                                    catch (Throwable e3) {
                                        BuddyPluginBuddyMessageHandler.this.buddy.log("Config save failed during message pending queueing", e3);
                                    }
                                    break;
                                }
                            }
                            if (!found) {
                                BuddyPluginBuddyMessageHandler.this.buddy.log("Failed to find message " + message.getID());
                            }
                        }
                    }
                    BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = BuddyPluginBuddyMessageHandler.this;
                    synchronized (buddyPluginBuddyMessageHandler) {
                        BuddyPluginBuddyMessageHandler.this.active_message = null;
                        messages_queued = BuddyPluginBuddyMessageHandler.this.message_count > 0;
                        BuddyPluginBuddyMessageHandler.this.last_failure = 0L;
                    }
                    if (messages_queued) {
                        BuddyPluginBuddyMessageHandler.this.buddy.persistentDispatchPending();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void sendFailed(BuddyPluginBuddy to_buddy, BuddyPluginException cause) {
                    BuddyPluginBuddyMessage message = BuddyPluginBuddyMessageHandler.this.active_message;
                    BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = BuddyPluginBuddyMessageHandler.this;
                    synchronized (buddyPluginBuddyMessageHandler) {
                        BuddyPluginBuddyMessageHandler.this.active_message = null;
                        BuddyPluginBuddyMessageHandler.this.last_failure = SystemTime.getCurrentTime();
                    }
                    BuddyPluginBuddyMessageHandler.this.reportFailed(message, cause, true);
                }
            });
        }
        catch (Throwable cause) {
            BuddyPluginBuddyMessage message = this.active_message;
            BuddyPluginBuddyMessageHandler e = this;
            synchronized (e) {
                this.active_message = null;
                this.last_failure = SystemTime.getCurrentTime();
            }
            boolean do_subsequent = true;
            if (!request_ok && !(cause instanceof BuddyPluginPasswordException)) {
                this.buddy.logMessage("Message request unavailable, deleting message");
                message.delete();
                boolean messages_queued = false;
                BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler2 = this;
                synchronized (buddyPluginBuddyMessageHandler2) {
                    this.last_failure = 0L;
                    messages_queued = this.message_count > 0;
                }
                if (messages_queued) {
                    do_subsequent = false;
                    this.buddy.persistentDispatchPending();
                }
            }
            this.reportFailed(message, cause, do_subsequent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportFailed(BuddyPluginBuddyMessage message, Throwable cause, boolean do_subsequent) {
        BuddyPluginException b_cause = cause instanceof BuddyPluginException ? (BuddyPluginException)cause : new BuddyPluginException("Failed to send message", cause);
        this.reportFailedSupport(message, b_cause);
        if (do_subsequent) {
            ArrayList<BuddyPluginBuddyMessage> other_messages = new ArrayList<BuddyPluginBuddyMessage>();
            BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
            synchronized (buddyPluginBuddyMessageHandler) {
                List messages = (List)this.config_map.get("messages");
                for (int i = 0; i < messages.size(); ++i) {
                    try {
                        BuddyPluginBuddyMessage msg = this.restoreMessage((Map)messages.get(i));
                        if (msg.getID() == message.getID()) continue;
                        other_messages.add(msg);
                        continue;
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
            if (other_messages.size() > 0) {
                BuddyPluginException o_cause = new BuddyPluginException("Reporting probable failure to subsequent messages");
                for (int i = 0; i < other_messages.size(); ++i) {
                    this.reportFailedSupport((BuddyPluginBuddyMessage)other_messages.get(i), o_cause);
                }
            }
        }
    }

    protected void reportFailedSupport(BuddyPluginBuddyMessage message, BuddyPluginException cause) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((BuddyPluginBuddyMessageListener)it.next()).deliveryFailed(message, cause);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPendingSuccess() {
        this.last_pending_success = 0L;
        ArrayList<BuddyPluginBuddyMessage> pending_messages = new ArrayList<BuddyPluginBuddyMessage>();
        boolean save_pending = false;
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            List pending_success = (List)this.config_map.get("pending_success");
            if (pending_success == null || pending_success.size() == 0) {
                return;
            }
            Iterator it = pending_success.iterator();
            while (it.hasNext()) {
                Map map = (Map)it.next();
                try {
                    pending_messages.add(this.restoreMessage(map));
                }
                catch (Throwable e) {
                    this.buddy.log("Failed to restore message from pending success queue", e);
                    it.remove();
                    save_pending = true;
                }
            }
        }
        for (int i = 0; i < pending_messages.size(); ++i) {
            BuddyPluginBuddyMessage message = (BuddyPluginBuddyMessage)pending_messages.get(i);
            try {
                Map reply = message.getReply();
                Iterator it = this.listeners.iterator();
                boolean processing_ok = true;
                while (it.hasNext()) {
                    try {
                        if (((BuddyPluginBuddyMessageListener)it.next()).deliverySucceeded(message, reply)) continue;
                        processing_ok = false;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                if (processing_ok) {
                    message.delete();
                    continue;
                }
                BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler2 = this;
                synchronized (buddyPluginBuddyMessageHandler2) {
                    this.last_pending_success = SystemTime.getCurrentTime();
                    continue;
                }
            }
            catch (BuddyPluginPasswordException e) {
                this.buddy.log("Failed to restore message reply", e);
                continue;
            }
            catch (Throwable e) {
                this.buddy.log("Failed to restore message reply - deleting message", e);
                message.delete();
            }
        }
        if (save_pending) {
            try {
                this.saveConfig();
            }
            catch (Throwable e) {
                this.buddy.log("Save failed during pending success processing", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount() {
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            return this.message_count - this.pending_deletes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteMessage(BuddyPluginBuddyMessage message) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((BuddyPluginBuddyMessageListener)it.next()).messageDeleted(message);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            String[] keys = new String[]{"messages", "pending_success", "explicit"};
            for (int i = 0; i < keys.length; ++i) {
                List messages = (List)this.config_map.get(keys[i]);
                if (messages == null) continue;
                boolean found = false;
                for (int j = 0; j < messages.size(); ++j) {
                    Map msg = (Map)messages.get(j);
                    if (message.getID() != ((Long)msg.get("id")).intValue()) continue;
                    messages.remove(j);
                    found = true;
                    break;
                }
                if (!found) continue;
                this.deleteRequest(message);
                this.deleteReply(message);
                try {
                    this.saveConfig();
                }
                catch (Throwable e) {
                    this.buddy.log("Config save failed during message delete", e);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            this.config_map.clear();
            try {
                this.saveConfig();
            }
            catch (Throwable e) {
                this.buddy.log("Config save failed during destroy", e);
            }
        }
    }

    protected void writeRequest(BuddyPluginBuddyMessage message, Map content) throws BuddyPluginException {
        this.writeContent(message.getID() + ".req.dat", content);
    }

    protected Map readRequest(BuddyPluginBuddyMessage message) throws BuddyPluginException {
        return this.readContent(message.getID() + ".req.dat");
    }

    protected void writeReply(BuddyPluginBuddyMessage message, Map content) throws BuddyPluginException {
        this.writeContent(message.getID() + ".rep.dat", content);
    }

    protected Map readReply(BuddyPluginBuddyMessage message) throws BuddyPluginException {
        return this.readContent(message.getID() + ".rep.dat");
    }

    protected void writeContent(String target_str, Map content) throws BuddyPluginException {
        if (!this.store.exists() && !this.store.mkdirs()) {
            throw new BuddyPluginException("Failed to create " + this.store);
        }
        File target = new File(this.store, target_str);
        try {
            BuddyPlugin.cryptoResult result = this.buddy.encrypt(BEncoder.encode(content));
            HashMap<String, Object> store_map = new HashMap<String, Object>();
            store_map.put("pk", this.buddy.getPlugin().getPublicKey());
            store_map.put("data", result.getPayload());
            if (!this.buddy.writeConfigFile(target, store_map)) {
                throw new BuddyPluginException("failed to write " + target);
            }
        }
        catch (BuddyPluginException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BuddyPluginException("Failed to write message", e);
        }
    }

    protected Map readContent(String target_str) throws BuddyPluginException {
        File target = new File(this.store, target_str);
        if (!target.exists()) {
            throw new BuddyPluginException("Failed to read persisted message - " + target + " doesn't exist");
        }
        Map map = this.buddy.readConfigFile(target);
        if (map.size() == 0) {
            throw new BuddyPluginException("Failed to read persisted message file " + target);
        }
        try {
            String pk = new String((byte[])map.get("pk"));
            if (!pk.equals(this.buddy.getPlugin().getPublicKey())) {
                throw new BuddyPluginException("Can't decrypt message as key changed");
            }
            byte[] data = (byte[])map.get("data");
            return BDecoder.decode(this.buddy.decrypt(data).getPayload());
        }
        catch (BuddyPluginException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BuddyPluginException("Failed to read message", e);
        }
    }

    protected void deleteRequest(BuddyPluginBuddyMessage message) {
        this.deleteRequest(message.getID());
    }

    protected void deleteRequest(int id) {
        File target = new File(this.store, id + ".req.dat");
        if (target.exists() && !target.delete()) {
            Debug.out("Failed to delete " + target);
        }
    }

    protected void deleteReply(BuddyPluginBuddyMessage message) {
        this.deleteReply(message.getID());
    }

    protected void deleteReply(int id) {
        File target = new File(this.store, id + ".rep.dat");
        if (target.exists() && !target.delete()) {
            Debug.out("Failed to delete " + target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuddyPluginBuddyMessage storeExplicitMessage(int type, Map msg) {
        BuddyPluginBuddyMessage message;
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            int id = this.next_message_id++;
            try {
                message = new BuddyPluginBuddyMessage(this, id, 1024 + type, msg, 0, SystemTime.getCurrentTime());
                this.storeExplicitMessage(message);
            }
            catch (Throwable e) {
                this.buddy.log("Failed to store explicit message", e);
                return null;
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List retrieveExplicitMessages(int type) {
        ArrayList<BuddyPluginBuddyMessage> result = new ArrayList<BuddyPluginBuddyMessage>();
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            List messages = (List)this.config_map.get("explicit");
            if (messages != null) {
                for (int i = 0; i < messages.size(); ++i) {
                    try {
                        BuddyPluginBuddyMessage msg = this.restoreMessage((Map)messages.get(i));
                        if (msg.getSubsystem() != 1024 + type) continue;
                        result.add(msg);
                        continue;
                    }
                    catch (Throwable e) {
                        this.buddy.log("Failed to restore message", e);
                    }
                }
            }
        }
        return result;
    }

    protected void storeExplicitMessage(BuddyPluginBuddyMessage msg) throws BuddyPluginException {
        this.storeMessageSupport(msg, "explicit");
    }

    protected void storeMessage(BuddyPluginBuddyMessage msg) throws BuddyPluginException {
        this.storeMessageSupport(msg, "messages");
    }

    protected void storeMessageSupport(BuddyPluginBuddyMessage msg, String key) throws BuddyPluginException {
        ArrayList messages = (ArrayList)this.config_map.get(key);
        if (messages == null) {
            messages = new ArrayList();
            this.config_map.put(key, messages);
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("id", new Long(msg.getID()));
        map.put("ss", new Long(msg.getSubsystem()));
        map.put("to", new Long(msg.getTimeout()));
        map.put("cr", new Long(msg.getCreateTime()));
        messages.add(map);
        this.saveConfig();
    }

    protected BuddyPluginBuddyMessage restoreMessage(Map map) throws BuddyPluginException {
        int id = ((Long)map.get("id")).intValue();
        int ss = ((Long)map.get("ss")).intValue();
        int to = ((Long)map.get("to")).intValue();
        long cr = (Long)map.get("cr");
        return new BuddyPluginBuddyMessage(this, id, ss, null, to, cr);
    }

    protected void loadConfig() {
        int exp_count;
        List explicit;
        int ps_count;
        List pending_success;
        File config_file = new File(this.store, "messages.dat");
        this.config_map = config_file.exists() ? this.buddy.readConfigFile(config_file) : new HashMap();
        List messages = (List)this.config_map.get("messages");
        if (messages != null) {
            this.message_count = messages.size();
            if (this.message_count > 0) {
                Map last_msg = (Map)messages.get(this.message_count - 1);
                this.next_message_id = ((Long)last_msg.get("id")).intValue() + 1;
            }
        }
        if ((pending_success = (List)this.config_map.get("pending_success")) != null && (ps_count = pending_success.size()) > 0) {
            Map last_msg = (Map)pending_success.get(ps_count - 1);
            this.next_message_id = Math.max(this.next_message_id, ((Long)last_msg.get("id")).intValue() + 1);
            this.last_pending_success = SystemTime.getCurrentTime();
        }
        if ((explicit = (List)this.config_map.get("explicit")) != null && (exp_count = explicit.size()) > 0) {
            Map last_msg = (Map)explicit.get(exp_count - 1);
            this.next_message_id = Math.max(this.next_message_id, ((Long)last_msg.get("id")).intValue() + 1);
        }
    }

    protected void saveConfig() throws BuddyPluginException {
        File config_file = new File(this.store, "messages.dat");
        List messages = (List)this.config_map.get("messages");
        List pending = (List)this.config_map.get("pending_success");
        List explicit = (List)this.config_map.get("explicit");
        if (!(messages != null && messages.size() != 0 || pending != null && pending.size() != 0 || explicit != null && explicit.size() != 0)) {
            if (this.store.exists()) {
                File[] files = this.store.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    files[i].delete();
                }
                this.store.delete();
            }
            this.message_count = 0;
            this.next_message_id = 0;
        } else {
            if (!this.store.exists() && !this.store.mkdirs()) {
                throw new BuddyPluginException("Failed to create " + this.store);
            }
            if (!this.buddy.writeConfigFile(config_file, this.config_map)) {
                throw new BuddyPluginException("Failed to write" + config_file);
            }
            this.message_count = messages == null ? 0 : messages.size();
        }
    }

    public void addListener(BuddyPluginBuddyMessageListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(BuddyPluginBuddyMessageListener listener) {
        this.listeners.remove(listener);
    }
}

