/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.common.table;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableStructureModificationListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;

public class TableStructureEventDispatcher
implements TableStructureModificationListener {
    private static Map instances = new HashMap();
    private static AEMonitor class_mon = new AEMonitor("TableStructureEventDispatcher:class");
    private CopyOnWriteList listeners;
    private AEMonitor listeners_mon = new AEMonitor("TableStructureEventDispatcher:L");

    private TableStructureEventDispatcher() {
        this.listeners = new CopyOnWriteList(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableStructureEventDispatcher getInstance(String sTableID) {
        try {
            class_mon.enter();
            TableStructureEventDispatcher instance = (TableStructureEventDispatcher)instances.get(sTableID);
            if (instance == null) {
                instance = new TableStructureEventDispatcher();
                instances.put(sTableID, instance);
            }
            TableStructureEventDispatcher tableStructureEventDispatcher = instance;
            return tableStructureEventDispatcher;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TableStructureModificationListener listener) {
        try {
            this.listeners_mon.enter();
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TableStructureModificationListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void tableStructureChanged() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            TableStructureModificationListener listener = (TableStructureModificationListener)iter.next();
            listener.tableStructureChanged();
        }
    }

    public void columnSizeChanged(TableColumnCore tableColumn) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            TableStructureModificationListener listener = (TableStructureModificationListener)iter.next();
            listener.columnSizeChanged(tableColumn);
        }
    }

    public void columnInvalidate(TableColumnCore tableColumn) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            TableStructureModificationListener listener = (TableStructureModificationListener)iter.next();
            listener.columnInvalidate(tableColumn);
        }
    }

    public void cellInvalidate(TableColumnCore tableColumn, Object data_source) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            TableStructureModificationListener listener = (TableStructureModificationListener)iter.next();
            listener.cellInvalidate(tableColumn, data_source);
        }
    }

    public void columnOrderChanged(int[] iPositions) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            TableStructureModificationListener listener = (TableStructureModificationListener)iter.next();
            listener.columnOrderChanged(iPositions);
        }
    }
}

