/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.selectedcontent;

import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.util.PlayUtils;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrentException;

public class SelectedContentV3
implements ISelectedContent {
    private final SelectedContent content;
    private boolean isPlatformContent;
    private boolean canPlay;
    private String thumbURL;
    private byte[] imageBytes;
    private DownloadUrlInfo downloadInfo;

    public SelectedContentV3(SelectedContent content) {
        this.content = content;
        this.setDM(content.getDM());
    }

    public SelectedContentV3() {
        this.content = new SelectedContent();
    }

    public SelectedContentV3(String hash, String displayName, boolean isPlatformContent, boolean canPlay) {
        this.isPlatformContent = isPlatformContent;
        this.canPlay = canPlay;
        this.content = new SelectedContent(hash, displayName);
    }

    public SelectedContentV3(DownloadManager dm) throws Exception {
        this.content = new SelectedContent();
        this.setDM(dm);
    }

    public String getDisplayName() {
        return this.content.getDisplayName();
    }

    public DownloadManager getDM() {
        return this.content.getDM();
    }

    public String getHash() {
        return this.content.getHash();
    }

    public void setDisplayName(String displayName) {
        this.content.setDisplayName(displayName);
    }

    public void setDM(DownloadManager dm) {
        this.content.setDM(dm);
        if (dm != null) {
            try {
                this.setHash(dm.getTorrent().getHashWrapper().toBase32String());
            }
            catch (TOTorrentException tOTorrentException) {
                // empty catch block
            }
            this.setPlatformContent(PlatformTorrentUtils.isContent(dm.getTorrent(), true));
            this.setDisplayName(PlatformTorrentUtils.getContentTitle2(dm));
            this.setCanPlay(PlayUtils.canUseEMP(dm.getTorrent()));
            this.setImageBytes(PlatformTorrentUtils.getContentThumbnail(dm.getTorrent()));
        }
    }

    public void setHash(String hash) {
        this.content.setHash(hash);
    }

    public void setHash(String hash, boolean isPlatformContent) {
        this.content.setHash(hash);
        this.setPlatformContent(isPlatformContent);
    }

    public boolean isPlatformContent() {
        return this.isPlatformContent;
    }

    public void setPlatformContent(boolean isPlatformContent) {
        this.isPlatformContent = isPlatformContent;
    }

    public boolean canPlay() {
        return this.canPlay;
    }

    public void setCanPlay(boolean canPlay) {
        this.canPlay = canPlay;
    }

    public String getThumbURL() {
        return this.thumbURL;
    }

    public void setThumbURL(String thumbURL) {
        this.thumbURL = thumbURL;
    }

    public void setImageBytes(byte[] imageBytes) {
        this.imageBytes = imageBytes;
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public DownloadUrlInfo getDownloadInfo() {
        return this.downloadInfo;
    }

    public void setDownloadInfo(DownloadUrlInfo info) {
        this.downloadInfo = info;
    }
}

