/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener;

import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.aelitis.azureus.ui.swt.browser.listener.IBuddyPageListener;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Point;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.progress.ProgressReportMessage;
import org.json.simple.JSONObject;

public abstract class AbstractBuddyPageListener
extends AbstractBrowserMessageListener
implements IBuddyPageListener {
    public static final String LISTENER_ID = "buddy-page";
    protected Map decodedMap = new HashMap(0);
    protected Browser browser;
    private Map confirmationResponse = null;
    private String invitationMessage = "";
    private Point size = new Point(-1, -1);
    private String windowState = null;
    private int invitationsSent = 0;
    private String message_success = MessageText.getString("message.status.success");

    public AbstractBuddyPageListener(Browser browser) {
        super(LISTENER_ID);
        this.browser = browser;
    }

    public void handleMessage(final BrowserMessage message) {
        if (Constants.isCVSVersion()) {
            System.out.println(message.getFullMessage());
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                String opID = message.getOperationId();
                AbstractBuddyPageListener.this.decodedMap = message.getDecodedMap();
                if ("close".equals(opID)) {
                    AbstractBuddyPageListener.this.handleClose();
                } else if ("cancel".equals(opID)) {
                    AbstractBuddyPageListener.this.handleCancel();
                } else if ("buddy-invitees".equals(opID)) {
                    if (AbstractBuddyPageListener.this.decodedMap.containsKey("buddies")) {
                        AbstractBuddyPageListener.this.handleBuddyInvites();
                    }
                    if (AbstractBuddyPageListener.this.decodedMap.containsKey("emails")) {
                        AbstractBuddyPageListener.this.handleEmailInvites();
                    }
                } else if ("invite-confirm".equals(opID)) {
                    if (AbstractBuddyPageListener.this.decodedMap.containsKey("message")) {
                        Object getmessageObj = AbstractBuddyPageListener.this.decodedMap.get("message");
                        if (getmessageObj instanceof Map) {
                            AbstractBuddyPageListener.this.confirmationResponse = (Map)getmessageObj;
                            List sentInvitations = MapUtils.getMapList(AbstractBuddyPageListener.this.confirmationResponse, "sentInvitations", Collections.EMPTY_LIST);
                            AbstractBuddyPageListener.this.invitationsSent = sentInvitations.size();
                        } else {
                            AbstractBuddyPageListener.this.confirmationResponse = null;
                        }
                        AbstractBuddyPageListener.this.handleInviteConfirm();
                    }
                } else if ("resize".equals(opID)) {
                    if (AbstractBuddyPageListener.this.decodedMap.containsKey("window_state")) {
                        AbstractBuddyPageListener.this.windowState = AbstractBuddyPageListener.this.decodedMap.get("window_state").toString();
                        if (!(null == AbstractBuddyPageListener.this.windowState || AbstractBuddyPageListener.this.windowState.equals("maximize") || AbstractBuddyPageListener.this.windowState.equals("minimize") || AbstractBuddyPageListener.this.windowState.equals("restore"))) {
                            AbstractBuddyPageListener.this.windowState = null;
                        }
                    } else {
                        if (AbstractBuddyPageListener.this.decodedMap.containsKey("width")) {
                            ((AbstractBuddyPageListener)AbstractBuddyPageListener.this).size.x = Integer.parseInt(AbstractBuddyPageListener.this.decodedMap.get("width").toString());
                        }
                        if (AbstractBuddyPageListener.this.decodedMap.containsKey("height")) {
                            ((AbstractBuddyPageListener)AbstractBuddyPageListener.this).size.y = Integer.parseInt(AbstractBuddyPageListener.this.decodedMap.get("height").toString());
                        }
                    }
                    AbstractBuddyPageListener.this.handleResize();
                } else if ("invitees-update".equals(opID)) {
                    try {
                        int nbInvitees = Integer.parseInt(AbstractBuddyPageListener.this.decodedMap.get("nb_invitees").toString());
                        AbstractBuddyPageListener.this.handleNbBuddiesUpdated(nbInvitees);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public List getInvitedBuddies() {
        if (this.decodedMap.containsKey("buddies")) {
            ArrayList<VuzeBuddy> invitedBuddies = new ArrayList<VuzeBuddy>();
            List invitedBuddyMaps = MapUtils.getMapList(this.decodedMap, "buddies", new ArrayList());
            for (JSONObject map : invitedBuddyMaps) {
                VuzeBuddy vBuddy = VuzeBuddyManager.createPotentialBuddy(null);
                vBuddy.setDisplayName(map.get("displayName").toString());
                vBuddy.setLoginID(map.get("name").toString());
                invitedBuddies.add(vBuddy);
            }
            return invitedBuddies;
        }
        return Collections.EMPTY_LIST;
    }

    public List getInvitedEmails() {
        if (this.decodedMap.containsKey("emails")) {
            return MapUtils.getMapList(this.decodedMap, "emails", new ArrayList());
        }
        return Collections.EMPTY_LIST;
    }

    public Map getConfirmationResponse() {
        return this.confirmationResponse;
    }

    public String getInvitationMessage() {
        return this.invitationMessage;
    }

    public List getConfirmationMessages() {
        List sentInvitations;
        Map response = this.getConfirmationResponse();
        ArrayList<ProgressReportMessage> message = new ArrayList<ProgressReportMessage>();
        if (null != response && !response.isEmpty() && null != (sentInvitations = MapUtils.getMapList(response, "sentInvitations", Collections.EMPTY_LIST)) && !sentInvitations.isEmpty()) {
            for (Object object : sentInvitations) {
                if (!(object instanceof Map)) continue;
                Map invitation = (Map)object;
                String msg = MapUtils.getMapString(invitation, "value", "");
                msg = msg + " : ";
                if (MapUtils.getMapBoolean(invitation, "success", false)) {
                    msg = msg + this.message_success;
                    message.add(new ProgressReportMessage(msg, 2));
                    continue;
                }
                msg = msg + MapUtils.getMapString(invitation, "cause", "");
                message.add(new ProgressReportMessage(msg, 4));
            }
        }
        return message;
    }

    public String getFormattedInviteMessage() {
        int successMessages = 0;
        int errorMessages = 0;
        List messages = this.getConfirmationMessages();
        for (ProgressReportMessage msg : messages) {
            if (msg.isInfo()) {
                ++successMessages;
                continue;
            }
            ++errorMessages;
        }
        String message = errorMessages == 0 ? (successMessages == 1 ? MessageText.getString("message.confirm.invite.singular") : (successMessages > 1 ? MessageText.getString("message.confirm.invite.plural") : "DEBUG: confirmation with no error and no success???")) : MessageText.getString("message.confirm.invite.error");
        return message;
    }

    public Point getSize() {
        return this.size;
    }

    public String getWindowState() {
        return this.windowState;
    }

    public int getInvitationsSent() {
        return this.invitationsSent;
    }
}

