/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener;

import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.aelitis.azureus.ui.swt.browser.listener.IStatusMessageListener;
import com.aelitis.azureus.util.MapUtils;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Constants;

public abstract class AbstractStatusListener
extends AbstractBrowserMessageListener
implements IStatusMessageListener {
    protected Map decodedMap = new HashMap(0);

    public AbstractStatusListener(String listenerID) {
        super(listenerID);
    }

    public void handleMessage(BrowserMessage message) {
        String opID = message.getOperationId();
        if (Constants.isCVSVersion()) {
            System.out.println("\tLogin status message: " + message.getFullMessage());
        }
        try {
            this.decodedMap = message.getDecodedMap();
        }
        catch (Exception e) {
            this.decodedMap = new HashMap(0);
        }
        if ("login-update".equals(opID)) {
            this.handleLoginUpdate();
        } else if ("login-status".equals(opID)) {
            this.handleLoginStatus();
        } else if ("page_load_completed".equals(opID)) {
            this.handlePageLoadCompleted();
        }
    }

    public String getUserName() {
        if (this.decodedMap.containsKey("user-name")) {
            return MapUtils.getMapString(this.decodedMap, "user-name", "");
        }
        return null;
    }

    public String getAvatar() {
        if (this.decodedMap.containsKey("avatar.url")) {
            return MapUtils.getMapString(this.decodedMap, "avatar.url", "");
        }
        return null;
    }

    public String getDisplayName() {
        if (this.decodedMap.containsKey("display-name")) {
            return MapUtils.getMapString(this.decodedMap, "display-name", "");
        }
        return null;
    }

    public String getPK() {
        if (this.decodedMap.containsKey("pk")) {
            return MapUtils.getMapString(this.decodedMap, "pk", "");
        }
        return null;
    }

    public void handleLoginUpdate() {
    }

    public void handleLoginStatus() {
    }

    public void handlePageLoadCompleted() {
    }

    public boolean isRegistrationStillOpen() {
        if (this.decodedMap.containsKey("registration-open")) {
            return MapUtils.getMapBoolean(this.decodedMap, "registration-open", true);
        }
        return true;
    }
}

