/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener;

import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.ui.swt.browser.listener.DownloadUrlInfoSWT;
import com.aelitis.azureus.ui.swt.shells.BrowserWindow;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.views.skin.FriendsToolbar;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;

public class DisplayListener
extends AbstractBrowserMessageListener {
    public static final String DEFAULT_LISTENER_ID = "display";
    public static final String OP_COPY_TO_CLIPBOARD = "copy-text";
    public static final String OP_OPEN_URL = "open-url";
    public static final String OP_RESET_URL = "reset-url";
    public static final String OP_SEND_EMAIL = "send-email";
    public static final String OP_IRC_SUPPORT = "irc-support";
    public static final String OP_BRING_TO_FRONT = "bring-to-front";
    public static final String OP_SWITCH_TO_TAB = "switch-to-tab";
    public static final String OP_REFRESH_TAB = "refresh-browser";
    public static final String VZ_NON_ACTIVE = "vz-non-active";
    public static final String OP_INVITE_FRIEND = "invite";
    public static final String OP_SET_SELECTED_CONTENT = "set-selected-content";
    public static final String OP_INVITE_FRIEND_PARAM_MESSAGE = "message";
    private Browser browser;

    public DisplayListener(String id, Browser browser) {
        super(id);
        this.browser = browser;
    }

    public DisplayListener(Browser browser) {
        this(DEFAULT_LISTENER_ID, browser);
    }

    public void handleMessage(BrowserMessage message) {
        String opid = message.getOperationId();
        if (OP_COPY_TO_CLIPBOARD.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            this.copyToClipboard(MapUtils.getMapString(decodedMap, "text", ""));
        } else if (OP_OPEN_URL.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            String target = MapUtils.getMapString(decodedMap, "target", null);
            if (target == null && !decodedMap.containsKey("width")) {
                this.launchUrl(MapUtils.getMapString(decodedMap, "url", null));
            } else {
                message.setCompleteDelayed(true);
                this.showBrowser(MapUtils.getMapString(decodedMap, "url", null), target, MapUtils.getMapInt(decodedMap, "width", 0), MapUtils.getMapInt(decodedMap, "height", 0), MapUtils.getMapBoolean(decodedMap, "resizable", false), message);
            }
        } else if (OP_RESET_URL.equals(opid)) {
            this.resetURL();
        } else if (OP_SEND_EMAIL.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            String to = MapUtils.getMapString(decodedMap, "to", "");
            String subject = MapUtils.getMapString(decodedMap, "subject", "");
            String body = MapUtils.getMapString(decodedMap, "body", null);
            this.sendEmail(to, subject, body);
        } else if (OP_IRC_SUPPORT.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            this.openIrc(null, MapUtils.getMapString(decodedMap, "channel", ""), MapUtils.getMapString(decodedMap, "user", ""));
        } else if (OP_BRING_TO_FRONT.equals(opid)) {
            this.bringToFront();
        } else if (OP_SWITCH_TO_TAB.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            this.switchToTab(MapUtils.getMapString(decodedMap, "target", ""));
        } else if (OP_REFRESH_TAB.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            this.refreshTab(MapUtils.getMapString(decodedMap, "browser-id", ""));
        } else if (OP_INVITE_FRIEND.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            FriendsToolbar friendsToolbar = (FriendsToolbar)SkinViewManager.getByClass(FriendsToolbar.class);
            if (friendsToolbar != null) {
                friendsToolbar.addBuddy(MapUtils.getMapString(decodedMap, OP_INVITE_FRIEND_PARAM_MESSAGE, null));
            }
        } else if (OP_SET_SELECTED_CONTENT.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            if (decodedMap != null) {
                this.setSelectedContent(message, decodedMap);
            }
        } else {
            throw new IllegalArgumentException("Unknown operation: " + opid);
        }
    }

    private void setSelectedContent(BrowserMessage message, Map decodedMap) {
        String callback;
        String hash = MapUtils.getMapString(decodedMap, "torrent-hash", null);
        String displayName = MapUtils.getMapString(decodedMap, "display-name", null);
        String dlURL = MapUtils.getMapString(decodedMap, "download-url", null);
        String referer = MapUtils.getMapString(decodedMap, "referer", "displaylistener");
        if (hash == null && dlURL == null) {
            SelectedContentManager.changeCurrentlySelectedContent(referer, null);
        }
        if ((callback = MapUtils.getMapString(decodedMap, "callback", null)) != null && this.context != null) {
            DownloadUrlInfoSWT dlInfo = new DownloadUrlInfoSWT(this.context, callback, hash);
            boolean canPlay = MapUtils.getMapBoolean(decodedMap, "can-play", false);
            boolean isVuzeContent = MapUtils.getMapBoolean(decodedMap, "is-vuze-content", true);
            SelectedContentV3 content = new SelectedContentV3(hash, displayName, isVuzeContent, canPlay);
            content.setDownloadInfo(dlInfo);
            SelectedContentManager.changeCurrentlySelectedContent(referer, new ISelectedContent[]{content});
            return;
        }
        if (displayName != null) {
            Subscription subs;
            String dlReferer = MapUtils.getMapString(decodedMap, "download-referer", null);
            String dlCookies = MapUtils.getMapString(decodedMap, "download-cookies", null);
            HashMap<String, String> dlHeader = MapUtils.getMapMap(decodedMap, "download-header", null);
            boolean canPlay = MapUtils.getMapBoolean(decodedMap, "can-play", false);
            boolean isVuzeContent = MapUtils.getMapBoolean(decodedMap, "is-vuze-content", true);
            SelectedContentV3 content = new SelectedContentV3(hash, displayName, isVuzeContent, canPlay);
            content.setThumbURL(MapUtils.getMapString(decodedMap, "thumbnail.url", null));
            DownloadUrlInfo dlInfo = new DownloadUrlInfo(dlURL);
            dlInfo.setReferer(dlReferer);
            if (dlCookies != null) {
                if (dlHeader == null) {
                    dlHeader = new HashMap<String, String>();
                }
                dlHeader.put("Cookie", dlCookies);
            }
            dlInfo.setRequestProperties(dlHeader);
            String subID = MapUtils.getMapString(decodedMap, "subscription-id", null);
            String subresID = MapUtils.getMapString(decodedMap, "subscription-result-id", null);
            if (subID != null && subresID != null && (subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(subID)) != null) {
                subs.addPotentialAssociation(subresID, dlURL);
            }
            dlInfo.setAdditionalProperties(decodedMap);
            content.setDownloadInfo(dlInfo);
            SelectedContentManager.changeCurrentlySelectedContent(referer, new ISelectedContent[]{content});
        } else {
            SelectedContentManager.changeCurrentlySelectedContent(referer, null);
        }
    }

    private void switchToTab(String tabID) {
        SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
        if (sideBar == null) {
            return;
        }
        sideBar.showItemByTabID(tabID);
    }

    private void bringToFront() {
        UIFunctions functions = UIFunctionsManager.getUIFunctions();
        if (functions != null) {
            functions.bringToFront();
        }
    }

    private void resetURL() {
        if (this.browser == null || this.browser.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (DisplayListener.this.browser == null || DisplayListener.this.browser.isDisposed()) {
                    return;
                }
                String sURL = (String)DisplayListener.this.browser.getData("StartURL");
                DisplayListener.this.context.debug("reset " + sURL);
                if (sURL != null && sURL.length() > 0) {
                    String sRand = "rand=" + SystemTime.getCurrentTime();
                    String startURLUnique = sURL.indexOf("rand=") > 0 ? sURL.replaceAll("rand=[0-9.]+", sRand) : (sURL.indexOf(63) > 0 ? sURL + "&" + sRand : sURL + "?" + sRand);
                    DisplayListener.this.browser.setUrl(startURLUnique);
                }
            }
        });
    }

    private void refreshTab(String tabID) {
        if (null == tabID || tabID.length() < 1) {
            return;
        }
        SWTSkin skin = SWTSkinFactory.getInstance();
        if (VZ_NON_ACTIVE.equals(tabID)) {
            SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
            ArrayList browserViewIDs = new ArrayList();
            Iterator iterator = browserViewIDs.iterator();
            while (iterator.hasNext()) {
                this.refreshBrowser(iterator.next().toString());
            }
        } else {
            this.refreshBrowser(tabID);
        }
    }

    private void refreshBrowser(String browserID) {
        Browser browser;
        SWTSkin skin = SWTSkinFactory.getInstance();
        SWTSkinObject skinObject = skin.getSkinObject(browserID);
        if (skinObject instanceof SWTSkinObjectBrowser && null != (browser = ((SWTSkinObjectBrowser)skinObject).getBrowser()) && !browser.isDisposed()) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    browser.refresh();
                }
            });
        }
    }

    private void launchUrl(String url) {
        if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("mailto:")) {
            Utils.launch(url);
        }
    }

    private void sendEmail(String to, String subject, String body) {
        String url = "mailto:" + to + "?subject=" + UrlUtils.encode(subject);
        if (body != null) {
            url = url + "&body=" + UrlUtils.encode(body);
        }
        Utils.launch(url);
    }

    private void copyToClipboard(final String text) {
        if (this.browser == null || this.browser.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (DisplayListener.this.browser == null || DisplayListener.this.browser.isDisposed()) {
                    return;
                }
                Clipboard cb = new Clipboard(DisplayListener.this.browser.getDisplay());
                TextTransfer textTransfer = TextTransfer.getInstance();
                cb.setContents(new Object[]{text}, new Transfer[]{textTransfer});
                cb.dispose();
            }
        });
    }

    private void openIrc(final String server, final String channel, final String alias) {
        try {
            PluginManager pluginManager = PluginInitializer.getDefaultInterface().getPluginManager();
            PluginInterface piChat = pluginManager.getPluginInterfaceByID("azplugins");
            UIManager manager = piChat.getUIManager();
            manager.addUIListener(new UIManagerListener(){

                public void UIDetached(UIInstance instance) {
                }

                public void UIAttached(UIInstance instance) {
                    if (instance instanceof UISWTInstance) {
                        try {
                            DisplayListener.this.debug("Opening IRC channel " + channel + " on " + server + " for user " + alias);
                            UISWTInstance swtInstance = (UISWTInstance)instance;
                            UISWTView[] openViews = swtInstance.getOpenViews("Main");
                            for (int i = 0; i < openViews.length; ++i) {
                                UISWTView view = openViews[i];
                                view.closeView();
                            }
                            swtInstance.openView("Main", "IRC", new String[]{server, channel, alias});
                        }
                        catch (Exception e) {
                            DisplayListener.this.debug("Failure opening IRC channel " + channel + " on " + server, e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            this.debug("Failure opening IRC channel " + channel + " on " + server, e);
        }
    }

    private void showBrowser(final String url, final String target, final int w, final int h, final boolean allowResize, final BrowserMessage message) {
        final UIFunctions functions = UIFunctionsManager.getUIFunctions();
        if (functions == null) {
            AEThread thread = new AEThread("show browser " + url){

                public void runSupport() {
                    final Display display = Display.getDefault();
                    display.asyncExec((Runnable)new AERunnable(){

                        public void runSupport() {
                            BrowserWindow window = new BrowserWindow(display.getActiveShell(), url, w, h, allowResize, false);
                            window.waitUntilClosed();
                            message.complete(false, true, null);
                        }
                    });
                }
            };
            thread.run();
            return;
        }
        AEThread thread = new AEThread("show browser " + url){

            public void runSupport() {
                functions.viewURL(url, target, w, h, allowResize, false);
                message.complete(false, true, null);
            }
        };
        thread.run();
    }
}

