/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.aelitis.azureus.core.messenger.config.PlatformRatingMessenger;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.ui.swt.utils.TorrentUIUtilsV3;
import com.aelitis.azureus.ui.swt.views.skin.VuzeShareUtils;
import com.aelitis.azureus.util.MapUtils;
import java.io.File;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TorrentListener
extends AbstractBrowserMessageListener {
    public static final String DEFAULT_LISTENER_ID = "torrent";
    public static final String OP_LOAD_TORRENT_OLD = "loadTorrent";
    public static final String OP_LOAD_TORRENT = "load-torrent";
    public static final String OP_UPDATE_RATING = "update-rating";
    public static final String OP_SHARE = "share-torrent";
    private AzureusCore core;
    private ClientMessageContext.torrentURLHandler torrentURLHandler;

    public TorrentListener(AzureusCore core) {
        this(DEFAULT_LISTENER_ID, core);
    }

    public TorrentListener(String id, AzureusCore core) {
        super(id);
        this.core = core;
    }

    public TorrentListener() {
        this(AzureusCoreFactory.getSingleton());
    }

    public void setTorrentURLHandler(ClientMessageContext.torrentURLHandler handler) {
        this.torrentURLHandler = handler;
    }

    public void setShell(Shell shell) {
    }

    public void handleMessage(BrowserMessage message) {
        String opid = message.getOperationId();
        if (OP_LOAD_TORRENT.equals(opid) || OP_LOAD_TORRENT_OLD.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            String url = MapUtils.getMapString(decodedMap, "url", null);
            boolean playNow = MapUtils.getMapBoolean(decodedMap, "play-now", false);
            boolean playPrepare = MapUtils.getMapBoolean(decodedMap, "play-prepare", false);
            boolean bringToFront = MapUtils.getMapBoolean(decodedMap, "bring-to-front", true);
            if (url != null) {
                if (this.torrentURLHandler != null) {
                    try {
                        this.torrentURLHandler.handleTorrentURL(url);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                DownloadUrlInfo dlInfo = new DownloadUrlInfo(url);
                dlInfo.setReferer(message.getReferer());
                TorrentUIUtilsV3.loadTorrent(this.core, dlInfo, playNow, playPrepare, bringToFront, false);
            } else {
                TorrentListener.loadTorrentByB64(this.core, message, MapUtils.getMapString(decodedMap, "b64", null));
            }
        } else if (OP_UPDATE_RATING.equals(opid)) {
            DownloadManager dm;
            Map decodedMap = message.getDecodedMap();
            String hash = MapUtils.getMapString(decodedMap, "torrent-hash", null);
            if (hash != null && (dm = this.core.getGlobalManager().getDownloadManager(new HashWrapper(Base32.decode(hash)))) != null && dm.getTorrent() != null) {
                PlatformRatingMessenger.getUserRating(new String[]{"content"}, new String[]{hash}, 7000L);
                PlatformRatingMessenger.updateGlobalRating(dm.getTorrent(), 7000L);
            }
        } else if (OP_SHARE.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            String hash = MapUtils.getMapString(decodedMap, "torrent-hash", null);
            String displayName = MapUtils.getMapString(decodedMap, "display-name", null);
            if (hash != null && displayName != null) {
                String referer = MapUtils.getMapString(decodedMap, "referer", "torrentlistener");
                boolean canPlay = MapUtils.getMapBoolean(decodedMap, "can-play", false);
                SelectedContentV3 content = new SelectedContentV3(hash, displayName, true, canPlay);
                content.setThumbURL(MapUtils.getMapString(decodedMap, "thumbnail.url", null));
                VuzeShareUtils.getInstance().shareTorrent(content, referer);
            }
        } else {
            throw new IllegalArgumentException("Unknown operation: " + opid);
        }
    }

    public static boolean loadTorrentByB64(AzureusCore core, String b64) {
        return TorrentListener.loadTorrentByB64(core, null, b64);
    }

    private static boolean loadTorrentByB64(AzureusCore core, BrowserMessage message, String b64) {
        if (b64 == null) {
            return false;
        }
        byte[] decodedTorrent = Base64.decode(b64);
        try {
            File tempTorrentFile = File.createTempFile("AZU", ".torrent");
            tempTorrentFile.deleteOnExit();
            String filename = tempTorrentFile.getAbsolutePath();
            FileUtil.writeBytesAsFile(filename, decodedTorrent);
            TOTorrent torrent = TorrentUtils.readFromFile(tempTorrentFile, false);
            if (!PlatformTorrentUtils.isPlatformTracker(torrent)) {
                Debug.out("stopped loading torrent because it's not in whitelist");
                return false;
            }
            String savePath = COConfigurationManager.getStringParameter("Default save path");
            if (savePath == null || savePath.length() == 0) {
                savePath = ".";
            }
            core.getGlobalManager().addDownloadManager(filename, savePath);
        }
        catch (Throwable t) {
            if (message != null) {
                message.debug("loadUrl error", t);
            } else {
                Debug.out(t);
            }
            return false;
        }
        return true;
    }
}

