/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener.publish;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.PublishUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class SeedingListener
extends AbstractBrowserMessageListener {
    private static final long INFINITE_ETA = 31535999L;
    private static final long STOPPED_ETA = -88L;
    private static final long ERROR_ETA = -99L;
    private static final String JS_UPLOAD_PROGRESS_MSG_KEY = "upload-progress";
    private static final String JS_INDIVI_UPDATE_MSG_OP = "torrents";
    private static final String JS_GLOBAL_UPDATE_MSG_OP = "global";
    public static final String DEFAULT_LISTENER_ID = "seeding";
    public static final String OP_SEND_UPDATE = "send-update";
    public static final String OP_REMOVE = "remove";
    public static final String OP_STOP = "stop";
    public static final String OP_START = "start";

    public SeedingListener() {
        this(DEFAULT_LISTENER_ID);
    }

    public SeedingListener(String id) {
        super(id);
    }

    public void handleMessage(BrowserMessage message) {
        if (OP_SEND_UPDATE.equals(message.getOperationId())) {
            this.sendUpdate();
        } else if (OP_REMOVE.equals(message.getOperationId())) {
            String id = MapUtils.getMapString(message.getDecodedMap(), "id", null);
            if (id != null) {
                this.removeTorrent(id);
            }
        } else if (OP_START.equals(message.getOperationId())) {
            String id = MapUtils.getMapString(message.getDecodedMap(), "id", null);
            if (id != null) {
                this.startTorrent(id);
            }
        } else if (OP_STOP.equals(message.getOperationId())) {
            String id = MapUtils.getMapString(message.getDecodedMap(), "id", null);
            if (id != null) {
                this.stopTorrent(id);
            }
        } else {
            throw new IllegalArgumentException("Unknown operation: " + message.getOperationId());
        }
    }

    private DownloadManager getDM(String magnet) {
        AzureusCore core = AzureusCoreFactory.getSingleton();
        return core.getGlobalManager().getDownloadManager(new HashWrapper(Base32.decode(magnet)));
    }

    private void removeTorrent(String id) {
        final DownloadManager dm = this.getDM(id);
        if (PublishUtils.isPublished(dm)) {
            PublishUtils.setPublished(dm, false);
            ManagerUtils.remove(dm, null, false, false, new AERunnable(){

                public void runSupport() {
                    PublishUtils.setPublished(dm);
                }
            });
        }
    }

    private void startTorrent(String id) {
        DownloadManager dm = this.getDM(id);
        if (dm != null) {
            try {
                dm.setForceStart(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void stopTorrent(String id) {
        DownloadManager dm = this.getDM(id);
        this.stop(dm);
    }

    private void stop(DownloadManager dm) {
        try {
            ManagerUtils.stop(dm, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendUpdate() {
        try {
            GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
            if (gm == null) {
                return;
            }
            List dmsArray = gm.getDownloadManagers();
            if (dmsArray == null) {
                return;
            }
            Object[] dms = dmsArray.toArray();
            boolean hasIncompletePublish = false;
            long totSeedingBytes = 0L;
            long totSeedingBytesRemaining = 0L;
            long total_up_rate_bps = 0L;
            int num_actually_uploading = 0;
            ArrayList<IndividualProgress> indiv_torrents = new ArrayList<IndividualProgress>();
            for (int i = dms.length - 1; i >= 0; --i) {
                DownloadManager d = (DownloadManager)dms[i];
                if (!PublishUtils.isPublished(d)) continue;
                long download_size = d.getTorrent().getSize();
                int percent_done = -1;
                if (d.getState() == 60 && d.getDownloadState().isOurContent() && d.getStats().getAvailability() < 2.0f) {
                    TRTrackerScraperResponse scrape = d.getTrackerScrapeResponse();
                    int numSeeds = scrape.getSeeds();
                    long seedingStartedOn = d.getStats().getTimeStartedSeeding();
                    if (numSeeds > 0 && seedingStartedOn > 0L && scrape.getScrapeStartTime() > seedingStartedOn) {
                        --numSeeds;
                    }
                    if (numSeeds == 0) {
                        float availability = d.getStats().getAvailability();
                        float pctDone = (float)((int)availability) - availability;
                        percent_done = (int)(pctDone * 100.0f);
                    } else {
                        percent_done = 100;
                    }
                }
                if (percent_done < 0) {
                    percent_done = (int)(d.getStats().getTotalDataBytesSent() * 100L / download_size);
                }
                if (percent_done > 99) {
                    indiv_torrents.add(new IndividualProgress(d.getTorrent().getHash(), d.getDisplayName(), 100, 0L));
                    continue;
                }
                hasIncompletePublish = true;
                long eta = 31535999L;
                if (d.getState() == 70) {
                    eta = -88L;
                } else if (d.getState() == 100) {
                    eta = -99L;
                } else {
                    ++num_actually_uploading;
                    totSeedingBytes += download_size;
                    long remaining = (long)((float)download_size * ((float)(100 - percent_done) / 100.0f));
                    totSeedingBytesRemaining += remaining;
                    long up_rate_bps = d.getStats().getDataSendRate();
                    if (up_rate_bps > 0L) {
                        total_up_rate_bps += up_rate_bps;
                        eta = remaining / up_rate_bps;
                    }
                }
                indiv_torrents.add(new IndividualProgress(d.getTorrent().getHash(), d.getDisplayName(), percent_done, eta));
            }
            if (!indiv_torrents.isEmpty()) {
                long g_percent = 100L;
                long g_eta = 31535999L;
                if (totSeedingBytes > 0L) {
                    g_percent = (totSeedingBytes - totSeedingBytesRemaining) * 100L / totSeedingBytes;
                    if (total_up_rate_bps > 0L) {
                        g_eta = totSeedingBytesRemaining / total_up_rate_bps;
                    }
                    if (num_actually_uploading < 1) {
                        g_eta = -88L;
                        g_percent = 0L;
                    }
                } else if (!hasIncompletePublish) {
                    g_eta = 0L;
                }
                ArrayList<Map> torrents = new ArrayList<Map>();
                for (IndividualProgress ind : indiv_torrents) {
                    long mod_eta = ind.eta;
                    if (g_eta > 0L && ind.eta > g_eta) {
                        mod_eta = g_eta;
                    }
                    torrents.add(this.constructJSTorrentProgress(ind.infohash, ind.name, ind.percent, mod_eta));
                }
                this.context.sendBrowserMessage(JS_UPLOAD_PROGRESS_MSG_KEY, JS_GLOBAL_UPDATE_MSG_OP, this.constructJSGlobalProgress((int)g_percent, g_eta));
                this.context.sendBrowserMessage(JS_UPLOAD_PROGRESS_MSG_KEY, JS_INDIVI_UPDATE_MSG_OP, torrents);
            }
        }
        catch (Throwable tt) {
            tt.printStackTrace();
        }
    }

    private Map constructJSTorrentProgress(byte[] infohash, String name, int percent, long _eta) {
        String hash = infohash == null ? "<null>" : Base32.encode(infohash);
        String eta = this.formatETA(_eta);
        HashMap<String, Object> torrent = new HashMap<String, Object>();
        torrent.put("hash", hash);
        torrent.put("name", name);
        torrent.put("percent", new Long(percent));
        torrent.put("eta", eta);
        return torrent;
    }

    private Map constructJSGlobalProgress(int percent, long _eta) {
        String eta = this.formatETA(_eta);
        HashMap<String, Object> global = new HashMap<String, Object>();
        global.put("percent", new Long(percent));
        global.put("eta", eta);
        return global;
    }

    private String formatETA(long eta) {
        if (eta == 31535999L) {
            return "";
        }
        if (eta == -88L) {
            return "x";
        }
        if (eta == -99L) {
            return "e";
        }
        return TimeFormatter.format(eta);
    }

    private static class IndividualProgress {
        private final byte[] infohash;
        private final String name;
        private final int percent;
        private final long eta;

        private IndividualProgress(byte[] _infohash, String _name, int _percent, long _eta) {
            this.infohash = _infohash;
            this.name = _name;
            this.percent = _percent;
            this.eta = _eta;
        }
    }
}

