/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.buddy.impl;

import com.aelitis.azureus.buddy.impl.VuzeBuddyImpl;
import com.aelitis.azureus.ui.swt.buddy.VuzeBuddySWT;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;

public class VuzeBuddySWTImpl
extends VuzeBuddyImpl
implements VuzeBuddySWT {
    private Image avatarImage;
    private boolean needsImageRebuilt = true;
    private boolean ourAvatarImage;

    public VuzeBuddySWTImpl(String publicKey) {
        super(publicKey);
    }

    public VuzeBuddySWTImpl() {
    }

    public void setAvatar(byte[] avatar) {
        this.needsImageRebuilt = true;
        super.setAvatar(avatar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getAvatarImage() {
        if (this.needsImageRebuilt) {
            this.disposeOldAvatarImage();
            byte[] avatarBytes = this.getAvatar();
            if (avatarBytes == null) {
                try {
                    this.avatarImage = ImageLoaderFactory.getInstance().getImage("image.buddy.default.avatar");
                }
                catch (Exception e) {
                    this.avatarImage = ImageRepository.getImage("azureus64");
                }
                this.ourAvatarImage = false;
            } else {
                Display display = Utils.getDisplay();
                if (display == null) {
                    return null;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(avatarBytes);
                Image bigAvatarImage = new Image((Device)display, (InputStream)is);
                this.avatarImage = new Image((Device)display, 40, 40);
                GC gc = new GC((Drawable)this.avatarImage);
                try {
                    Rectangle bounds = bigAvatarImage.getBounds();
                    try {
                        gc.setInterpolation(2);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    gc.drawImage(bigAvatarImage, 0, 0, bounds.width, bounds.height, 0, 0, 40, 40);
                }
                finally {
                    gc.dispose();
                }
                bigAvatarImage.dispose();
                this.ourAvatarImage = true;
            }
            this.needsImageRebuilt = false;
        }
        return this.avatarImage;
    }

    public void setAvatarImage(final Image avatarImage) {
        this.disposeOldAvatarImage();
        this.avatarImage = avatarImage;
        this.ourAvatarImage = false;
        if (avatarImage != null) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    ImageLoader loader = new ImageLoader();
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    loader.data = new ImageData[]{avatarImage.getImageData()};
                    loader.save((OutputStream)os, 5);
                    VuzeBuddySWTImpl.super.setAvatar(os.toByteArray());
                }
            });
        }
    }

    private void disposeOldAvatarImage() {
        if (this.ourAvatarImage && this.avatarImage != null && !this.avatarImage.isDisposed()) {
            final Image avatarImageToDispose = this.avatarImage;
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (!avatarImageToDispose.isDisposed()) {
                        avatarImageToDispose.dispose();
                    }
                }
            });
        }
    }

    public String toDebugString() {
        return "SWT" + super.toDebugString();
    }

    protected void finalize() throws Throwable {
        this.disposeOldAvatarImage();
        super.finalize();
    }
}

