/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionManagerUI;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnSubscriptionName
extends CoreTableColumn
implements TableCellRefreshListener,
TableCellSWTPaintListener,
TableCellMouseListener {
    public static String COLUMN_ID = "name";
    Image viewImage;
    int imageWidth = -1;
    int imageHeight = -1;

    public ColumnSubscriptionName(String sTableID) {
        super(COLUMN_ID, -2, 350, sTableID);
        this.setMinWidth(300);
        this.viewImage = ImageRepository.getImage("ic_view");
    }

    public void refresh(TableCell cell) {
        String name = null;
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub != null) {
            name = sub.getName();
        }
        if (name == null) {
            name = "";
        }
        if (!cell.setSortValue((Comparable)((Object)name)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(name);
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        Rectangle bounds = cell.getBounds();
        if (this.imageWidth == -1 || this.imageHeight == -1) {
            this.imageWidth = this.viewImage.getBounds().width;
            this.imageHeight = this.viewImage.getBounds().height;
        }
        bounds.width -= this.imageWidth + 5;
        GCStringPrinter.printString(gc, cell.getText(), bounds, true, false, 16384);
        gc.drawImage(this.viewImage, bounds.x + bounds.width, bounds.y + bounds.height / 2 - this.imageHeight / 2);
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        Subscription sub;
        TableCell cell;
        int cellWidth;
        if (event2.eventType == 1 && event2.button == 1 && event2.x > (cellWidth = (cell = event2.cell).getWidth()) - this.imageWidth - 5 && event2.x < cellWidth - 5 && (sub = (Subscription)cell.getDataSource()) != null) {
            SubscriptionManagerUI.sideBarItem item = (SubscriptionManagerUI.sideBarItem)sub.getUserData(SubscriptionManagerUI.SUB_IVIEW_KEY);
            item.activate();
        }
    }

    static {
        ImageRepository.addPath("com/aelitis/azureus/ui/images/ic_view.png", "ic_view");
    }
}

