/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import com.aelitis.azureus.util.DataSourceUtils;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnQuality
extends CoreTableColumn
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellSWTPaintListener {
    public static final String COLUMN_ID = "Quality";
    public Font font;
    private final int COLUMN_WIDTH = 50;

    public ColumnQuality(String sTableID) {
        super(COLUMN_ID, sTableID);
        this.initializeAsGraphic(50);
        this.setAlignment(3);
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        Rectangle cellBounds = cell.getBounds();
        TOTorrent torrent = DataSourceUtils.getTorrent(cell.getDataSource());
        String quality = PlatformTorrentUtils.getContentQuality(torrent);
        Image img = ImageLoaderFactory.getInstance().getImage("icon.quality." + quality);
        if (ImageLoader.isRealImage(img)) {
            Rectangle imgBounds = img.getBounds();
            if (imgBounds.height <= cellBounds.height) {
                gc.drawImage(img, cellBounds.x + (cellBounds.width - imgBounds.width) / 2, cellBounds.y + (cellBounds.height - imgBounds.height) / 2);
                return;
            }
        }
        GCStringPrinter.printString(gc, quality, cellBounds, true, false, 0x1000000);
    }

    public void refresh(TableCell cell) {
        TOTorrent torrent = DataSourceUtils.getTorrent(cell.getDataSource());
        String quality = PlatformTorrentUtils.getContentQuality(torrent);
        cell.setSortValue((Comparable)((Object)quality));
    }
}

