/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.messenger.config.PlatformRatingMessenger;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefresher;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnRateUpDown
extends CoreTableColumn
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellMouseListener {
    public static final String COLUMN_ID = "RateIt";
    private static UISWTGraphicImpl graphicRate;
    private static UISWTGraphicImpl graphicRateDown;
    private static UISWTGraphicImpl graphicRateUp;
    private static UISWTGraphicImpl[] graphicsWait;
    private static Rectangle boundsRate;
    private static int width;
    private boolean useButton = false;
    private boolean disabled = false;
    TableRow previousSelection = null;

    public ColumnRateUpDown(String sTableID) {
        super(COLUMN_ID, sTableID);
        this.initializeAsGraphic(width);
        this.setAlignment(3);
        this.setWidthLimits(width, width);
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    public void refresh(TableCell cell) {
        UISWTGraphicImpl graphic;
        Object ds = cell.getDataSource();
        TOTorrent torrent = null;
        if (ds instanceof TOTorrent) {
            torrent = (TOTorrent)ds;
        } else if (ds instanceof DownloadManager && !PlatformTorrentUtils.isContentProgressive(torrent = ((DownloadManager)ds).getTorrent()) && !((DownloadManager)ds).isDownloadComplete(false)) {
            return;
        }
        if (torrent == null) {
            return;
        }
        if (!PlatformTorrentUtils.isContent(torrent, true)) {
            return;
        }
        int rating = PlatformTorrentUtils.getUserRating(torrent);
        if (!cell.setSortValue(rating) && cell.isValid() && rating != -2) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        switch (rating) {
            case -2: {
                int i = TableCellRefresher.getRefreshIndex(1, graphicsWait.length);
                graphic = graphicsWait[i];
                TableCellRefresher.addCell(this, cell);
                break;
            }
            case -1: {
                graphic = graphicRate;
                break;
            }
            case 0: {
                graphic = graphicRateDown;
                break;
            }
            case 1: {
                graphic = graphicRateUp;
                break;
            }
            default: {
                graphic = null;
            }
        }
        cell.setGraphic(graphic);
    }

    public void cellMouseTrigger(final TableCellMouseEvent event2) {
        if (this.disabled) {
            return;
        }
        Object ds = event2.cell.getDataSource();
        TOTorrent torrent0 = null;
        if (ds instanceof TOTorrent) {
            torrent0 = (TOTorrent)ds;
        } else if (ds instanceof DownloadManager && !PlatformTorrentUtils.isContentProgressive(torrent0 = ((DownloadManager)ds).getTorrent()) && !((DownloadManager)ds).isDownloadComplete(false)) {
            return;
        }
        if (torrent0 == null) {
            return;
        }
        TOTorrent torrent = torrent0;
        if (event2.button != 1) {
            return;
        }
        if (!PlatformTorrentUtils.isContent(torrent, true)) {
            return;
        }
        if (event2.eventType == 1) {
            int alpha;
            boolean cancel = true;
            int cellWidth = event2.cell.getWidth();
            int cellHeight = event2.cell.getHeight();
            int x = event2.x - (cellWidth - ColumnRateUpDown.boundsRate.width) / 2;
            int y = event2.y - (cellHeight - ColumnRateUpDown.boundsRate.height) / 2;
            Graphic currentGraphic = event2.cell.getGraphic();
            if (x >= 0 && y >= 0 && x < ColumnRateUpDown.boundsRate.width && y < ColumnRateUpDown.boundsRate.height && (graphicRate.equals(currentGraphic) || graphicRateUp.equals(currentGraphic) || graphicRateDown.equals(currentGraphic)) && (alpha = graphicRate.getImage().getImageData().getAlpha(x, y)) > 0) {
                try {
                    cancel = false;
                    int value = x < ColumnRateUpDown.boundsRate.width / 2 ? 0 : 1;
                    int previousValue = PlatformTorrentUtils.getUserRating(torrent);
                    if (value != previousValue) {
                        PlatformRatingMessenger.setUserRating(torrent, value, true, 0L, new PlatformMessengerListener(){

                            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                                ColumnRateUpDown.this.refresh(event2.cell);
                            }

                            public void messageSent(PlatformMessage message) {
                            }
                        });
                        this.refresh(event2.cell);
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
            if (cancel) {
                try {
                    int oldValue = PlatformTorrentUtils.getUserRating(torrent);
                    if (oldValue == -2 || oldValue == -1) {
                        return;
                    }
                    PlatformRatingMessenger.setUserRating(torrent, -1, true, 0L, new PlatformMessengerListener(){

                        public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                            ColumnRateUpDown.this.refresh(event2.cell);
                        }

                        public void messageSent(PlatformMessage message) {
                        }
                    });
                    this.refresh(event2.cell);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    public boolean useButton() {
        return this.useButton;
    }

    public void setUseButton(boolean useButton) {
        this.useButton = useButton;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    static {
        width = 50;
        Image img = ImageLoaderFactory.getInstance().getImage("icon.rate.library");
        graphicRate = new UISWTGraphicImpl(img);
        img = ImageLoaderFactory.getInstance().getImage("icon.rate.library.down");
        graphicRateDown = new UISWTGraphicImpl(img);
        img = ImageLoaderFactory.getInstance().getImage("icon.rate.library.up");
        graphicRateUp = new UISWTGraphicImpl(img);
        boundsRate = img.getBounds();
        Image[] imgs = ImageLoaderFactory.getInstance().getImages("image.sidebar.vitality.dots");
        graphicsWait = new UISWTGraphicImpl[imgs.length];
        for (int i = 0; i < imgs.length; ++i) {
            ColumnRateUpDown.graphicsWait[i] = new UISWTGraphicImpl(imgs[i]);
        }
    }
}

