/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.messenger.config.PlatformRatingMessenger;
import com.aelitis.azureus.core.messenger.config.RatingUpdateListener2;
import com.aelitis.azureus.core.torrent.GlobalRatingUtils;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.torrent.RatingInfoList;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnRatingGlobal
extends CoreTableColumn
implements TableCellAddedListener {
    public static final String COLUMN_ID = "Rating_global";
    public static final int COLUMN_WIDTH = 60;
    private static Font font = null;
    private static Font smallFont = null;

    public ColumnRatingGlobal(String sTableID) {
        super(COLUMN_ID, sTableID);
        this.initialize(1, -1, 60);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    private DownloadManager getDM(Object ds) {
        DownloadManager dm = null;
        if (ds instanceof DownloadManager) {
            dm = (DownloadManager)ds;
        } else if (ds instanceof VuzeActivitiesEntry) {
            dm = ((VuzeActivitiesEntry)ds).getDownloadManger();
        }
        return dm;
    }

    private class Cell
    implements TableCellSWTPaintListener,
    TableCellDisposeListener,
    RatingUpdateListener2,
    TableCellVisibilityListener,
    TableCellRefreshListener {
        String rating = "--";
        private DownloadManager dm;
        private TableCell cell;

        public Cell(TableCell cell) {
            boolean isContent;
            this.cell = cell;
            PlatformRatingMessenger.addListener(this);
            cell.addListeners(this);
            cell.setMarginWidth(2);
            this.dm = ColumnRatingGlobal.this.getDM(cell.getDataSource());
            if (this.dm != null && !(isContent = PlatformTorrentUtils.isContent(this.dm.getTorrent(), true))) {
                this.rating = "";
                return;
            }
        }

        public void refresh(TableCell cell) {
            if (!cell.isValid()) {
                this.setSortValue(cell);
            }
        }

        private void setSortValue(TableCell cell) {
            this.dm = ColumnRatingGlobal.this.getDM(cell.getDataSource());
            if (this.dm == null) {
                return;
            }
            TOTorrent torrent = this.dm.getTorrent();
            if (torrent == null) {
                return;
            }
            long count = GlobalRatingUtils.getCount(torrent);
            String rating = GlobalRatingUtils.getRatingString(torrent);
            if (rating == null) {
                rating = "0";
            }
            int userRating = PlatformTorrentUtils.getUserRating(this.dm.getTorrent());
            try {
                float val = Float.parseFloat(rating) * 1000000.0f + (float)count;
                val = val * 10.0f + (float)(userRating + 3);
                cell.setSortValue(val);
            }
            catch (Exception e) {
                e.printStackTrace();
                cell.setSortValue(count > 0L ? new Float(count) : null);
            }
        }

        public void dispose(TableCell cell) {
            PlatformRatingMessenger.removeListener(this);
        }

        public void cellPaint(GC gcImage, TableCellSWT cell) {
            DownloadManager dm;
            if (cell.isDisposed()) {
                return;
            }
            DownloadManager newDM = ColumnRatingGlobal.this.getDM(cell.getDataSource());
            if (this.dm == null || newDM != this.dm) {
                if (newDM == null) {
                    return;
                }
                this.dm = newDM;
            }
            if ((dm = ColumnRatingGlobal.this.getDM(cell.getDataSource())) == null) {
                return;
            }
            TOTorrent torrent = dm.getTorrent();
            String rating = GlobalRatingUtils.getRatingString(torrent);
            long count = GlobalRatingUtils.getCount(torrent);
            int userRating = PlatformTorrentUtils.getUserRating(dm.getTorrent());
            try {
                float val = Float.parseFloat(rating) * 1000000.0f + (float)count;
                val = val * 10.0f + (float)(userRating + 3);
                boolean b = !cell.setSortValue(val);
            }
            catch (Exception e) {
                boolean b = !cell.setSortValue(count > 0L ? new Float(count) : null);
            }
            int width = cell.getWidth();
            int height = cell.getHeight();
            if (width <= 0 || height <= 0) {
                return;
            }
            Rectangle r = cell.getBounds();
            if (r.height < 30) {
                GCStringPrinter.printString(gcImage, rating, r, true, false, 131072);
                return;
            }
            int bigTextStyle = 131200;
            int smallTextStyle = 131072;
            if (font == null) {
                FontData[] fontData = gcImage.getFont().getFontData();
                Utils.getFontHeightFromPX(gcImage.getDevice(), fontData, gcImage, 20);
                font = new Font((Device)Display.getDefault(), fontData);
            }
            gcImage.setFont(font);
            Color color1 = ColorCache.getColor((Device)Display.getDefault(), GlobalRatingUtils.getColor(torrent));
            if (color1 == null) {
                color1 = ColorCache.getColor(gcImage.getDevice(), cell.getForeground());
            }
            if (color1 != null) {
                gcImage.setForeground(color1);
            }
            GCStringPrinter.printString(gcImage, rating, r, true, false, bigTextStyle);
            if (count > 0L) {
                if (smallFont == null) {
                    gcImage.setFont(null);
                    FontData[] fontData = gcImage.getFont().getFontData();
                    fontData[0].setHeight(Utils.pixelsToPoint(9, Display.getDefault().getDPI().y));
                    smallFont = new Font((Device)Display.getDefault(), fontData);
                }
                gcImage.setFont(smallFont);
                r.y += 20;
                String sRatingInfo = count + " ratings";
                Point ratingInfoExtent = gcImage.textExtent(sRatingInfo);
                if (ratingInfoExtent.x > r.width) {
                    sRatingInfo = DisplayFormatters.formatDecimal((double)count / 1000.0, 1) + "k ratings";
                    ratingInfoExtent = gcImage.textExtent(sRatingInfo);
                    if (ratingInfoExtent.x > r.width) {
                        sRatingInfo = count / 1000L + "k ratings";
                    }
                }
                GCStringPrinter.printString(gcImage, sRatingInfo, r, true, false, 0x80 | smallTextStyle);
            }
        }

        public void ratingUpdated(RatingInfoList rating) {
            if (this.dm == null) {
                return;
            }
            try {
                String hash = this.dm.getTorrent().getHashWrapper().toBase32String();
                if (rating.hasHash(hash)) {
                    this.setSortValue(this.cell);
                    this.cell.invalidate();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void cellVisibilityChanged(TableCell cell, int visibility) {
            if (visibility == 0) {
                PlatformRatingMessenger.addListener(this);
            } else if (visibility == 1) {
                PlatformRatingMessenger.removeListener(this);
            }
        }
    }
}

