/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.DataSourceUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnTitle
extends CoreTableColumn
implements TableCellRefreshListener,
ObfusticateCellText,
TableCellMouseMoveListener,
TableCellDisposeListener,
TableCellVisibilityListener {
    public static String COLUMN_ID = "name";
    public static boolean SHOW_EXT_INFO = false;
    public static boolean LINKIFY = false;
    public static String s = "";
    private Color colorLinkNormal;
    private Color colorLinkHover;

    public ColumnTitle(String sTableID) {
        super(COLUMN_ID, -1, 250, sTableID);
        this.setMinWidth(70);
        this.setObfustication(true);
        if (LINKIFY) {
            this.setType(2);
            SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
            this.colorLinkNormal = skinProperties.getColor("color.links.normal");
            this.colorLinkHover = skinProperties.getColor("color.links.hover");
        } else {
            this.removeCellMouseMoveListener(this);
            this.removeCellDisposeListener(this);
            this.removeCellVisibilityListener(this);
        }
    }

    public void dispose(TableCell cell) {
        this.disposeExisting(cell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(TableCell cell) {
        Image img;
        Graphic graphic;
        int pos;
        String path;
        String name = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null) {
            name = PlatformTorrentUtils.getContentTitle2(dm);
        }
        if (name == null) {
            name = "";
        }
        if (!cell.setSortValue((Comparable)((Object)name)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        if (!LINKIFY) {
            cell.setText(name);
            return;
        }
        if (SHOW_EXT_INFO && name.length() > 0 && (path = dm.getDownloadState().getPrimaryFile()) != null && (pos = path.lastIndexOf(46)) >= 0) {
            String ext = path.substring(pos);
            Program program = Program.findProgram((String)ext);
            if (program != null) {
                ext = ext + " (" + program.getName() + ")";
            }
            name = name + "\n" + MessageText.getString("TableColumn.header.name.ext", new String[]{ext});
        }
        if (!((graphic = cell.getBackgroundGraphic()) instanceof UISWTGraphic)) {
            cell.setText(name);
        }
        if ((img = ((UISWTGraphic)graphic).getImage()) == null) {
            return;
        }
        String sText = name;
        if (DataSourceUtils.isPlatformContent(dm)) {
            try {
                sText = "<A HREF=\"" + ConstantsV3.URL_PREFIX + "details/" + dm.getTorrent().getHashWrapper().toBase32String() + ".html?" + ConstantsV3.URL_SUFFIX + "\">" + name + "</A>";
            }
            catch (TOTorrentException e) {
                Debug.out(e);
            }
        }
        GC gc = new GC((Drawable)img);
        try {
            gc.setForeground(ColorCache.getColor(gc.getDevice(), cell.getForeground()));
            GCStringPrinter stringPrinter = new GCStringPrinter(gc, sText, img.getBounds(), true, true, 16448);
            stringPrinter.calculateMetrics();
            if (stringPrinter.hasHitUrl()) {
                int[] mouseOfs;
                TableRow row = cell.getTableRow();
                if (row instanceof TableRowCore) {
                    ((TableRowCore)row).setData("titleStringPrinter", stringPrinter);
                }
                if ((mouseOfs = cell.getMouseOffset()) != null && stringPrinter.getHitUrl(mouseOfs[0], mouseOfs[1]) != null) {
                    stringPrinter.setUrlColor(this.colorLinkHover);
                } else {
                    stringPrinter.setUrlColor(this.colorLinkNormal);
                }
            }
            stringPrinter.printString();
        }
        finally {
            gc.dispose();
        }
        this.disposeExisting(cell);
        cell.setGraphic(new UISWTGraphicImpl(img));
    }

    private void disposeExisting(TableCell cell) {
        Image oldImage;
        Graphic oldGraphic = cell.getGraphic();
        if (oldGraphic instanceof UISWTGraphic && (oldImage = ((UISWTGraphic)oldGraphic).getImage()) != null && !oldImage.isDisposed()) {
            cell.setGraphic(null);
            oldImage.dispose();
        }
    }

    public String getObfusticatedText(TableCell cell) {
        int i;
        String name = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null && (i = (name = dm.toString()).indexOf(35)) > 0) {
            name = name.substring(i + 1);
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        GCStringPrinter stringPrinter;
        if (!(event2.cell instanceof TableCellSWT)) {
            return;
        }
        TableRow row = event2.cell.getTableRow();
        if (row instanceof TableRowCore && (stringPrinter = (GCStringPrinter)((TableRowCore)row).getData("titleStringPrinter")) != null) {
            int oldCursorID;
            GCStringPrinter.URLInfo hitUrl = stringPrinter.getHitUrl(event2.x, event2.y);
            int newCursorID = oldCursorID = ((TableCellSWT)event2.cell).getCursorID();
            if (hitUrl != null) {
                if (event2.eventType == 1 && event2.button == 1) {
                    if (PlatformConfigMessenger.isURLBlocked(hitUrl.url)) {
                        Utils.launch(hitUrl.url);
                    } else {
                        UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
                        if (uif != null) {
                            uif.viewURL(hitUrl.url, "browse", 0, 0, false, false);
                            return;
                        }
                    }
                }
                newCursorID = 21;
            } else {
                newCursorID = 0;
            }
            if (oldCursorID != newCursorID) {
                ((TableCellSWT)event2.cell).setCursorID(newCursorID);
                event2.cell.invalidate();
                ((TableCellSWT)event2.cell).refreshAsync();
            }
        }
    }

    public void cellVisibilityChanged(TableCell cell, int visibility) {
        if (visibility == 1) {
            this.disposeExisting(cell);
        }
    }
}

