/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.vuzeactivity;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnActivityType
extends CoreTableColumn
implements TableCellSWTPaintListener,
TableCellRefreshListener {
    public static final String COLUMN_ID = "activityType";
    private static int WIDTH = 42;
    private static SimpleDateFormat timeFormat = new SimpleDateFormat("h:mm:ss a, EEEE, MMMM d, yyyy");

    public ColumnActivityType(String tableID) {
        super(COLUMN_ID, tableID);
        this.initializeAsGraphic(WIDTH);
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        ImageLoader imageLoader;
        Image imgIcon;
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)cell.getDataSource();
        if (entry.getIconID() != null && ImageLoader.isRealImage(imgIcon = (imageLoader = ImageLoaderFactory.getInstance()).getImage(entry.getIconID()))) {
            Rectangle cellBounds = cell.getBounds();
            Rectangle imgBounds = imgIcon.getBounds();
            gc.drawImage(imgIcon, cellBounds.x + (cellBounds.width - imgBounds.width) / 2, cellBounds.y + (cellBounds.height - imgBounds.height) / 2);
        }
    }

    public void refresh(TableCell cell) {
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)cell.getDataSource();
        if (cell.setSortValue((Comparable)((Object)entry.getTypeID())) || !cell.isValid()) {
            String ts = timeFormat.format(new Date(entry.getTimestamp()));
            cell.setToolTip("Activity occurred on " + ts);
        }
    }
}

