/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.vuzeactivity;

import com.aelitis.azureus.activities.VuzeActivitiesConstants;
import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesEntryBuddy;
import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.buddy.VuzeBuddySWT;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnMediaThumb;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnRate;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import com.aelitis.azureus.ui.swt.views.list.ListCell;
import com.aelitis.azureus.ui.swt.views.list.ListCellGraphic;
import com.aelitis.azureus.ui.swt.views.list.ListRow;
import com.aelitis.azureus.ui.swt.views.list.ListView;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.DataSourceUtils;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.StringCompareUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnVuzeActivity
extends CoreTableColumn
implements TableCellRefreshListener,
TableCellDisposeListener,
TableCellAddedListener,
TableCellMouseMoveListener,
TableCellVisibilityListener,
TableCellToolTipListener {
    private static final int MARGIN_WIDTH = 8 - ListView.COLUMN_MARGIN_WIDTH;
    private static final int EVENT_INDENT = 29 - MARGIN_WIDTH;
    private static final int MARGIN_HEIGHT = 6;
    private static final int AVATAR_HEIGHT = 40;
    private static final int AVATAR_PADDING = 5;
    public static String COLUMN_ID = "name";
    private static Font headerFont = null;
    private static Font vuzeNewsFont = null;
    private static SimpleDateFormat timeFormat = new SimpleDateFormat("h:mm:ss a, EEEE, MMMM d, yyyy");
    private Color colorLinkNormal;
    private Color colorLinkHover;
    private Color colorHeaderFG;
    private Color colorNewsFG;
    private Color colorNewsBG;
    private Color colorHeaderBG;
    private static Image imgDelete;
    private static Image imgUnRead;
    private int sortBy = 0;

    public ColumnVuzeActivity(String sTableID) {
        super(COLUMN_ID, -2, 250, sTableID);
        this.setObfustication(true);
        this.setType(2);
        this.setRefreshInterval(-2);
        SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
        this.colorLinkNormal = skinProperties.getColor("color.links.normal");
        this.colorLinkHover = skinProperties.getColor("color.links.hover");
        this.colorHeaderFG = skinProperties.getColor("color.activity.row.header.fg");
        this.colorHeaderBG = skinProperties.getColor("color.activity.row.header.bg");
        this.colorNewsBG = skinProperties.getColor("color.vuze-entry.news.bg");
        this.colorNewsFG = skinProperties.getColor("color.vuze-entry.news.fg");
        imgUnRead = ImageLoaderFactory.getInstance().getImage("image.activity.unread");
    }

    public int compare(Object arg1, Object arg0) {
        long x;
        boolean c1_is_null;
        TableCellCore cell1;
        TableCellCore cell0;
        VuzeActivitiesEntry c0 = arg0 instanceof VuzeActivitiesEntry ? (VuzeActivitiesEntry)arg0 : (VuzeActivitiesEntry)((cell0 = ((TableRowCore)arg0).getTableCellCore(COLUMN_ID)) == null ? null : cell0.getDataSource());
        VuzeActivitiesEntry c1 = arg1 instanceof VuzeActivitiesEntry ? (VuzeActivitiesEntry)arg1 : (VuzeActivitiesEntry)((cell1 = ((TableRowCore)arg1).getTableCellCore(COLUMN_ID)) == null ? null : cell1.getDataSource());
        boolean c0_is_null = c0 == null;
        boolean bl = c1_is_null = c1 == null;
        if (c1_is_null) {
            return c0_is_null ? 0 : -1;
        }
        if (c0_is_null) {
            return 1;
        }
        if (this.sortBy == 1) {
            long c1IDpos;
            long c0IDpos;
            String c0TypeID = c0.getTypeID();
            String c1TypeID = c1.getTypeID();
            boolean isC0Header = "Header".equals(c0TypeID);
            boolean isC1Header = "Header".equals(c1TypeID);
            if (isC0Header) {
                c0TypeID = c0.getID();
            }
            if (isC1Header) {
                c1TypeID = c1.getID();
            }
            if ((c0IDpos = MapUtils.getMapLong(VuzeActivitiesConstants.SORT_TYPE_ORDER, c0TypeID, 100L)) < (c1IDpos = MapUtils.getMapLong(VuzeActivitiesConstants.SORT_TYPE_ORDER, c1TypeID, 100L))) {
                return 1;
            }
            if (c0IDpos > c1IDpos) {
                return -1;
            }
            if (isC0Header) {
                return 1;
            }
            if (isC1Header) {
                return -1;
            }
        }
        return (x = c0.getTimestamp() - c1.getTimestamp()) == 0L ? 0 : (x > 0L ? 1 : -1);
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(MARGIN_WIDTH);
        cell.setMarginHeight(0);
        cell.setFillCell(true);
        Object ds = cell.getDataSource();
        if (!(ds instanceof VuzeActivitiesEntry)) {
            return;
        }
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)ds;
        entry.tableColumn = (TableColumnCore)cell.getTableColumn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(TableCell cell) {
        Rectangle drawRect;
        GCStringPrinter stringPrinter;
        VuzeActivitiesEntryBuddy entryBuddy;
        VuzeBuddy buddy;
        Image imgIcon;
        Object ds;
        boolean force;
        TableCellImpl thumbCell = this.getThumbCell(cell);
        TableCellImpl ratingCell = this.getRatingCell(cell);
        boolean bl = force = !cell.isValid();
        if (thumbCell != null && (!thumbCell.isValid() || thumbCell.getVisuallyChangedSinceRefresh())) {
            force = true;
        }
        if (ratingCell != null && (!ratingCell.isValid() || ratingCell.getVisuallyChangedSinceRefresh())) {
            force = true;
        }
        if (!((ds = cell.getDataSource()) instanceof VuzeActivitiesEntry)) {
            return;
        }
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)ds;
        int width = cell.getWidth();
        int height = cell.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        boolean canShowThumb = this.canShowThumb(entry);
        Image image = null;
        Graphic graphic = cell.getGraphic();
        if (graphic instanceof UISWTGraphic) {
            image = ((UISWTGraphic)graphic).getImage();
        }
        Rectangle imgBounds = image == null ? null : image.getBounds();
        if (cell.isValid() && !(force |= imgBounds == null || !imgBounds.equals((Object)new Rectangle(0, 0, width, height)))) {
            return;
        }
        ((TableColumnCore)cell.getTableColumn()).setSortValueLive(false);
        if (force) {
            graphic = cell.getBackgroundGraphic();
            if (graphic instanceof UISWTGraphic && (image = ((UISWTGraphic)graphic).getImage()) == null) {
                return;
            }
            imgBounds = image.getBounds();
        }
        if (entry.getIconID() == null) {
            imgIcon = null;
        } else {
            ImageLoader imageLoader = ImageLoaderFactory.getInstance();
            imgIcon = imageLoader.getImage(entry.getIconID());
            if (!ImageLoader.isRealImage(imgIcon)) {
                imgIcon = null;
            }
        }
        boolean isHeader = "Header".equals(entry.getTypeID());
        int x = isHeader ? 0 : EVENT_INDENT;
        int y = 0;
        boolean isVuzeNewsEntry = !isHeader && "VUZE_NEWS_ITEM".equalsIgnoreCase(entry.getTypeID());
        Image imgAvatar = null;
        if (entry instanceof VuzeActivitiesEntryBuddy && (buddy = (entryBuddy = (VuzeActivitiesEntryBuddy)entry).getBuddy()) instanceof VuzeBuddySWT) {
            VuzeBuddySWT buddySWT = (VuzeBuddySWT)buddy;
            imgAvatar = buddySWT.getAvatarImage();
        }
        int avatarPos = x + 10;
        if (imgAvatar != null && !imgAvatar.isDisposed()) {
            x += 57;
        }
        int style = 64;
        Display device = Display.getDefault();
        GC gcQuery = new GC((Drawable)device);
        try {
            boolean heightChanged;
            boolean isRatingReminder;
            int minHeight;
            FontData[] fontData;
            try {
                gcQuery.setAdvanced(true);
                gcQuery.setTextAntialias(1);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (isHeader) {
                if (headerFont == null) {
                    fontData = gcQuery.getFont().getFontData();
                    fontData[0].setStyle(1);
                    if (!ConstantsV3.isUnix) {
                        fontData[0].setName("Arial");
                    }
                    Utils.getFontHeightFromPX((Device)device, fontData, gcQuery, 17);
                    headerFont = new Font((Device)device, fontData);
                }
                gcQuery.setFont(headerFont);
            } else if (isVuzeNewsEntry) {
                if (vuzeNewsFont == null) {
                    fontData = gcQuery.getFont().getFontData();
                    fontData[0].setStyle(1);
                    vuzeNewsFont = new Font((Device)device, fontData);
                }
                gcQuery.setFont(vuzeNewsFont);
            }
            Rectangle potentialArea = new Rectangle(x, 2, width - x - 4, 10000);
            stringPrinter = new GCStringPrinter(gcQuery, entry.getText(), potentialArea, 0, 192);
            stringPrinter.calculateMetrics();
            Point textSize = stringPrinter.getCalculatedSize();
            if (isHeader) {
                height = 33;
                y = 8;
            } else {
                height = textSize.y;
                height += 12;
                y = 7;
            }
            style |= 0x80;
            int n = minHeight = imgAvatar == null || imgAvatar.isDisposed() ? 50 : 52;
            if (!isHeader && height < minHeight) {
                height = minHeight;
            }
            if (canShowThumb && height < 92) {
                height = 92;
            }
            if ((isRatingReminder = "Rating-Reminder".equals(entry.getTypeID())) && height < 70) {
                height = 70;
            }
            if (heightChanged = ((TableCellCore)cell).getTableRowCore().setDrawableHeight(height)) {
                this.disposeExisting(cell, null);
                graphic = cell.getBackgroundGraphic();
                if (graphic instanceof UISWTGraphic && (image = ((UISWTGraphic)graphic).getImage()) == null) {
                    return;
                }
                imgBounds = image.getBounds();
            }
            if (canShowThumb) {
                if (isRatingReminder) {
                    Rectangle ratingRect = this.getDMRatingRect(width, height);
                    int x1 = ratingRect.x + ratingRect.width + 5;
                    drawRect = new Rectangle(x1, y, width / 2 - x1 - 4, height - y + 6);
                } else {
                    drawRect = new Rectangle(x, y, width / 2 - x - 4, height - y + 6);
                }
            } else {
                drawRect = new Rectangle(x, y, width - x - 4, height - y + 6);
            }
            stringPrinter = new GCStringPrinter(gcQuery, entry.getText(), drawRect, 0, 192);
            stringPrinter.calculateMetrics();
            if (stringPrinter.hasHitUrl()) {
                GCStringPrinter.URLInfo hitUrl;
                GCStringPrinter.URLInfo[] hitUrlInfo = stringPrinter.getHitUrlInfo();
                for (int i = 0; i < hitUrlInfo.length; ++i) {
                    GCStringPrinter.URLInfo info = hitUrlInfo[i];
                    info.urlColor = this.colorLinkNormal;
                }
                int[] mouseOfs = cell.getMouseOffset();
                if (mouseOfs != null && (hitUrl = stringPrinter.getHitUrl(mouseOfs[0] - MARGIN_WIDTH, mouseOfs[1])) != null) {
                    hitUrl.urlColor = this.colorLinkHover;
                }
            }
        }
        finally {
            gcQuery.dispose();
        }
        GC gc = new GC((Drawable)image);
        try {
            TableRow row;
            try {
                gc.setAdvanced(true);
                gc.setTextAntialias(1);
            }
            catch (Exception e) {
                // empty catch block
            }
            gc.setBackground(ColorCache.getColor((Device)device, cell.getBackground()));
            gc.setForeground(ColorCache.getColor((Device)device, cell.getForeground()));
            if (isHeader) {
                gc.setFont(headerFont);
                if (this.colorHeaderFG != null) {
                    gc.setForeground(this.colorHeaderFG);
                }
                if (this.colorHeaderBG != null) {
                    row = (ListRow)cell.getTableRow();
                    ((ListRow)row).setBackgroundColor(this.colorHeaderBG);
                    gc.setBackground(this.colorHeaderBG);
                }
                gc.fillRectangle(imgBounds);
                height -= 5;
            } else {
                if (isVuzeNewsEntry) {
                    if (this.colorNewsBG != null) {
                        gc.setBackground(this.colorNewsBG);
                        row = (ListRow)cell.getTableRow();
                        ((ListRow)row).setBackgroundColor(this.colorNewsBG);
                    }
                    if (this.colorNewsFG != null) {
                        gc.setForeground(this.colorNewsFG);
                    }
                    gc.setFont(vuzeNewsFont);
                } else {
                    row = cell.getTableRow();
                    gc.setBackground(((ListRow)row).getBackground());
                }
                gc.fillRectangle(imgBounds);
                if (imgIcon != null) {
                    Rectangle iconBounds = imgIcon.getBounds();
                    gc.drawImage(imgIcon, iconBounds.x, iconBounds.y, iconBounds.width, iconBounds.height, 0, 6, 16, 16);
                }
                if (imgUnRead != null && !entry.isRead()) {
                    Rectangle imageBounds = imgUnRead.getBounds();
                    gc.drawImage(imgUnRead, (16 - imageBounds.width) / 2, 28);
                }
            }
            try {
                gc.setInterpolation(2);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (imgAvatar != null && !imgAvatar.isDisposed()) {
                Rectangle bounds = imgAvatar.getBounds();
                gc.drawImage(imgAvatar, 0, 0, bounds.width, bounds.height, avatarPos, 6, 40, 40);
            }
            stringPrinter.printString(gc, drawRect, style);
            entry.urlInfo = stringPrinter;
            if (canShowThumb) {
                Rectangle dmThumbRect = this.getDMImageRect(width, height);
                if (thumbCell == null) {
                    ListCellGraphic listCell = new ListCellGraphic((ListRow)cell.getTableRow(), 16384, dmThumbRect);
                    thumbCell = new TableCellImpl((TableRowCore)cell.getTableRow(), new ColumnMediaThumb(cell.getTableID(), -1), 0, listCell);
                    listCell.setTableCell(thumbCell);
                    ((TableCellImpl)cell).addChildCell(thumbCell);
                    listCell.setParentCell((TableCellSWT)cell);
                    this.setThumbCell(cell, thumbCell);
                }
                ((ListCell)thumbCell.getBufferedTableItem()).setBackground(gc.getBackground());
                ((ListCell)thumbCell.getBufferedTableItem()).setBounds(dmThumbRect);
                this.invalidateAndRefresh(thumbCell);
                DownloadManager dm = DataSourceUtils.getDM(ds);
                TOTorrent torrent = DataSourceUtils.getTorrent(ds);
                if (dm != null || torrent != null) {
                    String title = PlatformTorrentUtils.getContentTitle2(dm);
                    if (title == null && (title = PlatformTorrentUtils.getContentTitle(torrent)) == null && ds instanceof VuzeActivitiesEntry) {
                        title = ((VuzeActivitiesEntry)ds).getTorrentName();
                    }
                    long time = PlatformTorrentUtils.getContentVideoRunningTime(torrent);
                    int[] resolution = PlatformTorrentUtils.getContentVideoResolution(torrent);
                    if (time > 0L) {
                        title = title + "\n" + DisplayFormatters.formatTime(time * 1000L);
                    }
                    if (resolution != null) {
                        title = title + "\n" + resolution[0] + "x" + resolution[1];
                    }
                    Rectangle titleArea = new Rectangle(dmThumbRect.x + dmThumbRect.width + 3, dmThumbRect.y, width - dmThumbRect.x - dmThumbRect.width - MARGIN_WIDTH, dmThumbRect.height);
                    GCStringPrinter.printString(gc, title, titleArea);
                }
                if ("Rating-Reminder".equals(entry.getTypeID()) && canShowThumb && DataSourceUtils.isPlatformContent(ds)) {
                    Rectangle dmRatingRect = this.getDMRatingRect(width, height);
                    if (ratingCell == null) {
                        ListCellGraphic listCell = new ListCellGraphic((ListRow)cell.getTableRow(), 131072, dmRatingRect);
                        ratingCell = new TableCellImpl((TableRowCore)cell.getTableRow(), new ColumnRate(cell.getTableID(), true), 0, listCell);
                        listCell.setTableCell(ratingCell);
                        ((TableCellImpl)cell).addChildCell(ratingCell);
                        listCell.setParentCell((TableCellSWT)cell);
                        this.setRatingCell(cell, ratingCell);
                    }
                    ((ListCell)ratingCell.getBufferedTableItem()).setBackground(gc.getBackground());
                    ((ListCell)ratingCell.getBufferedTableItem()).setBounds(dmRatingRect);
                    this.invalidateAndRefresh(ratingCell);
                }
            }
            if (!isHeader && ((TableCellCore)cell).isMouseOver() && imgDelete != null) {
                gc.setAlpha(50);
                gc.drawImage(imgDelete, width - ColumnVuzeActivity.imgDelete.getBounds().width - 5, 2);
            }
        }
        finally {
            gc.dispose();
        }
        this.disposeExisting(cell, image);
        cell.setGraphic(new UISWTGraphicImpl(image));
    }

    private boolean canShowThumb(VuzeActivitiesEntry entry) {
        if (!entry.getShowThumb()) {
            return false;
        }
        return entry.getDownloadManger() != null || entry.getTorrent() != null || entry.getImageBytes() != null;
    }

    private void disposeExisting(TableCell cell, Image exceptIfThisImage) {
        Image oldImage;
        Graphic oldGraphic = cell.getGraphic();
        if (oldGraphic instanceof UISWTGraphic && (oldImage = ((UISWTGraphic)oldGraphic).getImage()) != null && !oldImage.isDisposed() && oldImage != exceptIfThisImage) {
            cell.setGraphic(null);
            oldImage.dispose();
        }
    }

    public void dispose(TableCell cell) {
        this.disposeExisting(cell, null);
        try {
            TableCellImpl thumbCell = this.getThumbCell(cell);
            if (thumbCell != null) {
                thumbCell.dispose();
                this.setThumbCell(cell, null);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        try {
            TableCellImpl ratingCell = this.getRatingCell(cell);
            if (ratingCell != null) {
                ratingCell.dispose();
                this.setRatingCell(cell, null);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    private void setThumbCell(TableCell cell, TableCellImpl thumbCell) {
        TableRow tableRow = cell.getTableRow();
        if (tableRow instanceof TableRowCore) {
            TableRowCore tableRowCore = (TableRowCore)tableRow;
            tableRowCore.setData("ThumbCell", thumbCell);
        }
    }

    private TableCellImpl getThumbCell(TableCell cell) {
        TableRow tableRow = cell.getTableRow();
        if (tableRow instanceof TableRowCore) {
            TableRowCore tableRowCore = (TableRowCore)tableRow;
            return (TableCellImpl)tableRowCore.getData("ThumbCell");
        }
        return null;
    }

    private boolean getIsMouseOverCell(String id, TableCell cell) {
        TableRowCore tableRowCore;
        Object data;
        TableRow tableRow = cell.getTableRow();
        if (tableRow instanceof TableRowCore && (data = (tableRowCore = (TableRowCore)tableRow).getData("IsMouseOver" + id + "Cell")) instanceof Boolean) {
            return (Boolean)data;
        }
        return false;
    }

    private boolean setIsMouseOverCell(String id, TableCell cell, boolean b) {
        TableRow tableRow = cell.getTableRow();
        if (tableRow instanceof TableRowCore) {
            TableRowCore tableRowCore = (TableRowCore)tableRow;
            tableRowCore.setData("IsMouseOver" + id + "Cell", new Boolean(b));
        }
        return false;
    }

    private void setRatingCell(TableCell cell, TableCellImpl ratingCell) {
        TableRow tableRow = cell.getTableRow();
        if (tableRow instanceof TableRowCore) {
            TableRowCore tableRowCore = (TableRowCore)tableRow;
            tableRowCore.setData("RatingCell", ratingCell);
        }
    }

    private TableCellImpl getRatingCell(TableCell cell) {
        TableRow tableRow = cell.getTableRow();
        if (tableRow instanceof TableRowCore) {
            TableRowCore tableRowCore = (TableRowCore)tableRow;
            return (TableCellImpl)tableRowCore.getData("RatingCell");
        }
        return null;
    }

    public void cellHover(TableCell cell) {
        Object toolTip;
        TableCellImpl thumbCell = this.getThumbCell(cell);
        if (thumbCell != null && this.getIsMouseOverCell("Thumb", cell) && (toolTip = thumbCell.getToolTip()) != null) {
            cell.setToolTip(toolTip);
        }
    }

    public void cellHoverComplete(TableCell cell) {
        Object toolTip;
        TableCellImpl thumbCell = this.getThumbCell(cell);
        if (thumbCell != null && this.getIsMouseOverCell("Thumb", cell) && (toolTip = thumbCell.getToolTip()) != null) {
            cell.setToolTip(null);
        }
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        String oldTooltip;
        Object o;
        Object ds;
        String tooltip = null;
        boolean invalidateAndRefresh = false;
        TableCellImpl thumbCell = this.getThumbCell(event2.cell);
        TableCellImpl ratingCell = this.getRatingCell(event2.cell);
        if (thumbCell != null || ratingCell != null) {
            TableColumn tc;
            TableColumn tc2;
            Rectangle dmThumbRect = this.getDMImageRect(event2.cell.getWidth(), event2.cell.getHeight());
            Rectangle dmRatingRect = this.getDMRatingRect(event2.cell.getWidth(), event2.cell.getHeight());
            TableCellMouseEvent subCellEvent = new TableCellMouseEvent();
            subCellEvent.button = event2.button;
            subCellEvent.data = event2.data;
            subCellEvent.eventType = event2.eventType;
            subCellEvent.row = event2.row;
            boolean isMouseOverThumbCell = false;
            if (thumbCell != null) {
                isMouseOverThumbCell = dmThumbRect.contains(event2.x, event2.y);
                boolean wasMouseOverThumbCell = this.getIsMouseOverCell("Thumb", event2.cell);
                if (wasMouseOverThumbCell != isMouseOverThumbCell) {
                    invalidateAndRefresh = true;
                    this.setIsMouseOverCell("Thumb", event2.cell, isMouseOverThumbCell);
                    subCellEvent.eventType = isMouseOverThumbCell ? 4 : 5;
                    subCellEvent.x = event2.x - dmThumbRect.x - MARGIN_WIDTH;
                    subCellEvent.y = event2.y - dmThumbRect.y;
                    subCellEvent.cell = thumbCell;
                    tc2 = thumbCell.getTableColumn();
                    if (tc2 instanceof TableColumnCore) {
                        ((TableColumnCore)tc2).invokeCellMouseListeners(subCellEvent);
                    }
                    if (thumbCell instanceof TableCellCore) {
                        thumbCell.invokeMouseListeners(subCellEvent);
                    }
                    event2.skipCoreFunctionality |= subCellEvent.skipCoreFunctionality;
                    subCellEvent.eventType = 3;
                }
            }
            boolean isMouseOverRatingCell = false;
            if (ratingCell != null) {
                isMouseOverRatingCell = dmRatingRect.contains(event2.x, event2.y);
                boolean wasMouseOverRatingCell = this.getIsMouseOverCell("Rating", event2.cell);
                if (wasMouseOverRatingCell != isMouseOverRatingCell) {
                    invalidateAndRefresh = true;
                    this.setIsMouseOverCell("Rating", event2.cell, isMouseOverRatingCell);
                    subCellEvent.eventType = isMouseOverRatingCell ? 4 : 5;
                    subCellEvent.cell = ratingCell;
                    subCellEvent.x = event2.x - dmRatingRect.x - MARGIN_WIDTH;
                    subCellEvent.y = event2.y - dmRatingRect.y;
                    tc = ratingCell.getTableColumn();
                    if (tc instanceof TableColumnCore) {
                        ((TableColumnCore)tc).invokeCellMouseListeners(subCellEvent);
                    }
                    if (ratingCell instanceof TableCellCore) {
                        ratingCell.invokeMouseListeners(subCellEvent);
                    }
                    event2.skipCoreFunctionality |= subCellEvent.skipCoreFunctionality;
                }
            }
            if (thumbCell != null && isMouseOverThumbCell) {
                subCellEvent.cell = thumbCell;
                subCellEvent.x = event2.x - dmThumbRect.x - MARGIN_WIDTH;
                subCellEvent.y = event2.y - dmThumbRect.y;
                if (thumbCell instanceof TableCellCore) {
                    TableRowCore row = thumbCell.getTableRowCore();
                    if (row != null) {
                        row.invokeMouseListeners(subCellEvent);
                    }
                    thumbCell.invokeMouseListeners(subCellEvent);
                    tc = thumbCell.getTableColumn();
                    if (tc instanceof TableColumnCore) {
                        ((TableColumnCore)tc).invokeCellMouseListeners(subCellEvent);
                    }
                }
                event2.skipCoreFunctionality |= subCellEvent.skipCoreFunctionality;
            }
            if (ratingCell != null && isMouseOverRatingCell) {
                subCellEvent.cell = ratingCell;
                subCellEvent.x = event2.x - dmRatingRect.x - MARGIN_WIDTH;
                subCellEvent.y = event2.y - dmRatingRect.y;
                if (ratingCell instanceof TableCellCore) {
                    ratingCell.getTableRowCore().invokeMouseListeners(subCellEvent);
                    ratingCell.invokeMouseListeners(subCellEvent);
                }
                if ((tc2 = ratingCell.getTableColumn()) instanceof TableColumnCore) {
                    ((TableColumnCore)tc2).invokeCellMouseListeners(subCellEvent);
                }
                event2.skipCoreFunctionality |= subCellEvent.skipCoreFunctionality;
            }
        }
        if ((ds = event2.cell.getDataSource()) instanceof VuzeActivitiesEntry) {
            VuzeActivitiesEntry entry = (VuzeActivitiesEntry)ds;
            if (entry.urlInfo != null) {
                int newCursor;
                GCStringPrinter.URLInfo hitUrl = ((GCStringPrinter)entry.urlInfo).getHitUrl(event2.x - MARGIN_WIDTH, event2.y);
                if (hitUrl != null) {
                    if (event2.eventType == 1) {
                        if (!PlatformConfigMessenger.urlCanRPC(hitUrl.url)) {
                            Utils.launch(hitUrl.url);
                        } else {
                            UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
                            if (uif != null) {
                                String target = hitUrl.target == null ? "browse" : hitUrl.target;
                                uif.viewURL(hitUrl.url, target, 0, 0, false, false);
                                return;
                            }
                        }
                    }
                    newCursor = 21;
                    tooltip = PlatformConfigMessenger.urlCanRPC(hitUrl.url) ? hitUrl.title : hitUrl.url;
                } else {
                    newCursor = 0;
                }
                int oldCursor = ((TableCellSWT)event2.cell).getCursorID();
                if (oldCursor != newCursor) {
                    invalidateAndRefresh = true;
                    ((TableCellSWT)event2.cell).setCursorID(newCursor);
                }
            }
            boolean inHitArea = new Rectangle(0, 0, EVENT_INDENT, EVENT_INDENT).contains(event2.x, event2.y);
            boolean isHeader = "Header".equals(entry.getTypeID());
            if (!isHeader && inHitArea) {
                String ts = timeFormat.format(new Date(entry.getTimestamp()));
                tooltip = "Activity occurred on " + ts + ";" + entry.getID();
            }
        }
        if ((o = event2.cell.getToolTip()) == null | o instanceof String && !StringCompareUtils.equals(oldTooltip = (String)o, tooltip)) {
            invalidateAndRefresh = true;
            event2.cell.setToolTip(tooltip);
        }
        if (invalidateAndRefresh) {
            this.invalidateAndRefresh(event2.cell);
        }
    }

    private void invalidateAndRefresh(TableCell cell) {
        cell.invalidate();
        if (cell instanceof TableCellCore) {
            TableCellCore cellCore = (TableCellCore)cell;
            cellCore.refreshAsync();
        }
    }

    private Rectangle getDMImageRect(int cellWidth, int cellHeight) {
        return new Rectangle(cellWidth / 2 + 10, 6, 105, 80);
    }

    private Rectangle getDMRatingRect(int cellWidth, int cellHeight) {
        return new Rectangle(EVENT_INDENT, 4, 50, 32);
    }

    public void cellVisibilityChanged(TableCell cell, int visibility) {
        TableCellImpl ratingCell;
        TableCellImpl thumbCell = this.getThumbCell(cell);
        if (thumbCell != null) {
            thumbCell.invokeVisibilityListeners(visibility, true);
        }
        if ((ratingCell = this.getRatingCell(cell)) != null) {
            ratingCell.invokeVisibilityListeners(visibility, true);
        }
    }

    public int getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(int sortBy) {
        this.sortBy = sortBy;
    }
}

