/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.listener.ConfigListener;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.LightBoxBrowserListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.LightBoxShell;
import org.gudy.azureus2.ui.swt.components.shell.StyledShell;
import org.gudy.azureus2.ui.swt.components.widgets.BubbleButton;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class LightBoxBrowserWindow {
    private String url = null;
    private String pageVerifierValue = "vuzePage";
    private StackLayout stack = new StackLayout();
    private Composite errorPanel;
    private Composite contentPanel;
    private Browser browser;
    private StyledShell styledShell;
    private LightBoxShell lightBoxShell;
    private int browserWidth = 0;
    private int browserHeight = 0;
    private Label errorMessageLabel;
    private String redirectURL = null;
    private Color borderColor = null;
    private Color contentBackgroundColor = null;
    private UIFunctionsSWT uiFunctions;
    private closeListener closeListener;

    public LightBoxBrowserWindow(String url, String prefixVerifier, int width, int height) {
        this.url = url;
        this.pageVerifierValue = prefixVerifier;
        this.browserWidth = width;
        this.browserHeight = height;
        Utils.execSWTThread(new Runnable(){

            public void run() {
                LightBoxBrowserWindow.this.init();
            }
        });
    }

    public LightBoxBrowserWindow(String url, int width, int height) {
        this(url, null, width, height);
    }

    public LightBoxBrowserWindow(String url) {
        this(url, null, 0, 0);
    }

    public void init() {
        this.uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (null == this.uiFunctions) {
            throw new IllegalStateException("No instance of UIFunctionsSWT found; the UIFunctionsManager might not have been initialized properly");
        }
        this.lightBoxShell = new LightBoxShell(true);
        this.borderColor = new Color((Device)this.lightBoxShell.getDisplay(), 38, 38, 38);
        this.contentBackgroundColor = new Color((Device)this.lightBoxShell.getDisplay(), 13, 13, 13);
        this.styledShell = this.lightBoxShell.createPopUpShell(6, true, true);
        this.styledShell.setBackground(this.borderColor);
        this.contentPanel = this.styledShell.getContent();
        this.stack.marginHeight = 0;
        this.stack.marginWidth = 0;
        this.contentPanel.setLayout((Layout)this.stack);
        this.contentPanel.setBackground(this.contentBackgroundColor);
        this.errorPanel = new Composite(this.contentPanel, 0);
        this.errorPanel.setBackground(this.contentBackgroundColor);
        this.errorPanel.setLayout((Layout)new FormLayout());
        this.errorPanel.setBackgroundMode(1);
        this.errorMessageLabel = new Label(this.errorPanel, 64);
        this.errorMessageLabel.setBackground(this.errorPanel.getBackground());
        this.errorMessageLabel.setForeground(Colors.grey);
        BubbleButton closeButton = new BubbleButton(this.errorPanel);
        closeButton.setText(MessageText.getString("wizard.close"));
        FormData fData = new FormData();
        fData.width = 100;
        fData.bottom = new FormAttachment(100, -20);
        fData.right = new FormAttachment(100, -20);
        closeButton.setLayoutData(fData);
        fData = new FormData();
        fData.top = new FormAttachment(0, 0);
        fData.left = new FormAttachment(0, 0);
        fData.bottom = new FormAttachment((Control)closeButton, 0);
        fData.right = new FormAttachment(100, -20);
        this.errorMessageLabel.setLayoutData((Object)fData);
        closeButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                LightBoxBrowserWindow.this.close();
            }
        });
        this.lightBoxShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (null != LightBoxBrowserWindow.this.borderColor && !LightBoxBrowserWindow.this.borderColor.isDisposed()) {
                    LightBoxBrowserWindow.this.borderColor.dispose();
                }
                if (null != LightBoxBrowserWindow.this.contentBackgroundColor && !LightBoxBrowserWindow.this.contentBackgroundColor.isDisposed()) {
                    LightBoxBrowserWindow.this.contentBackgroundColor.dispose();
                }
            }
        });
        try {
            this.browser = new Browser(this.contentPanel, Utils.getInitialBrowserStyle(0));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.browserWidth > 0 && this.browserHeight > 0) {
            this.styledShell.setSize(this.browserWidth, this.browserHeight, 6);
        }
        if (null != this.browser) {
            this.hookListeners();
            this.setUrl(this.url);
            this.stack.topControl = this.browser;
        } else {
            this.stack.topControl = this.errorPanel;
        }
        this.contentPanel.layout();
        if (this.uiFunctions.getMainShell().getMinimized()) {
            this.uiFunctions.getMainShell().setMinimized(false);
        }
        this.styledShell.hideShell(true);
        this.lightBoxShell.open(this.styledShell);
    }

    private void hookListeners() {
        this.browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event2) {
                LightBoxBrowserWindow.this.close();
            }
        });
        this.browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event2) {
                if (null != LightBoxBrowserWindow.this.pageVerifierValue) {
                    String browserText = null;
                    try {
                        browserText = LightBoxBrowserWindow.this.browser.getText();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (null != browserText && !LightBoxBrowserWindow.this.isPageVerified(LightBoxBrowserWindow.this.browser.getText())) {
                        String errorMessage = MessageText.getString("Browser.popup.error.no.access");
                        LightBoxBrowserWindow.this.errorMessageLabel.setText(errorMessage);
                        if (!((LightBoxBrowserWindow)LightBoxBrowserWindow.this).stack.topControl.equals(LightBoxBrowserWindow.this.errorPanel)) {
                            ((LightBoxBrowserWindow)LightBoxBrowserWindow.this).stack.topControl = LightBoxBrowserWindow.this.errorPanel;
                            LightBoxBrowserWindow.this.setSize(300, 200);
                            LightBoxBrowserWindow.this.contentPanel.layout();
                        }
                    }
                }
                if (LightBoxBrowserWindow.this.uiFunctions.getMainShell().getMinimized()) {
                    LightBoxBrowserWindow.this.uiFunctions.getMainShell().setMinimized(false);
                }
                LightBoxBrowserWindow.this.lightBoxShell.showBusy(false, 0L);
                LightBoxBrowserWindow.this.styledShell.animateFade(100);
            }

            public void changed(ProgressEvent event2) {
                if (event2.current == 0 && event2.total != 0) {
                    LightBoxBrowserWindow.this.styledShell.hideShell(true);
                    LightBoxBrowserWindow.this.lightBoxShell.showBusy(true, 500L);
                }
            }
        });
        if (!this.styledShell.isUseCustomTrim()) {
            this.browser.addTitleListener(new TitleListener(){

                public void changed(TitleEvent event2) {
                    LightBoxBrowserWindow.this.styledShell.setText(event2.title);
                }
            });
        }
        BrowserContext context = new BrowserContext("lightbox-browser-window" + Math.random(), this.browser, null, true);
        context.addMessageListener(new ConfigListener(this.browser));
        context.addMessageListener(new LightBoxBrowserListener(this));
        context.addMessageListener(new DisplayListener(null));
    }

    private boolean isPageVerified(String html) {
        if (null == html || html.length() < 1) {
            return false;
        }
        return html.indexOf("vuzePage") != -1;
    }

    public void close() {
        this.lightBoxShell.close();
        if (this.closeListener != null) {
            this.closeListener.close();
        }
    }

    public void refresh() {
        if (null != this.browser) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    LightBoxBrowserWindow.this.browser.refresh();
                }
            });
        }
    }

    public void setUrl(String url) {
        if (null != this.browser) {
            this.browser.setUrl(url);
            this.browser.setData("StartURL", (Object)url);
        }
    }

    public void setSize(int width, int height) {
        this.browserWidth = width;
        this.browserHeight = height;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                LightBoxBrowserWindow.this.styledShell.setSize(LightBoxBrowserWindow.this.browserWidth, LightBoxBrowserWindow.this.browserHeight);
            }
        });
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public void setCloseListener(closeListener l) {
        this.closeListener = l;
    }

    public static interface closeListener {
        public void close();
    }
}

