/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.IUIIntializer;
import com.aelitis.azureus.ui.skin.SkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinLayoutCompleteListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectButton;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectImage;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectImageContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectSash;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectSeparator;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectSlider;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTab;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText2;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinPropertiesClone;
import com.aelitis.azureus.ui.swt.skin.SWTSkinPropertiesImpl;
import com.aelitis.azureus.ui.swt.skin.SWTSkinPropertiesParam;
import com.aelitis.azureus.ui.swt.skin.SWTSkinPropertiesParamImpl;
import com.aelitis.azureus.ui.swt.skin.SWTSkinTabSet;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkin {
    private static final SWTSkinObjectListener[] NOLISTENERS = new SWTSkinObjectListener[0];
    static boolean DEBUGLAYOUT = System.getProperty("debuglayout") != null;
    private Map mapImageLoaders = new HashMap();
    private SWTSkinProperties skinProperties;
    private Listener handCursorListener;
    private Listener ontopPaintListener;
    private HashMap mapIDsToControls = new HashMap();
    private HashMap mapTabSetToControls = new HashMap();
    private HashMap mapPublicViewIDsToControls = new HashMap();
    private HashMap mapPublicViewIDsToListeners = new HashMap();
    private AEMonitor mapPublicViewIDsToListeners_mon = new AEMonitor("SWTSkin::mapPublicViewIDsToListeners");
    private ArrayList ontopImages = new ArrayList();
    private Shell shell;
    private boolean bLayoutComplete = false;
    private List listenersLayoutComplete = new ArrayList();
    private final ClassLoader classLoader;
    private boolean ourSkinProperties = false;
    private int currentSkinObjectcreationCount = 0;

    public SWTSkin() {
        this.classLoader = SWTSkin.class.getClassLoader();
        this.ourSkinProperties = true;
        this.init(new SWTSkinPropertiesImpl());
    }

    public SWTSkin(ClassLoader classLoader, String skinPath, String mainSkinFile) {
        this.classLoader = classLoader;
        this.ourSkinProperties = true;
        this.init(new SWTSkinPropertiesImpl(classLoader, skinPath, mainSkinFile));
    }

    private void init(SWTSkinProperties skinProperties) {
        this.skinProperties = skinProperties;
        ImageLoaderFactory.createInstance(this.classLoader, Display.getDefault(), skinProperties);
        this.ontopPaintListener = new Listener(){

            public void handleEvent(Event event2) {
                for (SWTSkinObject skinObject : SWTSkin.this.ontopImages) {
                    Control control = skinObject.getControl();
                    if (control == null) continue;
                    Rectangle bounds = control.getBounds();
                    Point point = control.toDisplay(0, 0);
                    bounds.x = point.x;
                    bounds.y = point.y;
                    Rectangle eventBounds = event2.getBounds();
                    point = ((Control)event2.widget).toDisplay(0, 0);
                    eventBounds.x += point.x;
                    eventBounds.y += point.y;
                    if (!eventBounds.intersects(bounds)) continue;
                    Point dst = new Point(bounds.x - point.x, bounds.y - point.y);
                    Image image = (Image)control.getData("image");
                    event2.gc.drawImage(image, dst.x, dst.y);
                }
            }
        };
    }

    public ImageLoader getImageLoader(SkinProperties properties) {
        ImageLoader loader = (ImageLoader)this.mapImageLoaders.get(properties);
        if (loader != null) {
            return loader;
        }
        loader = new ImageLoader(this.classLoader, Display.getDefault(), properties);
        this.mapImageLoaders.put(properties, loader);
        return loader;
    }

    public void addToControlMap(SWTSkinObject skinObject) {
        String sID = skinObject.getSkinObjectID();
        if (DEBUGLAYOUT) {
            System.out.println("addToControlMap: " + sID + " : " + skinObject);
        }
        this.addToArrayMap(this.mapIDsToControls, sID, skinObject);
        Control control = skinObject.getControl();
        if (control != null) {
            control.setData("ConfigID", (Object)skinObject.getConfigID());
            control.setData("SkinID", (Object)sID);
        }
    }

    private void addToArrayMap(Map arrayMap, Object key, SWTSkinObject object) {
        Object existing = arrayMap.get(key);
        if (existing instanceof SWTSkinObject[]) {
            SWTSkinObject[] existingObjects = (SWTSkinObject[])existing;
            boolean bAlreadyPresent = false;
            for (int i = 0; i < existingObjects.length; ++i) {
                if (existingObjects[i] == null || !existingObjects[i].equals(object)) continue;
                bAlreadyPresent = true;
                System.err.println("already present: " + key + "; " + object + "; existing: " + existingObjects[i] + " via " + Debug.getCompressedStackTrace());
                break;
            }
            if (!bAlreadyPresent) {
                int length = existingObjects.length;
                SWTSkinObject[] newObjects = new SWTSkinObject[length + 1];
                System.arraycopy(existingObjects, 0, newObjects, 0, length);
                newObjects[length] = object;
                arrayMap.put(key, newObjects);
            }
        } else {
            arrayMap.put(key, new SWTSkinObject[]{object});
        }
    }

    private Object getFromArrayMap(Map arrayMap, Object key, SWTSkinObject parent) {
        if (parent == null) {
            return null;
        }
        SWTSkinObject[] objects = (SWTSkinObject[])arrayMap.get(key);
        if (objects == null) {
            return null;
        }
        for (int i = 0; i < objects.length; ++i) {
            SWTSkinObject object;
            for (SWTSkinObject thisParent = object = objects[i]; thisParent != null; thisParent = thisParent.getParent()) {
                if (!thisParent.equals(parent)) continue;
                return object;
            }
        }
        return null;
    }

    private void setSkinObjectViewID(SWTSkinObject skinObject, String sViewID) {
        this.addToArrayMap(this.mapPublicViewIDsToControls, sViewID, skinObject);
    }

    public void dumpObjects() {
        System.out.println("=====");
        for (String sID : this.mapIDsToControls.keySet()) {
            Control control = this.getSkinObjectByID(sID).getControl();
            FormData formdata = (FormData)control.getLayoutData();
            System.out.println(sID);
            sID = sID + ".attach.";
            if (formdata.left != null) {
                System.out.println(sID + "left=" + this.getAttachLine(formdata.left));
            }
            if (formdata.right != null) {
                System.out.println(sID + "right=" + this.getAttachLine(formdata.right));
            }
            if (formdata.top != null) {
                System.out.println(sID + "top=" + this.getAttachLine(formdata.top));
            }
            if (formdata.bottom == null) continue;
            System.out.println(sID + "bottom=" + this.getAttachLine(formdata.bottom));
        }
    }

    public SWTSkinObject[] getSkinObjectsByType(String sTypeRegEx) {
        ArrayList<SWTSkinObject> list = new ArrayList<SWTSkinObject>();
        for (String sID : this.mapIDsToControls.keySet()) {
            SWTSkinObject so = this.getSkinObjectByID(sID);
            if (so == null || !so.getType().matches(sTypeRegEx)) continue;
            list.add(so);
        }
        return list.toArray(new SWTSkinObject[0]);
    }

    public SWTSkinObject getSkinObjectByID(String sID) {
        SWTSkinObject[] objects = (SWTSkinObject[])this.mapIDsToControls.get(sID);
        if (objects == null) {
            return null;
        }
        return objects[0];
    }

    protected SWTSkinObject getSkinObjectByID(String sID, SWTSkinObject parent) {
        if (parent == null) {
            return this.getSkinObjectByID(sID);
        }
        return (SWTSkinObject)this.getFromArrayMap(this.mapIDsToControls, sID, parent);
    }

    public SWTSkinObject getSkinObject(String sViewID) {
        SWTSkinObject[] objects = (SWTSkinObject[])this.mapPublicViewIDsToControls.get(sViewID);
        if (objects == null) {
            if (!Utils.isThisThreadSWT()) {
                Debug.out("View " + sViewID + " does not exist.  Skipping unattach check because not in SWT thread");
                return null;
            }
            return this.createUnattachedView(sViewID, null);
        }
        return objects[0];
    }

    private SWTSkinObject createUnattachedView(String viewID, SWTSkinObject parent) {
        String unattachedView = this.skinProperties.getStringValue("UnattachedView." + viewID);
        if (unattachedView != null) {
            String[] split;
            String parentID;
            SWTSkinObject soParent;
            if (unattachedView.indexOf(44) > 0 && (soParent = this.getSkinObjectByID(parentID = (split = unattachedView.split(","))[1], parent)) != null) {
                String configID = split[0];
                return this.createSkinObject(configID, configID, soParent);
            }
            SWTSkinObjectListener[] listeners = this.getSkinObjectListeners(viewID);
            for (int i = 0; i < listeners.length; ++i) {
                SWTSkinObjectListener l = listeners[i];
                Object o = l.eventOccured(null, 5, new String[]{viewID, unattachedView});
                if (!(o instanceof SWTSkinObject)) continue;
                return (SWTSkinObject)o;
            }
        }
        return null;
    }

    public SWTSkinObject getSkinObject(String sViewID, SWTSkinObject parent) {
        if (parent == null) {
            return this.getSkinObject(sViewID);
        }
        String parentViewID = parent.getViewID();
        if (parentViewID != null && parentViewID.equals(sViewID)) {
            return parent;
        }
        SWTSkinObject so = (SWTSkinObject)this.getFromArrayMap(this.mapPublicViewIDsToControls, sViewID, parent);
        if (so == null) {
            so = this.createUnattachedView(sViewID, parent);
        }
        return so;
    }

    public SWTSkinTabSet getTabSet(String sID) {
        return (SWTSkinTabSet)this.mapTabSetToControls.get(sID);
    }

    public SWTSkinObjectTab activateTab(SWTSkinObject skinObjectInTab) {
        if (skinObjectInTab == null) {
            return null;
        }
        if (skinObjectInTab instanceof SWTSkinObjectTab) {
            SWTSkinObjectTab tab = (SWTSkinObjectTab)skinObjectInTab;
            tab.getTabset().setActiveTab(tab);
            return tab;
        }
        for (SWTSkinTabSet tabset : this.mapTabSetToControls.values()) {
            SWTSkinObjectTab[] tabs = tabset.getTabs();
            boolean bHasSkinObject = false;
            for (int i = 0; i < tabs.length; ++i) {
                SWTSkinObjectTab tab = tabs[i];
                SWTSkinObject[] activeWidgets = tab.getActiveWidgets(true);
                for (int j = 0; j < activeWidgets.length; ++j) {
                    SWTSkinObject object = activeWidgets[j];
                    if (!this.hasSkinObject(object, skinObjectInTab)) continue;
                    tabset.setActiveTab(tab);
                    return tab;
                }
            }
        }
        System.out.println("NOT FOUND" + skinObjectInTab);
        return null;
    }

    private boolean hasSkinObject(SWTSkinObject start, SWTSkinObject skinObject) {
        if (start instanceof SWTSkinObjectContainer) {
            SWTSkinObject[] children = ((SWTSkinObjectContainer)start).getChildren();
            for (int i = 0; i < children.length; ++i) {
                SWTSkinObject object = children[i];
                if (!this.hasSkinObject(object, skinObject)) continue;
                return true;
            }
        }
        return skinObject.equals(start);
    }

    public SWTSkinTabSet getTabSet(SWTSkinObject skinObject) {
        String sTabSetID = skinObject.getProperties().getStringValue(skinObject.getConfigID() + ".tabset");
        return this.getTabSet(sTabSetID);
    }

    public boolean setActiveTab(String sTabSetID, String sTabViewID) {
        SWTSkinTabSet tabSet = this.getTabSet(sTabSetID);
        if (tabSet == null) {
            System.err.println(sTabSetID);
            return false;
        }
        return tabSet.setActiveTab(sTabViewID);
    }

    public void initialize(Shell shell, String startID) {
        this.initialize(shell, startID, null);
    }

    public void initialize(final Shell shell, String startID, IUIIntializer uiInitializer) {
        String[] sMainGroups;
        Color fg;
        this.shell = shell;
        FormLayout layout = new FormLayout();
        shell.setLayout((Layout)layout);
        shell.setBackgroundMode(1);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (ImageLoader loader : SWTSkin.this.mapImageLoaders.values()) {
                    loader.unLoadImages();
                }
                if (SWTSkin.this.ourSkinProperties) {
                    // empty if block
                }
            }
        });
        Listener l = new Listener(){
            Control lastControl = null;

            public void handleEvent(Event event2) {
                if (shell.isDisposed() && event2.display != null) {
                    event2.display.removeFilter(5, (Listener)this);
                    event2.display.removeFilter(7, (Listener)this);
                    return;
                }
                Control cursorControl = shell.getDisplay().getCursorControl();
                if (cursorControl != this.lastControl) {
                    SWTSkinObjectBasic so;
                    while (this.lastControl != null && !this.lastControl.isDisposed()) {
                        so = (SWTSkinObjectBasic)this.lastControl.getData("SkinObject");
                        if (so != null) {
                            so.switchSuffix("", 3, false, false);
                        }
                        this.lastControl = this.lastControl.getParent();
                    }
                    this.lastControl = cursorControl;
                    while (cursorControl != null) {
                        so = (SWTSkinObjectBasic)cursorControl.getData("SkinObject");
                        if (so != null) {
                            so.switchSuffix("-over", 3, false, false);
                        }
                        cursorControl = cursorControl.getParent();
                    }
                }
            }
        };
        shell.getDisplay().addFilter(5, l);
        shell.getDisplay().addFilter(7, l);
        shell.addListener(27, l);
        shell.addListener(26, l);
        Color bg = this.skinProperties.getColor(startID + ".color");
        if (bg != null) {
            shell.setBackground(bg);
        }
        if ((fg = this.skinProperties.getColor(startID + ".fgcolor")) != null) {
            shell.setForeground(fg);
        }
        if ((sMainGroups = this.skinProperties.getStringArray(startID + ".widgets")) == null) {
            System.out.println("NO " + startID + ".widgets!!");
            sMainGroups = new String[]{};
        }
        for (int i = 0; i < sMainGroups.length; ++i) {
            String sID = sMainGroups[i];
            if (DEBUGLAYOUT) {
                System.out.println("Container: " + sID);
            }
            if (uiInitializer != null) {
                uiInitializer.increaseProgress();
            }
            this.linkIDtoParent(this.skinProperties, sID, sID, null, false, true);
        }
    }

    private void addPaintListenerToAll(Control control) {
        if (!(control instanceof Shell)) {
            control.addListener(9, this.ontopPaintListener);
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.addPaintListenerToAll(children[i]);
            }
        }
    }

    public void layout() {
        if (DEBUGLAYOUT) {
            System.out.println("==== Start Apply Layout");
        }
        for (String sID : this.mapIDsToControls.keySet()) {
            SWTSkinObject[] objects = (SWTSkinObject[])this.mapIDsToControls.get(sID);
            if (DEBUGLAYOUT) {
                System.out.println("Apply Layout for " + objects.length + " " + sID);
            }
            for (int i = 0; i < objects.length; ++i) {
                this.attachControl(objects[i]);
            }
        }
        this.bLayoutComplete = true;
        Object[] listeners = this.listenersLayoutComplete.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            SWTSkinLayoutCompleteListener l = (SWTSkinLayoutCompleteListener)listeners[i];
            l.skinLayoutCompleted();
        }
        this.listenersLayoutComplete.clear();
        if (DEBUGLAYOUT) {
            System.out.println("==== End Apply Layout");
        }
        this.skinProperties.clearCache();
    }

    void attachControl(SWTSkinObject skinObject) {
        if (skinObject == null) {
            return;
        }
        Control controlToLayout = skinObject.getControl();
        if (controlToLayout == null || controlToLayout.isDisposed()) {
            return;
        }
        if (controlToLayout.getData("skin.layedout") != null) {
            return;
        }
        String sConfigID = skinObject.getConfigID();
        SWTSkinProperties properties = skinObject.getProperties();
        String[] sDirections = new String[]{"top", "bottom", "left", "right"};
        Object data = controlToLayout.getLayoutData();
        if (data != null && !(data instanceof FormData)) {
            return;
        }
        FormData oldFormData = (FormData)controlToLayout.getLayoutData();
        if (oldFormData == null) {
            oldFormData = new FormData();
        }
        FormData newFormData = new FormData(oldFormData.width, oldFormData.height);
        String templateID = properties.getStringValue(sConfigID + ".attach.template");
        if (templateID == null) {
            // empty if block
        }
        block18: for (int i = 0; i < sDirections.length; ++i) {
            FormAttachment attachment;
            Control control = null;
            int offset = 0;
            int percent = 0;
            String sAlign = null;
            int align = -1;
            switch (i) {
                case 0: {
                    attachment = oldFormData.top;
                    break;
                }
                case 1: {
                    attachment = oldFormData.bottom;
                    break;
                }
                case 2: {
                    attachment = oldFormData.left;
                    break;
                }
                case 3: {
                    attachment = oldFormData.right;
                    break;
                }
                default: {
                    attachment = null;
                }
            }
            if (attachment != null) {
                control = attachment.control;
                offset = attachment.offset;
                align = attachment.alignment;
                percent = attachment.numerator;
            }
            String suffix = ".attach." + sDirections[i];
            String prefix = sConfigID;
            String[] sParams = properties.getStringArray(sConfigID + suffix);
            if (sParams == null && templateID != null) {
                sParams = properties.getStringArray(templateID + suffix);
                prefix = templateID;
            }
            if (sParams == null) {
                if (attachment != null) {
                    attachment = control == null ? new FormAttachment(percent, offset) : new FormAttachment(control, offset, align);
                }
            } else if (sParams.length == 0 || sParams.length == 1 && sParams[0].length() == 0) {
                attachment = null;
            } else if (sParams[0].length() > 0 && Character.isDigit(sParams[0].charAt(0))) {
                try {
                    percent = Integer.parseInt(sParams[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (sParams.length > 1) {
                    try {
                        offset = Integer.parseInt(sParams[1]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                attachment = new FormAttachment(percent, offset);
            } else {
                int iNextPos;
                String sWidget = sParams[0];
                SWTSkinObject configSkinObject = this.getSkinObjectByID(sWidget, skinObject.getParent());
                if (configSkinObject != null) {
                    control = configSkinObject.getControl();
                    iNextPos = 1;
                } else {
                    iNextPos = 0;
                    if (sWidget.length() != 0) {
                        System.err.println("ERROR: Trying to attach " + sDirections[i] + " of widget '" + skinObject + "' to non-existant widget '" + sWidget + "'.  Attachment Parameters: " + properties.getStringValue(prefix + suffix));
                    }
                }
                for (int j = iNextPos; j < sParams.length; ++j) {
                    if (sParams[j].length() <= 0) continue;
                    char c = sParams[j].charAt(0);
                    if (Character.isDigit(c) || c == '-') {
                        try {
                            offset = Integer.parseInt(sParams[j]);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    sAlign = sParams[j];
                }
                if (sAlign != null) {
                    align = SWTSkinUtils.getAlignment(sAlign, align);
                }
                attachment = new FormAttachment(control, offset, align);
            }
            if (controlToLayout.getData("DEBUG") != null && attachment != null && controlToLayout instanceof Group) {
                Group group = (Group)controlToLayout;
                String sValue = properties.getStringValue(prefix + suffix);
                String sText = group.getText() + "; " + sDirections[i].substring(0, 1) + "=" + (sValue == null ? "(def)" : sValue);
                if (sText.length() < 20) {
                    group.setText(sText);
                }
                group.setToolTipText(sText);
            }
            if (DEBUGLAYOUT) {
                System.out.println("Attach: " + sConfigID + suffix + ": " + properties.getStringValue(prefix + suffix) + "/" + attachment);
            }
            switch (i) {
                case 0: {
                    newFormData.top = attachment;
                    continue block18;
                }
                case 1: {
                    newFormData.bottom = attachment;
                    continue block18;
                }
                case 2: {
                    newFormData.left = attachment;
                    continue block18;
                }
                case 3: {
                    newFormData.right = attachment;
                }
            }
        }
        if (!Constants.isWindows || controlToLayout instanceof Browser) {
            // empty if block
        }
        newFormData.height = properties.getIntValue(sConfigID + ".height", newFormData.height);
        newFormData.width = properties.getIntValue(sConfigID + ".width", newFormData.width);
        if (!skinObject.getDefaultVisibility()) {
            if (newFormData.width != 0 && newFormData.height != 0) {
                controlToLayout.setData("oldSize", (Object)new Point(newFormData.width, newFormData.height));
            }
            newFormData.width = 0;
            newFormData.height = 0;
        }
        controlToLayout.setLayoutData((Object)newFormData);
        controlToLayout.setData("skin.layedout", (Object)"");
    }

    private SWTSkinObject createContainer(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject, boolean bForceCreate, boolean bPropogate, SWTSkinObject intoSkinObject) {
        SWTSkinObject skinObject;
        String[] sItems = properties.getStringArray(sConfigID + ".widgets");
        if (sItems == null && !bForceCreate) {
            return null;
        }
        if (DEBUGLAYOUT) {
            System.out.println("createContainer: " + sID + ";" + properties.getStringValue(sConfigID + ".widgets"));
        }
        if ((skinObject = this.getSkinObjectByID(sID, parentSkinObject)) == null) {
            if (intoSkinObject == null) {
                skinObject = new SWTSkinObjectContainer(this, properties, sID, sConfigID, parentSkinObject);
                this.addToControlMap(skinObject);
            } else {
                skinObject = intoSkinObject;
            }
        } else if (!(skinObject instanceof SWTSkinObjectContainer)) {
            return skinObject;
        }
        if (!bPropogate) {
            boolean bl = bPropogate = properties.getIntValue(sConfigID + ".propogate", 0) == 1;
        }
        if (!bPropogate && parentSkinObject instanceof SWTSkinObjectContainer) {
            bPropogate = ((SWTSkinObjectContainer)parentSkinObject).getPropogation();
        }
        if (bPropogate) {
            ((SWTSkinObjectContainer)skinObject).setPropogation(true);
        }
        if (sItems != null) {
            String[] paramValues = null;
            if (properties instanceof SWTSkinPropertiesParam) {
                paramValues = ((SWTSkinPropertiesParam)properties).getParamValues();
            }
            if (properties instanceof SWTSkinPropertiesClone) {
                properties = ((SWTSkinPropertiesClone)properties).getOriginalProperties();
            }
            if (paramValues != null) {
                properties = new SWTSkinPropertiesParamImpl(properties, paramValues);
            }
            for (int i = 0; i < sItems.length; ++i) {
                String sItemID = sItems[i];
                this.linkIDtoParent(properties, sItemID, sItemID, skinObject, false, true);
            }
        }
        if (this.bLayoutComplete) {
            this.attachControl(skinObject);
        }
        return skinObject;
    }

    private SWTSkinObject createSash(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject, boolean bVertical) {
        SWTSkinObjectBasic skinObject;
        int style = bVertical ? 512 : 256;
        String[] sItems = properties.getStringArray(sConfigID + ".widgets");
        Object createOn = parentSkinObject == null ? this.shell : (Composite)parentSkinObject.getControl();
        if (sItems == null) {
            Sash sash = new Sash((Composite)createOn, style);
            skinObject = new SWTSkinObjectBasic(this, properties, (Control)sash, sID, sConfigID, "sash", parentSkinObject);
            this.addToControlMap(skinObject);
            sash.setBackground(sash.getDisplay().getSystemColor(3));
            sash.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Sash sash = (Sash)e.widget;
                    boolean FASTDRAG = true;
                    if (e.detail == 1) {
                        return;
                    }
                    Rectangle parentArea = sash.getParent().getClientArea();
                    FormData formData = (FormData)sash.getLayoutData();
                    formData.left = new FormAttachment(e.x * 100 / parentArea.width);
                    sash.getParent().layout();
                }
            });
        } else {
            SashForm sashForm = new SashForm((Composite)createOn, style);
            skinObject = new SWTSkinObjectContainer(this, properties, (Control)sashForm, sID, sConfigID, "sash", parentSkinObject);
            this.addToControlMap(skinObject);
            int iSashWidth = properties.getIntValue(sConfigID + ".sash.width", -1);
            if (iSashWidth > 0) {
                sashForm.SASH_WIDTH = iSashWidth;
            }
            for (int i = 0; i < sItems.length; ++i) {
                String sChildID = sItems[i];
                this.linkIDtoParent(properties, sChildID, sChildID, skinObject, false, true);
            }
        }
        if (this.bLayoutComplete) {
            this.attachControl(skinObject);
        }
        return skinObject;
    }

    private SWTSkinObject createMySash(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject, boolean bVertical) {
        SWTSkinObjectSash skinObject = new SWTSkinObjectSash(this, properties, sID, sConfigID, typeParams, parentSkinObject, bVertical);
        this.addToControlMap(skinObject);
        if (this.bLayoutComplete) {
            this.attachControl(skinObject);
        }
        return skinObject;
    }

    public SWTSkinObjectTab createTab(String sID, String sTemplateKey, SWTSkinObject tabHolder) {
        String sTemplateID = SWTSkinTabSet.getTemplateID(this, tabHolder, sTemplateKey);
        if (sTemplateID == null) {
            return null;
        }
        SWTSkinObject skinObject = this.linkIDtoParent(this.skinProperties, sID, sTemplateID, tabHolder, true, true);
        if (this.bLayoutComplete && skinObject != null) {
            ((Composite)skinObject.getControl()).getParent().layout(true);
        }
        if (skinObject instanceof SWTSkinObjectTab) {
            return (SWTSkinObjectTab)skinObject;
        }
        System.err.println(skinObject + " not a SWTSkinObjectTab! Template: " + sTemplateID);
        return null;
    }

    private SWTSkinObjectTab _createTab(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject) {
        SWTSkinObjectTab skinObjectTab = new SWTSkinObjectTab(this, properties, sID, sConfigID, parentSkinObject);
        this.createContainer(properties, sID, sConfigID, parentSkinObject, true, true, skinObjectTab);
        this.addToControlMap(skinObjectTab);
        String sTabSet = properties.getStringValue(sConfigID + ".tabset", "default");
        SWTSkinTabSet tabset = (SWTSkinTabSet)this.mapTabSetToControls.get(sTabSet);
        if (tabset == null) {
            tabset = new SWTSkinTabSet(this, sTabSet);
            this.mapTabSetToControls.put(sTabSet, tabset);
            if (DEBUGLAYOUT) {
                System.out.println("New TabSet: " + sTabSet);
            }
        }
        tabset.addTab(skinObjectTab);
        if (DEBUGLAYOUT) {
            System.out.println("Tab " + sID + " added");
        }
        if (this.bLayoutComplete) {
            this.attachControl(skinObjectTab);
        }
        return skinObjectTab;
    }

    private SWTSkinObject createTextLabel(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectText2 skinObject = new SWTSkinObjectText2(this, properties, sID, sConfigID, typeParams, parentSkinObject);
        this.addToControlMap(skinObject);
        if (this.bLayoutComplete) {
            this.attachControl(skinObject);
        }
        return skinObject;
    }

    private SWTSkinObject createSlider(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectSlider skinObject = new SWTSkinObjectSlider(this, properties, sID, sConfigID, typeParams, parentSkinObject);
        this.addToControlMap(skinObject);
        if (this.bLayoutComplete) {
            this.attachControl(skinObject);
        }
        return skinObject;
    }

    public Shell getShell() {
        return this.shell;
    }

    private String getAttachLine(FormAttachment attach) {
        String s = "";
        if (attach.control != null) {
            s = s + attach.control.getData("ConfigID");
            if (attach.offset != 0 || attach.alignment != -1) {
                s = s + "," + attach.offset;
            }
            if (attach.alignment != -1) {
                if (attach.alignment == 16384) {
                    s = s + ",left";
                } else if (attach.alignment == 131072) {
                    s = s + ",right";
                } else if (attach.alignment == 128) {
                    s = s + ",top";
                } else if (attach.alignment == 1024) {
                    s = s + ",bottom";
                } else if (attach.alignment == 0x1000000) {
                    s = s + ",center";
                }
            }
        } else {
            s = s + (int)(100.0 * (double)attach.numerator / (double)attach.denominator) + "," + attach.offset;
        }
        return s;
    }

    protected Listener getHandCursorListener(Display display) {
        if (this.handCursorListener == null) {
            final Cursor handCursor = new Cursor((Device)display, 21);
            this.handCursorListener = new Listener(){

                public void handleEvent(Event event2) {
                    if (event2.type == 6) {
                        ((Control)event2.widget).setCursor(handCursor);
                    }
                    if (event2.type == 7) {
                        ((Control)event2.widget).setCursor(null);
                    }
                }
            };
        }
        return this.handCursorListener;
    }

    public SWTSkinObject createSkinObject(String sID, String sConfigID, SWTSkinObject parentSkinObject) {
        return this.createSkinObject(sID, sConfigID, parentSkinObject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWTSkinObject createSkinObject(String sID, String sConfigID, SWTSkinObject parentSkinObject, Object creationParams) {
        SWTSkinObject skinObject = null;
        Cursor cursor = this.shell.getCursor();
        try {
            this.shell.setCursor(this.shell.getDisplay().getSystemCursor(1));
            boolean b = this.bLayoutComplete;
            this.bLayoutComplete = false;
            skinObject = this.linkIDtoParent(this.skinProperties, sID, sConfigID, parentSkinObject, true, true, creationParams);
            if (b && skinObject != null) {
                this.layout();
                Control control = skinObject.getParent().getControl();
                if (control instanceof Composite) {
                    ((Composite)control).layout(true);
                }
            }
            this.bLayoutComplete = b;
        }
        catch (Exception e) {
            Debug.out("Trying to create " + sID + "." + sConfigID + " on " + parentSkinObject, e);
        }
        finally {
            this.shell.setCursor(cursor);
        }
        return skinObject;
    }

    public void addSkinObject(SWTSkinObject skinObject) {
        String sViewID = skinObject.getViewID();
        if (sViewID != null) {
            this.setSkinObjectViewID(skinObject, sViewID);
        }
        this.attachControl(skinObject);
    }

    public void removeSkinObject(SWTSkinObject skinObject) {
        int x;
        skinObject.triggerListeners(3);
        String id = skinObject.getSkinObjectID();
        SWTSkinObject[] objects = (SWTSkinObject[])this.mapIDsToControls.get(id);
        if (objects != null) {
            x = 0;
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == skinObject || x++ == i) continue;
                objects[x] = objects[i];
            }
            SWTSkinObject[] newObjects = new SWTSkinObject[x];
            System.arraycopy(objects, 0, newObjects, 0, x);
            this.mapIDsToControls.put(id, newObjects);
        }
        if ((objects = (SWTSkinObject[])this.mapPublicViewIDsToControls.get(id = skinObject.getViewID())) != null) {
            x = 0;
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == skinObject || x++ == i) continue;
                objects[x] = objects[i];
            }
            SWTSkinObject[] newObjects = new SWTSkinObject[x];
            System.arraycopy(objects, 0, newObjects, 0, x);
            this.mapPublicViewIDsToControls.put(id, newObjects);
        }
        skinObject.dispose();
    }

    private SWTSkinObject linkIDtoParent(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject, boolean bForceCreate, boolean bAddView) {
        return this.linkIDtoParent(properties, sID, sConfigID, parentSkinObject, bForceCreate, bAddView, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SWTSkinObject linkIDtoParent(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject, boolean bForceCreate, boolean bAddView, Object creationParams) {
        ++this.currentSkinObjectcreationCount;
        SWTSkinObject skinObject = null;
        try {
            String sViewID;
            String sImageLoc;
            String sType;
            String[] sTypeParams = properties.getStringArray(sConfigID + ".type");
            if (sTypeParams != null && sTypeParams.length > 0) {
                sType = sTypeParams[0];
                bForceCreate = true;
            } else {
                sType = null;
                sImageLoc = properties.getStringValue(sConfigID);
                if (sImageLoc != null) {
                    sType = "image";
                } else {
                    String sText = properties.getStringValue(sConfigID + ".text");
                    if (sText != null) {
                        sType = "text";
                    } else {
                        String sWidgets = properties.getStringValue(sConfigID + ".widgets");
                        if (sWidgets != null || bForceCreate) {
                            sType = "container";
                        }
                    }
                }
                if (sType == null) {
                    if (DEBUGLAYOUT) {
                        System.err.println("no type defined for " + sConfigID);
                    }
                    SWTSkinObject sWTSkinObject = null;
                    return sWTSkinObject;
                }
                sTypeParams = new String[]{sType};
            }
            if (sType.equals("image")) {
                skinObject = this.createImageLabel(properties, sID, sConfigID, null, sTypeParams, parentSkinObject);
            } else if (sType.equals("image2")) {
                skinObject = this.createImageLabel2(properties, sID, parentSkinObject);
            } else if (sType.equals("container2")) {
                skinObject = this.createContainer2(properties, sID, sConfigID, parentSkinObject, bForceCreate, false, null);
            } else if (sType.equals("container")) {
                skinObject = this.createContainer(properties, sID, sConfigID, parentSkinObject, bForceCreate, false, null);
            } else if (sType.equals("text")) {
                skinObject = this.createTextLabel(properties, sID, sConfigID, sTypeParams, parentSkinObject);
            } else if (sType.equals("tab")) {
                skinObject = this._createTab(properties, sID, sConfigID, parentSkinObject);
            } else if (sType.equals("v-sash")) {
                skinObject = this.createSash(properties, sID, sConfigID, parentSkinObject, true);
            } else if (sType.equals("h-sash")) {
                skinObject = this.createSash(properties, sID, sConfigID, parentSkinObject, false);
            } else if (sType.equals("v-mysash")) {
                skinObject = this.createMySash(properties, sID, sConfigID, sTypeParams, parentSkinObject, true);
            } else if (sType.equals("h-mysash")) {
                skinObject = this.createMySash(properties, sID, sConfigID, sTypeParams, parentSkinObject, false);
            } else if (sType.equals("clone")) {
                skinObject = this.createClone(properties, sID, sConfigID, sTypeParams, parentSkinObject);
            } else if (sType.equals("slider")) {
                skinObject = this.createSlider(properties, sID, sConfigID, sTypeParams, parentSkinObject);
            } else {
                if (sType.equals("hidden")) {
                    sImageLoc = null;
                    return sImageLoc;
                }
                if (sType.equals("browser")) {
                    skinObject = this.createBrowser(properties, sID, sConfigID, parentSkinObject);
                } else if (sType.equals("separator")) {
                    skinObject = this.createSeparator(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                } else if (sType.equals("button")) {
                    skinObject = this.createButton(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                } else {
                    System.err.println(sConfigID + ": Invalid type of " + sType);
                }
            }
            skinObject.setData("CreationParams", creationParams);
            if (bAddView && (sViewID = skinObject.getViewID()) != null) {
                this.setSkinObjectViewID(skinObject, sViewID);
            }
            if (this.bLayoutComplete) {
                this.attachControl(skinObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            --this.currentSkinObjectcreationCount;
        }
        if (skinObject != null) {
            skinObject.triggerListeners(4);
        }
        return skinObject;
    }

    private SWTSkinObject createButton(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectButton skinObject = new SWTSkinObjectButton(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        if (this.bLayoutComplete) {
            this.attachControl(skinObject);
        }
        return skinObject;
    }

    private SWTSkinObject createBrowser(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject) {
        SWTSkinObjectBrowser skinObject = new SWTSkinObjectBrowser(this, properties, sID, sConfigID, parentSkinObject);
        this.addToControlMap(skinObject);
        if (this.bLayoutComplete) {
            this.attachControl(skinObject);
        }
        return skinObject;
    }

    private SWTSkinObject createClone(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject) {
        String[] sCloneParams;
        if (sConfigID == "") {
            System.err.println("XXXXXXXX " + sID + " has no config ID.." + Debug.getStackTrace(false, false));
        }
        if (typeParams.length > 1) {
            int size = typeParams.length - 1;
            sCloneParams = new String[size];
            System.arraycopy(typeParams, 1, sCloneParams, 0, size);
        } else {
            sCloneParams = properties.getStringArray(sConfigID + ".clone");
            if (sCloneParams == null || sCloneParams.length < 1) {
                return null;
            }
        }
        if (properties instanceof SWTSkinPropertiesClone) {
            properties = ((SWTSkinPropertiesClone)properties).getOriginalProperties();
        }
        SWTSkinPropertiesClone cloneProperties = new SWTSkinPropertiesClone(properties, sConfigID, sCloneParams);
        return this.linkIDtoParent(cloneProperties, sID, "", parentSkinObject, false, false);
    }

    private SWTSkinObject createImageLabel(SWTSkinProperties properties, String sID, String sConfigID, String sImageID, String[] typeParams, SWTSkinObject parentSkinObject) {
        if (sImageID == null) {
            sImageID = sConfigID;
            if (typeParams.length > 1) {
                properties.addProperty(sConfigID + ".image", typeParams[1]);
            }
        }
        SWTSkinObjectImage skinObject = new SWTSkinObjectImage(this, properties, sID, sConfigID, sImageID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createContainer2(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject, boolean bForceCreate, boolean bPropogate, SWTSkinObject intoSkinObject) {
        SWTSkinObject skinObject;
        String[] sItems = properties.getStringArray(sConfigID + ".widgets");
        if (sItems == null && !bForceCreate) {
            return null;
        }
        if (DEBUGLAYOUT) {
            System.out.println("createContainer: " + sID + ";" + properties.getStringValue(sConfigID + ".widgets"));
        }
        if ((skinObject = this.getSkinObjectByID(sID, parentSkinObject)) == null) {
            if (intoSkinObject == null) {
                skinObject = new SWTSkinObjectImageContainer(this, properties, sID, sConfigID, parentSkinObject);
                this.addToControlMap(skinObject);
            } else {
                skinObject = intoSkinObject;
            }
        } else if (!(skinObject instanceof SWTSkinObjectContainer)) {
            return skinObject;
        }
        if (!bPropogate) {
            boolean bl = bPropogate = properties.getIntValue(sConfigID + ".propogate", 0) == 1;
        }
        if (!bPropogate && parentSkinObject instanceof SWTSkinObjectContainer) {
            bPropogate = ((SWTSkinObjectContainer)parentSkinObject).getPropogation();
        }
        if (bPropogate) {
            ((SWTSkinObjectContainer)skinObject).setPropogation(true);
        }
        if (sItems != null) {
            String[] paramValues = null;
            if (properties instanceof SWTSkinPropertiesParam) {
                paramValues = ((SWTSkinPropertiesParam)properties).getParamValues();
            }
            if (properties instanceof SWTSkinPropertiesClone) {
                properties = ((SWTSkinPropertiesClone)properties).getOriginalProperties();
            }
            if (paramValues != null) {
                properties = new SWTSkinPropertiesParamImpl(properties, paramValues);
            }
            for (int i = 0; i < sItems.length; ++i) {
                String sItemID = sItems[i];
                this.linkIDtoParent(properties, sItemID, sItemID, skinObject, false, true);
            }
        }
        if (this.bLayoutComplete) {
            this.attachControl(skinObject);
        }
        return skinObject;
    }

    private SWTSkinObject createImageLabel2(SWTSkinProperties properties, String sConfigID, SWTSkinObject parentSkinObject) {
        Object createOn = parentSkinObject == null ? this.shell : (Composite)parentSkinObject.getControl();
        Canvas drawable = new Canvas((Composite)createOn, 262144);
        drawable.setVisible(false);
        ImageLoader imageLoader = this.getImageLoader(properties);
        Image image = imageLoader.getImage(sConfigID);
        if (ImageLoader.isRealImage(image)) {
            image = imageLoader.getImage(sConfigID + ".image");
        }
        drawable.setData("image", (Object)image);
        SWTSkinObjectBasic skinObject = new SWTSkinObjectBasic(this, properties, (Control)drawable, sConfigID, sConfigID, "image", parentSkinObject);
        this.addToControlMap(skinObject);
        this.ontopImages.add(skinObject);
        return skinObject;
    }

    private SWTSkinObject createSeparator(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectSeparator skinObject = new SWTSkinObjectSeparator(this, properties, sID, sConfigID, parentSkinObject);
        this.addToControlMap(skinObject);
        if (this.bLayoutComplete) {
            this.attachControl(skinObject);
        }
        return skinObject;
    }

    public SWTSkinProperties getSkinProperties() {
        return this.skinProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(String viewID, SWTSkinObjectListener listener) {
        this.mapPublicViewIDsToListeners_mon.enter();
        try {
            Object existing = this.mapPublicViewIDsToListeners.get(viewID);
            if (existing instanceof List) {
                List list = (List)existing;
                list.add(listener);
            } else {
                ArrayList<SWTSkinObjectListener> list = new ArrayList<SWTSkinObjectListener>();
                list.add(listener);
                this.mapPublicViewIDsToListeners.put(viewID, list);
            }
        }
        finally {
            this.mapPublicViewIDsToListeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWTSkinObjectListener[] getSkinObjectListeners(String viewID) {
        if (viewID == null) {
            return NOLISTENERS;
        }
        this.mapPublicViewIDsToListeners_mon.enter();
        try {
            Object existing = this.mapPublicViewIDsToListeners.get(viewID);
            if (existing instanceof List) {
                List list = (List)existing;
                SWTSkinObjectListener[] sWTSkinObjectListenerArray = list.toArray(NOLISTENERS);
                return sWTSkinObjectListenerArray;
            }
            SWTSkinObjectListener[] sWTSkinObjectListenerArray = NOLISTENERS;
            return sWTSkinObjectListenerArray;
        }
        finally {
            this.mapPublicViewIDsToListeners_mon.exit();
        }
    }

    public boolean isLayoutComplete() {
        return this.bLayoutComplete;
    }

    public void addListener(SWTSkinLayoutCompleteListener l) {
        if (!this.listenersLayoutComplete.contains(l)) {
            this.listenersLayoutComplete.add(l);
        }
    }

    public static void main(String[] args) {
        Date d = new Date();
        long t = d.getTime();
        t -= 99878400000L;
        t -= 21600000L;
        Date then = new Date(t -= 1020000L);
        System.out.println(d + ";" + then);
    }

    public boolean isCreatingSO() {
        return this.currentSkinObjectcreationCount > 0;
    }

    public void triggerLanguageChange() {
        Object[] values = this.mapIDsToControls.values().toArray();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (!(value instanceof SWTSkinObject[])) continue;
            SWTSkinObject[] skinObjects = (SWTSkinObject[])value;
            for (int j = 0; j < skinObjects.length; ++j) {
                SWTSkinObject so = skinObjects[j];
                so.triggerListeners(6);
            }
        }
    }
}

