/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;

public class SWTSkinObjectText2
extends SWTSkinObjectBasic
implements SWTSkinObjectText,
PaintListener {
    String sText;
    String sDisplayText;
    String sKey;
    boolean bIsTextDefault = false;
    private int style = 64;
    private Canvas canvas;
    private boolean isUnderline;
    private int antialiasMode = -1;
    private boolean isAllcaps;
    private boolean hasShadow;
    private int hpadding;
    private int vpadding;
    private boolean relayoutOnTextChange = true;
    private boolean isItalic = false;
    private static Font font = null;
    private GCStringPrinter lastStringPrinter;
    private Color colorUrl;

    public SWTSkinObjectText2(SWTSkin skin, final SWTSkinProperties skinProperties, String sID, final String sConfigID, String[] typeParams, SWTSkinObject parent) {
        super(skin, skinProperties, sID, sConfigID, "text", parent);
        String sAntiAlias;
        String sVAlign;
        int align;
        String sAlign = skinProperties.getStringValue(sConfigID + ".align");
        if (sAlign != null && (align = SWTSkinUtils.getAlignment(sAlign, 0)) != 0) {
            this.style |= align;
        }
        if ((sVAlign = skinProperties.getStringValue(sConfigID + ".v-align")) != null) {
            int align2 = SWTSkinUtils.getAlignment(sVAlign, 0);
            if (align2 != 0x1000000) {
                this.style = align2 != 0 ? (this.style |= align2) : (this.style |= 0x80);
            }
        } else {
            this.style |= 0x80;
        }
        if (skinProperties.getIntValue(sConfigID + ".border", 0) == 1) {
            this.style |= 0x800;
        }
        if ((sAntiAlias = skinProperties.getStringValue(sConfigID + ".antialias", (String)null)) != null && sAntiAlias.length() > 0) {
            this.antialiasMode = sAntiAlias.equals("1") || sAntiAlias.toLowerCase().equals("true") ? 1 : 0;
        }
        this.relayoutOnTextChange = skinProperties.getBooleanValue(sConfigID + ".text.relayoutOnChange", true);
        Object createOn = parent == null ? skin.getShell() : (Composite)parent.getControl();
        this.canvas = new Canvas((Composite)createOn, 0x20000000){
            Point ptMax;
            {
                super(x0, x1);
                this.ptMax = new Point(0, 0);
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                int fixedHeight;
                int fixedWidth;
                int border = this.getBorderWidth() * 2;
                Point pt = new Point(border, border);
                if (SWTSkinObjectText2.this.sDisplayText == null) {
                    return pt;
                }
                Font existingFont = (Font)SWTSkinObjectText2.this.canvas.getData("font");
                Color existingColor = (Color)SWTSkinObjectText2.this.canvas.getData("color");
                GC gc = new GC((Drawable)this);
                if (existingFont != null) {
                    gc.setFont(existingFont);
                }
                if (existingColor != null) {
                    gc.setForeground(existingColor);
                }
                if (SWTSkinObjectText2.this.antialiasMode != -1) {
                    try {
                        gc.setTextAntialias(SWTSkinObjectText2.this.antialiasMode);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                pt = gc.textExtent(SWTSkinObjectText2.this.sDisplayText);
                pt.x += border + SWTSkinObjectText2.this.hpadding;
                pt.y += border + SWTSkinObjectText2.this.vpadding;
                gc.dispose();
                if (SWTSkinObjectText2.this.isUnderline) {
                    ++pt.y;
                }
                if (SWTSkinObjectText2.this.hasShadow) {
                    ++pt.x;
                }
                if (SWTSkinObjectText2.this.isItalic) {
                    pt.x += 4;
                }
                if ((fixedWidth = skinProperties.getIntValue(sConfigID + ".width", -1)) >= 0) {
                    pt.x = fixedWidth;
                }
                if ((fixedHeight = skinProperties.getIntValue(sConfigID + ".height", -1)) >= 0) {
                    pt.y = fixedHeight;
                }
                if (this.isVisible()) {
                    if (pt.x > this.ptMax.x) {
                        this.ptMax.x = pt.x;
                    }
                    if (pt.y > this.ptMax.y) {
                        this.ptMax.y = pt.y;
                    }
                }
                return pt;
            }
        };
        this.canvas.setData("font", (Object)font);
        this.setControl((Control)this.canvas);
        if (typeParams.length > 1) {
            this.bIsTextDefault = true;
            this.sText = typeParams[1];
            for (int i = 2; i < typeParams.length; ++i) {
                this.sText = this.sText + ", " + typeParams[i];
            }
            this.sDisplayText = this.isAllcaps && this.sText != null ? this.sText.toUpperCase() : this.sText;
        }
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                GCStringPrinter.URLInfo hitUrl;
                if (SWTSkinObjectText2.this.lastStringPrinter != null && (hitUrl = SWTSkinObjectText2.this.lastStringPrinter.getHitUrl(e.x, e.y)) != null) {
                    Utils.launch(hitUrl.url);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (SWTSkinObjectText2.this.lastStringPrinter != null && SWTSkinObjectText2.this.lastStringPrinter.hasHitUrl()) {
                    GCStringPrinter.URLInfo hitUrl = SWTSkinObjectText2.this.lastStringPrinter.getHitUrl(e.x, e.y);
                    SWTSkinObjectText2.this.canvas.setCursor(hitUrl == null ? null : SWTSkinObjectText2.this.canvas.getDisplay().getSystemCursor(21));
                }
            }
        });
        this.setAlwaysHookPaintListener(true);
        this.updateFont("");
    }

    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        String text;
        if ((suffix = super.switchSuffix(suffix, level, walkUp, walkDown)) == null) {
            return null;
        }
        String sPrefix = this.sConfigID + ".text";
        if ((this.sText == null || this.bIsTextDefault) && (text = this.properties.getStringValue(sPrefix + suffix)) != null) {
            this.sText = text;
            this.sDisplayText = this.isAllcaps && this.sText != null ? this.sText.toUpperCase() : this.sText;
        }
        final String fSuffix = suffix;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (SWTSkinObjectText2.this.canvas == null || SWTSkinObjectText2.this.canvas.isDisposed()) {
                    return;
                }
                SWTSkinObjectText2.this.updateFont(fSuffix);
            }
        });
        return suffix;
    }

    private void updateFont(String suffix) {
        Color color;
        String sPrefix = this.sConfigID + ".text";
        Color newColorURL = this.properties.getColor(sPrefix + ".urlcolor" + suffix);
        if (newColorURL != null) {
            this.colorUrl = newColorURL;
        }
        if ((color = this.properties.getColor(sPrefix + ".color" + suffix)) != null) {
            this.canvas.setData("color", (Object)color);
        }
        this.hpadding = this.properties.getIntValue(sPrefix + ".h-padding", 0);
        this.vpadding = this.properties.getIntValue(sPrefix + ".v-padding", 0);
        Font existingFont = (Font)this.canvas.getData("Font" + suffix);
        if (existingFont != null && !existingFont.isDisposed()) {
            this.canvas.setData("font", (Object)existingFont);
        } else {
            String sSize;
            String sStyle;
            boolean bNewFont = false;
            int iFontSize = -1;
            int iFontWeight = -1;
            String sFontFace = null;
            FontData[] tempFontData = this.canvas.getFont().getFontData();
            sFontFace = this.properties.getStringValue(sPrefix + ".font" + suffix);
            if (sFontFace != null) {
                tempFontData[0].setName(sFontFace);
                bNewFont = true;
            }
            if ((sStyle = this.properties.getStringValue(sPrefix + ".style" + suffix)) != null) {
                this.isAllcaps = false;
                String[] sStyles = sStyle.toLowerCase().split(",");
                for (int i = 0; i < sStyles.length; ++i) {
                    String s = sStyles[i];
                    if (s.equals("allcaps")) {
                        this.isAllcaps = true;
                    }
                    if (s.equals("bold")) {
                        iFontWeight = iFontWeight == -1 ? 1 : (iFontWeight |= 1);
                        bNewFont = true;
                    }
                    if (s.equals("italic")) {
                        iFontWeight = iFontWeight == -1 ? 2 : (iFontWeight |= 2);
                        bNewFont = true;
                        this.isItalic = true;
                    } else {
                        this.isItalic = false;
                    }
                    this.isUnderline = s.equals("underline");
                    if (this.isUnderline) {
                        this.canvas.addPaintListener(new PaintListener(){

                            public void paintControl(PaintEvent e) {
                                int x = 0;
                                Point pt = e.gc.textExtent(SWTSkinObjectText2.this.sDisplayText);
                                Point size = ((Control)e.widget).getSize();
                                if (pt.x < size.x) {
                                    x = size.x - pt.x;
                                    size.x = pt.x;
                                }
                                e.gc.drawLine(x, size.y - 1, size.x - 1 + x, size.y - 1);
                            }
                        });
                    }
                    if (s.equals("strike")) {
                        this.canvas.addPaintListener(new PaintListener(){

                            public void paintControl(PaintEvent e) {
                                Point size = ((Control)e.widget).getSize();
                                int y = size.y / 2;
                                e.gc.drawLine(0, y, size.x - 1, y);
                            }
                        });
                    }
                    if (s.equals("normal")) {
                        bNewFont = true;
                    }
                    if (!s.equals("shadow")) continue;
                    this.hasShadow = true;
                }
                String string = this.sDisplayText = this.isAllcaps && this.sText != null ? this.sText.toUpperCase() : this.sText;
            }
            if (iFontWeight >= 0) {
                tempFontData[0].setStyle(iFontWeight);
            }
            if ((sSize = this.properties.getStringValue(sPrefix + ".size" + suffix)) != null) {
                FontData[] fd = this.canvas.getFont().getFontData();
                try {
                    char firstChar = sSize.charAt(0);
                    if (firstChar == '+' || firstChar == '-') {
                        sSize = sSize.substring(1);
                    }
                    double dSize = NumberFormat.getInstance(Locale.US).parse(sSize).doubleValue();
                    iFontSize = firstChar == '+' ? (int)((double)fd[0].height + dSize) : (firstChar == '-' ? (int)((double)fd[0].height - dSize) : (sSize.endsWith("px") ? Utils.getFontHeightFromPX((Device)this.canvas.getDisplay(), tempFontData, null, (int)dSize) : (int)dSize));
                    bNewFont = true;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (bNewFont) {
                FontData[] fd = this.canvas.getFont().getFontData();
                if (iFontSize > 0) {
                    fd[0].setHeight(iFontSize);
                }
                if (iFontWeight >= 0) {
                    fd[0].setStyle(iFontWeight);
                }
                if (sFontFace != null) {
                    fd[0].setName(sFontFace);
                }
                final Font canvasFont = new Font((Device)this.canvas.getDisplay(), fd);
                this.canvas.setData("font", (Object)canvasFont);
                this.canvas.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        canvasFont.dispose();
                    }
                });
                this.canvas.setData("Font" + suffix, (Object)canvasFont);
            }
        }
        this.canvas.redraw();
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (text.equals(this.sText)) {
            return;
        }
        this.sText = text;
        this.sDisplayText = this.isAllcaps && this.sText != null ? this.sText.toUpperCase() : this.sText;
        this.sKey = null;
        this.bIsTextDefault = false;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (SWTSkinObjectText2.this.canvas != null && !SWTSkinObjectText2.this.canvas.isDisposed()) {
                    SWTSkinObjectText2.this.canvas.redraw();
                    if (SWTSkinObjectText2.this.relayoutOnTextChange) {
                        Utils.relayout((Control)SWTSkinObjectText2.this.canvas);
                    }
                }
            }
        });
    }

    public void paintControl(GC gc) {
        if (this.sText == null || this.sText.length() == 0) {
            return;
        }
        super.paintControl(gc);
        Composite composite = (Composite)this.control;
        Rectangle clientArea = composite.getClientArea();
        Font existingFont = (Font)this.canvas.getData("font");
        Color existingColor = (Color)this.canvas.getData("color");
        if (existingFont != null) {
            gc.setFont(existingFont);
        }
        if (existingColor != null) {
            gc.setForeground(existingColor);
        }
        if (this.antialiasMode != -1) {
            try {
                gc.setTextAntialias(this.antialiasMode);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.hasShadow) {
            Rectangle r = new Rectangle(clientArea.x + 1, clientArea.y + 1, clientArea.width, clientArea.height);
            Color foreground = gc.getForeground();
            Color color = ColorCache.getColor(gc.getDevice(), 0, 0, 0);
            gc.setForeground(color);
            gc.setAlpha(64);
            GCStringPrinter.printString(gc, this.sDisplayText, r, true, false, this.style);
            gc.setAlpha(255);
            gc.setForeground(foreground);
        }
        this.lastStringPrinter = new GCStringPrinter(gc, this.sDisplayText, clientArea, true, false, this.style);
        if (this.colorUrl != null) {
            this.lastStringPrinter.setUrlColor(this.colorUrl);
        }
        this.lastStringPrinter.printString();
    }

    public void setTextID(String key) {
        if (key == null) {
            this.setText("");
        } else if (key.equals(this.sKey)) {
            return;
        }
        this.sText = MessageText.getString(key);
        this.sDisplayText = this.isAllcaps && this.sText != null ? this.sText.toUpperCase() : this.sText;
        this.sKey = key;
        this.bIsTextDefault = false;
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                SWTSkinObjectText2.this.canvas.redraw();
                if (SWTSkinObjectText2.this.relayoutOnTextChange) {
                    SWTSkinObjectText2.this.canvas.layout(true);
                    Utils.relayout((Control)SWTSkinObjectText2.this.canvas);
                }
            }
        });
    }

    public void setTextID(String key, String[] params) {
        if (key == null) {
            this.setText("");
        }
        this.sText = MessageText.getString(key, params);
        this.sDisplayText = this.isAllcaps && this.sText != null ? this.sText.toUpperCase() : this.sText;
        this.sKey = key;
        this.bIsTextDefault = false;
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                SWTSkinObjectText2.this.canvas.redraw();
                if (SWTSkinObjectText2.this.relayoutOnTextChange) {
                    SWTSkinObjectText2.this.canvas.layout(true);
                    Utils.relayout((Control)SWTSkinObjectText2.this.canvas);
                }
            }
        });
    }

    public void triggerListeners(int eventType, Object params) {
        if (eventType == 6 && this.sKey != null) {
            this.setTextID(this.sKey);
        }
        super.triggerListeners(eventType, params);
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }
}

