/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.browser.listener.DownloadUrlInfoSWT;
import com.aelitis.azureus.ui.swt.utils.PlayNowList;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.PlayUtils;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.FileDownloadWindow;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

public class TorrentUIUtilsV3 {
    private static final Pattern hashPattern = Pattern.compile("download/([A-Z0-9]{32})\\.torrent");

    public static void loadTorrent(final AzureusCore core, DownloadUrlInfo dlInfo, final boolean playNow, final boolean playPrepare, boolean bringToFront, final boolean forceDRMtoCDP) {
        if (dlInfo instanceof DownloadUrlInfoSWT) {
            DownloadUrlInfoSWT dlInfoSWT = (DownloadUrlInfoSWT)dlInfo;
            dlInfoSWT.invoke(playNow ? "play" : "download");
            return;
        }
        String url = dlInfo.getDownloadURL();
        try {
            UIFunctionsSWT uiFunctions;
            Matcher m;
            if ((playNow || playPrepare) && (m = hashPattern.matcher(url)).find()) {
                String hash = m.group(1);
                GlobalManager gm = core.getGlobalManager();
                final DownloadManager dm = gm.getDownloadManager(new HashWrapper(Base32.decode(hash)));
                if (dm != null) {
                    new AEThread2("playExisting", true){

                        public void run() {
                            if (playNow) {
                                Debug.outNoStack("loadTorrent already exists.. playing", false);
                                TorrentListViewsUtils.playOrStream(dm);
                            } else {
                                Debug.outNoStack("loadTorrent already exists.. preparing", false);
                                PlayUtils.prepareForPlay(dm);
                            }
                        }
                    }.start();
                    return;
                }
            }
            if (PlatformConfigMessenger.urlCanRPC(url)) {
                url = ConstantsV3.appendURLSuffix(url);
            }
            if ((uiFunctions = (UIFunctionsSWT)UIFunctionsManager.getUIFunctions()) != null) {
                Shell shell;
                if (!COConfigurationManager.getBooleanParameter("add_torrents_silently") && bringToFront) {
                    uiFunctions.bringToFront();
                }
                if ((shell = uiFunctions.getMainShell()) != null) {
                    new FileDownloadWindow(core, shell, url, dlInfo.getReferer(), dlInfo.getRequestProperties(), new TorrentDownloaderCallBackInterface(){

                        public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
                            if (state == 3) {
                                DownloadManager existingDM;
                                HashWrapper hw;
                                TOTorrent torrent;
                                File file = inf.getFile();
                                file.deleteOnExit();
                                if (!TorrentUtil.isFileTorrent(file, Utils.findAnyShell(), file.getName())) {
                                    return;
                                }
                                try {
                                    torrent = TorrentUtils.readFromFile(file, false);
                                }
                                catch (TOTorrentException e) {
                                    Debug.out(e);
                                    return;
                                }
                                if (playNow && !PlatformTorrentUtils.isPlatformTracker(torrent)) {
                                    Debug.out("stopped loading torrent because it's not in whitelist");
                                    return;
                                }
                                try {
                                    hw = torrent.getHashWrapper();
                                }
                                catch (TOTorrentException e1) {
                                    Debug.out(e1);
                                    return;
                                }
                                if (forceDRMtoCDP && (PlatformTorrentUtils.isContentDRM(torrent) || PlatformTorrentUtils.isContentPurchased(torrent))) {
                                    TorrentListViewsUtils.viewDetails(hw.toBase32String(), "loadtorrent");
                                    return;
                                }
                                GlobalManager gm = core.getGlobalManager();
                                if ((playNow || playPrepare) && (existingDM = gm.getDownloadManager(hw)) != null) {
                                    if (playNow) {
                                        TorrentListViewsUtils.playOrStream(existingDM);
                                    } else {
                                        PlayUtils.prepareForPlay(existingDM);
                                    }
                                    return;
                                }
                                final HashWrapper fhw = hw;
                                GlobalManagerAdapter l = new GlobalManagerAdapter(){

                                    public void downloadManagerAdded(DownloadManager dm) {
                                        try {
                                            core.getGlobalManager().removeListener(this);
                                            TorrentUIUtilsV3.handleDMAdded(dm, playNow, playPrepare, fhw);
                                        }
                                        catch (Exception e) {
                                            Debug.out(e);
                                        }
                                    }
                                };
                                gm.addListener(l, false);
                                if (playNow || playPrepare) {
                                    PlayNowList.add(hw);
                                }
                                TorrentOpener.openTorrent(file.getAbsolutePath());
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    private static void handleDMAdded(final DownloadManager dm, final boolean playNow, final boolean playPrepare, final HashWrapper fhw) {
        new AEThread2("playDM", true){

            public void run() {
                try {
                    HashWrapper hw = dm.getTorrent().getHashWrapper();
                    if (!hw.equals(fhw)) {
                        return;
                    }
                    boolean showHomeHint = true;
                    if (playNow || playPrepare) {
                        if (playNow) {
                            showHomeHint = !TorrentListViewsUtils.playOrStream(dm);
                        } else {
                            PlayUtils.prepareForPlay(dm);
                            showHomeHint = false;
                        }
                    }
                    if (showHomeHint) {
                        TorrentListViewsUtils.showHomeHint(dm);
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }.start();
    }

    public static boolean addTorrentToGM(TOTorrent torrent) {
        try {
            File tempTorrentFile = File.createTempFile("AZU", ".torrent");
            tempTorrentFile.deleteOnExit();
            String filename = tempTorrentFile.getAbsolutePath();
            torrent.serialiseToBEncodedFile(tempTorrentFile);
            String savePath = COConfigurationManager.getStringParameter("Default save path");
            if (savePath == null || savePath.length() == 0) {
                savePath = ".";
            }
            AzureusCore core = AzureusCoreFactory.getSingleton();
            core.getGlobalManager().addDownloadManager(filename, savePath);
        }
        catch (Throwable t) {
            Debug.out(t);
            return false;
        }
        return true;
    }
}

