/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views;

import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.views.ViewDownSpeedGraph;
import com.aelitis.azureus.ui.swt.views.ViewUpSpeedGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.stats.VivaldiView;

public class TopBarView {
    private List topbarViews = new ArrayList();
    private IView activeTopBar;
    private final SWTSkin skin;
    private final UISWTInstanceImpl uiSWTinstance;
    private org.eclipse.swt.widgets.List listPlugins;
    private Composite cPluginArea;

    public TopBarView(SWTSkin skin, UISWTInstanceImpl uiSWTinstance) {
        this.skin = skin;
        this.uiSWTinstance = uiSWTinstance;
    }

    public void buildTopBarViews() {
        SWTSkinObject skinObject = this.skin.getSkinObject("topbar-plugins");
        if (skinObject == null) {
            return;
        }
        try {
            int toActiveView;
            SWTSkinObject soList;
            SWTSkinObject soTitle;
            SWTSkinObject soNext;
            IView[] coreTopBarViews = new IView[]{new ViewDownSpeedGraph(), new ViewUpSpeedGraph(), new VivaldiView(false)};
            this.cPluginArea = (Composite)skinObject.getControl();
            final UIUpdatable updatable = new UIUpdatable(){

                public void updateUI() {
                    Object[] views = TopBarView.this.topbarViews.toArray();
                    for (int i = 0; i < views.length; ++i) {
                        try {
                            IView view = (IView)views[i];
                            if (!view.getComposite().isVisible()) continue;
                            view.refresh();
                            continue;
                        }
                        catch (Exception e) {
                            Debug.out(e);
                        }
                    }
                }

                public String getUpdateUIName() {
                    return "TopBar";
                }
            };
            try {
                UIFunctionsManager.getUIFunctions().getUIUpdater().addUpdater(updatable);
            }
            catch (Exception e) {
                Debug.out(e);
            }
            skinObject.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    try {
                        UIFunctionsManager.getUIFunctions().getUIUpdater().removeUpdater(updatable);
                    }
                    catch (Exception ex) {
                        Debug.out(ex);
                    }
                    Object[] views = TopBarView.this.topbarViews.toArray();
                    TopBarView.this.topbarViews.clear();
                    for (int i = 0; i < views.length; ++i) {
                        IView view = (IView)views[i];
                        view.delete();
                    }
                }
            });
            SWTSkinObject soPrev = this.skin.getSkinObject("topbar-plugin-prev");
            if (soPrev != null) {
                SWTSkinButtonUtility btnPrev = new SWTSkinButtonUtility(soPrev);
                btnPrev.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        if (TopBarView.this.activeTopBar == null || TopBarView.this.topbarViews.size() <= 1) {
                            return;
                        }
                        int i = TopBarView.this.topbarViews.indexOf(TopBarView.this.activeTopBar) - 1;
                        if (i < 0) {
                            i = TopBarView.this.topbarViews.size() - 1;
                        }
                        TopBarView.this.activateTopBar((IView)TopBarView.this.topbarViews.get(i));
                    }
                });
            }
            if ((soNext = this.skin.getSkinObject("topbar-plugin-next")) != null) {
                SWTSkinButtonUtility btnNext = new SWTSkinButtonUtility(soNext);
                btnNext.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        if (TopBarView.this.activeTopBar == null || TopBarView.this.topbarViews.size() <= 1) {
                            return;
                        }
                        int i = TopBarView.this.topbarViews.indexOf(TopBarView.this.activeTopBar) + 1;
                        if (i >= TopBarView.this.topbarViews.size()) {
                            i = 0;
                        }
                        TopBarView.this.activateTopBar((IView)TopBarView.this.topbarViews.get(i));
                    }
                });
            }
            if ((soTitle = this.skin.getSkinObject("topbar-plugin-title")) != null) {
                Composite cTitle = (Composite)soTitle.getControl();
                cTitle.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        e.gc.setAdvanced(true);
                        if (e.gc.getAdvanced() && TopBarView.this.activeTopBar != null) {
                            try {
                                e.gc.setTextAntialias(1);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            try {
                                Transform transform = new Transform(e.gc.getDevice());
                                transform.rotate(270.0f);
                                e.gc.setTransform(transform);
                                String s = TopBarView.this.activeTopBar.getShortTitle();
                                Point size = e.gc.textExtent(s);
                                e.gc.drawText(s, -size.x, 0, true);
                                transform.dispose();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
            if ((soList = this.skin.getSkinObject("topbar-plugin-list")) != null) {
                Composite cList = (Composite)soList.getControl();
                this.listPlugins = new org.eclipse.swt.widgets.List(cList, 0);
                this.listPlugins.setLayoutData((Object)Utils.getFilledFormData());
                this.listPlugins.setBackground(cList.getBackground());
                this.listPlugins.setForeground(cList.getForeground());
                this.listPlugins.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        int i = TopBarView.this.listPlugins.getSelectionIndex();
                        if (i >= 0 && i < TopBarView.this.topbarViews.size()) {
                            TopBarView.this.activateTopBar((IView)TopBarView.this.topbarViews.get(i));
                            COConfigurationManager.setParameter("topbar.viewindex", i);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            if ((skinObject = this.skin.getSkinObject("pluginbar")) != null) {
                Listener l = new Listener(){
                    private int mouseDownAt = 0;

                    public void handleEvent(Event event2) {
                        Composite c = (Composite)event2.widget;
                        if (event2.type == 3) {
                            Rectangle clientArea = c.getClientArea();
                            if (event2.y > clientArea.height - 10) {
                                this.mouseDownAt = event2.y;
                            }
                        } else if (event2.type == 4 && this.mouseDownAt > 0) {
                            int diff = event2.y - this.mouseDownAt;
                            this.mouseDownAt = 0;
                            FormData formData = (FormData)c.getLayoutData();
                            formData.height += diff;
                            if (formData.height < 50) {
                                formData.height = 50;
                            } else {
                                Rectangle clientArea = c.getShell().getClientArea();
                                int max = clientArea.height - 350;
                                if (formData.height > max) {
                                    formData.height = max;
                                }
                            }
                            COConfigurationManager.setParameter("v3.topbar.height", formData.height);
                            Utils.relayout((Control)c);
                        } else if (event2.type == 5) {
                            Rectangle clientArea = c.getClientArea();
                            boolean draggable = event2.y > clientArea.height - 10;
                            c.setCursor(draggable ? c.getDisplay().getSystemCursor(7) : null);
                        } else if (event2.type == 7) {
                            c.setCursor(null);
                        }
                    }
                };
                Control control = skinObject.getControl();
                control.addListener(3, l);
                control.addListener(4, l);
                control.addListener(5, l);
                control.addListener(7, l);
                skinObject.addListener(new SWTSkinObjectListener(){

                    public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                        if (eventType == 0) {
                            int h = COConfigurationManager.getIntParameter("v3.topbar.height");
                            Control control = skinObject.getControl();
                            FormData formData = (FormData)control.getLayoutData();
                            formData.height = h;
                            control.setLayoutData((Object)formData);
                            Utils.relayout(control);
                        }
                        return null;
                    }
                });
            }
            int viewIndex = toActiveView = COConfigurationManager.getIntParameter("topbar.viewindex", 0);
            for (int i = 0; i < coreTopBarViews.length; ++i) {
                IView view = coreTopBarViews[i];
                this.addTopBarView(view, this.cPluginArea);
                if (toActiveView-- != 0) continue;
                this.activateTopBar(view);
                if (this.listPlugins == null) continue;
                this.listPlugins.setSelection(viewIndex);
            }
            Map pluginViews = null;
            pluginViews = this.uiSWTinstance.getViewListeners("TopBar");
            if (pluginViews != null) {
                String[] sNames = pluginViews.keySet().toArray(new String[0]);
                for (int i = 0; i < sNames.length; ++i) {
                    UISWTViewEventListener l = (UISWTViewEventListener)pluginViews.get(sNames[i]);
                    if (l == null) continue;
                    try {
                        UISWTViewImpl view = new UISWTViewImpl("TopBar", sNames[i], l);
                        this.addTopBarView(view, this.cPluginArea);
                        if (toActiveView-- != 0) continue;
                        this.activateTopBar(view);
                        if (this.listPlugins == null) continue;
                        this.listPlugins.setSelection(viewIndex);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (toActiveView >= 0 && this.topbarViews.size() > 0) {
                this.activeTopBar = (IView)this.topbarViews.get(0);
                this.activeTopBar.getComposite().setVisible(true);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    protected void activateTopBar(IView view) {
        Composite c;
        if (this.activeTopBar != null) {
            c = this.activeTopBar.getComposite();
            while (c.getParent() != this.cPluginArea) {
                c = c.getParent();
            }
            c.setVisible(false);
        }
        this.activeTopBar = view;
        c = this.activeTopBar.getComposite();
        while (c.getParent() != this.cPluginArea) {
            c = c.getParent();
        }
        c.setVisible(true);
        SWTSkinObject soTitle = this.skin.getSkinObject("topbar-plugin-title");
        if (soTitle != null) {
            soTitle.getControl().redraw();
        }
    }

    private void addTopBarView(IView view, Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayoutData((Object)Utils.getFilledFormData());
        parent.setLayout((Layout)new FormLayout());
        view.initialize(parent);
        parent.setVisible(false);
        Control[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            boolean useGridLayout;
            Control control = children[i];
            Object ld = control.getLayoutData();
            boolean bl = useGridLayout = ld != null && ld instanceof GridData;
            if (useGridLayout) {
                GridLayout gridLayout = new GridLayout();
                gridLayout.horizontalSpacing = 0;
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
                gridLayout.verticalSpacing = 0;
                parent.setLayout((Layout)gridLayout);
                break;
            }
            if (ld != null) continue;
            control.setLayoutData((Object)Utils.getFilledFormData());
        }
        this.topbarViews.add(view);
        if (this.listPlugins != null) {
            String s = view.getFullTitle();
            if (MessageText.keyExists(s)) {
                s = MessageText.getString(s);
            }
            this.listPlugins.add(s);
        }
    }
}

