/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.list;

import com.aelitis.azureus.ui.swt.views.list.ListCell;
import com.aelitis.azureus.ui.swt.views.list.ListRow;
import com.aelitis.azureus.ui.swt.views.list.ListView;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem;

public class ListCellGraphic
extends ListCell
implements BufferedGraphicTableItem {
    private int marginHeight = 1;
    private int marginWidth = 1;
    private int orientation = 0x1000000;
    private Image image;
    private Rectangle imageBounds;

    public ListCellGraphic(ListRow row, int alignment, Rectangle bounds) {
        super(row, alignment, bounds);
    }

    public Image getGraphic() {
        return this.image;
    }

    public Point getSize() {
        Rectangle bounds = this.getBounds();
        if (bounds == null) {
            return new Point(0, 0);
        }
        return new Point(bounds.width - this.marginWidth * 2, bounds.height - this.marginHeight * 2);
    }

    public boolean setGraphic(Image img) {
        if (img != null && img.isDisposed()) {
            return false;
        }
        if (this.image == img) {
            return false;
        }
        this.image = img;
        if (this.image != null) {
            this.imageBounds = this.image.getBounds();
        }
        if (this.row != null) {
            ListCell cellToRefresh = this;
            if (this.parentCell != null && !this.parentCell.isDisposed()) {
                cellToRefresh = (ListCell)this.parentCell.getBufferedTableItem();
            }
            ((ListView)this.row.getView()).cellRefresh(cellToRefresh, true, true);
        }
        return true;
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public void setMargin(int width, int height) {
        if (width >= 0) {
            this.marginWidth = width;
        }
        if (height >= 0) {
            this.marginHeight = height;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public void doPaint(GC gc) {
        Rectangle bounds;
        if (gc == null || gc.isDisposed()) {
            Debug.out("gc is null or disposed");
            return;
        }
        if (!this.isShown()) {
            return;
        }
        Color colorBG = this.getBackground();
        if (colorBG != null) {
            gc.setBackground(colorBG);
        }
        if ((bounds = this.getBounds()) == null) {
            return;
        }
        if (this.orientation != 4) {
            gc.fillRectangle(bounds);
        }
        if (this.image != null && !this.image.isDisposed()) {
            int x;
            Point size = this.getSize();
            int y = this.marginHeight;
            y += (size.y - this.imageBounds.height) / 2;
            if (this.orientation == 0x1000000) {
                x = this.marginWidth;
                x += (size.x - this.imageBounds.width) / 2;
            } else {
                x = this.orientation == 131072 ? size.x - this.imageBounds.width : this.marginWidth;
            }
            int width = Math.min(size.x - x, this.imageBounds.width);
            int height = Math.min(size.y - y, this.imageBounds.height);
            if (width >= 0 && height >= 0) {
                gc.drawImage(this.image, 0, 0, width, height, bounds.x + x, bounds.y + y, width, height);
            }
        }
    }

    public Image getBackgroundImage() {
        Rectangle bounds = this.getBounds();
        if (bounds == null || bounds.isEmpty()) {
            return null;
        }
        Image image = new Image((Device)Display.getDefault(), bounds.width - this.marginWidth * 2, bounds.height - this.marginHeight * 2);
        GC gc = new GC((Drawable)image);
        Color colorBG = this.getBackground();
        if (colorBG != null) {
            gc.setBackground(colorBG);
        }
        gc.fillRectangle(image.getBounds());
        gc.dispose();
        return image;
    }
}

