/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.browser.listener.VuzeListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTab;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinTabSet;
import com.aelitis.azureus.ui.swt.skin.SWTSkinTabSetListener;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.util.ConstantsV3;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;

public class MiniBrowse
extends SkinView {
    public static boolean PULL_TABS = false;
    private SWTSkinObjectBrowser browserSkinObject;

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.browserSkinObject = (SWTSkinObjectBrowser)skinObject.getSkin().getSkinObject("minibrowse");
        if (PULL_TABS) {
            PlatformConfigMessenger.getBrowseSections("minibrowse", 0L, new PlatformConfigMessenger.GetBrowseSectionsReplyListener(){

                public void replyReceived(final Map[] browseSections) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            MiniBrowse.this.createBrowseTabs(MiniBrowse.this.browserSkinObject, browseSections);
                        }
                    });
                }

                public void messageSent() {
                }
            });
        } else {
            this.createBrowseArea(this.browserSkinObject);
        }
        return null;
    }

    private void createBrowseArea(SWTSkinObjectBrowser browserSkinObject) {
        this.browserSkinObject = browserSkinObject;
        browserSkinObject.setURL(ConstantsV3.URL_PREFIX + "dashboard.start" + "?" + ConstantsV3.URL_SUFFIX);
    }

    protected void createBrowseTabs(SWTSkinObject skinObject, final Map[] browseSections) {
        SWTSkin skin = skinObject.getSkin();
        AzureusCore core = AzureusCoreFactory.getSingleton();
        Composite cArea = (Composite)skinObject.getControl();
        final Browser browser = new Browser(cArea, Utils.getInitialBrowserStyle(0));
        BrowserContext context = new BrowserContext("mini", browser, null, true);
        context.addMessageListener(new TorrentListener(core));
        context.addMessageListener(new VuzeListener());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        browser.setLayoutData((Object)formData);
        skinObject = skin.getSkinObject("minibrowse-tabs");
        if (skinObject == null) {
            return;
        }
        Control previousControl = null;
        SWTSkinTabSet tabSet = null;
        for (int i = 0; i < browseSections.length; ++i) {
            String sTabName = (String)browseSections[i].get("title");
            String sTabID = "internal.minibrowse.tab." + i;
            SWTSkinObjectTab skinTab = skin.createTab(sTabID, "tab", skinObject);
            if (skinTab == null) continue;
            if (tabSet == null) {
                tabSet = skin.getTabSet(skinTab);
            }
            Control currentControl = skinTab.getControl();
            if (previousControl != null) {
                formData = (FormData)skinTab.getControl().getLayoutData();
                if (formData == null) {
                    formData = new FormData();
                }
                formData.left = new FormAttachment(previousControl, 1);
                currentControl.setLayoutData((Object)formData);
            }
            previousControl = currentControl;
            SWTSkinObject tabText = skin.getSkinObject("minibrowse-tab-text", skinTab);
            if (tabText instanceof SWTSkinObjectText) {
                ((SWTSkinObjectText)tabText).setText(sTabName);
            }
            if (i != 0) continue;
            tabSet.addListener(new SWTSkinTabSetListener(){

                public void tabChanged(SWTSkinTabSet tabSet, String oldTabID, String newTabID) {
                    browser.stop();
                    browser.execute("document.clear(); document.write('Loading..');");
                    char c = newTabID.charAt(newTabID.length() - 1);
                    int i = c - 48;
                    if (i >= 0 && i < browseSections.length) {
                        browser.setUrl((String)browseSections[i].get("url"));
                        System.out.println(browser.getUrl());
                    }
                }
            });
            tabSet.setActiveTabByID(sTabID);
        }
        cArea.getParent().layout(true, true);
    }
}

