/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.CookiesListener;
import com.aelitis.azureus.ui.swt.browser.OpenCloseSearchDetailsListener;
import com.aelitis.azureus.ui.swt.browser.listener.ExternalLoginCookieListener;
import com.aelitis.azureus.ui.swt.browser.listener.MetaSearchListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.MapUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarVitalityImage;
import org.gudy.azureus2.ui.swt.PropertiesWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

public class SearchResultsTabArea
extends SkinView
implements ViewTitleInfo,
OpenCloseSearchDetailsListener {
    private SWTSkinObjectBrowser browserSkinObject;
    private SWTSkin skin;
    private String searchText;
    private boolean searchResultsInitialized = false;
    protected String title;
    private MenuItem menuItem;
    private SideBarVitalityImage vitalityImage;

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.skin = skinObject.getSkin();
        this.browserSkinObject = (SWTSkinObjectBrowser)this.skin.getSkinObject("searchresults", skinObject);
        this.createBrowseArea(this.browserSkinObject);
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getDefaultPluginInterface();
        UIManager uim = pi.getUIManager();
        final MenuManager menuManager = uim.getMenuManager();
        if (this.menuItem == null) {
            this.menuItem = menuManager.addMenuItem("sidebar.Search", "Search.menu.engines");
            this.menuItem.setStyle(5);
            this.menuItem.addFillListener(new MenuItemFillListener(){

                public void menuWillBeShown(MenuItem menu, Object data) {
                    SearchResultsTabArea.this.menuItem.removeAllChildItems();
                    Engine[] engines = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngines(true, false);
                    Arrays.sort(engines, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            return ((Engine)o1).getName().compareToIgnoreCase(((Engine)o2).getName());
                        }
                    });
                    for (int i = 0; i < engines.length; ++i) {
                        String cookies;
                        WebEngine we;
                        MenuItem mi;
                        final Engine engine = engines[i];
                        MenuItem engine_menu = menuManager.addMenuItem(SearchResultsTabArea.this.menuItem, "!" + engine.getName() + "!");
                        engine_menu.setStyle(5);
                        if (engine.getSource() != 1) {
                            mi = menuManager.addMenuItem(engine_menu, "MyTorrentsView.menu.exportmenu");
                            mi.addListener(new MenuItemListener(){

                                public void selected(MenuItem menu, Object target) {
                                    final Shell shell = Utils.findAnyShell();
                                    shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                                        public void runSupport() {
                                            FileDialog dialog = new FileDialog(shell, 139264);
                                            dialog.setFilterPath(TorrentOpener.getFilterPathData());
                                            dialog.setText(MessageText.getString("metasearch.export.select.template.file"));
                                            dialog.setFilterExtensions(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                                            dialog.setFilterNames(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                                            String path = TorrentOpener.setFilterPathData(dialog.open());
                                            if (path != null) {
                                                String lc = path.toLowerCase();
                                                if (!lc.endsWith(".vuze") && !lc.endsWith(".vuz")) {
                                                    path = path + ".vuze";
                                                }
                                                try {
                                                    engine.exportToVuzeFile(new File(path));
                                                }
                                                catch (Throwable e) {
                                                    Debug.out(e);
                                                }
                                            }
                                        }
                                    });
                                }
                            });
                        }
                        if (engine instanceof WebEngine && (we = (WebEngine)engine).isNeedsAuth() && (cookies = we.getCookies()) != null && cookies.length() > 0) {
                            MenuItem mi2 = menuManager.addMenuItem(engine_menu, "Subscription.menu.resetauth");
                            mi2.addListener(new MenuItemListener(){

                                public void selected(MenuItem menu, Object target) {
                                    we.setCookies(null);
                                }
                            });
                        }
                        if (engine_menu.getItems().length > 0) {
                            mi = menuManager.addMenuItem(engine_menu, "Subscription.menu.sep");
                            mi.setStyle(4);
                        }
                        mi = menuManager.addMenuItem(engine_menu, "Subscription.menu.properties");
                        mi.addListener(new MenuItemListener(){

                            public void selected(MenuItem menu, Object target) {
                                WebEngine web_engine;
                                String auth_str = String.valueOf(false);
                                String engine_str = engine.getNameEx();
                                if (engine instanceof WebEngine && (web_engine = (WebEngine)engine).isNeedsAuth()) {
                                    auth_str = String.valueOf(true) + ": cookies=" + this.toString(web_engine.getRequiredCookies());
                                }
                                String[] keys = new String[]{"subs.prop.template", "subs.prop.auth"};
                                String[] values = new String[]{engine_str, auth_str};
                                new PropertiesWindow(engine.getName(), keys, values);
                            }

                            private String toString(String[] strs) {
                                String res = "";
                                for (int i = 0; i < strs.length; ++i) {
                                    res = res + (i == 0 ? "" : ",") + strs[i];
                                }
                                return res;
                            }
                        });
                        if (engine_menu.getItems().length != 0) continue;
                        engine_menu.setEnabled(false);
                    }
                }
            });
        }
        if (this.browserSkinObject != null) {
            Object o = skinObject.getData("CreationParams");
            if (o instanceof String) {
                this.anotherSearch((String)o);
            }
            if (o instanceof SearchQuery) {
                SearchQuery sq = (SearchQuery)o;
                this.anotherSearch(sq.term, sq.toSubscribe);
            }
        }
        this.closeSearchResults(null);
        return null;
    }

    private void createBrowseArea(SWTSkinObjectBrowser browserSkinObject) {
        SideBarEntrySWT entry;
        this.browserSkinObject = browserSkinObject;
        browserSkinObject.getContext().addMessageListener(new MetaSearchListener(this));
        SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
        if (sidebar != null && (entry = sidebar.getSideBarEntry(this)) != null) {
            this.vitalityImage = entry.addVitalityImage("image.sidebar.vitality.dots");
            this.vitalityImage.setVisible(false);
        }
        browserSkinObject.addListener(new BrowserContext.loadingListener(){

            public void browserLoadingChanged(boolean loading, String url) {
                if (SearchResultsTabArea.this.vitalityImage != null) {
                    SearchResultsTabArea.this.vitalityImage.setVisible(loading);
                }
            }
        });
        SWTSkinObject soSearchResults = this.getSkinObject("searchresults-search-results");
        if (soSearchResults instanceof SWTSkinObjectBrowser) {
            SWTSkinObjectBrowser browserSearchResults = (SWTSkinObjectBrowser)soSearchResults;
            browserSearchResults.addListener(new BrowserContext.loadingListener(){

                public void browserLoadingChanged(boolean loading, String url) {
                    if (SearchResultsTabArea.this.vitalityImage != null) {
                        SearchResultsTabArea.this.vitalityImage.setVisible(loading);
                    }
                }
            });
        }
    }

    public void restart() {
        if (this.browserSkinObject != null) {
            this.browserSkinObject.restart();
        }
    }

    public void openSearchResults(final Map params) {
        if (!this.searchResultsInitialized) {
            this.searchResultsInitialized = true;
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    SWTSkinObject soSearchResults = SearchResultsTabArea.this.getSkinObject("searchresults-search-results");
                    if (soSearchResults != null) {
                        SWTSkinObjectBrowser browserSkinObject = (SWTSkinObjectBrowser)soSearchResults;
                        final Browser browser = browserSkinObject.getBrowser();
                        browser.addTitleListener(new TitleListener(){

                            public void changed(TitleEvent event2) {
                                SearchResultsTabArea.this.title = event2.title;
                                int i = SearchResultsTabArea.this.title.toLowerCase().indexOf("details:");
                                if (i > 0) {
                                    SearchResultsTabArea.this.title = SearchResultsTabArea.this.title.substring(i + 9);
                                }
                            }
                        });
                        ExternalLoginCookieListener cookieListener = new ExternalLoginCookieListener(new CookiesListener(){

                            public void cookiesFound(String cookies) {
                                browser.setData("current-cookies", (Object)cookies);
                            }
                        }, browser);
                        cookieListener.hook();
                    }
                }
            });
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                String listenerAdded;
                SWTSkinObject soSearchResults = SearchResultsTabArea.this.getSkinObject("searchresults-search-results");
                if (soSearchResults == null) {
                    return;
                }
                Control controlTop = SearchResultsTabArea.this.browserSkinObject.getControl();
                Control controlBottom = soSearchResults.getControl();
                Browser search = ((SWTSkinObjectBrowser)soSearchResults).getBrowser();
                String url = MapUtils.getMapString(params, "url", "http://google.com/search?q=" + Math.random());
                if (PlatformConfigMessenger.urlCanRPC(url)) {
                    url = ConstantsV3.appendURLSuffix(url);
                }
                if ((listenerAdded = (String)search.getData("g.nt.la")) == null) {
                    search.setData("g.nt.la", (Object)"");
                    search.addProgressListener(new ProgressListener(){

                        public void changed(ProgressEvent event2) {
                        }

                        public void completed(ProgressEvent event2) {
                            Browser search = (Browser)event2.widget;
                            String execAfterLoad = (String)search.getData("execAfterLoad");
                            search.setData("execAfterLoad", null);
                            if (execAfterLoad != null && !execAfterLoad.equals("")) {
                                boolean result = search.execute(execAfterLoad);
                            }
                        }
                    });
                }
                String execAfterLoad = MapUtils.getMapString(params, "execAfterLoad", null);
                search.setData("execAfterLoad", (Object)execAfterLoad);
                search.setUrl(url);
                FormData gd = (FormData)controlBottom.getLayoutData();
                gd.top = new FormAttachment(controlTop, 0);
                gd.height = -1;
                controlBottom.setLayoutData((Object)gd);
                soSearchResults.setVisible(true);
                controlBottom.setVisible(true);
                search.setVisible(true);
                gd = (FormData)controlTop.getLayoutData();
                gd.bottom = null;
                gd.height = MapUtils.getMapInt(params, "top-height", 120);
                controlTop.setLayoutData((Object)gd);
                controlTop.getParent().layout(true);
            }
        });
    }

    public void closeSearchResults(Map params) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SWTSkinObject soSearchResults = SearchResultsTabArea.this.skin.getSkinObject("searchresults-search-results");
                if (soSearchResults == null) {
                    return;
                }
                Control controlTop = SearchResultsTabArea.this.browserSkinObject.getControl();
                Control controlBottom = soSearchResults.getControl();
                Browser search = ((SWTSkinObjectBrowser)soSearchResults).getBrowser();
                soSearchResults.setVisible(false);
                FormData gd = (FormData)controlBottom.getLayoutData();
                if (gd == null) {
                    return;
                }
                gd.top = null;
                gd.height = 0;
                controlBottom.setLayoutData((Object)gd);
                gd = (FormData)controlTop.getLayoutData();
                gd.bottom = new FormAttachment(controlBottom, 0);
                gd.height = -1;
                controlTop.setLayoutData((Object)gd);
                controlBottom.getParent().layout(true);
                search.setUrl("about:blank");
            }
        });
    }

    public void resizeMainBrowser() {
    }

    public void resizeSecondaryBrowser() {
    }

    public void anotherSearch(String searchText) {
        this.anotherSearch(searchText, false);
    }

    public void anotherSearch(String searchText, boolean toSubscribe) {
        this.searchText = searchText;
        String url = ConstantsV3.URL_PREFIX + "search?q=" + UrlUtils.encode(searchText) + "&" + ConstantsV3.URL_SUFFIX + "&rand=" + SystemTime.getCurrentTime();
        if (System.getProperty("metasearch", "1").equals("1")) {
            url = ConstantsV3.URL_PREFIX + "xsearch?q=" + UrlUtils.encode(searchText) + "&" + ConstantsV3.URL_SUFFIX + "&rand=" + SystemTime.getCurrentTime();
            if (toSubscribe) {
                url = url + "&createSubscription=1";
            }
        }
        this.closeSearchResults(null);
        this.browserSkinObject.setURL(url);
        ViewTitleInfoManager.refreshTitleInfo(this);
    }

    public Object getTitleInfoProperty(int propertyID) {
        if (propertyID == 4) {
            return this;
        }
        if (propertyID == 5) {
            return this.searchText;
        }
        return null;
    }

    public static class SearchQuery {
        public String term;
        public boolean toSubscribe;
    }
}

