/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SkinViewManager {
    private static Map skinViews = new HashMap();
    private static Map skinIDs = new HashMap();
    private static List listeners = new ArrayList();

    public static void add(SkinView skinView) {
        Object object = skinViews.get(skinView.getClass());
        if (object instanceof SkinView[]) {
            SkinView[] oldSkinViews = (SkinView[])object;
            SkinView[] newSkinViews = new SkinView[oldSkinViews.length + 1];
            System.arraycopy(oldSkinViews, 0, newSkinViews, 0, oldSkinViews.length);
            newSkinViews[oldSkinViews.length] = skinView;
            skinViews.put(skinView.getClass(), newSkinViews);
        } else if (object != null) {
            SkinView[] newObjs = new SkinView[]{(SkinView)object, skinView};
            skinViews.put(skinView.getClass(), newObjs);
        } else {
            skinViews.put(skinView.getClass(), skinView);
        }
        if (skinView.getMainSkinObject() != null) {
            skinIDs.put(skinView.getMainSkinObject().getSkinObjectID(), skinView);
        }
        SkinViewManager.triggerListeners(skinView);
    }

    public static SkinView getByClass(Class cla) {
        SWTSkinObject so;
        SkinView sv = null;
        Object object = skinViews.get(cla);
        if (object == null) {
            return null;
        }
        if (object instanceof SkinView[]) {
            SWTSkinObject so2;
            SkinView[] svs = (SkinView[])object;
            for (int i = 0; i < svs.length && ((so2 = (sv = svs[i]).getMainSkinObject()) == null || so2.isDisposed()); ++i) {
            }
        } else {
            sv = (SkinView)object;
        }
        if (sv != null && (so = sv.getMainSkinObject()) != null && so.isDisposed()) {
            return null;
        }
        return sv;
    }

    public static SkinView[] getMultiByClass(Class cla) {
        Object object = skinViews.get(cla);
        if (object instanceof Object[]) {
            return (SkinView[])((Object[])object);
        }
        return new SkinView[]{(SkinView)object};
    }

    public static SkinView getBySkinObjectID(String id) {
        SWTSkinObject so;
        SkinView sv = (SkinView)skinIDs.get(id);
        if (sv != null && (so = sv.getMainSkinObject()) != null && so.isDisposed()) {
            return null;
        }
        return sv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(SkinViewManagerListener l) {
        Class<SkinViewManager> clazz = SkinViewManager.class;
        synchronized (SkinViewManager.class) {
            if (!listeners.contains(l)) {
                listeners.add(l);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RemoveListener(SkinViewManagerListener l) {
        Class<SkinViewManager> clazz = SkinViewManager.class;
        synchronized (SkinViewManager.class) {
            listeners.remove(l);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void triggerListeners(SkinView skinView) {
        Object[] array = listeners.toArray();
        for (int i = 0; i < array.length; ++i) {
            SkinViewManagerListener l = (SkinViewManagerListener)array[i];
            l.skinViewAdded(skinView);
        }
    }

    public static interface SkinViewManagerListener {
        public void skinViewAdded(SkinView var1);
    }
}

