/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin.sidebar;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesListener;
import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoListener;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectSash;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionsView;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarEnabler;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarEnablerSelectedContent;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarItem;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import com.aelitis.azureus.ui.swt.views.skin.SBC_LibraryView;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.ToolBarView;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarListener;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarToolTips;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarVitalityImageSWT;
import com.aelitis.azureus.util.MapUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIPluginView;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarEntry;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarVitalityImage;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.mainwindow.PluginsMenuHelper;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventCancelledException;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.IView;

public class SideBar
extends SkinView
implements UIUpdatable,
ViewTitleInfoListener {
    private static final int SIDEBAR_SPACING = 2;
    public static final String SIDEBAR_SECTION_PLUGINS = "Plugins";
    public static final String SIDEBAR_SECTION_LIBRARY = "Library";
    public static final String SIDEBAR_SECTION_LIBRARY_DL = "LibraryDL";
    public static final String SIDEBAR_SECTION_LIBRARY_CD = "LibraryCD";
    public static final String SIDEBAR_SECTION_LIBRARY_UNOPENED = "LibraryUnopened";
    public static final String SIDEBAR_SECTION_TOOLS = "Tools";
    public static final String SIDEBAR_SECTION_BROWSE = "Browse";
    public static final String SIDEBAR_SECTION_WELCOME = "Welcome";
    public static final String SIDEBAR_SECTION_PUBLISH = "Publish";
    public static final String SIDEBAR_SECTION_SUBSCRIPTIONS = "Subscriptions";
    public static final String SIDEBAR_SECTION_ADVANCED = "Advanced";
    public static final boolean SHOW_ALL_PLUGINS = false;
    public static final boolean SHOW_TOOLS = false;
    public static final String SIDEBAR_SECTION_ACTIVITIES = "Activity";
    private static final int IMAGELEFT_SIZE = 20;
    private static final int IMAGELEFT_GAP = 5;
    private static final boolean ALWAYS_IMAGE_GAP = false;
    private SWTSkin skin;
    private SWTSkinObject soSideBarContents;
    private SWTSkinObject soSideBarList;
    private Tree tree;
    private Font fontHeader;
    private SideBarEntrySWT currentSideBarEntry;
    private static Map mapTitleInfoToEntry = new LightHashMap();
    private static Map mapIdToSideBarInfo = new LightHashMap();
    private static List listTreeItemsNoTitleInfo = new ArrayList();
    private static DisposeListener disposeTreeItemListener;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    double lastPercent = 0.8;
    private Color bg;
    private Color fg;
    private Color bgSel;
    private Color fgSel;
    private Color colorFocus;
    private Image imgClose;
    private SWTSkinObject soSideBarPopout;
    private SelectionListener dropDownSelectionListener;
    private ImageLoader imageLoader;
    private int maxIndicatorWidth;
    private Image imgCloseSelected;
    private static Map mapAutoOpen;
    private Image treeImage;
    private Image lastImage;
    private Image imgUntwist;
    private Image imgTwist;
    private Shell shellFade;
    public static SideBar instance;

    public SideBar() {
        if (instance == null) {
            instance = this;
        }
    }

    public Object skinObjectCreated(SWTSkinObject skinObject, Object params) {
        this.skin = skinObject.getSkin();
        this.soSideBarContents = this.skin.getSkinObject("sidebar-contents");
        this.soSideBarList = this.skin.getSkinObject("sidebar-list");
        this.soSideBarPopout = this.skin.getSkinObject("sidebar-pop");
        this.imageLoader = this.skin.getImageLoader(skinObject.getProperties());
        this.imgClose = this.imageLoader.getImage("image.sidebar.closeitem");
        this.imgCloseSelected = this.imageLoader.getImage("image.sidebar.closeitem-selected");
        this.imgTwist = this.imageLoader.getImage("image.sidebar.twist");
        this.imgUntwist = this.imageLoader.getImage("image.sidebar.untwist");
        ViewTitleInfoManager.addListener(this);
        this.createSideBar();
        this.setupDefaultItems();
        try {
            UIFunctionsManager.getUIFunctions().getUIUpdater().addUpdater(this);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        Display.getDefault().addFilter(1, new Listener(){

            public void handleEvent(Event event2) {
                if (event2.keyCode == 0x1000012 || event2.keyCode == 0x1000010 || event2.keyCode == 116 && event2.stateMask == 0x410000) {
                    event2.doit = false;
                    event2.keyCode = 0;
                    event2.character = '\u0000';
                    SideBar.this.flipSideBarVisibility();
                }
            }
        });
        return null;
    }

    private void addMenuNotifications() {
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getDefaultPluginInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        org.gudy.azureus2.plugins.ui.menus.MenuItem menuItem = menuManager.addMenuItem("sidebar.Activity", "v3.activity.button.readall");
        menuItem.addListener(new MenuItemListener(){

            public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                VuzeActivitiesEntry[] allEntries = VuzeActivitiesManager.getAllEntries();
                for (int i = 0; i < allEntries.length; ++i) {
                    VuzeActivitiesEntry entry = allEntries[i];
                    entry.setRead(true);
                }
            }
        });
    }

    private void addMenuUnwatched() {
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getDefaultPluginInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        org.gudy.azureus2.plugins.ui.menus.MenuItem menuItem = menuManager.addMenuItem("sidebar.LibraryUnopened", "v3.activity.button.watchall");
        menuItem.addListener(new MenuItemListener(){

            public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                AzureusCore core = AzureusCoreFactory.getSingleton();
                GlobalManager gm = core.getGlobalManager();
                List downloadManagers = gm.getDownloadManagers();
                for (DownloadManager dm : downloadManagers) {
                    if (PlatformTorrentUtils.getHasBeenOpened(dm) || !dm.getAssumedComplete()) continue;
                    PlatformTorrentUtils.setHasBeenOpened(dm, true);
                }
            }
        });
    }

    public void flipSideBarVisibility() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                SWTSkinObjectSash soSash = (SWTSkinObjectSash)SideBar.this.skin.getSkinObject("sidebar-sash");
                if (soSash.getPercent() == 0.0) {
                    if (SideBar.this.lastPercent != 0.0) {
                        soSash.setPercent(SideBar.this.lastPercent);
                    }
                    if (SideBar.this.soSideBarPopout != null) {
                        Object ld = SideBar.this.soSideBarPopout.getControl().getLayoutData();
                        if (ld instanceof FormData) {
                            FormData fd = (FormData)ld;
                            fd.width = 0;
                        }
                        SideBar.this.soSideBarPopout.setVisible(false);
                        Utils.relayout(SideBar.this.soSideBarPopout.getControl());
                    }
                } else {
                    SideBar.this.lastPercent = soSash.getPercent();
                    soSash.setPercent(0.0);
                    if (SideBar.this.soSideBarPopout != null) {
                        Object ld = SideBar.this.soSideBarPopout.getControl().getLayoutData();
                        if (ld instanceof FormData) {
                            FormData fd = (FormData)ld;
                            fd.width = 24;
                        }
                        SideBar.this.soSideBarPopout.setVisible(true);
                        SideBar.this.soSideBarPopout.getControl().moveAbove(null);
                        Utils.relayout(SideBar.this.soSideBarPopout.getControl());
                    }
                }
            }
        });
    }

    public boolean isVisible() {
        SWTSkinObjectSash soSash = (SWTSkinObjectSash)this.skin.getSkinObject("sidebar-sash");
        return soSash.getPercent() != 0.0;
    }

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        if (!this.isVisible()) {
            this.flipSideBarVisibility();
        }
        return null;
    }

    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        try {
            UIFunctionsManager.getUIFunctions().getUIUpdater().removeUpdater(this);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return null;
    }

    private void createSideBar() {
        Composite parent = (Composite)this.soSideBarList.getControl();
        int NO_SCROLL = 16;
        this.tree = new Tree(parent, 0x20010210);
        this.tree.setHeaderVisible(false);
        new SideBarToolTips(this, this.tree);
        this.tree.setLayoutData((Object)Utils.getFilledFormData());
        SWTSkinProperties skinProperties = this.skin.getSkinProperties();
        this.bg = skinProperties.getColor("color.sidebar.bg");
        this.fg = skinProperties.getColor("color.sidebar.fg");
        this.bgSel = skinProperties.getColor("color.sidebar.selected.bg");
        this.fgSel = skinProperties.getColor("color.sidebar.selected.fg");
        this.colorFocus = skinProperties.getColor("color.sidebar.focus");
        this.tree.setBackground(this.bg);
        this.tree.setForeground(this.fg);
        FontData[] fontData = this.tree.getFont().getFontData();
        fontData[0].setStyle(1);
        Utils.getFontHeightFromPX((Device)this.tree.getDisplay(), fontData, null, 13);
        this.fontHeader = new Font((Device)this.tree.getDisplay(), fontData);
        Listener treeListener = new Listener(){
            TreeItem lastTopItem = null;
            boolean mouseDowned = false;

            public void handleEvent(final Event event2) {
                TreeItem treeItem = (TreeItem)event2.item;
                block0 : switch (event2.type) {
                    case 41: {
                        int clientWidth = ((SideBar)SideBar.this).tree.getClientArea().width;
                        String text = treeItem.getText(event2.index);
                        Point size = event2.gc.textExtent(text);
                        if (event2.x + event2.width < clientWidth) {
                            event2.width = size.x + event2.x;
                            event2.x = 0;
                        }
                        int padding = 4;
                        event2.height = 24;
                        break;
                    }
                    case 42: {
                        break;
                    }
                    case 9: {
                        Rectangle bounds = event2.getBounds();
                        if (SideBar.this.tree.getItemCount() == 0) {
                            return;
                        }
                        int indent = Constants.isUnix ? ((SideBar)SideBar.this).tree.getClientArea().width - 1 : ((SideBar)SideBar.this).tree.getItem((int)0).getBounds().x;
                        int y = event2.y + 1;
                        treeItem = SideBar.this.tree.getItem(new Point(indent, y));
                        while (treeItem != null) {
                            String id = (String)treeItem.getData("Plugin.viewID");
                            SideBarEntrySWT sideBarInfo = SideBar.getSideBarInfo(id);
                            Rectangle itemBounds = sideBarInfo.getBounds();
                            event2.item = treeItem;
                            boolean selected = SideBar.this.tree.getSelectionCount() == 1 && SideBar.this.tree.getSelection()[0].equals(treeItem);
                            event2.detail = selected ? 2 : 0;
                            Rectangle newClip = bounds.intersection(itemBounds);
                            event2.setBounds(newClip);
                            SideBar.this.paintSideBar(event2, sideBarInfo);
                            y = itemBounds.y + itemBounds.height + 1;
                            if (y > bounds.y + bounds.height) break;
                            treeItem = SideBar.this.tree.getItem(new Point(indent, y));
                        }
                        if (SideBar.this.tree.getTopItem() == this.lastTopItem) break;
                        this.lastTopItem = SideBar.this.tree.getTopItem();
                        SideBarEntrySWT[] sideBarEntries = mapIdToSideBarInfo.values().toArray(new SideBarEntrySWT[0]);
                        SideBar.this.updateSideBarHitAreasY(sideBarEntries);
                        break;
                    }
                    case 40: {
                        event2.doit = false;
                        break;
                    }
                    case 11: {
                        SideBar.this.tree.redraw();
                        break;
                    }
                    case 13: {
                        SideBar.this.itemSelected(treeItem);
                        break;
                    }
                    case 3: {
                        this.mouseDowned = true;
                    }
                    case 4: {
                        if (!this.mouseDowned) {
                            return;
                        }
                        this.mouseDowned = false;
                        if (SideBar.this.tree.getItemCount() == 0 || event2.button != 1) {
                            return;
                        }
                        int indent = Constants.isUnix ? ((SideBar)SideBar.this).tree.getClientArea().width - 1 : ((SideBar)SideBar.this).tree.getItem((int)0).getBounds().x;
                        treeItem = SideBar.this.tree.getItem(new Point(indent, event2.y));
                        if (treeItem == null) {
                            return;
                        }
                        String id = (String)treeItem.getData("Plugin.viewID");
                        SideBarEntrySWT sideBarInfo = SideBar.getSideBarInfo(id);
                        Rectangle closeArea = (Rectangle)treeItem.getData("closeArea");
                        if (closeArea != null && closeArea.contains(event2.x, event2.y)) {
                            treeItem.dispose();
                        } else if (SideBar.this.currentSideBarEntry != sideBarInfo) {
                            SideBar.this.itemSelected(sideBarInfo.treeItem);
                        }
                        SideBarVitalityImage[] vitalityImages = sideBarInfo.getVitalityImages();
                        for (int i = 0; i < vitalityImages.length; ++i) {
                            Rectangle hitArea;
                            SideBarVitalityImageSWT vitalityImage = (SideBarVitalityImageSWT)vitalityImages[i];
                            if (!vitalityImage.isVisible() || (hitArea = vitalityImage.getHitArea()) == null || !hitArea.contains(event2.x, event2.y)) continue;
                            vitalityImage.triggerClickedListeners(event2.x, event2.y);
                            break block0;
                        }
                        break;
                    }
                    case 12: {
                        SideBar.this.fontHeader.dispose();
                        SideBar.this.saveCloseables();
                        break;
                    }
                    case 18: {
                        String id = (String)treeItem.getData("Plugin.viewID");
                        SideBarEntrySWT sideBarInfo = SideBar.getSideBarInfo(id);
                        if (!sideBarInfo.disableCollapse) break;
                        SideBar.this.tree.setRedraw(false);
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                ((TreeItem)event2.item).setExpanded(true);
                                SideBar.this.tree.setRedraw(true);
                            }
                        });
                        break;
                    }
                }
            }
        };
        this.tree.addListener(41, treeListener);
        this.tree.addListener(11, treeListener);
        this.tree.addListener(9, treeListener);
        this.tree.addListener(13, treeListener);
        this.tree.addListener(12, treeListener);
        this.tree.addListener(4, treeListener);
        this.tree.addListener(3, treeListener);
        this.tree.addListener(18, treeListener);
        final Menu menuTree = new Menu((Control)this.tree);
        this.tree.setMenu(menuTree);
        menuTree.addMenuListener(new MenuListener(){
            boolean bShown = false;

            public void menuHidden(MenuEvent e) {
                this.bShown = false;
                if (Constants.isOSX) {
                    return;
                }
                Utils.execSWTThreadLater(0, new AERunnable(){

                    public void runSupport() {
                        if (bShown || menuTree.isDisposed()) {
                            return;
                        }
                        Utils.disposeSWTObjects(menuTree.getItems());
                    }
                });
            }

            public void menuShown(MenuEvent e) {
                Utils.disposeSWTObjects(menuTree.getItems());
                this.bShown = true;
                int indent = Constants.isUnix ? ((SideBar)SideBar.this).tree.getClientArea().width - 1 : ((SideBar)SideBar.this).tree.getItem((int)0).getBounds().x;
                Point ptMouse = SideBar.this.tree.toControl(e.display.getCursorLocation());
                TreeItem treeItem = SideBar.this.tree.getItem(new Point(indent, ptMouse.y));
                if (treeItem == null) {
                    return;
                }
                String id = (String)treeItem.getData("Plugin.viewID");
                SideBarEntrySWT sideBarInfo = SideBar.getSideBarInfo(id);
                SideBar.this.fillMenu(menuTree, sideBarInfo);
                if (menuTree.getItemCount() == 0) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            menuTree.setVisible(false);
                        }
                    });
                }
            }
        });
        if (this.soSideBarPopout != null) {
            SWTSkinObject soExpand;
            SWTSkinObject soDropDown = this.skin.getSkinObject("sidebar-dropdown");
            if (soDropDown != null) {
                final Menu menuDropDown = new Menu(soDropDown.getControl());
                menuDropDown.addMenuListener(new MenuListener(){
                    boolean bShown = false;

                    public void menuHidden(MenuEvent e) {
                        this.bShown = false;
                        if (Constants.isOSX) {
                            return;
                        }
                        Utils.execSWTThreadLater(0, new AERunnable(){

                            public void runSupport() {
                                if (bShown || menuDropDown.isDisposed()) {
                                    return;
                                }
                                Utils.disposeSWTObjects(menuDropDown.getItems());
                            }
                        });
                    }

                    public void menuShown(MenuEvent e) {
                        Utils.disposeSWTObjects(menuDropDown.getItems());
                        this.bShown = true;
                        SideBar.this.fillDropDownMenu(menuDropDown, SideBar.this.tree.getItems(), 0);
                    }
                });
                this.dropDownSelectionListener = new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        String id = (String)e.widget.getData("Plugin.viewID");
                        SideBar.this.showItemByID(id);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                };
                SWTSkinButtonUtility btnDropDown = new SWTSkinButtonUtility(soDropDown);
                btnDropDown.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        Control c = buttonUtility.getSkinObject().getControl();
                        menuDropDown.setLocation(c.getDisplay().getCursorLocation());
                        menuDropDown.setVisible(!menuDropDown.getVisible());
                    }
                });
            }
            if ((soExpand = this.skin.getSkinObject("sidebar-expand")) != null) {
                SWTSkinButtonUtility btnExpand = new SWTSkinButtonUtility(soExpand);
                btnExpand.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        SideBar.this.flipSideBarVisibility();
                    }
                });
            }
        }
    }

    protected void fillDropDownMenu(Menu menuDropDown, TreeItem[] items, int indent) {
        int i;
        String s = "";
        for (i = 0; i < indent; ++i) {
            s = s + "   ";
        }
        for (i = 0; i < items.length; ++i) {
            TreeItem[] subItems;
            String o;
            TreeItem treeItem = items[i];
            MenuItem menuItem = new MenuItem(menuDropDown, 16);
            String id = (String)treeItem.getData("Plugin.viewID");
            menuItem.setData("Plugin.viewID", (Object)id);
            SideBarEntrySWT sideBarInfo = SideBar.getSideBarInfo(id);
            ViewTitleInfo titleInfo = sideBarInfo.getTitleInfo();
            String ind = "";
            if (titleInfo != null && (o = (String)titleInfo.getTitleInfoProperty(0)) != null) {
                ind = "  (" + o + ")";
            }
            menuItem.setText(s + treeItem.getData("text") + ind);
            menuItem.addSelectionListener(this.dropDownSelectionListener);
            if (this.currentSideBarEntry != null && this.currentSideBarEntry.id.equals(id)) {
                menuItem.setSelection(true);
            }
            if ((subItems = treeItem.getItems()).length <= 0) continue;
            this.fillDropDownMenu(menuDropDown, subItems, ++indent);
        }
    }

    protected void fillMenu(Menu menuTree, SideBarEntry entry) {
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] menu_items = MenuItemManager.getInstance().getAllAsArray("sidebar");
        MenuBuildUtils.addPluginMenuItems((Composite)this.soMain.getControl(), menu_items, menuTree, false, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(new Object[]{entry}));
        if (entry != null) {
            menu_items = MenuItemManager.getInstance().getAllAsArray("sidebar." + entry.getId());
            MenuBuildUtils.addPluginMenuItems((Composite)this.soMain.getControl(), menu_items, menuTree, false, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(new Object[]{entry}));
            if (this.currentSideBarEntry != null && this.currentSideBarEntry.datasource instanceof DownloadManager) {
                DownloadManager[] downloads = new DownloadManager[]{(DownloadManager)this.currentSideBarEntry.datasource};
                MenuItem mi = MenuFactory.createTorrentMenuItem(menuTree);
                mi.setData("downloads", (Object)downloads);
                mi.setData("is_detailed_view", (Object)new Boolean(true));
            }
        }
    }

    protected void paintSideBar(Event event2, SideBarEntrySWT sideBarInfo) {
        String textIndicator;
        TreeItem treeItem = (TreeItem)event2.item;
        String text = (String)treeItem.getData("text");
        if (text == null) {
            text = "";
        }
        Rectangle itemBounds = treeItem.getBounds();
        GC gc = event2.gc;
        gc.setAntialias(1);
        gc.setAdvanced(true);
        boolean selected = (event2.detail & 2) > 0;
        Color fgText = Colors.black;
        if (selected) {
            Color color2;
            Color color1;
            if (this.fgSel != null) {
                fgText = this.fgSel;
            }
            if (this.bgSel != null) {
                gc.setBackground(this.bgSel);
            }
            if (this.tree.isFocusControl()) {
                color1 = ColorCache.getColor(gc.getDevice(), "#166688");
                color2 = ColorCache.getColor(gc.getDevice(), "#1c2458");
            } else {
                color1 = ColorCache.getColor(gc.getDevice(), "#447281");
                color2 = ColorCache.getColor(gc.getDevice(), "#393e58");
            }
            gc.setBackground(color1);
            gc.fillRectangle(event2.x, itemBounds.y, event2.width, 3);
            gc.setForeground(color1);
            gc.setBackground(color2);
            gc.fillGradientRectangle(event2.x, itemBounds.y + 3, event2.width, itemBounds.height - 3, true);
        } else {
            if (this.fg != null) {
                fgText = this.fg;
            }
            if (this.bg != null) {
                gc.setBackground(this.bg);
            }
            gc.fillRectangle(event2.getBounds());
        }
        Rectangle treeArea = this.tree.getClientArea();
        gc.setFont(this.tree.getFont());
        if (sideBarInfo == null) {
            String id = (String)treeItem.getData("Plugin.viewID");
            sideBarInfo = SideBar.getSideBarInfo(id);
        }
        int x1IndicatorOfs = 2;
        int x0IndicatorOfs = itemBounds.x;
        if (sideBarInfo.titleInfo != null && (textIndicator = (String)sideBarInfo.titleInfo.getTitleInfoProperty(0)) != null) {
            Pattern pattern;
            Color color2;
            Color color1;
            Point textSize = gc.textExtent(textIndicator);
            Point minTextSize = gc.textExtent("99");
            if (textSize.x < minTextSize.x + 2) {
                textSize.x = minTextSize.x + 2;
            }
            int width = textSize.x + textSize.y / 2 + 2;
            int startX = treeArea.width - (x1IndicatorOfs += width + 2);
            int textOffsetY = 0;
            int height = textSize.y + 3;
            int startY = itemBounds.y + (itemBounds.height - height) / 2;
            if (selected) {
                color1 = ColorCache.getColor(gc.getDevice(), "#000000");
                color2 = ColorCache.getColor(gc.getDevice(), "#000000");
                pattern = new Pattern(gc.getDevice(), 0.0f, (float)startY, 0.0f, (float)(startY + height), color1, 127, color2, 4);
            } else {
                color1 = ColorCache.getColor(gc.getDevice(), "#166688");
                color2 = ColorCache.getColor(gc.getDevice(), "#1c2056");
                pattern = new Pattern(gc.getDevice(), 0.0f, (float)startY, 0.0f, (float)(startY + height), color1, color2);
            }
            gc.setBackgroundPattern(pattern);
            gc.fillRoundRectangle(startX, startY, width, height, textSize.y + 1, height);
            gc.setBackgroundPattern(null);
            pattern.dispose();
            if (this.maxIndicatorWidth > width) {
                this.maxIndicatorWidth = width;
            }
            gc.setForeground(Colors.white);
            GCStringPrinter.printString(gc, textIndicator, new Rectangle(startX, startY + textOffsetY, width, height), true, false, 0x1000000);
        }
        if (sideBarInfo.closeable) {
            Image img = selected ? this.imgCloseSelected : this.imgClose;
            Rectangle closeArea = img.getBounds();
            closeArea.x = treeArea.width - closeArea.width - 2 - x1IndicatorOfs;
            closeArea.y = itemBounds.y + (itemBounds.height - closeArea.height) / 2;
            x1IndicatorOfs += closeArea.width + 2;
            gc.drawImage(img, closeArea.x, closeArea.y);
            treeItem.setData("closeArea", (Object)closeArea);
        }
        SideBarVitalityImage[] vitalityImages = sideBarInfo.getVitalityImages();
        for (int i = 0; i < vitalityImages.length; ++i) {
            SideBarVitalityImageSWT vitalityImage = (SideBarVitalityImageSWT)vitalityImages[i];
            if (!vitalityImage.isVisible()) continue;
            vitalityImage.switchSuffix(selected ? "-selected" : "");
            Image image = vitalityImage.getImage();
            if (image == null) continue;
            Rectangle bounds = image.getBounds();
            bounds.x = treeArea.width - bounds.width - 2 - x1IndicatorOfs;
            bounds.y = itemBounds.y + (itemBounds.height - bounds.height) / 2;
            x1IndicatorOfs += bounds.width + 2;
            gc.drawImage(image, bounds.x, bounds.y);
            vitalityImage.setHitArea(bounds);
        }
        Image imageLeft = sideBarInfo.getImageLeft(selected ? "-selected" : null);
        if (imageLeft == null && selected) {
            imageLeft = sideBarInfo.getImageLeft(null);
        }
        if (imageLeft != null) {
            Rectangle bounds = imageLeft.getBounds();
            int x = x0IndicatorOfs + (20 - bounds.width) / 2;
            int y = itemBounds.y + (itemBounds.height - bounds.height) / 2;
            gc.drawImage(imageLeft, x, y);
            x0IndicatorOfs += 25;
        } else if (treeItem.getParentItem() != null) {
            x0IndicatorOfs += 12;
        }
        if (treeItem.getParentItem() == null) {
            gc.setFont(this.fontHeader);
            gc.setForeground(ColorCache.getColor(gc.getDevice(), "#2B2D32"));
        }
        gc.setForeground(fgText);
        Rectangle clipping = new Rectangle(x0IndicatorOfs, itemBounds.y, treeArea.width - x1IndicatorOfs - 2 - x0IndicatorOfs, itemBounds.height);
        if (event2.getBounds().intersects(clipping)) {
            if (text.startsWith(" ")) {
                text = text.substring(1);
                clipping.x += 30;
                clipping.width -= 30;
            }
            GCStringPrinter.printString(gc, text, clipping, true, false, 0);
        }
        if (treeItem.getItemCount() > 0 && !sideBarInfo.disableCollapse) {
            int yStart;
            int arrowSize;
            int xStart;
            gc.setAntialias(1);
            Color oldBG = gc.getBackground();
            gc.setBackground(gc.getForeground());
            if (treeItem.getExpanded()) {
                xStart = 15;
                arrowSize = 8;
                yStart = itemBounds.height - (itemBounds.height + arrowSize) / 2;
                gc.fillPolygon(new int[]{itemBounds.x - xStart, itemBounds.y + yStart, itemBounds.x - xStart + arrowSize, itemBounds.y + yStart, itemBounds.x - xStart + arrowSize / 2, itemBounds.y + 16});
            } else {
                xStart = 15;
                arrowSize = 8;
                yStart = itemBounds.height - (itemBounds.height + arrowSize) / 2;
                gc.fillPolygon(new int[]{itemBounds.x - xStart, itemBounds.y + yStart, itemBounds.x - xStart + arrowSize, itemBounds.y + yStart + 4, itemBounds.x - xStart, itemBounds.y + yStart + 8});
            }
            gc.setBackground(oldBG);
            gc.setFont(this.fontHeader);
        }
    }

    private void updateSideBarHitAreasY(SideBarEntrySWT[] entries) {
        for (int x = 0; x < entries.length; ++x) {
            Rectangle closeArea;
            SideBarEntrySWT sideBarInfo = entries[x];
            TreeItem treeItem = sideBarInfo.treeItem;
            if (treeItem == null || treeItem.isDisposed()) continue;
            Rectangle itemBounds = sideBarInfo.getBounds();
            if (sideBarInfo.closeable && (closeArea = (Rectangle)treeItem.getData("closeArea")) != null) {
                closeArea.y = itemBounds.y + (itemBounds.height - closeArea.height) / 2;
            }
            SideBarVitalityImage[] vitalityImages = sideBarInfo.getVitalityImages();
            for (int i = 0; i < vitalityImages.length; ++i) {
                Rectangle bounds;
                Image image;
                SideBarVitalityImageSWT vitalityImage = (SideBarVitalityImageSWT)vitalityImages[i];
                if (!vitalityImage.isVisible() || (image = vitalityImage.getImage()) == null || (bounds = vitalityImage.getHitArea()) == null) continue;
                bounds.y = itemBounds.y + (itemBounds.height - bounds.height) / 2;
            }
        }
    }

    private void setupDefaultItems() {
        Composite parent;
        final ViewTitleInfo titleInfoActivityView = new ViewTitleInfo(){

            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0) {
                    int count = 0;
                    VuzeActivitiesEntry[] allEntries = VuzeActivitiesManager.getAllEntries();
                    for (int i = 0; i < allEntries.length; ++i) {
                        VuzeActivitiesEntry entry = allEntries[i];
                        if (entry.isRead()) continue;
                        ++count;
                    }
                    if (count > 0) {
                        return "" + count;
                    }
                    return null;
                }
                if (propertyID == 2) {
                    return "image.sidebar.activity";
                }
                return null;
            }
        };
        VuzeActivitiesManager.addListener(new VuzeActivitiesListener(){

            public void vuzeNewsEntryChanged(VuzeActivitiesEntry entry) {
            }

            public void vuzeNewsEntriesRemoved(VuzeActivitiesEntry[] entries) {
                ViewTitleInfoManager.refreshTitleInfo(titleInfoActivityView);
            }

            public void vuzeNewsEntriesAdded(VuzeActivitiesEntry[] entries) {
                ViewTitleInfoManager.refreshTitleInfo(titleInfoActivityView);
            }
        });
        ImageLoader imageLoader = ImageLoaderFactory.getInstance();
        SideBarEntrySWT entry = this.createEntryFromSkinRef(null, SIDEBAR_SECTION_LIBRARY, "library", MessageText.getString("sidebar.Library"), null, null, false, -1);
        entry.setImageLeftID("image.sidebar.library");
        entry.disableCollapse = true;
        this.createEntryFromSkinRef(SIDEBAR_SECTION_LIBRARY, SIDEBAR_SECTION_LIBRARY_DL, "library", MessageText.getString("sidebar.LibraryDL"), null, null, false, -1);
        this.createEntryFromSkinRef(SIDEBAR_SECTION_LIBRARY, SIDEBAR_SECTION_LIBRARY_UNOPENED, "library", MessageText.getString("sidebar.LibraryUnopened"), null, null, false, -1);
        this.addMenuUnwatched();
        entry = this.createEntryFromSkinRef(null, SIDEBAR_SECTION_BROWSE, "main.area.browsetab", MessageText.getString("sidebar.VuzeHDNetwork"), null, null, false, -1);
        entry.setImageLeftID("image.sidebar.vuze");
        SideBarEntrySWT entryActivity = this.createEntryFromSkinRef(null, SIDEBAR_SECTION_ACTIVITIES, "activity", MessageText.getString("sidebar.Activity"), titleInfoActivityView, null, false, -1);
        this.addMenuNotifications();
        this.createTreeItemFromIViewClass(null, SIDEBAR_SECTION_SUBSCRIPTIONS, "subscriptions", SubscriptionsView.class, null, null, null, null, false);
        UISWTInstanceImpl uiSWTInstance = (UISWTInstanceImpl)UIFunctionsManagerSWT.getUIFunctionsSWT().getUISWTInstance();
        if (uiSWTInstance != null) {
            Map allViews = uiSWTInstance.getAllViews();
            Object[] parentIDs = allViews.keySet().toArray();
            for (int i = 0; i < parentIDs.length; ++i) {
                String parentID = (String)parentIDs[i];
                Map mapSubViews = (Map)allViews.get(parentID);
                if (mapSubViews == null) continue;
                Object[] viewIDs = mapSubViews.keySet().toArray();
                for (int j = 0; j < viewIDs.length; ++j) {
                    boolean open;
                    String viewID = (String)viewIDs[j];
                    UISWTViewEventListener l = (UISWTViewEventListener)mapSubViews.get(viewID);
                    if (l == null || !(open = COConfigurationManager.getBooleanParameter("SideBar.AutoOpen." + viewID, false))) continue;
                    this.createTreeItemFromEventListener(parentID, null, l, viewID, true, null);
                }
            }
        }
        SBC_LibraryView.setupViewTitle();
        PluginsMenuHelper.getInstance().addPluginAddedViewListener(new PluginsMenuHelper.PluginAddedViewListener(){

            public void pluginViewAdded(PluginsMenuHelper.IViewInfo viewInfo) {
                Object o = mapAutoOpen.get(viewInfo.viewID);
                if (o instanceof Map) {
                    SideBar.this.processAutoOpenMap(viewInfo.viewID, (Map)o, viewInfo);
                }
            }
        });
        this.loadCloseables();
        if (System.getProperty("v3.sidebar.advanced", "0").equals("1")) {
            this.createEntryFromSkinRef(null, SIDEBAR_SECTION_ADVANCED, "main.area.advancedtab", SIDEBAR_SECTION_ADVANCED, null, null, false, -1);
        }
        if ((parent = this.tree.getParent()).isVisible()) {
            parent.layout(true, true);
        }
    }

    private SideBarEntrySWT createWelcomeSection() {
        SideBarEntrySWT entry = this.createEntryFromSkinRef(null, SIDEBAR_SECTION_WELCOME, "main.area.welcome", MessageText.getString("v3.MainWindow.menu.getting_started").replaceAll("&", ""), null, null, true, 0);
        entry.setImageLeftID("image.sidebar.welcome");
        return entry;
    }

    public TreeItem createTreeItemFromIView(String parentID, IView iview, String id, Object datasource, boolean closeable, boolean show) {
        int i;
        if (id == null && (i = (id = iview.getClass().getName()).lastIndexOf(46)) > 0) {
            id = id.substring(i + 1);
        }
        TreeItem treeItem = null;
        SideBarEntrySWT sideBarInfo = SideBar.getSideBarInfo(id);
        if (sideBarInfo.treeItem != null) {
            treeItem = sideBarInfo.treeItem;
        } else {
            SideBarEntrySWT sideBarInfoParent = SideBar.getSideBarInfo(parentID);
            TreeItem parentTreeItem = sideBarInfoParent.treeItem;
            treeItem = this.createTreeItem(parentTreeItem, id, datasource, null, iview.getFullTitle(), closeable, -1);
            this.setupTreeItem(null, treeItem, id, null, iview.getFullTitle(), null, datasource, closeable);
            sideBarInfo.parentID = parentID;
            this.createSideBarContentArea(id, iview, treeItem, datasource, closeable);
            iview.dataSourceChanged(datasource);
        }
        if (show) {
            this.showTreeItem(treeItem);
        }
        return treeItem;
    }

    public void showTreeItem(TreeItem treeItem) {
        if (treeItem != null) {
            treeItem.getParent().select(treeItem);
            treeItem.getParent().showItem(treeItem);
            this.itemSelected(treeItem);
        }
    }

    public TreeItem createTreeItemFromIViewClass(String parent, String title, Class iviewClass) {
        String id = iviewClass.getName();
        int i = id.lastIndexOf(46);
        if (i > 0) {
            id = id.substring(i + 1);
        }
        return this.createTreeItemFromIViewClass(parent, id, title, iviewClass, null, null, null, null, true);
    }

    public TreeItem createTreeItemFromIViewClass(String parent, String id, String title, Class iviewClass, Class[] iviewClassArgs, Object[] iviewClassVals, Object datasource, ViewTitleInfo titleInfo, boolean closeable) {
        SideBarEntrySWT sideBarInfo = SideBar.getSideBarInfo(id);
        if (sideBarInfo.treeItem != null) {
            return sideBarInfo.treeItem;
        }
        TreeItem parentItem = parent == null ? null : SideBar.getSideBarInfo((String)parent).treeItem;
        TreeItem treeItem = parentItem != null ? new TreeItem(parentItem, 0) : new TreeItem(this.tree, 0);
        sideBarInfo.iviewClass = iviewClass;
        sideBarInfo.iviewClassArgs = iviewClassArgs;
        sideBarInfo.iviewClassVals = iviewClassVals;
        sideBarInfo.closeable = closeable;
        sideBarInfo.parentID = parent;
        this.setupTreeItem(null, treeItem, id, titleInfo, title, null, datasource, closeable);
        return treeItem;
    }

    private TreeItem createTreeItem(Object parentTreeItem, String id, Object datasource, ViewTitleInfo titleInfo, String title, boolean closeable, int index) {
        if (parentTreeItem == null) {
            parentTreeItem = this.tree;
        }
        TreeItem treeItem = parentTreeItem instanceof Tree ? (index >= 0 ? new TreeItem((Tree)parentTreeItem, 0, index) : new TreeItem((Tree)parentTreeItem, 0)) : (index >= 0 ? new TreeItem((TreeItem)parentTreeItem, 0, index) : new TreeItem((TreeItem)parentTreeItem, 0));
        return treeItem;
    }

    private void setupTreeItem(IView iview, TreeItem treeItem, String id, ViewTitleInfo titleInfo, String title, Composite initializeView, Object datasource, boolean closeable) {
        final SideBarEntrySWT sideBarInfo = SideBar.getSideBarInfo(id);
        boolean pull = true;
        if (treeItem.getParentItem() != null) {
            treeItem.getParentItem().setExpanded(true);
        }
        treeItem.removeDisposeListener(disposeTreeItemListener);
        treeItem.addDisposeListener(disposeTreeItemListener);
        treeItem.setData("Plugin.viewID", (Object)id);
        if (iview != null) {
            sideBarInfo.iview = iview;
        }
        if (title != null) {
            treeItem.setData("text", (Object)title);
        } else if (sideBarInfo.iview != null) {
            treeItem.setData("text", (Object)sideBarInfo.iview.getFullTitle());
        }
        if (titleInfo == null) {
            UISWTViewEventListener eventListener;
            if (sideBarInfo.iview instanceof ViewTitleInfo) {
                titleInfo = (ViewTitleInfo)((Object)sideBarInfo.iview);
            } else if (sideBarInfo.iview instanceof UISWTViewImpl && (eventListener = ((UISWTViewImpl)sideBarInfo.iview).getEventListener()) instanceof ViewTitleInfo) {
                titleInfo = (ViewTitleInfo)((Object)eventListener);
            }
        }
        if (titleInfo != null) {
            sideBarInfo.titleInfo = titleInfo;
        }
        if (sideBarInfo.titleInfo != null) {
            String imageID;
            mapTitleInfoToEntry.put(sideBarInfo.titleInfo, sideBarInfo);
            String newText = (String)sideBarInfo.titleInfo.getTitleInfoProperty(5);
            if (newText != null) {
                pull = false;
                treeItem.setData("text", (Object)newText);
            }
            if ((imageID = (String)sideBarInfo.titleInfo.getTitleInfoProperty(2)) != null) {
                sideBarInfo.setImageLeftID(imageID.length() == 0 ? null : imageID);
            }
            listTreeItemsNoTitleInfo.remove(treeItem);
        } else if (!listTreeItemsNoTitleInfo.contains(treeItem)) {
            listTreeItemsNoTitleInfo.add(treeItem);
        }
        if (treeItem != null) {
            sideBarInfo.treeItem = treeItem;
        }
        if (datasource != null) {
            sideBarInfo.datasource = datasource;
        }
        sideBarInfo.closeable = closeable;
        sideBarInfo.pullTitleFromIView = pull;
        if (closeable) {
            LightHashMap autoOpenInfo = new LightHashMap();
            if (sideBarInfo.parentID != null) {
                autoOpenInfo.put("parentID", sideBarInfo.parentID);
            }
            if (sideBarInfo.iviewClass != null) {
                autoOpenInfo.put("iviewClass", sideBarInfo.iviewClass.getName());
            }
            if (sideBarInfo.eventListener != null) {
                autoOpenInfo.put("eventlistenerid", id);
            }
            if (sideBarInfo.iview != null) {
                autoOpenInfo.put("title", sideBarInfo.iview.getFullTitle());
            }
            if (sideBarInfo.datasource instanceof DownloadManager) {
                try {
                    autoOpenInfo.put("dm", ((DownloadManager)sideBarInfo.datasource).getTorrent().getHashWrapper().toBase32String());
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            mapAutoOpen.put(id, autoOpenInfo);
        }
        if (initializeView != null) {
            iview.initialize(initializeView);
            initializeView.setVisible(false);
            Composite composite = iview.getComposite();
            if (composite != null && !composite.isDisposed()) {
                composite.setVisible(false);
                composite.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (sideBarInfo.treeItem != null && !sideBarInfo.treeItem.isDisposed()) {
                            try {
                                sideBarInfo.treeItem.dispose();
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
            if (sideBarInfo.datasource != null) {
                iview.dataSourceChanged(sideBarInfo.datasource);
            }
            initializeView.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (sideBarInfo.iview != null) {
                        try {
                            sideBarInfo.iview.delete();
                        }
                        catch (Throwable t) {
                            Debug.out(t);
                        }
                        sideBarInfo.iview = null;
                    }
                }
            });
        }
    }

    public static SideBarEntrySWT getSideBarInfo(String id) {
        SideBarEntrySWT sidebarInfo = (SideBarEntrySWT)mapIdToSideBarInfo.get(id);
        if (sidebarInfo == null) {
            sidebarInfo = new SideBarEntrySWT(instance, id);
            mapIdToSideBarInfo.put(id, sidebarInfo);
        }
        return sidebarInfo;
    }

    public boolean showItemByID(String id) {
        SideBarEntrySWT sideBarInfo = SideBar.getSideBarInfo(id);
        if (sideBarInfo.treeItem != null) {
            this.itemSelected(sideBarInfo.treeItem);
            return true;
        }
        if (id.equals(SIDEBAR_SECTION_ADVANCED)) {
            SideBarEntrySWT entry = this.createEntryFromSkinRef(null, SIDEBAR_SECTION_ADVANCED, "main.area.advancedtab", SIDEBAR_SECTION_ADVANCED, null, null, false, -1);
            this.itemSelected(entry.treeItem);
            return true;
        }
        if (id.equals(SIDEBAR_SECTION_WELCOME)) {
            SideBarEntrySWT entry = this.createWelcomeSection();
            this.itemSelected(entry.treeItem);
            return true;
        }
        if (id.equals(SIDEBAR_SECTION_PUBLISH)) {
            SideBarEntrySWT entry = this.createEntryFromSkinRef(SIDEBAR_SECTION_BROWSE, SIDEBAR_SECTION_PUBLISH, "publishtab.area", SIDEBAR_SECTION_PUBLISH, null, null, true, -1);
            this.itemSelected(entry.treeItem);
            return true;
        }
        return false;
    }

    private void itemSelected(final TreeItem treeItem) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SideBar.this._itemSelected(treeItem);
            }
        });
    }

    private void disabledViewModes() {
        ToolBarView tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class);
        if (tb != null) {
            ToolBarItem itemModeBig;
            ToolBarItem itemModeSmall = tb.getToolBarItem("modeSmall");
            if (itemModeSmall != null) {
                itemModeSmall.getSkinButton().getSkinObject().switchSuffix("");
                itemModeSmall.setEnabled(false);
            }
            if ((itemModeBig = tb.getToolBarItem("modeBig")) != null) {
                itemModeBig.getSkinButton().getSkinObject().switchSuffix("");
                itemModeBig.setEnabled(false);
            }
        }
    }

    private void _itemSelected(TreeItem treeItem) {
        String id;
        SideBarEntrySWT newSideBarInfo;
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0 || selection[0] != treeItem) {
            this.tree.showItem(treeItem);
            this.tree.select(treeItem);
        }
        if (this.currentSideBarEntry == (newSideBarInfo = SideBar.getSideBarInfo(id = (String)treeItem.getData("Plugin.viewID")))) {
            this.triggerSelectionListener(newSideBarInfo, newSideBarInfo);
            return;
        }
        IView newIView = newSideBarInfo.iview;
        if (newIView == null && newSideBarInfo.iviewClass != null) {
            newIView = this.createSideBarContentArea(id, newSideBarInfo);
            if (newIView == null) {
                return;
            }
            this.setupTreeItem(newIView, treeItem, (String)treeItem.getData("Plugin.viewID"), null, newIView.getFullTitle(), null, null, newSideBarInfo.closeable);
        }
        if (newIView == null && newSideBarInfo.eventListener != null) {
            newIView = this.createTreeItemFromEventListener(null, treeItem, newSideBarInfo.eventListener, id, newSideBarInfo.closeable, null);
        }
        if (newIView != null) {
            if (newIView instanceof ToolBarEnabler) {
                ISelectedContent[] sels = new ISelectedContent[]{new ToolBarEnablerSelectedContent((ToolBarEnabler)((Object)newIView))};
                TableView tv = null;
                if (newIView instanceof TableView) {
                    tv = (TableView)((Object)newIView);
                }
                SelectedContentManager.changeCurrentlySelectedContent("IconBarEnabler", sels, tv);
            } else {
                SelectedContentManager.clearCurrentlySelectedContent();
            }
            this.disabledViewModes();
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    SideBar.this.flipVisibilityTo(newSideBarInfo);
                }
            });
        }
    }

    protected void flipVisibilityTo(SideBarEntrySWT newSideBarInfo) {
        Composite c;
        Composite composite;
        SWTSkinObjectContainer container;
        SideBarEntrySWT oldSideBarInfo = this.currentSideBarEntry;
        this.currentSideBarEntry = newSideBarInfo;
        if (this.currentSideBarEntry.iview instanceof UISWTViewImpl) {
            Object ds = ((UISWTViewImpl)this.currentSideBarEntry.iview).getDataSource();
            DownloadManager dm = null;
            if (ds instanceof DownloadManager) {
                dm = (DownloadManager)ds;
            } else if (ds instanceof Download) {
                dm = PluginCoreUtils.unwrap((Download)ds);
            }
            if (dm != null) {
                try {
                    TableView tv = null;
                    if (this.currentSideBarEntry.iview instanceof TableView) {
                        tv = (TableView)((Object)this.currentSideBarEntry.iview);
                    }
                    SelectedContentManager.changeCurrentlySelectedContent(this.currentSideBarEntry.id, new ISelectedContent[]{new SelectedContentV3(dm)}, tv);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if ((container = (SWTSkinObjectContainer)newSideBarInfo.skinObject) != null && (composite = container.getComposite()) != null && !composite.isDisposed()) {
            composite.setVisible(true);
            composite.moveAbove(null);
        }
        if ((c = this.currentSideBarEntry.iview.getComposite()) != null && !c.isDisposed()) {
            c.setVisible(true);
        }
        if (oldSideBarInfo != null && oldSideBarInfo != newSideBarInfo) {
            Composite oldComposite;
            if (this.lastImage != null && !this.lastImage.isDisposed()) {
                this.lastImage.dispose();
                this.lastImage = null;
            }
            if (oldSideBarInfo.skinObject != null && (container = (SWTSkinObjectContainer)oldSideBarInfo.skinObject) != null) {
                oldComposite = container.getControl();
                this.doFade((Control)oldComposite);
                container.setVisible(false);
                if (!oldComposite.isDisposed()) {
                    oldComposite.getShell().update();
                }
            }
            if (oldSideBarInfo.iview != null && (oldComposite = oldSideBarInfo.iview.getComposite()) != null && !oldComposite.isDisposed()) {
                this.doFade((Control)oldComposite);
                oldComposite.setVisible(false);
                oldComposite.getShell().update();
            }
        }
        this.triggerSelectionListener(newSideBarInfo, oldSideBarInfo);
    }

    private void doFade(Control oldComposite) {
    }

    public IView createTreeItemFromEventListener(String parentID, TreeItem treeItem, UISWTViewEventListener l, String id, boolean closeable, Object datasource) {
        UISWTViewImpl iview;
        block21: {
            String name;
            String originialID = id;
            SideBarEntrySWT sideBarInfo = SideBar.getSideBarInfo(id);
            if (sideBarInfo.treeItem != null && sideBarInfo.iview != null) {
                if (sideBarInfo.eventListener == l) {
                    System.err.println("Already created view " + id);
                }
                id = id + "_" + SystemTime.getCurrentTime();
                sideBarInfo = SideBar.getSideBarInfo(id);
            }
            String string = name = sideBarInfo.treeItem == null ? id : (String)sideBarInfo.treeItem.getData("text");
            if (treeItem == null) {
                PluginsMenuHelper.IViewInfo viewInfo;
                int i;
                TreeItem parentTreeItem = parentID == null ? null : SideBar.getSideBarInfo((String)parentID).treeItem;
                PluginsMenuHelper.IViewInfo foundViewInfo = null;
                PluginsMenuHelper.IViewInfo[] pluginViewsInfo = PluginsMenuHelper.getInstance().getPluginViewsInfo();
                for (i = 0; i < pluginViewsInfo.length; ++i) {
                    viewInfo = pluginViewsInfo[i];
                    if (viewInfo.event_listener != l) continue;
                    foundViewInfo = viewInfo;
                    break;
                }
                if (foundViewInfo == null) {
                    pluginViewsInfo = PluginsMenuHelper.getInstance().getPluginLogViewsInfo();
                    for (i = 0; i < pluginViewsInfo.length; ++i) {
                        viewInfo = pluginViewsInfo[i];
                        if (viewInfo.event_listener != l) continue;
                        foundViewInfo = viewInfo;
                        break;
                    }
                }
                if (foundViewInfo != null) {
                    PluginsMenuHelper.IViewInfo[] pluginLogViewsInfo = PluginsMenuHelper.getInstance().getPluginLogViewsInfo();
                    for (int i2 = 0; i2 < pluginLogViewsInfo.length; ++i2) {
                        PluginsMenuHelper.IViewInfo viewInfo2 = pluginLogViewsInfo[i2];
                        if (viewInfo2.event_listener != l) continue;
                        foundViewInfo = viewInfo2;
                        break;
                    }
                }
                name = foundViewInfo == null ? id : foundViewInfo.name;
                sideBarInfo.eventListener = l;
                sideBarInfo.parentID = parentID;
                treeItem = this.createTreeItem(parentTreeItem, id, datasource, null, name, closeable, -1);
            }
            iview = null;
            try {
                iview = new UISWTViewImpl(parentID, id, l, datasource);
                iview.setTitle(name);
                iview.dataSourceChanged(datasource);
                if (l instanceof UISWTViewEventListenerSkinObject) {
                    iview.setUseCoreDataSource(true);
                }
                Composite parent = (Composite)this.soSideBarContents.getControl();
                parent.setBackgroundMode(0);
                Composite viewComposite = new Composite(parent, 0);
                viewComposite.setBackgroundMode(0);
                viewComposite.setLayoutData((Object)Utils.getFilledFormData());
                viewComposite.setBackground(parent.getDisplay().getSystemColor(22));
                viewComposite.setForeground(parent.getDisplay().getSystemColor(21));
                if (l instanceof UISWTViewEventListenerSkinObject) {
                    viewComposite.setLayout((Layout)new FormLayout());
                } else {
                    GridLayout gridLayout = new GridLayout();
                    gridLayout.marginWidth = 0;
                    gridLayout.marginHeight = 0;
                    gridLayout.verticalSpacing = 0;
                    gridLayout.horizontalSpacing = 0;
                    viewComposite.setLayout((Layout)gridLayout);
                }
                SWTSkinObjectContainer soContents = new SWTSkinObjectContainer(this.skin, this.skin.getSkinProperties(), (Control)viewComposite, "Contents" + (mapIdToSideBarInfo.size() + 1), "", "container", this.soSideBarContents);
                sideBarInfo.skinObject = soContents;
                sideBarInfo.eventListener = l;
                sideBarInfo.parentID = parentID;
                this.setupTreeItem(iview, treeItem, id, null, iview.getFullTitle(), viewComposite, datasource, closeable);
                if (parent.isVisible()) {
                    parent.layout(true, true);
                }
                if (closeable) {
                    COConfigurationManager.setParameter("SideBar.AutoOpen." + id, true);
                } else {
                    COConfigurationManager.removeParameter("SideBar.AutoOpen." + id);
                }
            }
            catch (UISWTViewEventCancelledException e) {
                if (treeItem != null && !treeItem.isDisposed()) {
                    treeItem.dispose();
                }
                this.showItemByID(originialID);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    final String id2 = id;
                    l = new UISWTViewEventListener(){

                        public boolean eventOccurred(UISWTViewEvent event2) {
                            if (event2.getType() == 2) {
                                Composite c = (Composite)event2.getData();
                                Label label = new Label(c, 0x1000000);
                                label.setText("Plugin " + id2 + " did not want to initialize");
                            }
                            return true;
                        }
                    };
                    iview = new UISWTViewImpl("SideBar.Plugins", id, l, datasource);
                    String text = (String)treeItem.getData("text");
                    if (text != null) {
                        iview.setTitle(text);
                    }
                    Composite parent = (Composite)this.soSideBarContents.getControl();
                    Composite viewComposite = new Composite(parent, 0);
                    viewComposite.setLayoutData((Object)Utils.getFilledFormData());
                    viewComposite.setLayout((Layout)new FormLayout());
                    viewComposite.setBackground(parent.getDisplay().getSystemColor(22));
                    viewComposite.setForeground(parent.getDisplay().getSystemColor(21));
                    SWTSkinObjectContainer soContents = new SWTSkinObjectContainer(this.skin, this.skin.getSkinProperties(), (Control)viewComposite, "Contents" + (mapIdToSideBarInfo.size() + 1), "", "container", this.soSideBarContents);
                    sideBarInfo.skinObject = soContents;
                    sideBarInfo.eventListener = l;
                    this.setupTreeItem(iview, treeItem, id, null, iview.getFullTitle(), viewComposite, datasource, closeable);
                    parent.layout(true, true);
                }
                catch (Exception e1) {
                    Debug.out(e1);
                }
                if (e instanceof UISWTViewEventCancelledException) break block21;
                Debug.out(e);
            }
        }
        return iview;
    }

    private IView createSideBarContentArea(String id, SideBarEntrySWT sideBarInfo) {
        if (id == null) {
            return null;
        }
        IView iview = null;
        try {
            if (sideBarInfo.iviewClassArgs == null) {
                iview = (IView)sideBarInfo.iviewClass.newInstance();
            } else {
                Constructor constructor = sideBarInfo.iviewClass.getConstructor(sideBarInfo.iviewClassArgs);
                iview = (IView)constructor.newInstance(sideBarInfo.iviewClassVals);
            }
            this.createSideBarContentArea(id, iview, sideBarInfo.treeItem, sideBarInfo.datasource, sideBarInfo.closeable);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (iview != null) {
                iview.delete();
            }
            iview = null;
        }
        return iview;
    }

    private IView createSideBarContentArea(String id, IView view, TreeItem item, Object datasource, boolean closeable) {
        try {
            Composite parent = (Composite)this.soSideBarContents.getControl();
            SWTSkinObjectContainer soContents = new SWTSkinObjectContainer(this.skin, this.skin.getSkinProperties(), "Contents" + (mapIdToSideBarInfo.size() + 1), "", this.soSideBarContents);
            Composite viewComposite = soContents.getComposite();
            viewComposite.setBackground(parent.getDisplay().getSystemColor(22));
            viewComposite.setForeground(parent.getDisplay().getSystemColor(21));
            viewComposite.setLayoutData((Object)Utils.getFilledFormData());
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            viewComposite.setLayout((Layout)gridLayout);
            SideBarEntrySWT sideBarInfo = SideBar.getSideBarInfo((String)item.getData("Plugin.viewID"));
            sideBarInfo.skinObject = soContents;
            this.setupTreeItem(view, item, id, null, null, viewComposite, datasource, closeable);
            Composite iviewComposite = view.getComposite();
            Object existingLayout = iviewComposite.getLayoutData();
            if (existingLayout == null || existingLayout instanceof GridData) {
                GridData gridData = new GridData(1808);
                iviewComposite.setLayoutData((Object)gridData);
            }
            parent.layout(true, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (view != null) {
                view.delete();
            }
            view = null;
        }
        return view;
    }

    public SideBarEntrySWT createEntryFromSkinRef(String parentID, final String id, final String configID, String title, ViewTitleInfo titleInfo, final Object params, boolean closeable, int index) {
        Object datasource = null;
        SideBarEntrySWT sideBarInfo = SideBar.getSideBarInfo(id);
        if (sideBarInfo.treeItem != null) {
            return sideBarInfo;
        }
        TreeItem treeItem = null;
        UISWTViewEventListenerSkinObject l = new UISWTViewEventListenerSkinObject(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean eventOccurred(UISWTViewEvent event2) {
                switch (event2.getType()) {
                    case 2: {
                        Composite parent = (Composite)event2.getData();
                        SWTSkinObject soParent = (SWTSkinObject)parent.getData("SkinObject");
                        Shell shell = parent.getShell();
                        Cursor cursor = shell.getCursor();
                        try {
                            shell.setCursor(shell.getDisplay().getSystemCursor(1));
                            this.skinObject = SideBar.this.skin.createSkinObject(id, configID, soParent, params);
                            this.skinObject.getControl().setLayoutData((Object)Utils.getFilledFormData());
                            break;
                        }
                        finally {
                            shell.setCursor(cursor);
                        }
                    }
                    case 5: {
                        break;
                    }
                }
                return true;
            }
        };
        sideBarInfo.eventListener = l;
        TreeItem parentTreeItem = parentID == null ? null : SideBar.getSideBarInfo((String)parentID).treeItem;
        sideBarInfo.parentID = parentID;
        treeItem = this.createTreeItem(parentTreeItem == null ? this.tree : parentTreeItem, id, datasource, titleInfo, title, closeable, index);
        this.setupTreeItem(null, treeItem, id, titleInfo, title, null, datasource, closeable);
        return sideBarInfo;
    }

    public String getUpdateUIName() {
        if (this.currentSideBarEntry == null || this.currentSideBarEntry.iview == null) {
            return "Sidebar";
        }
        if (this.currentSideBarEntry.iview instanceof UIPluginView) {
            UIPluginView uiPluginView = (UIPluginView)((Object)this.currentSideBarEntry.iview);
            return uiPluginView.getViewID();
        }
        return this.currentSideBarEntry.iview.getFullTitle();
    }

    public void updateUI() {
        if (this.currentSideBarEntry == null || this.currentSideBarEntry.iview == null || this.tree.getSelectionCount() == 0) {
            return;
        }
        this.currentSideBarEntry.iview.refresh();
        SideBarEntrySWT entry = SideBar.getSideBarInfo(this.currentSideBarEntry.id);
        if (entry.pullTitleFromIView && entry.treeItem != null && !entry.treeItem.isDisposed()) {
            entry.treeItem.setData("text", (Object)this.currentSideBarEntry.iview.getFullTitle());
        }
    }

    public void viewTitleInfoRefresh(final ViewTitleInfo titleIndicator) {
        if (titleIndicator == null) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                String imageID;
                if (SideBar.this.tree == null || SideBar.this.tree.isDisposed()) {
                    return;
                }
                SideBarEntrySWT sideBarEntry = (SideBarEntrySWT)mapTitleInfoToEntry.get(titleIndicator);
                if (sideBarEntry == null) {
                    SkinView skinView;
                    String id;
                    Object o = titleIndicator.getTitleInfoProperty(4);
                    if (o instanceof SkinView && (id = (skinView = (SkinView)o).getMainSkinObject().getSkinObjectID()) != null) {
                        Iterator iter = listTreeItemsNoTitleInfo.iterator();
                        while (iter.hasNext()) {
                            TreeItem searchTreeItem = (TreeItem)iter.next();
                            if (searchTreeItem.isDisposed()) {
                                iter.remove();
                                continue;
                            }
                            String treeItemID = (String)searchTreeItem.getData("Plugin.viewID");
                            if (treeItemID == null || !treeItemID.equals(id)) continue;
                            sideBarEntry = SideBar.getSideBarInfo(treeItemID);
                            if (sideBarEntry.treeItem == null) break;
                            sideBarEntry.titleInfo = titleIndicator;
                            mapTitleInfoToEntry.put(titleIndicator, sideBarEntry);
                            break;
                        }
                    }
                    if (sideBarEntry == null || sideBarEntry.treeItem == null) {
                        return;
                    }
                }
                if (sideBarEntry.treeItem == null || sideBarEntry.treeItem.isDisposed()) {
                    return;
                }
                String newText = (String)titleIndicator.getTitleInfoProperty(5);
                if (newText != null) {
                    sideBarEntry.pullTitleFromIView = false;
                    sideBarEntry.treeItem.setData("text", (Object)newText);
                }
                if ((imageID = (String)titleIndicator.getTitleInfoProperty(2)) != null) {
                    sideBarEntry.setImageLeftID(imageID.length() == 0 ? null : imageID);
                }
                sideBarEntry.redraw();
                String logID = (String)titleIndicator.getTitleInfoProperty(7);
                if (logID != null) {
                    sideBarEntry.setLogID(logID);
                }
            }
        });
    }

    public SideBarEntrySWT getCurrentSideBarInfo() {
        return this.currentSideBarEntry;
    }

    public void addListener(SideBarListener l) {
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.add(l);
    }

    public void removeListener(SideBarListener l) {
        this.listeners.remove(l);
    }

    private void triggerSelectionListener(SideBarEntrySWT newSideBarEntry, SideBarEntrySWT oldSideBarEntry) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            SideBarListener l = (SideBarListener)iter.next();
            l.sidebarItemSelected(newSideBarEntry, oldSideBarEntry);
        }
    }

    public IView getIViewFromID(String id) {
        if (id == null) {
            return null;
        }
        return SideBar.getSideBarInfo((String)id).iview;
    }

    public void saveCloseables() {
        for (String id : mapAutoOpen.keySet()) {
            String s;
            Object o = mapAutoOpen.get(id);
            if (!(o instanceof Map)) continue;
            SideBarEntrySWT sideBarInfo = SideBar.getSideBarInfo(id);
            Map autoOpenInfo = (Map)o;
            if (sideBarInfo.treeItem == null || sideBarInfo.treeItem.isDisposed() || (s = (String)sideBarInfo.treeItem.getData("text")) == null) continue;
            autoOpenInfo.put("title", s);
        }
        FileUtil.writeResilientConfigFile("sidebarauto.config", mapAutoOpen);
    }

    public void loadCloseables() {
        mapAutoOpen = FileUtil.readResilientConfigFile("sidebarauto.config", true);
        if (mapAutoOpen.isEmpty()) {
            return;
        }
        BDecoder.decodeStrings(mapAutoOpen);
        for (String id : mapAutoOpen.keySet()) {
            Object o = mapAutoOpen.get(id);
            if (!(o instanceof Map)) continue;
            this.processAutoOpenMap(id, (Map)o, null);
        }
    }

    private void processAutoOpenMap(String id, Map autoOpenInfo, PluginsMenuHelper.IViewInfo viewInfo) {
        try {
            Class<?> cla;
            SideBarEntrySWT sideBarInfo = SideBar.getSideBarInfo(id);
            if (sideBarInfo.treeItem != null) {
                return;
            }
            if (id.equals(SIDEBAR_SECTION_WELCOME)) {
                this.createWelcomeSection();
            }
            String title = MapUtils.getMapString(autoOpenInfo, "title", id);
            String parentID = (String)autoOpenInfo.get("parentID");
            if (viewInfo != null) {
                if (viewInfo.view != null) {
                    this.createTreeItemFromIView(parentID, viewInfo.view, id, null, true, false);
                } else if (viewInfo.event_listener != null) {
                    this.createTreeItemFromEventListener(parentID, null, viewInfo.event_listener, id, true, null);
                }
                if (sideBarInfo.iview == null) {
                    this.createSideBarContentArea(id, sideBarInfo);
                }
            }
            if ((cla = Class.forName(MapUtils.getMapString(autoOpenInfo, "iviewClass", ""))) != null) {
                String dmHash = MapUtils.getMapString(autoOpenInfo, "dm", null);
                DownloadManager ds = null;
                if (dmHash != null) {
                    HashWrapper hw = new HashWrapper(Base32.decode(dmHash));
                    GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                    ds = gm.getDownloadManager(hw);
                    return;
                }
                this.createTreeItemFromIViewClass(parentID, id, title, cla, null, null, ds, null, true);
                if (sideBarInfo.iview == null) {
                    this.createSideBarContentArea(id, sideBarInfo);
                }
            }
        }
        catch (ClassNotFoundException ce) {
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    public void showItemByTabID(final String tabID) {
        if (tabID == null) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (SideBar.this.tree.isDisposed()) {
                    return;
                }
                IView viewFromID = SideBar.this.getIViewFromID(tabID);
                if (viewFromID != null) {
                    SideBar.this.showItemByID(tabID);
                }
                if (tabID.equals("library") || tabID.equals("minilibrary")) {
                    SideBar.this.showItemByID(SideBar.SIDEBAR_SECTION_LIBRARY);
                } else if (tabID.equals("publish")) {
                    SideBar.this.showItemByID(SideBar.SIDEBAR_SECTION_PUBLISH);
                } else if (tabID.equals("activities")) {
                    SideBar.this.showItemByID(SideBar.SIDEBAR_SECTION_ACTIVITIES);
                } else {
                    SideBar.this.showItemByID(SideBar.SIDEBAR_SECTION_BROWSE);
                }
            }
        });
    }

    public SideBarEntrySWT getSideBarEntry(SkinView skinView) {
        SWTSkinObject so = skinView.getMainSkinObject();
        Object[] sideBarEntries = mapIdToSideBarInfo.values().toArray();
        for (int i = 0; i < sideBarEntries.length; ++i) {
            SWTSkinObject entrySOParent;
            SideBarEntrySWT entry = (SideBarEntrySWT)sideBarEntries[i];
            SWTSkinObject entrySO = entry.getSkinObject();
            SWTSkinObject sWTSkinObject = entrySOParent = entrySO == null ? entrySO : entrySO.getParent();
            if (entrySO != so && entrySO != so.getParent() && entrySOParent != so) continue;
            return entry;
        }
        return null;
    }

    public SideBarEntry[] getSideBarEntries() {
        return mapIdToSideBarInfo.values().toArray(new SideBarEntry[0]);
    }

    protected void linkTitleInfoToEntry(ViewTitleInfo ti, SideBarEntry entry) {
        mapTitleInfoToEntry.put(ti, entry);
    }

    public void closeSideBar(final String id) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SideBarEntrySWT entry = SideBar.getSideBarInfo(id);
                if (entry != null && entry.treeItem != null && !entry.treeItem.isDisposed()) {
                    entry.treeItem.dispose();
                }
            }
        });
    }

    static /* synthetic */ Image access$1200(SideBar x0) {
        return x0.lastImage;
    }

    static /* synthetic */ Shell access$1300(SideBar x0) {
        return x0.shellFade;
    }

    static {
        mapAutoOpen = new LightHashMap();
        instance = null;
        disposeTreeItemListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                final TreeItem treeItem = (TreeItem)e.widget;
                final Tree tree = treeItem.getParent();
                final int itemIndex = tree.indexOf(treeItem);
                final String id = (String)treeItem.getData("Plugin.viewID");
                Utils.execSWTThreadLater(0, new AERunnable(){

                    public void runSupport() {
                        listTreeItemsNoTitleInfo.remove(treeItem);
                        if (id != null) {
                            try {
                                SideBarEntrySWT entry = SideBar.getSideBarInfo(id);
                                entry.treeItem = null;
                                entry.triggerCloseListeners();
                                if (entry.iview != null) {
                                    IView iviewDelete = entry.iview;
                                    entry.iview = null;
                                    iviewDelete.delete();
                                }
                                if (entry.skinObject != null) {
                                    SWTSkinObject so = entry.skinObject;
                                    entry.skinObject = null;
                                    so.getSkin().removeSkinObject(so);
                                }
                                COConfigurationManager.removeParameter("SideBar.AutoOpen." + id);
                                if (Constants.isOSX && !tree.isDisposed() && tree.getSelectionCount() == 0) {
                                    if (entry.parentID != null) {
                                        entry.getSidebar().showItemByID(entry.parentID);
                                    } else {
                                        int i = itemIndex;
                                        if (i >= tree.getItemCount()) {
                                            i = tree.getItemCount() - 1;
                                        }
                                        TreeItem item = tree.getItem(i);
                                        entry.getSidebar().itemSelected(item);
                                    }
                                }
                            }
                            catch (Exception e2) {
                                Debug.out(e2);
                            }
                            mapAutoOpen.remove(id);
                            mapIdToSideBarInfo.remove(id);
                            return;
                        }
                        Iterator iter = mapIdToSideBarInfo.keySet().iterator();
                        while (iter.hasNext()) {
                            String id2 = (String)iter.next();
                            SideBarEntrySWT sideBarInfo = SideBar.getSideBarInfo(id2);
                            if (sideBarInfo == null || sideBarInfo.treeItem != treeItem) continue;
                            iter.remove();
                        }
                    }
                });
            }
        };
    }

    public static abstract class UISWTViewEventListenerSkinObject
    implements UISWTViewEventListener {
        protected SWTSkinObject skinObject;

        public SWTSkinObject getSkinObject() {
            return this.skinObject;
        }
    }
}

