/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin.sidebar;

import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarCloseListener;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarLogIdListener;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarVitalityImageSWT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarEntry;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarVitalityImage;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.views.IView;

public class SideBarEntrySWT
implements SideBarEntry {
    public final String id;
    public String parentID;
    public Object datasource;
    public ViewTitleInfo titleInfo;
    SWTSkinObject skinObject;
    TreeItem treeItem;
    boolean pullTitleFromIView;
    public IView iview;
    public boolean closeable;
    public UISWTViewEventListener eventListener;
    public Class iviewClass;
    public Class[] iviewClassArgs;
    public Object[] iviewClassVals;
    public boolean disableCollapse;
    private List listVitalityImages = Collections.EMPTY_LIST;
    private String imageLeftID;
    private List listCloseListeners = Collections.EMPTY_LIST;
    private List listLogIDListeners = Collections.EMPTY_LIST;
    private final SideBar sidebar;
    private String logID;

    public SideBarEntrySWT(SideBar sidebar, String id) {
        int i;
        this.id = id;
        this.logID = id == null ? "null" : ((i = id.indexOf(95)) > 0 ? id.substring(0, i) : id);
        this.sidebar = sidebar;
    }

    public String getParentID() {
        return this.parentID;
    }

    public void setParentID(String parentID) {
        this.parentID = parentID;
    }

    public Object getDatasourceCore() {
        return this.datasource;
    }

    public Object getDatasource() {
        return PluginCoreUtils.convert(this.datasource, false);
    }

    public void setDatasource(Object datasource) {
        this.datasource = datasource;
    }

    public ViewTitleInfo getTitleInfo() {
        return this.titleInfo;
    }

    public void setTitleInfo(ViewTitleInfo titleInfo) {
        String newText;
        this.titleInfo = titleInfo;
        this.sidebar.linkTitleInfoToEntry(titleInfo, this);
        if (this.treeItem != null && !this.treeItem.isDisposed() && (newText = (String)titleInfo.getTitleInfoProperty(5)) != null) {
            this.pullTitleFromIView = false;
            this.treeItem.setData("text", (Object)newText);
        }
    }

    public SWTSkinObject getSkinObject() {
        return this.skinObject;
    }

    public void setSkinObject(SWTSkinObject skinObject) {
        this.skinObject = skinObject;
    }

    public TreeItem getTreeItem() {
        return this.treeItem;
    }

    public void setTreeItem(TreeItem treeItem) {
        this.treeItem = treeItem;
    }

    public boolean isPullTitleFromIView() {
        return this.pullTitleFromIView;
    }

    public void setPullTitleFromIView(boolean pullTitleFromIView) {
        this.pullTitleFromIView = pullTitleFromIView;
    }

    public IView getIView() {
        return this.iview;
    }

    public void setIView(IView iview) {
        this.iview = iview;
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    public UISWTViewEventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(UISWTViewEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public Class getIViewClass() {
        return this.iviewClass;
    }

    public void setIViewClass(Class iviewClass) {
        this.iviewClass = iviewClass;
    }

    public Class[] getIViewClassArgs() {
        return this.iviewClassArgs;
    }

    public void setIViewClassArgs(Class[] iviewClassArgs) {
        this.iviewClassArgs = iviewClassArgs;
    }

    public Object[] getIViewClassVals() {
        return this.iviewClassVals;
    }

    public void setIViewClassVals(Object[] iviewClassVals) {
        this.iviewClassVals = iviewClassVals;
    }

    public String getId() {
        return this.id;
    }

    public SideBarVitalityImage addVitalityImage(String imageID) {
        SideBarVitalityImageSWT vitalityImage = new SideBarVitalityImageSWT(this, imageID);
        if (this.listVitalityImages == Collections.EMPTY_LIST) {
            this.listVitalityImages = new ArrayList(1);
        }
        this.listVitalityImages.add(vitalityImage);
        return vitalityImage;
    }

    public SideBarVitalityImage[] getVitalityImages() {
        return this.listVitalityImages.toArray(new SideBarVitalityImage[0]);
    }

    public SideBarVitalityImage getVitalityImage(int hitX, int hitY) {
        SideBarVitalityImage[] vitalityImages = this.getVitalityImages();
        for (int i = 0; i < vitalityImages.length; ++i) {
            Rectangle hitArea;
            SideBarVitalityImageSWT vitalityImage = (SideBarVitalityImageSWT)vitalityImages[i];
            if (!vitalityImage.isVisible() || (hitArea = vitalityImage.getHitArea()) == null || !hitArea.contains(hitX, hitY)) continue;
            return vitalityImage;
        }
        return null;
    }

    public void redraw() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (SideBarEntrySWT.this.treeItem == null || SideBarEntrySWT.this.treeItem.isDisposed()) {
                    return;
                }
                Tree tree = SideBarEntrySWT.this.treeItem.getParent();
                Rectangle bounds = SideBarEntrySWT.this.treeItem.getBounds();
                Rectangle treeBounds = tree.getBounds();
                tree.redraw(0, bounds.y, treeBounds.width, bounds.height, true);
                tree.update();
            }
        });
    }

    public Rectangle getBounds() {
        if (this.treeItem == null || this.treeItem.isDisposed()) {
            return null;
        }
        Tree tree = this.treeItem.getParent();
        Rectangle bounds = this.treeItem.getBounds();
        Rectangle treeBounds = tree.getBounds();
        return new Rectangle(0, bounds.y, treeBounds.width, bounds.height);
    }

    public void setImageLeftID(String id) {
        this.imageLeftID = id;
    }

    public Image getImageLeft(String suffix) {
        if (this.imageLeftID == null) {
            return null;
        }
        Image img = null;
        img = suffix == null ? ImageLoaderFactory.getInstance().getImage(this.imageLeftID) : ImageLoaderFactory.getInstance().getImage(this.imageLeftID + suffix);
        if (ImageLoader.isRealImage(img)) {
            return img;
        }
        return null;
    }

    public void addListener(SideBarCloseListener l) {
        if (this.listCloseListeners == Collections.EMPTY_LIST) {
            this.listCloseListeners = new ArrayList(1);
        }
        this.listCloseListeners.add(l);
    }

    protected void triggerCloseListeners() {
        Object[] list = this.listCloseListeners.toArray();
        for (int i = 0; i < list.length; ++i) {
            SideBarCloseListener l = (SideBarCloseListener)list[i];
            l.sidebarClosed(this);
        }
    }

    public void addListener(SideBarLogIdListener l) {
        if (this.listLogIDListeners == Collections.EMPTY_LIST) {
            this.listLogIDListeners = new ArrayList(1);
        }
        this.listLogIDListeners.add(l);
    }

    public void removeListener(SideBarLogIdListener sideBarLogIdListener) {
        this.listLogIDListeners.remove(sideBarLogIdListener);
    }

    protected void triggerLogIDListeners(String oldID) {
        Object[] list = this.listLogIDListeners.toArray();
        for (int i = 0; i < list.length; ++i) {
            SideBarLogIdListener l = (SideBarLogIdListener)list[i];
            l.sidebarLogIdChanged(this, oldID, this.logID);
        }
    }

    public String getLogID() {
        return this.logID;
    }

    public void setLogID(String logID) {
        if (logID == null || logID.equals("" + this.logID)) {
            return;
        }
        String oldID = this.logID;
        this.logID = logID;
        this.triggerLogIDListeners(oldID);
    }

    public SideBar getSidebar() {
        return this.sidebar;
    }
}

