/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.messenger.config.PlatformDCAdManager;
import com.aelitis.azureus.util.JSONUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;

public class AzpdFileAccess {
    public static final String PARAM_EXPIRE_TIME = "az-expire-time";
    public static final String PARAM_CREATE_TIME = "az-create-time";
    public static final String PARAM_IS_OFFLINE = "is-off-line";
    static final String EXT_AZUREUS_PLAYER_DATA = "azpd";

    public static synchronized boolean isAzpdFileExpired(File azpdFile) {
        try {
            if (!azpdFile.exists()) {
                return true;
            }
            Map params = AzpdFileAccess.readAzpdFileToMap(azpdFile);
            String expireString = (String)params.get(PARAM_EXPIRE_TIME);
            if (expireString == null) {
                return true;
            }
            long expireTime = Long.parseLong(expireString);
            long currTime = System.currentTimeMillis();
            return currTime > expireTime;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public static synchronized String readAzpdFile(File azpdFile) throws IOException {
        String data = FileUtil.readFileAsString(azpdFile, 10000000);
        return data;
    }

    public static synchronized Map readAzpdFileToMap(File azpdFile) throws IOException {
        String data = AzpdFileAccess.readAzpdFile(azpdFile);
        return JSONUtils.decodeJSON(data);
    }

    public static synchronized void writeAzpdFile(File azpdFile, String data) {
        FileUtil.writeBytesAsFile(azpdFile.getAbsolutePath(), data.getBytes());
    }

    public static synchronized Map getPlayerDataMap(DownloadManager dm) {
        try {
            File azureusPlayDataFile = AzpdFileAccess.determineAzpdFileLocation(dm);
            String data = AzpdFileAccess.readAzpdFile(azureusPlayDataFile);
            return JSONUtils.decodeJSON(data);
        }
        catch (TOTorrentException tte) {
            PlatformDCAdManager.debug("TOTorrent Error - getPlayerDataMap(): " + tte);
            tte.printStackTrace();
            return null;
        }
        catch (Throwable t) {
            PlatformDCAdManager.debug("Error - getPlayerDataMap(): " + t);
            t.printStackTrace();
            return null;
        }
    }

    public static File determineAzpdFileLocation(DownloadManager dm) throws TOTorrentException {
        try {
            File azpdDir = AzpdFileAccess.getAzpdDir();
            String fileNamePrefix = dm.getTorrent().getHashWrapper().toBase32String();
            return new File(azpdDir, fileNamePrefix + "." + EXT_AZUREUS_PLAYER_DATA);
        }
        catch (TOTorrentException te) {
            throw te;
        }
        catch (Exception e) {
            Debug.out("determineAzpdFileLocation: " + e.toString());
            return null;
        }
    }

    public static File getAzpdDir() {
        File azpdDir;
        File mediaDir = FileUtil.getUserFile("media");
        if (!mediaDir.exists()) {
            FileUtil.mkdirs(mediaDir);
        }
        if (!(azpdDir = new File(mediaDir, EXT_AZUREUS_PLAYER_DATA)).exists()) {
            FileUtil.mkdirs(azpdDir);
        }
        return azpdDir;
    }
}

