/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;

public class DataSourceUtils {
    public static DownloadManager getDM(Object ds) {
        try {
            if (ds instanceof DownloadManager) {
                return (DownloadManager)ds;
            }
            if (ds instanceof VuzeActivitiesEntry) {
                String assetHash;
                VuzeActivitiesEntry entry = (VuzeActivitiesEntry)ds;
                DownloadManager dm = entry.getDownloadManger();
                if (dm == null && (assetHash = entry.getAssetHash()) != null) {
                    GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                    dm = gm.getDownloadManager(new HashWrapper(Base32.decode(assetHash)));
                    entry.setDownloadManager(dm);
                }
                return dm;
            }
            if (ds instanceof TOTorrent) {
                GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                return gm.getDownloadManager((TOTorrent)ds);
            }
            if (ds instanceof ISelectedContent) {
                return DataSourceUtils.getDM(((ISelectedContent)ds).getDM());
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    public static TOTorrent getTorrent(Object ds) {
        TOTorrent torrent;
        if (ds instanceof TOTorrent) {
            return (TOTorrent)ds;
        }
        if (ds instanceof DownloadManager && (torrent = ((DownloadManager)ds).getTorrent()) != null) {
            return torrent;
        }
        if (ds instanceof VuzeActivitiesEntry) {
            DownloadManager dm;
            torrent = ((VuzeActivitiesEntry)ds).getTorrent();
            if (torrent == null && (dm = DataSourceUtils.getDM(ds)) != null) {
                torrent = dm.getTorrent();
            }
            return torrent;
        }
        if (ds instanceof ISelectedContent) {
            return DataSourceUtils.getTorrent(((ISelectedContent)ds).getDM());
        }
        return null;
    }

    public static boolean isPlatformContent(Object ds) {
        TOTorrent torrent = DataSourceUtils.getTorrent(ds);
        if (torrent != null) {
            return PlatformTorrentUtils.isContent(torrent, true);
        }
        return ds instanceof VuzeActivitiesEntry && ((VuzeActivitiesEntry)ds).isPlatformContent();
    }

    public static String getHash(Object ds) {
        try {
            if (ds instanceof DownloadManager) {
                return ((DownloadManager)ds).getTorrent().getHashWrapper().toBase32String();
            }
            if (ds instanceof TOTorrent) {
                return ((TOTorrent)ds).getHashWrapper().toBase32String();
            }
            if (ds instanceof VuzeActivitiesEntry) {
                VuzeActivitiesEntry entry = (VuzeActivitiesEntry)ds;
                return entry.getAssetHash();
            }
            if (ds instanceof ISelectedContent) {
                return ((ISelectedContent)ds).getHash();
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    public static DownloadUrlInfo getDownloadInfo(Object ds) {
        if (ds instanceof ISelectedContent) {
            return ((ISelectedContent)ds).getDownloadInfo();
        }
        return null;
    }
}

