/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import java.io.InputStream;
import java.net.URL;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class ImageDownloader {
    public static void loadImage(String url, final ImageDownloaderListener l) {
        try {
            ResourceDownloader rd = ResourceDownloaderFactoryImpl.getSingleton().create(new URL(url));
            rd.addListener(new ResourceDownloaderAdapter(){

                public boolean completed(ResourceDownloader downloader, InputStream is) {
                    try {
                        if (is != null && is.available() > 0) {
                            byte[] newImageBytes = new byte[is.available()];
                            is.read(newImageBytes);
                            if (l != null) {
                                l.imageDownloaded(newImageBytes);
                            }
                        }
                        return true;
                    }
                    catch (Exception e) {
                        Debug.out(e);
                        return false;
                    }
                }
            });
            rd.asyncDownload();
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public static interface ImageDownloaderListener {
        public void imageDownloaded(byte[] var1);
    }
}

