/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.content.AzureusPlatformContentDirectory;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.peer.cache.CacheDiscovery;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.DownloadUtils;
import com.aelitis.azureus.util.ExternalStimulusHandler;
import com.aelitis.azureus.util.NavigationHelper;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeAddedListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class InitialisationFunctions {
    private static final String EXTENSION_PREFIX = "azid";

    public static void earlyInitialisation(AzureusCore core) {
        DownloadUtils.initialise(core);
        DownloadManagerEnhancer dme = DownloadManagerEnhancer.initialise(core);
        InitialisationFunctions.registerTrackerURLExtensions(core);
        AzureusPlatformContentDirectory.register();
        CacheDiscovery.initialise(dme);
        MetaSearchManagerFactory.preInitialise();
        SubscriptionManagerFactory.preInitialise();
        NavigationHelper.initialise();
    }

    public static void lateInitialisation(AzureusCore core) {
        ExternalStimulusHandler.initialise(core);
        core.getPluginManager().getDefaultPluginInterface().getUtilities().createDelayedTask(new Runnable(){

            public void run() {
                MetaSearchManagerFactory.getSingleton();
                SubscriptionManagerFactory.getSingleton();
            }
        }).queue();
    }

    protected static void registerTrackerURLExtensions(AzureusCore core) {
        PluginInterface pi = core.getPluginManager().getDefaultPluginInterface();
        org.gudy.azureus2.plugins.download.DownloadManager dm = pi.getDownloadManager();
        dm.addDownloadWillBeAddedListener(new DownloadWillBeAddedListener(){

            public void initialised(Download download) {
                InitialisationFunctions.register(download);
            }
        });
        dm.addListener(new DownloadManagerListener(){

            public void downloadAdded(Download download) {
                InitialisationFunctions.register(download);
            }

            public void downloadRemoved(Download download) {
            }
        });
    }

    protected static void register(final Download download) {
        DownloadManagerStateAttributeListener dmsal = new DownloadManagerStateAttributeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void attributeEventOccurred(DownloadManager dm, String attribute_name, int event_type) {
                try {
                    Torrent t = download.getTorrent();
                    if (t == null) {
                        return;
                    }
                    if (!PlatformTorrentUtils.isContent(t, true)) {
                        return;
                    }
                    DownloadUtils.addTrackerExtension(download, InitialisationFunctions.EXTENSION_PREFIX, ConstantsV3.AZID);
                    download.setFlag(32L, true);
                }
                finally {
                    dm.getDownloadState().removeListener(this, "trackerclientextensions", 2);
                }
            }
        };
        PluginCoreUtils.unwrap(download).getDownloadState().addListener(dmsal, "trackerclientextensions", 2);
    }
}

