/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.udp.uc;

import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketRequestDecoder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public abstract class PRUDPPacketRequest
extends PRUDPPacket {
    public static final int PR_HEADER_SIZE = 16;
    private static AEMonitor class_mon = new AEMonitor("PRUDPPacketRequest:class");
    private static Map packet_decoders = new HashMap();
    protected long connection_id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDecoders(Map _decoders) {
        try {
            class_mon.enter();
            HashMap new_decoders = new HashMap(packet_decoders);
            for (Integer action : _decoders.keySet()) {
                if (!packet_decoders.containsKey(action)) continue;
                Debug.out("Duplicate codec! " + action);
            }
            new_decoders.putAll(_decoders);
            packet_decoders = new_decoders;
        }
        finally {
            class_mon.exit();
        }
    }

    public PRUDPPacketRequest(int _action, long _con_id) {
        super(_action);
        this.connection_id = _con_id;
    }

    protected PRUDPPacketRequest(int _action, long _con_id, int _trans_id) {
        super(_action, _trans_id);
        this.connection_id = _con_id;
    }

    public long getConnectionId() {
        return this.connection_id;
    }

    public void serialise(DataOutputStream os) throws IOException {
        os.writeLong(this.connection_id);
        os.writeInt(this.getAction());
        os.writeInt(this.getTransactionId());
    }

    public static PRUDPPacketRequest deserialiseRequest(PRUDPPacketHandler handler, DataInputStream is) throws IOException {
        long connection_id = is.readLong();
        int action = is.readInt();
        int transaction_id = is.readInt();
        PRUDPPacketRequestDecoder decoder = (PRUDPPacketRequestDecoder)packet_decoders.get(new Integer(action));
        if (decoder == null) {
            throw new IOException("No decoder registered for action '" + action + "'");
        }
        return decoder.decode(handler, is, connection_id, action, transaction_id);
    }

    public String getString() {
        return super.getString() + ":request[con=" + this.connection_id + ",trans=" + this.getTransactionId() + "]";
    }
}

