/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl;

import com.aelitis.azureus.core.util.HTTPUtils;
import com.aelitis.azureus.core.util.Java15Utils;
import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPAdapter;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPListener;
import com.aelitis.net.upnp.UPnPLogListener;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.impl.SSDPIGD;
import com.aelitis.net.upnp.impl.SSDPIGDFactory;
import com.aelitis.net.upnp.impl.SSDPIGDListener;
import com.aelitis.net.upnp.impl.device.UPnPDeviceImpl;
import com.aelitis.net.upnp.impl.device.UPnPRootDeviceImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;

public class UPnPImpl
extends ResourceDownloaderAdapter
implements UPnP,
SSDPIGDListener {
    public static final String NL = "\r\n";
    private static UPnPImpl singleton;
    private static AEMonitor class_mon;
    private UPnPAdapter adapter;
    private SSDPIGD ssdp;
    private Map root_locations = new HashMap();
    private List log_listeners = new ArrayList();
    private List log_history = new ArrayList();
    private List log_alert_history = new ArrayList();
    private List rd_listeners = new ArrayList();
    private AEMonitor rd_listeners_mon = new AEMonitor("UPnP:L");
    private int http_calls_ok = 0;
    private int direct_calls_ok = 0;
    private int trace_index = 0;
    private ThreadPool device_dispatcher = new ThreadPool("UPnPDispatcher", 1, true);
    private Set device_dispatcher_pending = new HashSet();
    protected AEMonitor this_mon = new AEMonitor("UPnP");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UPnP getSingleton(UPnPAdapter adapter, String[] selected_interfaces) throws UPnPException {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new UPnPImpl(adapter, selected_interfaces);
            }
            UPnPImpl uPnPImpl = singleton;
            return uPnPImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected UPnPImpl(UPnPAdapter _adapter, String[] _selected_interfaces) throws UPnPException {
        this.adapter = _adapter;
        this.ssdp = SSDPIGDFactory.create(this, _selected_interfaces);
        this.ssdp.addListener(this);
        this.ssdp.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rootDiscovered(final NetworkInterface network_interface, final InetAddress local_address, final String usn, final URL location) {
        try {
            this.rd_listeners_mon.enter();
            if (this.device_dispatcher_pending.contains(usn)) {
                return;
            }
            if (this.device_dispatcher_pending.size() > 512) {
                Debug.out("Device dispatcher queue is full - dropping discovery of " + usn + "/" + location);
            }
            this.device_dispatcher_pending.add(usn);
        }
        finally {
            this.rd_listeners_mon.exit();
        }
        this.device_dispatcher.run(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                ArrayList listeners;
                UPnPRootDeviceImpl old_root_device;
                try {
                    UPnPImpl.this.rd_listeners_mon.enter();
                    old_root_device = (UPnPRootDeviceImpl)UPnPImpl.this.root_locations.get(usn);
                    UPnPImpl.this.device_dispatcher_pending.remove(usn);
                }
                finally {
                    UPnPImpl.this.rd_listeners_mon.exit();
                }
                if (old_root_device != null) {
                    if (!old_root_device.getNetworkInterface().getName().equals(network_interface.getName())) {
                        return;
                    }
                    if (old_root_device.getLocation().equals(location)) {
                        return;
                    }
                }
                if (old_root_device != null) {
                    try {
                        UPnPImpl.this.rd_listeners_mon.enter();
                        UPnPImpl.this.root_locations.remove(usn);
                    }
                    finally {
                        UPnPImpl.this.rd_listeners_mon.exit();
                    }
                    old_root_device.destroy(true);
                }
                try {
                    UPnPImpl.this.rd_listeners_mon.enter();
                    listeners = new ArrayList(UPnPImpl.this.rd_listeners);
                }
                finally {
                    UPnPImpl.this.rd_listeners_mon.exit();
                }
                for (int i = 0; i < listeners.size(); ++i) {
                    try {
                        if (((UPnPListener)listeners.get(i)).deviceDiscovered(usn, location)) continue;
                        return;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                UPnPImpl.this.log("UPnP: root discovered: usn=" + usn + ", location=" + location + ", ni=" + network_interface.getName() + ",local=" + local_address.toString());
                try {
                    UPnPRootDeviceImpl new_root_device = new UPnPRootDeviceImpl(UPnPImpl.this, network_interface, local_address, usn, location);
                    try {
                        UPnPImpl.this.rd_listeners_mon.enter();
                        UPnPImpl.this.root_locations.put(usn, new_root_device);
                        listeners = new ArrayList(UPnPImpl.this.rd_listeners);
                    }
                    finally {
                        UPnPImpl.this.rd_listeners_mon.exit();
                    }
                    for (int i = 0; i < listeners.size(); ++i) {
                        try {
                            ((UPnPListener)listeners.get(i)).rootDeviceFound(new_root_device);
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                catch (UPnPException e) {
                    String message = e.getMessage();
                    String msg = message == null ? Debug.getNestedExceptionMessageAndStack(e) : message;
                    UPnPImpl.this.adapter.log(msg);
                }
            }
        });
    }

    public void rootAlive(String usn, URL location) {
        UPnPRootDeviceImpl root_device = (UPnPRootDeviceImpl)this.root_locations.get(usn);
        if (root_device == null) {
            this.ssdp.searchNow();
        }
    }

    public void rootLost(InetAddress local_address, final String usn) {
        this.device_dispatcher.run(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                UPnPRootDeviceImpl root_device = null;
                try {
                    UPnPImpl.this.rd_listeners_mon.enter();
                    root_device = (UPnPRootDeviceImpl)UPnPImpl.this.root_locations.remove(usn);
                }
                finally {
                    UPnPImpl.this.rd_listeners_mon.exit();
                }
                if (root_device == null) {
                    return;
                }
                UPnPImpl.this.log("UPnP: root lost: usn=" + usn + ", location=" + root_device.getLocation() + ", ni=" + root_device.getNetworkInterface().getName() + ",local=" + root_device.getLocalAddress().toString());
                root_device.destroy(false);
            }
        });
    }

    public void interfaceChanged(NetworkInterface network_interface) {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ArrayList roots;
        this.log("UPnP: reset");
        try {
            this.rd_listeners_mon.enter();
            roots = new ArrayList(this.root_locations.values());
            this.root_locations.clear();
        }
        finally {
            this.rd_listeners_mon.exit();
        }
        for (int i = 0; i < roots.size(); ++i) {
            ((UPnPRootDeviceImpl)roots.get(i)).destroy(true);
        }
        this.ssdp.searchNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleXMLParserDocument parseXML(InputStream _is) throws SimpleXMLParserDocumentException, IOException {
        ByteArrayOutputStream baos = null;
        try {
            int len;
            baos = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[8192];
            while ((len = _is.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
        }
        finally {
            baos.close();
        }
        byte[] bytes_in = baos.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes_in);
        try {
            String line;
            StringBuffer data = new StringBuffer(1024);
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)is, "UTF-8"));
            HashSet<Character> ignore_map = null;
            while ((line = lnr.readLine()) != null) {
                for (int i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (c < ' ' && c != '\r' && c != '\t') {
                        Character cha;
                        data.append(' ');
                        if (ignore_map == null) {
                            ignore_map = new HashSet<Character>();
                        }
                        if (ignore_map.contains(cha = new Character(c))) continue;
                        ignore_map.add(cha);
                        this.adapter.trace("    ignoring character(s) " + c + " in xml response");
                        continue;
                    }
                    data.append(c);
                }
                data.append("\n");
            }
            String data_str = data.toString();
            this.adapter.trace("UPnP:Response:" + data_str);
            return this.adapter.parseXML(data_str);
        }
        catch (Throwable e) {
            try {
                FileOutputStream trace = new FileOutputStream(this.getTraceFile());
                trace.write(bytes_in);
                trace.close();
            }
            catch (Throwable f) {
                this.adapter.log(f);
            }
            if (e instanceof SimpleXMLParserDocumentException) {
                throw (SimpleXMLParserDocumentException)e;
            }
            throw new SimpleXMLParserDocumentException(e);
        }
    }

    public SimpleXMLParserDocument downloadXML(UPnPRootDeviceImpl root, URL url) throws UPnPException {
        return this.downloadXMLSupport(null, url);
    }

    public SimpleXMLParserDocument downloadXML(UPnPDeviceImpl device, URL url) throws UPnPException {
        try {
            if (device != null) {
                device.restoreRelativeBaseURL();
            }
            return this.downloadXMLSupport(device.getFriendlyName(), url);
        }
        catch (UPnPException e) {
            if (device != null) {
                device.clearRelativeBaseURL();
                return this.downloadXMLSupport(device.getFriendlyName(), url);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleXMLParserDocument downloadXMLSupport(String friendly_name, URL url) throws UPnPException {
        try {
            SimpleXMLParserDocument simpleXMLParserDocument;
            TorrentUtils.setTLSDescription("UPnP Device" + (friendly_name == null ? "" : ": " + friendly_name));
            ResourceDownloaderFactory rdf = this.adapter.getResourceDownloaderFactory();
            ResourceDownloader rd = rdf.getRetryDownloader(rdf.create(url, true), 3);
            rd.addListener(this);
            InputStream data = rd.download();
            try {
                simpleXMLParserDocument = this.parseXML(data);
            }
            catch (Throwable throwable) {
                try {
                    data.close();
                    throw throwable;
                }
                catch (Throwable e) {
                    this.adapter.log(Debug.getNestedExceptionMessageAndStack(e));
                    if (e instanceof UPnPException) {
                        throw (UPnPException)e;
                    }
                    throw new UPnPException("Root device location '" + url + "' - data read failed", e);
                }
            }
            data.close();
            return simpleXMLParserDocument;
        }
        finally {
            TorrentUtils.setTLSDescription(null);
        }
    }

    protected boolean forceDirect() {
        String http_proxy = System.getProperty("http.proxyHost");
        String socks_proxy = System.getProperty("socksProxyHost");
        boolean force_direct = http_proxy != null && http_proxy.trim().length() > 0 || socks_proxy != null && socks_proxy.trim().length() > 0;
        return force_direct;
    }

    public SimpleXMLParserDocument performSOAPRequest(UPnPService service, String soap_action, String request2) throws SimpleXMLParserDocumentException, UPnPException, IOException {
        SimpleXMLParserDocument res;
        block4: {
            if (service.getDirectInvocations() || this.forceDirect()) {
                res = this.performSOAPRequest(service, soap_action, request2, false);
            } else {
                try {
                    res = this.performSOAPRequest(service, soap_action, request2, true);
                    ++this.http_calls_ok;
                }
                catch (IOException e) {
                    res = this.performSOAPRequest(service, soap_action, request2, false);
                    ++this.direct_calls_ok;
                    if (this.direct_calls_ok != 1) break block4;
                    this.log("Invocation via http connection failed (" + e.getMessage() + ") but socket connection succeeded");
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleXMLParserDocument performSOAPRequest(UPnPService service, String soap_action, String request2, boolean use_http_connection) throws SimpleXMLParserDocumentException, UPnPException, IOException {
        URL control = service.getControlURL();
        this.adapter.trace("UPnP:Request: -> " + control + "," + request2);
        if (use_http_connection) {
            try {
                TorrentUtils.setTLSDescription("UPnP Device: " + service.getDevice().getFriendlyName());
                HttpURLConnection con = (HttpURLConnection)Java15Utils.openConnectionForceNoProxy(control);
                con.setRequestProperty("SOAPAction", "\"" + soap_action + "\"");
                con.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
                con.setRequestProperty("User-Agent", "Azureus (UPnP/1.0)");
                con.setRequestMethod("POST");
                con.setDoInput(true);
                con.setDoOutput(true);
                OutputStream os = con.getOutputStream();
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
                pw.println(request2);
                pw.flush();
                con.connect();
                if (con.getResponseCode() == 405 || con.getResponseCode() == 500) {
                    con = (HttpURLConnection)control.openConnection();
                    con.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
                    con.setRequestMethod("M-POST");
                    con.setRequestProperty("MAN", "\"http://schemas.xmlsoap.org/soap/envelope/\"; ns=01");
                    con.setRequestProperty("01-SOAPACTION", "\"" + soap_action + "\"");
                    con.setDoInput(true);
                    con.setDoOutput(true);
                    os = con.getOutputStream();
                    pw = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
                    pw.println(request2);
                    pw.flush();
                    con.connect();
                    SimpleXMLParserDocument simpleXMLParserDocument = this.parseXML(con.getInputStream());
                    return simpleXMLParserDocument;
                }
                SimpleXMLParserDocument simpleXMLParserDocument = this.parseXML(con.getInputStream());
                return simpleXMLParserDocument;
            }
            finally {
                TorrentUtils.setTLSDescription(null);
            }
        }
        Socket socket = new Socket(control.getHost(), control.getPort());
        try {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF8"));
            String url_target = control.toString();
            int p1 = url_target.indexOf("://") + 3;
            p1 = url_target.indexOf("/", p1);
            url_target = url_target.substring(p1);
            pw.print("POST " + url_target + " HTTP/1.1" + NL);
            pw.print("Content-Type: text/xml; charset=\"utf-8\"\r\n");
            pw.print("SOAPAction: \"" + soap_action + "\"" + NL);
            pw.print("User-Agent: Azureus (UPnP/1.0)\r\n");
            pw.print("Host: " + control.getHost() + NL);
            pw.print("Content-Length: " + request2.getBytes("UTF8").length + NL);
            pw.print("Connection: Keep-Alive\r\n");
            pw.print("Pragma: no-cache\r\n\r\n");
            pw.print(request2);
            pw.flush();
            InputStream is = HTTPUtils.decodeChunkedEncoding(socket.getInputStream());
            SimpleXMLParserDocument simpleXMLParserDocument = this.parseXML(is);
            return simpleXMLParserDocument;
        }
        finally {
            try {
                socket.close();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getTraceFile() {
        try {
            this.this_mon.enter();
            ++this.trace_index;
            if (this.trace_index == 6) {
                this.trace_index = 1;
            }
            File file = new File(this.adapter.getTraceDir(), "upnp_trace" + this.trace_index + ".log");
            return file;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public UPnPAdapter getAdapter() {
        return this.adapter;
    }

    public void reportActivity(ResourceDownloader downloader, String activity) {
        this.log(activity);
    }

    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.log(e);
    }

    public void log(Throwable e) {
        this.log(e.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String str) {
        ArrayList old_listeners;
        try {
            this.this_mon.enter();
            old_listeners = new ArrayList(this.log_listeners);
            this.log_history.add(str);
            if (this.log_history.size() > 32) {
                this.log_history.remove(0);
            }
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < old_listeners.size(); ++i) {
            ((UPnPLogListener)old_listeners.get(i)).log(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAlert(String str, boolean error, int type) {
        ArrayList old_listeners;
        try {
            this.this_mon.enter();
            old_listeners = new ArrayList(this.log_listeners);
            this.log_alert_history.add(new Object[]{str, new Boolean(error), new Integer(type)});
            if (this.log_alert_history.size() > 32) {
                this.log_alert_history.remove(0);
            }
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < old_listeners.size(); ++i) {
            ((UPnPLogListener)old_listeners.get(i)).logAlert(str, error, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogListener(UPnPLogListener l) {
        int i;
        ArrayList old_alerts;
        ArrayList old_logs;
        try {
            this.this_mon.enter();
            old_logs = new ArrayList(this.log_history);
            old_alerts = new ArrayList(this.log_alert_history);
            this.log_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
        for (i = 0; i < old_logs.size(); ++i) {
            l.log((String)old_logs.get(i));
        }
        for (i = 0; i < old_alerts.size(); ++i) {
            Object[] entry = (Object[])old_alerts.get(i);
            l.logAlert((String)entry[0], (Boolean)entry[1], (Integer)entry[2]);
        }
    }

    public void removeLogListener(UPnPLogListener l) {
        this.log_listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRootDeviceListener(UPnPListener l) {
        ArrayList old_locations;
        try {
            this.this_mon.enter();
            old_locations = new ArrayList(this.root_locations.values());
            this.rd_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < old_locations.size(); ++i) {
            UPnPRootDevice device = (UPnPRootDevice)old_locations.get(i);
            try {
                if (!l.deviceDiscovered(device.getUSN(), device.getLocation())) continue;
                l.rootDeviceFound(device);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRootDeviceListener(UPnPListener l) {
        try {
            this.this_mon.enter();
            this.rd_listeners.remove(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    static {
        class_mon = new AEMonitor("UPnP:class");
    }
}

