/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config.impl;

import com.aelitis.azureus.core.AzureusCore;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.global.GlobalManager;

public final class TransferSpeedValidator {
    public static final String AUTO_UPLOAD_ENABLED_CONFIGKEY = "Auto Upload Speed Enabled";
    public static final String AUTO_UPLOAD_SEEDING_ENABLED_CONFIGKEY = "Auto Upload Speed Seeding Enabled";
    public static final String UPLOAD_CONFIGKEY = "Max Upload Speed KBs";
    public static final String UPLOAD_SEEDING_CONFIGKEY = "Max Upload Speed Seeding KBs";
    public static final String DOWNLOAD_CONFIGKEY = "Max Download Speed KBs";
    public static final String UPLOAD_SEEDING_ENABLED_CONFIGKEY = "enable.seedingonly.upload.rate";
    public static final String[] CONFIG_PARAMS = new String[]{"Auto Upload Speed Enabled", "Auto Upload Speed Seeding Enabled", "Max Upload Speed KBs", "Max Upload Speed Seeding KBs", "Max Download Speed KBs", "enable.seedingonly.upload.rate"};
    private final String configKey;
    private final Number configValue;
    private static boolean seeding_upload_enabled;

    public TransferSpeedValidator(String configKey, Number value) {
        this.configKey = configKey;
        this.configValue = value;
    }

    private static Object validate(String configKey, Number value) {
        int newValue = value.intValue();
        if (newValue < 0) {
            newValue = 0;
        }
        if (configKey == UPLOAD_CONFIGKEY) {
            int downValue = COConfigurationManager.getIntParameter(DOWNLOAD_CONFIGKEY);
            if (newValue != 0 && newValue < 5 && (downValue == 0 || downValue > newValue * 2)) {
                newValue = (downValue + 1) / 2;
            }
        } else if (configKey == DOWNLOAD_CONFIGKEY) {
            int upValue = COConfigurationManager.getIntParameter(UPLOAD_CONFIGKEY);
            if (upValue != 0 && upValue < 5) {
                if (newValue > upValue * 2) {
                    newValue = upValue * 2;
                } else if (newValue == 0) {
                    newValue = upValue * 2;
                }
            }
        } else if (configKey != UPLOAD_SEEDING_CONFIGKEY) {
            throw new IllegalArgumentException("Invalid Configuation Key; use key for max upload and max download");
        }
        return new Integer(newValue);
    }

    public Object getValue() {
        return TransferSpeedValidator.validate(this.configKey, this.configValue);
    }

    public static String getActiveUploadParameter(GlobalManager gm) {
        if (seeding_upload_enabled && gm.isSeedingOnly()) {
            return UPLOAD_SEEDING_CONFIGKEY;
        }
        return UPLOAD_CONFIGKEY;
    }

    public static String getDownloadParameter() {
        return DOWNLOAD_CONFIGKEY;
    }

    public static int getGlobalDownloadRateLimitBytesPerSecond() {
        return COConfigurationManager.getIntParameter(TransferSpeedValidator.getDownloadParameter()) * 1024;
    }

    public static void setGlobalDownloadRateLimitBytesPerSecond(int bytes_per_second) {
        COConfigurationManager.setParameter(TransferSpeedValidator.getDownloadParameter(), (bytes_per_second + 1023) / 1024);
    }

    public static boolean isAutoUploadAvailable(AzureusCore core) {
        return core.getSpeedManager().isAvailable();
    }

    public static String getActiveAutoUploadParameter(GlobalManager gm) {
        if (COConfigurationManager.getBooleanParameter(AUTO_UPLOAD_ENABLED_CONFIGKEY)) {
            return AUTO_UPLOAD_ENABLED_CONFIGKEY;
        }
        if (gm.isSeedingOnly()) {
            return AUTO_UPLOAD_SEEDING_ENABLED_CONFIGKEY;
        }
        return AUTO_UPLOAD_ENABLED_CONFIGKEY;
    }

    public static boolean isAutoSpeedActive(GlobalManager gm) {
        return COConfigurationManager.getBooleanParameter(TransferSpeedValidator.getActiveAutoUploadParameter(gm));
    }

    static {
        COConfigurationManager.addAndFireParameterListener(UPLOAD_SEEDING_ENABLED_CONFIGKEY, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                seeding_upload_enabled = COConfigurationManager.getBooleanParameter(parameterName);
            }
        });
    }
}

