/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessControllerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerFactory;
import com.aelitis.azureus.core.util.CaseSensitiveFileMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerAllocationScheduler;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoSetImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerPieceImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckScheduler;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.disk.impl.access.DMAccessFactory;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.access.DMReader;
import org.gudy.azureus2.core3.disk.impl.access.DMWriter;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMap;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapper;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFactory;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFile;
import org.gudy.azureus2.core3.disk.impl.resume.RDResumeHandler;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.impl.DownloadManagerMoveHandler;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class DiskManagerImpl
extends LogRelation
implements DiskManagerHelper {
    private static final int DM_FREE_PIECELIST_TIMEOUT = 120000;
    private static final LogIDs LOGID = LogIDs.DISK;
    private static DiskAccessController disk_access_controller;
    private static DiskManagerRecheckScheduler recheck_scheduler;
    private static DiskManagerAllocationScheduler allocation_scheduler;
    private static ThreadPool start_pool;
    private static AEMonitor cache_read_mon;
    private boolean used = false;
    private boolean started = false;
    private AESemaphore started_sem = new AESemaphore("DiskManager::started");
    private boolean starting;
    private boolean stopping;
    private int state_set_via_method;
    protected String errorMessage = "";
    private int pieceLength;
    private int lastPieceLength;
    private int nbPieces;
    private long totalLength;
    private int percentDone;
    private long allocated;
    private long remaining;
    private TOTorrent torrent;
    private DMReader reader;
    private DMChecker checker;
    private DMWriter writer;
    private RDResumeHandler resume_handler;
    private DMPieceMapper piece_mapper;
    private DiskManagerPieceImpl[] pieces;
    private DMPieceMap piece_map_use_accessor;
    private long piece_map_use_accessor_time;
    private DiskManagerFileInfoImpl[] files;
    private DiskManagerFileInfoSet fileset;
    protected DownloadManager download_manager;
    private boolean alreadyMoved = false;
    private boolean skipped_file_set_changed = true;
    private long skipped_file_set_size;
    private long skipped_but_downloaded;
    private boolean checking_enabled = true;
    private static final int LDT_STATECHANGED = 1;
    private static final int LDT_PRIOCHANGED = 2;
    private static final int LDT_PIECE_DONE_CHANGED = 3;
    private static final int LDT_ACCESS_MODE_CHANGED = 4;
    protected static ListenerManager listeners_aggregator;
    private ListenerManager listeners = ListenerManager.createManager("DiskM:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object listener, int type, Object value) {
            listeners_aggregator.dispatch(listener, type, value);
        }
    });
    private AEMonitor start_stop_mon = new AEMonitor("DiskManager:startStop");
    private AEMonitor file_piece_mon = new AEMonitor("DiskManager:filePiece");

    public static DiskAccessController getDefaultDiskAccessController() {
        return disk_access_controller;
    }

    public DiskManagerImpl(TOTorrent _torrent, DownloadManager _dmanager) {
        this.torrent = _torrent;
        this.download_manager = _dmanager;
        this.pieces = new DiskManagerPieceImpl[0];
        this.setState(1);
        this.percentDone = 0;
        if (this.torrent == null) {
            this.errorMessage = "Torrent not available";
            this.setState(10);
            return;
        }
        LocaleUtilDecoder locale_decoder = null;
        try {
            locale_decoder = LocaleTorrentUtil.getTorrentEncoding(this.torrent);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            this.errorMessage = TorrentUtils.exceptionToText(e);
            this.setState(10);
            return;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.errorMessage = "Initialisation failed - " + Debug.getNestedExceptionMessage(e);
            this.setState(10);
            return;
        }
        this.piece_mapper = DMPieceMapperFactory.create(this.torrent);
        try {
            this.piece_mapper.construct(locale_decoder, this.download_manager.getAbsoluteSaveLocation().getName());
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.errorMessage = "Failed to build piece map - " + Debug.getNestedExceptionMessage(e);
            this.setState(10);
            return;
        }
        this.remaining = this.totalLength = this.piece_mapper.getTotalLength();
        this.nbPieces = this.torrent.getNumberOfPieces();
        this.pieceLength = (int)this.torrent.getPieceLength();
        this.lastPieceLength = this.piece_mapper.getLastPieceLength();
        this.pieces = new DiskManagerPieceImpl[this.nbPieces];
        for (int i = 0; i < this.nbPieces; ++i) {
            this.pieces[i] = new DiskManagerPieceImpl(this, i, i == this.nbPieces - 1 ? this.lastPieceLength : this.pieceLength);
        }
        this.reader = DMAccessFactory.createReader(this);
        this.checker = DMAccessFactory.createChecker(this);
        this.writer = DMAccessFactory.createWriter(this);
        this.resume_handler = new RDResumeHandler(this, this.checker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.start_stop_mon.enter();
            if (this.used) {
                Debug.out("DiskManager reuse not supported!!!!");
            }
            this.used = true;
            if (this.getState() == 10) {
                Debug.out("starting a faulty disk manager");
                return;
            }
            this.started = true;
            this.starting = true;
            start_pool.run(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    boolean stop_required;
                    try {
                        try {
                            DiskManagerImpl.this.start_stop_mon.enter();
                            if (DiskManagerImpl.this.stopping) {
                                throw new Exception("Stopped during startup");
                            }
                        }
                        finally {
                            DiskManagerImpl.this.start_stop_mon.exit();
                        }
                        DiskManagerImpl.this.startSupport();
                    }
                    catch (Throwable e) {
                        DiskManagerImpl.this.errorMessage = Debug.getNestedExceptionMessage(e) + " (start)";
                        Debug.printStackTrace(e);
                        DiskManagerImpl.this.setState(10);
                    }
                    finally {
                        DiskManagerImpl.this.started_sem.release();
                    }
                    try {
                        DiskManagerImpl.this.start_stop_mon.enter();
                        stop_required = DiskManagerImpl.this.getState() == 10 || DiskManagerImpl.this.stopping;
                        DiskManagerImpl.this.starting = false;
                    }
                    finally {
                        DiskManagerImpl.this.start_stop_mon.exit();
                    }
                    if (stop_required) {
                        DiskManagerImpl.this.stop(false);
                    }
                }
            });
        }
        finally {
            this.start_stop_mon.exit();
        }
    }

    private void startSupport() {
        boolean files_exist = false;
        if (this.download_manager.isPersistent()) {
            File[] move_to_dirs = DownloadManagerMoveHandler.getRelatedDirs(this.download_manager);
            for (int i = 0; i < move_to_dirs.length; ++i) {
                String move_to_dir = move_to_dirs[i].getAbsolutePath();
                if (!this.filesExist(move_to_dir)) continue;
                files_exist = true;
                this.alreadyMoved = true;
                this.download_manager.setTorrentSaveDir(move_to_dir);
                break;
            }
        }
        this.reader.start();
        this.checker.start();
        this.writer.start();
        if (!this.alreadyMoved && !this.download_manager.isDataAlreadyAllocated()) {
            SaveLocationChange transfer;
            if (!files_exist) {
                files_exist = this.filesExist();
            }
            if (!files_exist && (transfer = DownloadManagerMoveHandler.onInitialisation(this.download_manager)) != null) {
                if (transfer.download_location != null || transfer.download_name != null) {
                    File dl_location = transfer.download_location;
                    if (dl_location == null) {
                        dl_location = this.download_manager.getAbsoluteSaveLocation().getParentFile();
                    }
                    if (transfer.download_name == null) {
                        this.download_manager.setTorrentSaveDir(dl_location.getAbsolutePath());
                    } else {
                        this.download_manager.setTorrentSaveDir(dl_location.getAbsolutePath(), transfer.download_name);
                    }
                }
                if (transfer.torrent_location != null || transfer.torrent_name != null) {
                    try {
                        this.download_manager.setTorrentFile(transfer.torrent_location, transfer.torrent_name);
                    }
                    catch (DownloadManagerException e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        int newFiles = this.allocateFiles();
        if (this.getState() == 10) {
            return;
        }
        if (this.getState() == 10) {
            return;
        }
        this.setState(3);
        this.resume_handler.start();
        if (this.checking_enabled) {
            if (newFiles == 0) {
                this.resume_handler.checkAllPieces(false);
                if (this.getRemainingExcludingDND() == 0L) {
                    this.checkFreePieceList(true);
                }
            } else if (newFiles != this.files.length) {
                this.resume_handler.checkAllPieces(true);
            }
        }
        if (this.getState() == 10) {
            return;
        }
        this.setState(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean closing) {
        try {
            this.start_stop_mon.enter();
            if (!this.started) {
                return;
            }
            if (this.starting) {
                this.stopping = true;
                this.checker.stop();
                this.writer.stop();
                this.reader.stop();
                this.resume_handler.stop(closing);
                this.saveState(false);
                return;
            }
            this.started = false;
            this.stopping = false;
        }
        finally {
            this.start_stop_mon.exit();
        }
        this.started_sem.reserve();
        this.checker.stop();
        this.writer.stop();
        this.reader.stop();
        this.resume_handler.stop(closing);
        if (this.files != null) {
            for (int i = 0; i < this.files.length; ++i) {
                try {
                    if (this.files[i] == null) continue;
                    this.files[i].getCacheFile().close();
                    continue;
                }
                catch (Throwable e) {
                    this.setFailed("File close fails: " + Debug.getNestedExceptionMessage(e));
                }
            }
        }
        if (this.getState() == 4) {
            try {
                this.saveResumeData(false);
            }
            catch (Exception e) {
                this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
            }
        }
        this.saveState();
        this.listeners.clear();
    }

    public boolean filesExist() {
        return this.filesExist(this.download_manager.getAbsoluteSaveLocation().getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected boolean filesExist(String root_dir) {
        if (!this.torrent.isSimpleTorrent()) {
            root_dir = root_dir + File.separator + this.download_manager.getAbsoluteSaveLocation().getName();
        }
        if (!root_dir.endsWith(File.separator)) {
            root_dir = root_dir + File.separator;
        }
        DMPieceMapperFile[] pm_files = this.piece_mapper.getFiles();
        String[] storage_types = this.getStorageTypes();
        for (int i = 0; i < pm_files.length; ++i) {
            DMPieceMapperFile pm_info = pm_files[i];
            File relative_file = pm_info.getDataFile();
            long target_length = pm_info.getLength();
            DiskManagerFileInfoImpl file_info = pm_info.getFileInfo();
            boolean close_it = false;
            try {
                if (file_info == null) {
                    boolean linear = storage_types[i].equals("L");
                    file_info = new DiskManagerFileInfoImpl(this, new File(root_dir + relative_file.toString()), i, pm_info.getTorrentFile(), linear);
                    close_it = true;
                }
                try {
                    CacheFile cache_file = file_info.getCacheFile();
                    File data_file = file_info.getFile(true);
                    if (!cache_file.exists()) {
                        File parent;
                        File current = data_file;
                        while (!current.exists() && (parent = current.getParentFile()) != null) {
                            if (parent.exists()) {
                                this.errorMessage = parent.isDirectory() ? current.toString() + " not found." : parent.toString() + " is not a directory.";
                                boolean bl = false;
                                return bl;
                            }
                            current = parent;
                        }
                        this.errorMessage = data_file.toString() + " not found.";
                        boolean bl = false;
                        return bl;
                    }
                    long existing_length = file_info.getCacheFile().getLength();
                    if (existing_length <= target_length) continue;
                    if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                        file_info.setAccessMode(2);
                        file_info.getCacheFile().setLength(target_length);
                        Debug.out("Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath() + ", truncating");
                        continue;
                    }
                    this.errorMessage = "Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (close_it) {
                        file_info.getCacheFile().close();
                    }
                }
            }
            catch (Throwable e) {
                this.errorMessage = Debug.getNestedExceptionMessage(e) + " (filesExist:" + relative_file.toString() + ")";
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allocateFiles() {
        HashSet<String> file_set = new HashSet<String>();
        DMPieceMapperFile[] pm_files = this.piece_mapper.getFiles();
        DiskManagerFileInfoImpl[] allocated_files = new DiskManagerFileInfoImpl[pm_files.length];
        try {
            allocation_scheduler.register(this);
            this.setState(2);
            this.allocated = 0L;
            int numNewFiles = 0;
            String root_dir = this.download_manager.getAbsoluteSaveLocation().getParent();
            if (!this.torrent.isSimpleTorrent()) {
                root_dir = root_dir + File.separator + this.download_manager.getAbsoluteSaveLocation().getName();
            }
            root_dir = root_dir + File.separator;
            String[] storage_types = this.getStorageTypes();
            for (int i = 0; i < pm_files.length; ++i) {
                block77: {
                    int i2;
                    boolean mustExistOrAllocate;
                    int bHighPriority;
                    DiskManagerFileInfoImpl fileInfo2;
                    DMPieceMapperFile pm_info = pm_files[i];
                    long target_length = pm_info.getLength();
                    File relative_data_file = pm_info.getDataFile();
                    try {
                        boolean linear = storage_types[i].equals("L");
                        allocated_files[i] = fileInfo2 = new DiskManagerFileInfoImpl(this, new File(root_dir + relative_data_file.toString()), i, pm_info.getTorrentFile(), linear);
                        pm_info.setFileInfo(fileInfo2);
                    }
                    catch (CacheFileManagerException e) {
                        this.errorMessage = Debug.getNestedExceptionMessage(e) + " (allocateFiles:" + relative_data_file.toString() + ")";
                        this.setState(10);
                        int n = -1;
                        allocation_scheduler.unregister(this);
                        if (this.files == null) {
                            for (int i3 = 0; i3 < allocated_files.length; ++i3) {
                                if (allocated_files[i3] == null) continue;
                                try {
                                    allocated_files[i3].getCacheFile().close();
                                    continue;
                                }
                                catch (Throwable e2) {
                                    // empty catch block
                                }
                            }
                        }
                        return n;
                    }
                    CacheFile cache_file = fileInfo2.getCacheFile();
                    File data_file = fileInfo2.getFile(true);
                    String data_file_name = data_file.getName();
                    String file_key = data_file.getAbsolutePath();
                    if (Constants.isWindows) {
                        file_key = file_key.toLowerCase();
                    }
                    if (file_set.contains(file_key)) {
                        this.errorMessage = "File occurs more than once in download: " + data_file.toString();
                        this.setState(10);
                        int n = -1;
                        return n;
                    }
                    file_set.add(file_key);
                    int separator = data_file_name.lastIndexOf(".");
                    if (separator == -1) {
                        separator = 0;
                    }
                    fileInfo2.setExtension(data_file_name.substring(separator));
                    String extensions = COConfigurationManager.getStringParameter("priorityExtensions", "");
                    if (!extensions.equals("")) {
                        boolean bIgnoreCase = COConfigurationManager.getBooleanParameter("priorityExtensionsIgnoreCase");
                        StringTokenizer st = new StringTokenizer(extensions, ";");
                        while (st.hasMoreTokens()) {
                            String extension = st.nextToken();
                            if (!(extension = extension.trim()).startsWith(".")) {
                                extension = "." + extension;
                            }
                            if ((bHighPriority = bIgnoreCase ? fileInfo2.getExtension().equalsIgnoreCase(extension) : fileInfo2.getExtension().equals(extension)) == 0) continue;
                            fileInfo2.setPriority(true);
                        }
                    }
                    fileInfo2.setDownloaded(0L);
                    boolean bl = mustExistOrAllocate = cache_file.getStorageType() != 2 || RDResumeHandler.fileMustExist(this.download_manager, fileInfo2);
                    if (!mustExistOrAllocate && cache_file.exists()) {
                        data_file.delete();
                    }
                    if (cache_file.exists()) {
                        block76: {
                            try {
                                long existing_length = fileInfo2.getCacheFile().getLength();
                                if (existing_length <= target_length) break block76;
                                if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                                    fileInfo2.setAccessMode(2);
                                    cache_file.setLength(target_length);
                                    Debug.out("Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath() + ", truncating");
                                    break block76;
                                }
                                this.errorMessage = "Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath();
                                this.setState(10);
                                bHighPriority = -1;
                                return bHighPriority;
                            }
                            catch (CacheFileManagerException e) {
                                this.errorMessage = Debug.getNestedExceptionMessage(e) + " (allocateFiles existing:" + data_file.getAbsolutePath() + ")";
                                this.setState(10);
                                int extension = -1;
                                allocation_scheduler.unregister(this);
                                if (this.files == null) {
                                    for (i2 = 0; i2 < allocated_files.length; ++i2) {
                                        if (allocated_files[i2] == null) continue;
                                        try {
                                            allocated_files[i2].getCacheFile().close();
                                            continue;
                                        }
                                        catch (Throwable e3) {
                                            // empty catch block
                                        }
                                    }
                                }
                                return extension;
                            }
                        }
                        fileInfo2.setAccessMode(1);
                        this.allocated += target_length;
                        continue;
                    }
                    if (!mustExistOrAllocate) continue;
                    if (this.download_manager.isDataAlreadyAllocated()) {
                        this.errorMessage = "Data file missing: " + data_file.getAbsolutePath();
                        this.setState(10);
                        int e = -1;
                        return e;
                    }
                    while (this.started && !allocation_scheduler.getPermission(this)) {
                    }
                    if (!this.started) {
                        int e = -1;
                        return e;
                    }
                    try {
                        fileInfo2.setAccessMode(2);
                        if (COConfigurationManager.getBooleanParameter("Enable incremental file creation")) {
                            fileInfo2.getCacheFile().setLength(0L);
                            break block77;
                        }
                        if (target_length > 0L && COConfigurationManager.getBooleanParameter("XFS Allocation")) {
                            fileInfo2.getCacheFile().setLength(target_length);
                            String[] cmd = new String[]{"/usr/sbin/xfs_io", "-c", "resvsp 0 " + target_length, data_file.getAbsolutePath()};
                            ByteArrayOutputStream os = new ByteArrayOutputStream();
                            byte[] buffer = new byte[1024];
                            try {
                                Process p = Runtime.getRuntime().exec(cmd);
                                int count = p.getErrorStream().read(buffer);
                                while (count > 0) {
                                    os.write(buffer, 0, count);
                                    count = p.getErrorStream().read(buffer);
                                }
                                os.close();
                                p.waitFor();
                            }
                            catch (IOException e) {
                                String message = MessageText.getString("xfs.allocation.xfs_io.not.found", new String[]{e.getMessage()});
                                Logger.log(new LogAlert((Object)this, false, 3, message));
                            }
                            if (os.size() > 0) {
                                String message = os.toString().trim();
                                if (message.endsWith("is not on an XFS filesystem")) {
                                    Logger.log(new LogEvent(this, LogIDs.DISK, "XFS file allocation impossible because \"" + data_file.getAbsolutePath() + "\" is not on an XFS filesystem. Original error reported by xfs_io : \"" + message + "\""));
                                } else {
                                    throw new IOException(message);
                                }
                            }
                            this.allocated += target_length;
                            break block77;
                        }
                        if (COConfigurationManager.getBooleanParameter("Zero New")) {
                            boolean successfulAlloc = false;
                            try {
                                successfulAlloc = this.writer.zeroFile(fileInfo2, target_length);
                                break block77;
                            }
                            catch (Exception e) {
                                this.errorMessage = Debug.getNestedExceptionMessage(e) + " (allocateFiles new:" + data_file.toString() + ")";
                                throw e;
                            }
                            finally {
                                if (!successfulAlloc) {
                                    try {
                                        fileInfo2.getCacheFile().close();
                                        fileInfo2.getCacheFile().delete();
                                    }
                                    catch (Throwable e) {}
                                    this.setState(10);
                                }
                            }
                        }
                        fileInfo2.getCacheFile().setLength(target_length);
                        this.allocated += target_length;
                    }
                    catch (Exception e) {
                        this.errorMessage = Debug.getNestedExceptionMessage(e) + " (allocateFiles new:" + data_file.toString() + ")";
                        this.setState(10);
                        int n = -1;
                        allocation_scheduler.unregister(this);
                        if (this.files == null) {
                            for (i2 = 0; i2 < allocated_files.length; ++i2) {
                                if (allocated_files[i2] == null) continue;
                                try {
                                    allocated_files[i2].getCacheFile().close();
                                    continue;
                                }
                                catch (Throwable e4) {
                                    // empty catch block
                                }
                            }
                        }
                        return n;
                    }
                }
                ++numNewFiles;
            }
            this.files = allocated_files;
            this.fileset = new DiskManagerFileInfoSetImpl(this.files, this);
            this.loadFilePriorities();
            this.download_manager.setDataAlreadyAllocated(true);
            int n = numNewFiles;
            return n;
        }
        finally {
            allocation_scheduler.unregister(this);
            if (this.files == null) {
                for (int i = 0; i < allocated_files.length; ++i) {
                    if (allocated_files[i] == null) continue;
                    try {
                        allocated_files[i].getCacheFile().close();
                        continue;
                    }
                    catch (Throwable e) {}
                }
            }
        }
    }

    public DiskAccessController getDiskAccessController() {
        return disk_access_controller;
    }

    public void enqueueReadRequest(DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        this.reader.readBlock(request2, listener);
    }

    public boolean hasOutstandingReadRequestForPiece(int piece_number) {
        return this.reader.hasOutstandingReadRequestForPiece(piece_number);
    }

    public int getNbPieces() {
        return this.nbPieces;
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    public void setPercentDone(int num) {
        this.percentDone = num;
    }

    public long getRemaining() {
        return this.remaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRemainingExcludingDND() {
        long rem;
        DiskManagerFileInfoImpl[] current_files;
        if (this.skipped_file_set_changed && (current_files = this.files) != null) {
            this.skipped_file_set_changed = false;
            try {
                this.file_piece_mon.enter();
                this.skipped_file_set_size = 0L;
                this.skipped_but_downloaded = 0L;
                for (int i = 0; i < current_files.length; ++i) {
                    DiskManagerFileInfoImpl file = current_files[i];
                    if (!file.isSkipped()) continue;
                    this.skipped_file_set_size += file.getLength();
                    this.skipped_but_downloaded += file.getDownloaded();
                }
            }
            finally {
                this.file_piece_mon.exit();
            }
        }
        if ((rem = this.remaining - (this.skipped_file_set_size - this.skipped_but_downloaded)) < 0L) {
            rem = 0L;
        }
        return rem;
    }

    public long getAllocated() {
        return this.allocated;
    }

    public void setAllocated(long num) {
        this.allocated = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPieceDone(DiskManagerPieceImpl dmPiece, boolean done) {
        int piece_number = dmPiece.getPieceNumber();
        int piece_length = dmPiece.getLength();
        try {
            this.file_piece_mon.enter();
            if (dmPiece.isDone() != done) {
                dmPiece.setDoneSupport(done);
                this.remaining = done ? (this.remaining -= (long)piece_length) : (this.remaining += (long)piece_length);
                DMPieceList piece_list = this.getPieceList(piece_number);
                for (int i = 0; i < piece_list.size(); ++i) {
                    long file_done;
                    DMPieceMapEntry piece_map_entry = piece_list.get(i);
                    DiskManagerFileInfoImpl this_file = piece_map_entry.getFile();
                    long file_length = this_file.getLength();
                    long file_done_before = file_done = this_file.getDownloaded();
                    file_done = done ? (file_done += (long)piece_map_entry.getLength()) : (file_done -= (long)piece_map_entry.getLength());
                    if (file_done < 0L) {
                        Debug.out("piece map entry length negative");
                        file_done = 0L;
                    } else if (file_done > file_length) {
                        Debug.out("piece map entry length too large");
                        file_done = file_length;
                    }
                    if (this_file.isSkipped()) {
                        this.skipped_but_downloaded += file_done - file_done_before;
                    }
                    this_file.setDownloaded(file_done);
                    if (file_done != file_length || this_file.getAccessMode() != 2) continue;
                    try {
                        this_file.setAccessMode(1);
                        continue;
                    }
                    catch (Exception e) {
                        this.setFailed("Disk access error - " + Debug.getNestedExceptionMessage(e));
                        Debug.printStackTrace(e);
                    }
                }
                if (this.getState() == 4) {
                    this.listeners.dispatch(3, dmPiece);
                }
            }
        }
        finally {
            this.file_piece_mon.exit();
        }
    }

    public void accessModeChanged(DiskManagerFileInfoImpl file, int old_mode, int new_mode) {
        this.listeners.dispatch(4, new Object[]{file, new Integer(old_mode), new Integer(new_mode)});
    }

    public DiskManagerPiece[] getPieces() {
        return this.pieces;
    }

    public DiskManagerPiece getPiece(int PieceNumber) {
        return this.pieces[PieceNumber];
    }

    public int getPieceLength() {
        return this.pieceLength;
    }

    public int getPieceLength(int piece_number) {
        if (piece_number == this.nbPieces - 1) {
            return this.lastPieceLength;
        }
        return this.pieceLength;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public int getLastPieceLength() {
        return this.lastPieceLength;
    }

    public int getState() {
        return this.state_set_via_method;
    }

    protected void setState(int _state) {
        if (this.state_set_via_method == 10) {
            if (_state != 10) {
                Debug.out("DiskManager: attempt to move from faulty state to " + _state);
            }
            return;
        }
        if (this.state_set_via_method != _state) {
            int[] params = new int[]{this.state_set_via_method, _state};
            this.state_set_via_method = _state;
            this.listeners.dispatch(1, params);
        }
    }

    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    public DiskManagerFileInfoSet getFileSet() {
        return this.fileset;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setFailed(final String reason) {
        new AEThread("DiskManager:setFailed"){

            public void runSupport() {
                DiskManagerImpl.this.errorMessage = reason;
                Logger.log(new LogAlert((Object)DiskManagerImpl.this, false, 3, DiskManagerImpl.this.errorMessage));
                DiskManagerImpl.this.setState(10);
                DiskManagerImpl.this.stop(false);
            }
        }.start();
    }

    public void setFailed(final DiskManagerFileInfo file, final String reason) {
        new AEThread("DiskManager:setFailed"){

            public void runSupport() {
                DiskManagerImpl.this.errorMessage = reason;
                Logger.log(new LogAlert((Object)DiskManagerImpl.this, false, 3, DiskManagerImpl.this.errorMessage));
                DiskManagerImpl.this.setState(10);
                DiskManagerImpl.this.stop(false);
                RDResumeHandler.recheckFile(DiskManagerImpl.this.download_manager, file);
            }
        }.start();
    }

    public int getCacheMode() {
        return 1;
    }

    public DMPieceList getPieceList(int piece_number) {
        DMPieceMap map = this.piece_map_use_accessor;
        if (map == null) {
            this.piece_map_use_accessor = map = this.piece_mapper.getPieceMap();
        }
        this.piece_map_use_accessor_time = SystemTime.getCurrentTime();
        return map.getPieceList(piece_number);
    }

    public void checkFreePieceList(boolean force_discard) {
        if (this.piece_map_use_accessor == null) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        if (!force_discard) {
            if (now < this.piece_map_use_accessor_time) {
                this.piece_map_use_accessor_time = now;
                return;
            }
            if (now - this.piece_map_use_accessor_time < 120000L) {
                return;
            }
        }
        this.piece_map_use_accessor = null;
    }

    public byte[] getPieceHash(int piece_number) throws TOTorrentException {
        return this.torrent.getPieces()[piece_number];
    }

    public DiskManagerReadRequest createReadRequest(int pieceNumber, int offset, int length) {
        return this.reader.createReadRequest(pieceNumber, offset, length);
    }

    public DiskManagerCheckRequest createCheckRequest(int pieceNumber, Object user_data) {
        return this.checker.createCheckRequest(pieceNumber, user_data);
    }

    public boolean hasOutstandingCheckRequestForPiece(int piece_number) {
        return this.checker.hasOutstandingCheckRequestForPiece(piece_number);
    }

    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        this.checker.enqueueCompleteRecheckRequest(request2, listener);
    }

    public void enqueueCheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        this.checker.enqueueCheckRequest(request2, listener);
    }

    public int getCompleteRecheckStatus() {
        return this.checker.getCompleteRecheckStatus();
    }

    public void setPieceCheckingEnabled(boolean enabled) {
        this.checking_enabled = enabled;
        this.checker.setCheckingEnabled(enabled);
    }

    public DirectByteBuffer readBlock(int pieceNumber, int offset, int length) {
        return this.reader.readBlock(pieceNumber, offset, length);
    }

    public DiskManagerWriteRequest createWriteRequest(int pieceNumber, int offset, DirectByteBuffer data, Object user_data) {
        return this.writer.createWriteRequest(pieceNumber, offset, data, user_data);
    }

    public void enqueueWriteRequest(DiskManagerWriteRequest request2, DiskManagerWriteRequestListener listener) {
        this.writer.writeBlock(request2, listener);
    }

    public boolean hasOutstandingWriteRequestForPiece(int piece_number) {
        return this.writer.hasOutstandingWriteRequestForPiece(piece_number);
    }

    public boolean checkBlockConsistencyForWrite(String originator, int pieceNumber, int offset, DirectByteBuffer data) {
        if (pieceNumber < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " pieceNumber=" + pieceNumber + " < 0"));
            }
            return false;
        }
        if (pieceNumber >= this.nbPieces) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " pieceNumber=" + pieceNumber + " >= this.nbPieces=" + this.nbPieces));
            }
            return false;
        }
        int length = this.pieceLength;
        if (pieceNumber == this.nbPieces - 1) {
            length = this.lastPieceLength;
        }
        if (offset < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " offset=" + offset + " < 0"));
            }
            return false;
        }
        if (offset > length) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " offset=" + offset + " > length=" + length));
            }
            return false;
        }
        int size = data.remaining((byte)8);
        if (size <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " size=" + size + " <= 0"));
            }
            return false;
        }
        if (offset + size > length) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " offset=" + offset + " + size=" + size + " > length=" + length));
            }
            return false;
        }
        return true;
    }

    public boolean checkBlockConsistencyForRead(String originator, int pieceNumber, int offset, int length) {
        return DiskManagerUtil.checkBlockConsistencyForRead(this, originator, pieceNumber, offset, length);
    }

    public boolean checkBlockConsistencyForHint(String originator, int pieceNumber, int offset, int length) {
        return DiskManagerUtil.checkBlockConsistencyForHint(this, originator, pieceNumber, offset, length);
    }

    public void saveResumeData(boolean interim_save) throws Exception {
        this.resume_handler.saveResumeData(interim_save);
    }

    public void downloadEnded() {
        this.moveDownloadFilesWhenEndedOrRemoved(false, true);
    }

    public void downloadRemoved() {
        this.moveDownloadFilesWhenEndedOrRemoved(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveDownloadFilesWhenEndedOrRemoved(boolean removing, boolean torrent_file_exists) {
        try {
            SaveLocationChange move_details;
            boolean ending;
            this.start_stop_mon.enter();
            boolean bl = ending = !removing;
            if (ending) {
                if (this.alreadyMoved) {
                    boolean bl2 = false;
                    return bl2;
                }
                this.alreadyMoved = true;
            }
            if ((move_details = removing ? DownloadManagerMoveHandler.onRemoval(this.download_manager) : DownloadManagerMoveHandler.onCompletion(this.download_manager)) != null) {
                this.moveFiles(move_details, true);
            }
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.start_stop_mon.exit();
            if (!removing) {
                try {
                    this.saveResumeData(false);
                }
                catch (Throwable e) {
                    this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
                }
            }
        }
    }

    public void moveDataFiles(File new_parent_dir, String new_name) {
        SaveLocationChange loc_change = new SaveLocationChange();
        loc_change.download_location = new_parent_dir;
        loc_change.download_name = new_name;
        this.moveFiles(loc_change, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveFiles(SaveLocationChange loc_change, boolean change_to_read_only) {
        boolean move_files = false;
        if (loc_change.hasDownloadChange()) {
            move_files = !this.isFileDestinationIsItself(loc_change);
        }
        try {
            this.start_stop_mon.enter();
            boolean files_moved = true;
            if (move_files) {
                files_moved = this.moveDataFiles0(loc_change, change_to_read_only);
            }
            if (loc_change.hasTorrentChange() && files_moved) {
                this.moveTorrentFile(loc_change);
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        finally {
            this.start_stop_mon.exit();
        }
    }

    private void logMoveFileError(String destination_path, String message) {
        Logger.log(new LogEvent((Object)this, LOGID, 3, message));
        Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{destination_path, message});
    }

    private boolean isFileDestinationIsItself(SaveLocationChange loc_change) {
        File old_location = this.download_manager.getAbsoluteSaveLocation();
        File new_location = loc_change.normaliseDownloadLocation(old_location);
        try {
            old_location = old_location.getCanonicalFile();
            new_location = new_location.getCanonicalFile();
            if (old_location.equals(new_location)) {
                return true;
            }
            if (!this.download_manager.getTorrent().isSimpleTorrent() && FileUtil.isAncestorOf(new_location, old_location)) {
                String msg = "Target is sub-directory of files";
                this.logMoveFileError(new_location.toString(), msg);
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return false;
    }

    private boolean moveDataFiles0(SaveLocationChange loc_change, boolean change_to_read_only) throws Exception {
        int i;
        File move_to_dir_name = loc_change.download_location;
        if (move_to_dir_name == null) {
            move_to_dir_name = this.download_manager.getAbsoluteSaveLocation().getParentFile();
        }
        String move_to_dir = move_to_dir_name.toString();
        String new_name = loc_change.download_name;
        if (this.files == null) {
            return false;
        }
        if (this.isFileDestinationIsItself(loc_change)) {
            return false;
        }
        boolean simple_torrent = this.download_manager.getTorrent().isSimpleTorrent();
        File save_location = this.download_manager.getAbsoluteSaveLocation();
        String move_from_dir = save_location.getParentFile().getCanonicalFile().getPath();
        File[] new_files = new File[this.files.length];
        File[] old_files = new File[this.files.length];
        boolean[] link_only = new boolean[this.files.length];
        for (i = 0; i < this.files.length; ++i) {
            File new_file;
            File old_file = this.files[i].getFile(false);
            File linked_file = FMFileManagerFactory.getSingleton().getFileLink(this.torrent, old_file);
            if (!linked_file.equals(old_file)) {
                if (simple_torrent) {
                    if (linked_file.getParentFile().getCanonicalPath().equals(save_location.getParentFile().getCanonicalPath())) {
                        old_file = linked_file;
                    } else {
                        link_only[i] = true;
                    }
                } else if (linked_file.getCanonicalPath().startsWith(save_location.getCanonicalPath())) {
                    old_file = linked_file;
                } else {
                    link_only[i] = true;
                }
            }
            old_files[i] = old_file;
            String old_parent_path = old_file.getCanonicalFile().getParent();
            if (!old_parent_path.startsWith(move_from_dir)) {
                this.logMoveFileError(move_to_dir, "Could not determine relative path for file - " + old_parent_path);
                throw new IOException("relative path assertion failed: move_from_dir=\"" + move_from_dir + "\", old_parent_path=\"" + old_parent_path + "\"");
            }
            String sub_path = old_parent_path.substring(move_from_dir.length());
            if (sub_path.startsWith(File.separator)) {
                sub_path = sub_path.substring(1);
            }
            if (new_name == null) {
                new_file = new File(new File(move_to_dir, sub_path), old_file.getName());
            } else if (simple_torrent) {
                new_file = new File(new File(move_to_dir, sub_path), new_name);
            } else {
                String new_path;
                int pos = sub_path.indexOf(File.separator);
                if (pos == -1) {
                    new_path = new_name;
                } else {
                    String sub_sub_path = sub_path.substring(pos);
                    String expected_old_name = sub_path.substring(0, pos);
                    new_path = new_name + sub_sub_path;
                    boolean assert_expected_old_name = expected_old_name.equals(save_location.getName());
                    if (!assert_expected_old_name) {
                        Debug.out("Assertion check for renaming file in multi-name torrent " + (assert_expected_old_name ? "passed" : "failed") + "\n" + "  Old parent path: " + old_parent_path + "\n" + "  Subpath: " + sub_path + "\n" + "  Sub-subpath: " + sub_sub_path + "\n" + "  Expected old name: " + expected_old_name + "\n" + "  Torrent pre-move name: " + save_location.getName() + "\n" + "  New torrent name: " + new_name + "\n" + "  Old file: " + old_file + "\n" + "  Linked file: " + linked_file + "\n" + "\n" + "  Move-to-dir: " + move_to_dir + "\n" + "  New path: " + new_path + "\n" + "  Old file [name]: " + old_file.getName() + "\n");
                    }
                }
                new_file = new File(new File(move_to_dir, new_path), old_file.getName());
            }
            new_files[i] = new_file;
            if (link_only[i]) continue;
            if (new_file.exists()) {
                String msg = "" + linked_file.getName() + " already exists in MoveTo destination dir";
                Logger.log(new LogEvent((Object)this, LOGID, 3, msg));
                Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefileexists"), new String[]{old_file.getName()});
                Debug.out(msg);
                return false;
            }
            FileUtil.mkdirs(new_file.getParentFile());
        }
        for (i = 0; i < this.files.length; ++i) {
            File new_file = new_files[i];
            try {
                this.files[i].moveFile(new_file, link_only[i]);
                if (!change_to_read_only) continue;
                this.files[i].setAccessMode(1);
                continue;
            }
            catch (CacheFileManagerException e) {
                String msg = "Failed to move " + old_files[i].toString() + " to destination dir";
                Logger.log(new LogEvent((Object)this, LOGID, 3, msg));
                Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{old_files[i].toString(), Debug.getNestedExceptionMessage(e)});
                for (int j = 0; j < i; ++j) {
                    try {
                        this.files[j].moveFile(old_files[j], link_only[j]);
                        continue;
                    }
                    catch (CacheFileManagerException f) {
                        Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilerecoveryfails"), new String[]{old_files[j].toString(), Debug.getNestedExceptionMessage(f)});
                    }
                }
                return false;
            }
        }
        if (save_location.isDirectory()) {
            TorrentUtils.recursiveEmptyDirDelete(save_location, false);
        }
        if (new_name == null) {
            this.download_manager.setTorrentSaveDir(move_to_dir);
        } else {
            this.download_manager.setTorrentSaveDir(move_to_dir, new_name);
        }
        return true;
    }

    private void moveTorrentFile(SaveLocationChange loc_change) {
        if (!loc_change.hasTorrentChange()) {
            return;
        }
        File old_torrent_file = new File(this.download_manager.getTorrentFileName());
        File new_torrent_file = loc_change.normaliseTorrentLocation(old_torrent_file);
        if (!old_torrent_file.exists()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 1, "Torrent file '" + old_torrent_file.getPath() + "' has been deleted, move operation ignored"));
            }
            return;
        }
        try {
            this.download_manager.setTorrentFile(loc_change.torrent_location, loc_change.torrent_name);
        }
        catch (DownloadManagerException e) {
            String msg = "Failed to move " + old_torrent_file.toString() + " to " + new_torrent_file.toString();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, msg));
            }
            Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{old_torrent_file.toString(), new_torrent_file.toString()});
            Debug.out(msg);
        }
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public void addListener(DiskManagerListener l) {
        this.listeners.addListener(l);
        int[] params = new int[]{this.getState(), this.getState()};
        this.listeners.dispatch(l, 1, params);
    }

    public void removeListener(DiskManagerListener l) {
        this.listeners.removeListener(l);
    }

    public static void deleteDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file) {
        block8: {
            if (torrent == null || torrent_save_file == null) {
                return;
            }
            try {
                if (torrent.isSimpleTorrent()) {
                    File target = new File(torrent_save_dir, torrent_save_file);
                    target = FMFileManagerFactory.getSingleton().getFileLink(torrent, target.getCanonicalFile());
                    FileUtil.deleteWithRecycle(target);
                    break block8;
                }
                PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
                if (Constants.isOSX && torrent_save_file.length() > 0 && COConfigurationManager.getBooleanParameter("Move Deleted Data To Recycle Bin") && mgr.hasCapability(PlatformManagerCapabilities.RecoverableFileDelete)) {
                    try {
                        String dir = torrent_save_dir + File.separatorChar + torrent_save_file + File.separatorChar;
                        if (DiskManagerImpl.countFiles(new File(dir)) == DiskManagerImpl.countDataFiles(torrent, torrent_save_dir, torrent_save_file)) {
                            mgr.performRecoverableFileDelete(dir);
                            break block8;
                        }
                        DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file);
                    }
                    catch (PlatformManagerException ex) {
                        DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file);
                    }
                    break block8;
                }
                DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private static int countFiles(File f) {
        if (f.isFile()) {
            return 1;
        }
        int res = 0;
        File[] files = f.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                res += DiskManagerImpl.countFiles(files[i]);
            }
        }
        return res;
    }

    private static int countDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file) {
        try {
            int res = 0;
            LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
            TOTorrentFile[] files = torrent.getFiles();
            for (int i = 0; i < files.length; ++i) {
                byte[][] path_comps = files[i].getPathComponents();
                String path_str = torrent_save_dir + File.separator + torrent_save_file + File.separator;
                for (int j = 0; j < path_comps.length; ++j) {
                    String comp2 = locale_decoder.decodeString(path_comps[j]);
                    comp2 = FileUtil.convertOSSpecificChars(comp2, j != path_comps.length - 1);
                    path_str = path_str + (j == 0 ? "" : File.separator) + comp2;
                }
                File file = new File(path_str).getCanonicalFile();
                File linked_file = FMFileManagerFactory.getSingleton().getFileLink(torrent, file);
                boolean skip = false;
                if (linked_file != file && !linked_file.getCanonicalPath().startsWith(new File(torrent_save_dir).getCanonicalPath())) {
                    skip = true;
                }
                if (skip || !file.exists() || file.isDirectory()) continue;
                ++res;
            }
            return res;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return -1;
        }
    }

    private static void deleteDataFileContents(TOTorrent torrent, String torrent_save_dir, String torrent_save_file) throws TOTorrentException, UnsupportedEncodingException, LocaleUtilEncodingException {
        LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
        TOTorrentFile[] files = torrent.getFiles();
        String root_path = torrent_save_dir + File.separator + torrent_save_file + File.separator;
        boolean delete_if_not_in_dir = COConfigurationManager.getBooleanParameter("File.delete.include_files_outside_save_dir");
        for (int i = 0; i < files.length; ++i) {
            boolean delete;
            byte[][] path_comps = files[i].getPathComponents();
            String path_str = root_path;
            for (int j = 0; j < path_comps.length; ++j) {
                try {
                    String comp2 = locale_decoder.decodeString(path_comps[j]);
                    comp2 = FileUtil.convertOSSpecificChars(comp2, j != path_comps.length - 1);
                    path_str = path_str + (j == 0 ? "" : File.separator) + comp2;
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    Debug.out("file - unsupported encoding!!!!");
                }
            }
            File file = new File(path_str);
            File linked_file = FMFileManagerFactory.getSingleton().getFileLink(torrent, file);
            if (linked_file == file) {
                delete = true;
            } else {
                try {
                    if (delete_if_not_in_dir || linked_file.getCanonicalPath().startsWith(new File(root_path).getCanonicalPath())) {
                        file = linked_file;
                        delete = true;
                    } else {
                        delete = false;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    delete = false;
                }
            }
            if (!delete || !file.exists() || file.isDirectory()) continue;
            try {
                FileUtil.deleteWithRecycle(file);
                continue;
            }
            catch (Exception e) {
                Debug.out(e.toString());
            }
        }
        TorrentUtils.recursiveEmptyDirDelete(new File(torrent_save_dir, torrent_save_file));
    }

    public void skippedFileSetChanged(DiskManagerFileInfo file) {
        this.skipped_file_set_changed = true;
        this.listeners.dispatch(2, file);
    }

    public void priorityChanged(DiskManagerFileInfo file) {
        this.listeners.dispatch(2, file);
    }

    private void loadFilePriorities() {
        DiskManagerImpl.loadFilePriorities(this.download_manager, this.fileset);
    }

    private static void loadFilePriorities(DownloadManager download_manager, DiskManagerFileInfoSet fileSet) {
        try {
            DiskManagerFileInfo[] files = fileSet.getFiles();
            if (files == null) {
                return;
            }
            List file_priorities = (List)download_manager.getData("file_priorities");
            if (file_priorities == null) {
                return;
            }
            boolean[] toSkip = new boolean[files.length];
            boolean[] prio = new boolean[files.length];
            for (int i = 0; i < files.length; ++i) {
                DiskManagerFileInfo file = files[i];
                if (file == null) {
                    return;
                }
                int priority = ((Long)file_priorities.get(i)).intValue();
                if (priority == 0) {
                    toSkip[i] = true;
                    continue;
                }
                if (priority != 1) continue;
                prio[i] = true;
            }
            fileSet.setPriority(prio, true);
            fileSet.setSkipped(toSkip, true);
        }
        catch (Throwable t) {
            Debug.printStackTrace(t);
        }
    }

    protected void storeFilePriorities() {
        DiskManagerImpl.storeFilePriorities(this.download_manager, this.files);
    }

    protected static void storeFilePriorities(DownloadManager download_manager, DiskManagerFileInfo[] files) {
        if (files == null) {
            return;
        }
        ArrayList<Long> file_priorities = new ArrayList<Long>(files.length);
        for (int i = 0; i < files.length; ++i) {
            DiskManagerFileInfo file = files[i];
            if (file == null) {
                return;
            }
            boolean skipped = file.isSkipped();
            boolean priority = file.isPriority();
            int value = -1;
            if (skipped) {
                value = 0;
            } else if (priority) {
                value = 1;
            }
            file_priorities.add(i, new Long(value));
        }
        download_manager.setData("file_priorities", file_priorities);
    }

    protected static void storeFileDownloaded(DownloadManager download_manager, DiskManagerFileInfo[] files, boolean persist) {
        DownloadManagerState state = download_manager.getDownloadState();
        HashMap details = new HashMap();
        ArrayList<Long> downloaded = new ArrayList<Long>();
        details.put("downloaded", downloaded);
        for (int i = 0; i < files.length; ++i) {
            downloaded.add(new Long(files[i].getDownloaded()));
        }
        state.setMapAttribute("filedownloaded", details);
        if (persist) {
            state.save();
        }
    }

    protected static void loadFileDownloaded(DownloadManager download_manager, DiskManagerFileInfoHelper[] files) {
        DownloadManagerState state = download_manager.getDownloadState();
        Map details = state.getMapAttribute("filedownloaded");
        if (details == null) {
            return;
        }
        List downloaded = (List)details.get("downloaded");
        if (downloaded == null) {
            return;
        }
        try {
            for (int i = 0; i < files.length; ++i) {
                files[i].setDownloaded((Long)downloaded.get(i));
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void saveState() {
        this.saveState(true);
    }

    protected void saveState(boolean persist) {
        if (this.files != null) {
            DiskManagerImpl.storeFileDownloaded(this.download_manager, this.files, persist);
            this.storeFilePriorities();
        }
        this.checkFreePieceList(false);
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    public String getInternalName() {
        return this.download_manager.getInternalName();
    }

    public DownloadManagerState getDownloadState() {
        return this.download_manager.getDownloadState();
    }

    public File getSaveLocation() {
        return this.download_manager.getSaveLocation();
    }

    public String[] getStorageTypes() {
        return DiskManagerImpl.getStorageTypes(this.download_manager);
    }

    public String getStorageType(int fileIndex) {
        return DiskManagerImpl.getStorageType(this.download_manager, fileIndex);
    }

    public static String[] getStorageTypes(DownloadManager download_manager) {
        DownloadManagerState state = download_manager.getDownloadState();
        String[] types = state.getListAttribute("storetypes");
        if (types.length == 0) {
            types = new String[download_manager.getTorrent().getFiles().length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = "L";
            }
        }
        return types;
    }

    public static String getStorageType(DownloadManager download_manager, int fileIndex) {
        DownloadManagerState state = download_manager.getDownloadState();
        String type = state.getListAttribute("storetypes", fileIndex);
        return type != null ? type : "L";
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean setFileLink(DownloadManager download_manager, DiskManagerFileInfo[] info, DiskManagerFileInfo file_info, File from_file, File to_link) {
        File existing_link = FMFileManagerFactory.getSingleton().getFileLink(download_manager.getTorrent(), to_link);
        if (!existing_link.equals(to_link) && !from_file.equals(to_link)) {
            Logger.log(new LogAlert((Object)download_manager, true, 3, "Attempt to link to existing link '" + existing_link.toString() + "'"));
            return false;
        }
        File existing_file = file_info.getFile(true);
        if (to_link.equals(existing_file)) {
            return true;
        }
        for (int i = 0; i < info.length; ++i) {
            if (!to_link.equals(info[i].getFile(true))) continue;
            Logger.log(new LogAlert((Object)download_manager, true, 3, "Attempt to link to existing file '" + info[i].getFile(true) + "'"));
            return false;
        }
        if (to_link.exists()) {
            if (!existing_file.exists()) {
                download_manager.recheckFile(file_info);
            } else {
                if (!FileUtil.deleteWithRecycle(existing_file)) {
                    Logger.log(new LogAlert((Object)download_manager, true, 3, "Failed to delete '" + existing_file.toString() + "'"));
                    return false;
                }
                download_manager.recheckFile(file_info);
            }
        } else if (existing_file.exists() && !FileUtil.renameFile(existing_file, to_link)) {
            Logger.log(new LogAlert((Object)download_manager, true, 3, "Failed to rename '" + existing_file.toString() + "'"));
            return false;
        }
        DownloadManagerState state = download_manager.getDownloadState();
        state.setFileLink(from_file, to_link);
        state.save();
        return true;
    }

    public static DiskManagerFileInfoSet getFileInfoSkeleton(final DownloadManager download_manager, DiskManagerListener listener) {
        TOTorrent torrent = download_manager.getTorrent();
        if (torrent == null) {
            return new DiskManagerFileInfoSetImpl(new DiskManagerFileInfoImpl[0], null);
        }
        String tempRootDir = download_manager.getAbsoluteSaveLocation().getParent();
        if (tempRootDir == null) {
            tempRootDir = download_manager.getAbsoluteSaveLocation().getPath();
        }
        if (!torrent.isSimpleTorrent()) {
            tempRootDir = tempRootDir + File.separator + download_manager.getAbsoluteSaveLocation().getName();
        }
        String root_dir = tempRootDir = tempRootDir + File.separator;
        try {
            LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
            TOTorrentFile[] torrent_files = torrent.getFiles();
            DiskManagerFileInfoHelper[] res = new FileSkeleton[torrent_files.length];
            DiskManagerFileInfoSet fileSetSkeleton = new DiskManagerFileInfoSet((FileSkeleton[])res, download_manager, listener){
                final /* synthetic */ FileSkeleton[] val$res;
                final /* synthetic */ DownloadManager val$download_manager;
                final /* synthetic */ DiskManagerListener val$listener;
                {
                    this.val$res = fileSkeletonArray;
                    this.val$download_manager = downloadManager;
                    this.val$listener = diskManagerListener;
                }

                public DiskManagerFileInfo[] getFiles() {
                    return this.val$res;
                }

                public int nbFiles() {
                    return this.val$res.length;
                }

                public void setPriority(boolean[] toChange, boolean setPriority) {
                    int i;
                    if (toChange.length != this.val$res.length) {
                        throw new IllegalArgumentException("array length mismatches the number of files");
                    }
                    for (i = 0; i < this.val$res.length; ++i) {
                        if (!toChange[i]) continue;
                        this.val$res[i].priority = setPriority;
                    }
                    DiskManagerImpl.storeFilePriorities(this.val$download_manager, this.val$res);
                    for (i = 0; i < this.val$res.length; ++i) {
                        if (!toChange[i]) continue;
                        this.val$listener.filePriorityChanged(this.val$res[i]);
                    }
                }

                public void setSkipped(boolean[] toChange, boolean setSkipped) {
                    int i;
                    if (toChange.length != this.val$res.length) {
                        throw new IllegalArgumentException("array length mismatches the number of files");
                    }
                    if (!setSkipped && !Arrays.equals(toChange, this.setStorageTypes(toChange, 1))) {
                        return;
                    }
                    for (i = 0; i < this.val$res.length; ++i) {
                        if (!toChange[i]) continue;
                        this.val$res[i].skipped = setSkipped;
                    }
                    if (!setSkipped) {
                        DiskManagerUtil.doFileExistenceChecks(this, toChange, this.val$download_manager, true);
                    }
                    DiskManagerImpl.storeFilePriorities(this.val$download_manager, this.val$res);
                    for (i = 0; i < this.val$res.length; ++i) {
                        if (!toChange[i]) continue;
                        this.val$listener.filePriorityChanged(this.val$res[i]);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean[] setStorageTypes(boolean[] toChange, int newStroageType) {
                    if (toChange.length != this.val$res.length) {
                        throw new IllegalArgumentException("array length mismatches the number of files");
                    }
                    String[] types = DiskManagerImpl.getStorageTypes(this.val$download_manager);
                    boolean[] modified = new boolean[this.val$res.length];
                    boolean[] toSkip = new boolean[this.val$res.length];
                    int toSkipCount = 0;
                    DownloadManagerState dmState = this.val$download_manager.getDownloadState();
                    try {
                        int i;
                        dmState.suppressStateSave(true);
                        for (i = 0; i < this.val$res.length; ++i) {
                            int old_type;
                            if (!toChange[i]) continue;
                            final int idx = i;
                            int n = old_type = types[i].equals("L") ? 1 : 2;
                            if (newStroageType == old_type) {
                                modified[i] = true;
                                continue;
                            }
                            try {
                                File target_file = this.val$res[i].getFile(true);
                                if (target_file.exists()) {
                                    CacheFile cache_file = CacheFileManagerFactory.getSingleton().createFile(new CacheFileOwner(){

                                        public String getCacheFileOwnerName() {
                                            return val$download_manager.getInternalName();
                                        }

                                        public TOTorrentFile getCacheFileTorrentFile() {
                                            return val$res[idx].getTorrentFile();
                                        }

                                        public File getCacheFileControlFileDir() {
                                            return val$download_manager.getDownloadState().getStateFile();
                                        }

                                        public int getCacheMode() {
                                            return 1;
                                        }
                                    }, target_file, newStroageType == 1 ? 1 : 2);
                                    cache_file.close();
                                    boolean bl = toSkip[i] = newStroageType == 2 && !this.val$res[i].isSkipped();
                                    if (toSkip[i]) {
                                        ++toSkipCount;
                                    }
                                }
                                modified[i] = true;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                                Logger.log(new LogAlert((Object)this.val$download_manager, true, 3, "Failed to change storage type for '" + this.val$res[i].getFile(true) + "': " + Debug.getNestedExceptionMessage(e)));
                                RDResumeHandler.recheckFile(this.val$download_manager, this.val$res[i]);
                            }
                            types[i] = newStroageType == 1 ? "L" : "C";
                        }
                        dmState.setListAttribute("storetypes", types);
                        if (toSkipCount > 0) {
                            this.setSkipped(toSkip, true);
                        }
                        for (i = 0; i < this.val$res.length; ++i) {
                            int cleared;
                            if (!toChange[i] || (cleared = RDResumeHandler.storageTypeChanged(this.val$download_manager, this.val$res[i])) <= 0) continue;
                            this.val$res[i].downloaded -= (long)cleared * this.val$res[i].getTorrentFile().getTorrent().getPieceLength();
                            if (this.val$res[i].downloaded >= 0L) continue;
                            this.val$res[i].downloaded = 0L;
                        }
                        DiskManagerImpl.storeFileDownloaded(this.val$download_manager, this.val$res, true);
                        DiskManagerUtil.doFileExistenceChecks(this, toChange, this.val$download_manager, newStroageType == 1);
                    }
                    finally {
                        dmState.suppressStateSave(false);
                        dmState.save();
                    }
                    return modified;
                }
            };
            for (int i = 0; i < res.length; ++i) {
                TOTorrentFile torrent_file = torrent_files[i];
                int file_index = i;
                FileSkeleton info = new FileSkeleton((FileSkeleton[])res, listener, fileSetSkeleton, file_index, torrent_file, root_dir, locale_decoder){
                    private CacheFile read_cache_file;
                    private WeakReference dataFile = new WeakReference<Object>(null);
                    final /* synthetic */ FileSkeleton[] val$res;
                    final /* synthetic */ DiskManagerListener val$listener;
                    final /* synthetic */ DiskManagerFileInfoSet val$fileSetSkeleton;
                    final /* synthetic */ int val$file_index;
                    final /* synthetic */ TOTorrentFile val$torrent_file;
                    final /* synthetic */ String val$root_dir;
                    final /* synthetic */ LocaleUtilDecoder val$locale_decoder;
                    {
                        this.val$res = fileSkeletonArray;
                        this.val$listener = diskManagerListener;
                        this.val$fileSetSkeleton = diskManagerFileInfoSet;
                        this.val$file_index = n;
                        this.val$torrent_file = tOTorrentFile;
                        this.val$root_dir = string;
                        this.val$locale_decoder = localeUtilDecoder;
                    }

                    public void setPriority(boolean b) {
                        this.priority = b;
                        DiskManagerImpl.storeFilePriorities(download_manager, this.val$res);
                        this.val$listener.filePriorityChanged(this);
                    }

                    public void setSkipped(boolean _skipped) {
                        if (!_skipped && this.getStorageType() == 2 && !this.setStorageType(1)) {
                            return;
                        }
                        this.skipped = _skipped;
                        DiskManagerImpl.storeFilePriorities(download_manager, this.val$res);
                        if (!_skipped) {
                            boolean[] toCheck = new boolean[this.val$fileSetSkeleton.nbFiles()];
                            toCheck[this.val$file_index] = true;
                            DiskManagerUtil.doFileExistenceChecks(this.val$fileSetSkeleton, toCheck, download_manager, true);
                        }
                        this.val$listener.filePriorityChanged(this);
                    }

                    public int getAccessMode() {
                        return 1;
                    }

                    public long getDownloaded() {
                        return this.downloaded;
                    }

                    public void setDownloaded(long l) {
                        this.downloaded = l;
                    }

                    public String getExtension() {
                        String data_name = this.lazyGetFile().getName();
                        int separator = data_name.lastIndexOf(".");
                        if (separator == -1) {
                            separator = 0;
                        }
                        return data_name.substring(separator);
                    }

                    public int getFirstPieceNumber() {
                        return this.val$torrent_file.getFirstPieceNumber();
                    }

                    public int getLastPieceNumber() {
                        return this.val$torrent_file.getLastPieceNumber();
                    }

                    public long getLength() {
                        return this.val$torrent_file.getLength();
                    }

                    public int getIndex() {
                        return this.val$file_index;
                    }

                    public int getNbPieces() {
                        return this.val$torrent_file.getNumberOfPieces();
                    }

                    public boolean isPriority() {
                        return this.priority;
                    }

                    public boolean isSkipped() {
                        return this.skipped;
                    }

                    public DiskManager getDiskManager() {
                        return null;
                    }

                    public DownloadManager getDownloadManager() {
                        return download_manager;
                    }

                    public File getFile(boolean follow_link) {
                        File link;
                        if (follow_link && (link = this.getLink()) != null) {
                            return link;
                        }
                        return this.lazyGetFile();
                    }

                    private File lazyGetFile() {
                        File toReturn = (File)this.dataFile.get();
                        if (toReturn != null) {
                            return toReturn;
                        }
                        TOTorrent tor = download_manager.getTorrent();
                        String path_str = this.val$root_dir;
                        File simpleFile = null;
                        if (tor.isSimpleTorrent()) {
                            simpleFile = download_manager.getAbsoluteSaveLocation();
                        } else {
                            byte[][] path_comps = this.val$torrent_file.getPathComponents();
                            for (int j = 0; j < path_comps.length; ++j) {
                                String comp2;
                                try {
                                    comp2 = this.val$locale_decoder.decodeString(path_comps[j]);
                                }
                                catch (UnsupportedEncodingException e) {
                                    Debug.printStackTrace(e);
                                    comp2 = "undecodableFileName" + this.val$file_index;
                                }
                                comp2 = FileUtil.convertOSSpecificChars(comp2, j != path_comps.length - 1);
                                path_str = path_str + (j == 0 ? "" : File.separator) + comp2;
                            }
                        }
                        toReturn = simpleFile != null ? simpleFile : new File(path_str);
                        this.dataFile = new WeakReference<File>(toReturn);
                        return toReturn;
                    }

                    public TOTorrentFile getTorrentFile() {
                        return this.val$torrent_file;
                    }

                    public boolean setLink(File link_destination) {
                        if (download_manager.getTorrent().isSimpleTorrent()) {
                            try {
                                download_manager.moveDataFiles(link_destination.getParentFile(), link_destination.getName());
                                return true;
                            }
                            catch (DownloadManagerException e) {
                                return false;
                            }
                        }
                        return this.setLinkAtomic(link_destination);
                    }

                    public boolean setLinkAtomic(File link_destination) {
                        return DiskManagerImpl.setFileLink(download_manager, this.val$res, this, this.lazyGetFile(), link_destination);
                    }

                    public File getLink() {
                        return download_manager.getDownloadState().getFileLink(this.lazyGetFile());
                    }

                    public boolean setStorageType(int type) {
                        boolean[] change = new boolean[this.val$res.length];
                        change[this.val$file_index] = true;
                        return this.val$fileSetSkeleton.setStorageTypes(change, type)[this.val$file_index];
                    }

                    public int getStorageType() {
                        return DiskManagerImpl.getStorageType(download_manager, this.val$file_index).equals("L") ? 1 : 2;
                    }

                    public void flushCache() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public DirectByteBuffer read(long offset, int length) throws IOException {
                        block7: {
                            try {
                                cache_read_mon.enter();
                                if (this.read_cache_file != null) break block7;
                                try {
                                    int type = DiskManagerImpl.getStorageType(download_manager, this.val$file_index).equals("L") ? 1 : 2;
                                    this.read_cache_file = CacheFileManagerFactory.getSingleton().createFile(new CacheFileOwner(){

                                        public String getCacheFileOwnerName() {
                                            return download_manager.getInternalName();
                                        }

                                        public TOTorrentFile getCacheFileTorrentFile() {
                                            return val$torrent_file;
                                        }

                                        public File getCacheFileControlFileDir() {
                                            return download_manager.getDownloadState().getStateFile();
                                        }

                                        public int getCacheMode() {
                                            return 1;
                                        }
                                    }, this.getFile(true), type == 1 ? 1 : 2);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                    throw new IOException(e.getMessage());
                                }
                            }
                            finally {
                                cache_read_mon.exit();
                            }
                        }
                        DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)6, length);
                        try {
                            this.read_cache_file.read(buffer, offset, (short)1);
                        }
                        catch (Throwable e) {
                            buffer.returnToPool();
                            Debug.printStackTrace(e);
                            throw new IOException(e.getMessage());
                        }
                        return buffer;
                    }

                    public void close() {
                        if (this.read_cache_file != null) {
                            try {
                                this.read_cache_file.close();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            this.read_cache_file = null;
                        }
                    }

                    public void addListener(DiskManagerFileInfoListener listener) {
                        if (this.getDownloaded() == this.getLength()) {
                            try {
                                listener.dataWritten(0L, this.getLength());
                                listener.dataChecked(0L, this.getLength());
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }

                    public void removeListener(DiskManagerFileInfoListener listener) {
                    }
                };
                res[i] = info;
            }
            DiskManagerImpl.loadFilePriorities(download_manager, fileSetSkeleton);
            DiskManagerImpl.loadFileDownloaded(download_manager, res);
            return fileSetSkeleton;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return new DiskManagerFileInfoSetImpl(new DiskManagerFileInfoImpl[0], null);
        }
    }

    public static void setFileLinks(DownloadManager download_manager, CaseSensitiveFileMap links) {
        try {
            CacheFileManagerFactory.getSingleton().setFileLinks(download_manager.getTorrent(), links);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public String getRelationText() {
        return "TorrentDM: '" + this.download_manager.getDisplayName() + "'";
    }

    public Object[] getQueryableInterfaces() {
        return new Object[]{this.download_manager, this.torrent};
    }

    public DiskManagerRecheckScheduler getRecheckScheduler() {
        return recheck_scheduler;
    }

    public boolean isInteresting(int pieceNumber) {
        return this.pieces[pieceNumber].isInteresting();
    }

    public boolean isDone(int pieceNumber) {
        return this.pieces[pieceNumber].isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEvidence(IndentWriter writer) {
        writer.println("Disk Manager");
        try {
            writer.indent();
            writer.println("percent_done=" + this.percentDone + ",allocated=" + this.allocated + ",remaining=" + this.remaining);
            writer.println("skipped_file_set_size=" + this.skipped_file_set_size + ",skipped_but_downloaded=" + this.skipped_but_downloaded);
            writer.println("already_moved=" + this.alreadyMoved);
        }
        finally {
            writer.exdent();
        }
    }

    static {
        int max_read_threads = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxthreads");
        int max_read_mb = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxmb");
        int max_write_threads = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxthreads");
        int max_write_mb = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxmb");
        disk_access_controller = DiskAccessControllerFactory.create(max_read_threads, max_read_mb, max_write_threads, max_write_mb);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Disk access controller params: " + max_read_threads + "/" + max_read_mb + "/" + max_write_threads + "/" + max_write_mb));
        }
        recheck_scheduler = new DiskManagerRecheckScheduler();
        allocation_scheduler = new DiskManagerAllocationScheduler();
        start_pool = new ThreadPool("DiskManager:start", 64, true);
        start_pool.setThreadPriority(1);
        cache_read_mon = new AEMonitor("DiskManager:cacheRead");
        listeners_aggregator = ListenerManager.createAsyncManager("DiskM:ListenAggregatorDispatcher", new ListenerManagerDispatcher(){

            public void dispatch(Object _listener, int type, Object value) {
                DiskManagerListener listener = (DiskManagerListener)_listener;
                if (type == 1) {
                    int[] params = (int[])value;
                    listener.stateChanged(params[0], params[1]);
                } else if (type == 2) {
                    listener.filePriorityChanged((DiskManagerFileInfo)value);
                } else if (type == 3) {
                    listener.pieceDoneChanged((DiskManagerPiece)value);
                } else if (type == 4) {
                    Object[] o = (Object[])value;
                    listener.fileAccessModeChanged((DiskManagerFileInfo)o[0], (Integer)o[1], (Integer)o[2]);
                }
            }
        });
    }

    static abstract class FileSkeleton
    implements DiskManagerFileInfoHelper {
        protected boolean priority;
        protected boolean skipped;
        protected long downloaded;

        FileSkeleton() {
        }
    }
}

