/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.access.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequest;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequestListener;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gudy.azureus2.core3.disk.DiskManagerException;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.access.DMWriter;
import org.gudy.azureus2.core3.disk.impl.access.impl.DiskManagerWriteRequestImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.SystemTime;

public class DMWriterImpl
implements DMWriter {
    private static final LogIDs LOGID = LogIDs.DISK;
    private static final int MIN_ZERO_BLOCK = 0x100000;
    private DiskManagerHelper disk_manager;
    private DiskAccessController disk_access;
    private int async_writes;
    private Set write_requests = new HashSet();
    private AESemaphore async_write_sem = new AESemaphore("DMWriter::asyncWrite");
    private boolean started;
    private volatile boolean stopped;
    private int pieceLength;
    private long totalLength;
    private boolean complete_recheck_in_progress;
    private AEMonitor this_mon = new AEMonitor("DMWriter");

    public DMWriterImpl(DiskManagerHelper _disk_manager) {
        this.disk_manager = _disk_manager;
        this.disk_access = this.disk_manager.getDiskAccessController();
        this.pieceLength = this.disk_manager.getPieceLength();
        this.totalLength = this.disk_manager.getTotalLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new RuntimeException("DMWWriter: start while started");
            }
            if (this.stopped) {
                throw new RuntimeException("DMWWriter: start after stopped");
            }
            this.started = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        int write_wait;
        try {
            this.this_mon.enter();
            if (this.stopped || !this.started) {
                return;
            }
            this.stopped = true;
            write_wait = this.async_writes;
        }
        finally {
            this.this_mon.exit();
        }
        long log_time = SystemTime.getCurrentTime();
        for (int i = 0; i < write_wait; ++i) {
            long now = SystemTime.getCurrentTime();
            if (now < log_time) {
                log_time = now;
            } else if (now - log_time > 1000L) {
                log_time = now;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.disk_manager, LOGID, "Waiting for writes to complete - " + (write_wait - i) + " remaining"));
                }
            }
            this.async_write_sem.reserve();
        }
    }

    public boolean isChecking() {
        return this.complete_recheck_in_progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zeroFile(DiskManagerFileInfoImpl file, long length) throws DiskManagerException {
        CacheFile cache_file = file.getCacheFile();
        try {
            if (length == 0L) {
                cache_file.setLength(0L);
            } else {
                int buffer_size = this.pieceLength < 0x100000 ? 0x100000 : this.pieceLength;
                buffer_size = (buffer_size + 1023) / 1024 * 1024;
                DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)7, buffer_size);
                long remainder = length;
                long written = 0L;
                try {
                    byte[] blanks = new byte[1024];
                    for (int i = 0; i < buffer_size / 1024; ++i) {
                        buffer.put((byte)8, blanks);
                    }
                    buffer.position((byte)8, 0);
                    while (remainder > 0L && !this.stopped) {
                        int write_size = buffer_size;
                        if (remainder < (long)write_size) {
                            write_size = (int)remainder;
                            buffer.limit((byte)8, write_size);
                        }
                        final AESemaphore sem = new AESemaphore("DMW&C:zeroFile");
                        final Throwable[] op_failed = new Throwable[]{null};
                        this.disk_access.queueWriteRequest(cache_file, written, buffer, false, new DiskAccessRequestListener(){

                            public void requestComplete(DiskAccessRequest request2) {
                                sem.release();
                            }

                            public void requestCancelled(DiskAccessRequest request2) {
                                op_failed[0] = new Throwable("Request cancelled");
                                sem.release();
                            }

                            public void requestFailed(DiskAccessRequest request2, Throwable cause) {
                                op_failed[0] = cause;
                                sem.release();
                            }

                            public int getPriority() {
                                return -1;
                            }

                            public void requestExecuted(long bytes) {
                            }
                        });
                        sem.reserve();
                        if (op_failed[0] != null) {
                            throw op_failed[0];
                        }
                        buffer.position((byte)8, 0);
                        written += (long)write_size;
                        remainder -= (long)write_size;
                        this.disk_manager.setAllocated(this.disk_manager.getAllocated() + (long)write_size);
                        this.disk_manager.setPercentDone((int)(this.disk_manager.getAllocated() * 1000L / this.totalLength));
                    }
                }
                finally {
                    buffer.returnToPool();
                }
                cache_file.flushCache();
            }
            if (this.stopped) {
                return false;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new DiskManagerException(e);
        }
        return true;
    }

    public DiskManagerWriteRequest createWriteRequest(int pieceNumber, int offset, DirectByteBuffer buffer, Object user_data) {
        return new DiskManagerWriteRequestImpl(pieceNumber, offset, buffer, user_data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOutstandingWriteRequestForPiece(int piece_number) {
        try {
            this.this_mon.enter();
            for (DiskManagerWriteRequest request2 : this.write_requests) {
                if (request2.getPieceNumber() != piece_number) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlock(final DiskManagerWriteRequest request2, final DiskManagerWriteRequestListener _listener) {
        block12: {
            request2.requestStarts();
            final DiskManagerWriteRequestListener listener = new DiskManagerWriteRequestListener(){

                public void writeCompleted(DiskManagerWriteRequest request2) {
                    request2.requestEnds(true);
                    _listener.writeCompleted(request2);
                }

                public void writeFailed(DiskManagerWriteRequest request2, Throwable cause) {
                    request2.requestEnds(false);
                    _listener.writeFailed(request2, cause);
                }
            };
            try {
                int pieceNumber = request2.getPieceNumber();
                DirectByteBuffer buffer = request2.getBuffer();
                int offset = request2.getOffset();
                final DiskManagerPiece dmPiece = this.disk_manager.getPieces()[pieceNumber];
                if (dmPiece.isDone()) {
                    buffer.returnToPool();
                    listener.writeCompleted(request2);
                    break block12;
                }
                int buffer_position = buffer.position((byte)8);
                int buffer_limit = buffer.limit((byte)8);
                int previousFilesLength = 0;
                int currentFile = 0;
                DMPieceList pieceList2 = this.disk_manager.getPieceList(pieceNumber);
                DMPieceMapEntry current_piece = pieceList2.get(currentFile);
                long fileOffset = current_piece.getOffset();
                while (previousFilesLength + current_piece.getLength() < offset) {
                    previousFilesLength += current_piece.getLength();
                    fileOffset = 0L;
                    current_piece = pieceList2.get(++currentFile);
                }
                ArrayList<Object[]> chunks = new ArrayList<Object[]>();
                while (buffer_position < buffer_limit) {
                    current_piece = pieceList2.get(currentFile);
                    long file_limit = (long)buffer_position + (current_piece.getFile().getLength() - current_piece.getOffset() - (long)(offset - previousFilesLength));
                    if (file_limit > (long)buffer_limit) {
                        file_limit = buffer_limit;
                    }
                    if (file_limit > (long)buffer_position) {
                        long file_pos = fileOffset + (long)(offset - previousFilesLength);
                        chunks.add(new Object[]{current_piece.getFile(), new Long(file_pos), new Integer((int)file_limit)});
                        buffer_position = (int)file_limit;
                    }
                    ++currentFile;
                    fileOffset = 0L;
                    previousFilesLength = offset;
                }
                DiskManagerWriteRequestListener l = new DiskManagerWriteRequestListener(){

                    public void writeCompleted(DiskManagerWriteRequest request22) {
                        this.complete();
                        listener.writeCompleted(request22);
                    }

                    public void writeFailed(DiskManagerWriteRequest request22, Throwable cause) {
                        this.complete();
                        if (dmPiece.isDone()) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(DMWriterImpl.this.disk_manager, LOGID, "Piece " + dmPiece.getPieceNumber() + " write failed but already marked as done"));
                            }
                            listener.writeCompleted(request22);
                        } else {
                            DMWriterImpl.this.disk_manager.setFailed("Disk write error - " + Debug.getNestedExceptionMessage(cause));
                            Debug.printStackTrace(cause);
                            listener.writeFailed(request22, cause);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void complete() {
                        try {
                            DMWriterImpl.this.this_mon.enter();
                            DMWriterImpl.this.async_writes--;
                            if (!DMWriterImpl.this.write_requests.remove(request2)) {
                                Debug.out("request not found");
                            }
                            if (DMWriterImpl.this.stopped) {
                                DMWriterImpl.this.async_write_sem.release();
                            }
                        }
                        finally {
                            DMWriterImpl.this.this_mon.exit();
                        }
                    }
                };
                try {
                    this.this_mon.enter();
                    if (this.stopped) {
                        buffer.returnToPool();
                        listener.writeFailed(request2, new Exception("Disk writer has been stopped"));
                        return;
                    }
                    ++this.async_writes;
                    this.write_requests.add(request2);
                }
                finally {
                    this.this_mon.exit();
                }
                new requestDispatcher(request2, l, buffer, chunks);
            }
            catch (Throwable e) {
                request2.getBuffer().returnToPool();
                this.disk_manager.setFailed("Disk write error - " + Debug.getNestedExceptionMessage(e));
                Debug.printStackTrace(e);
                listener.writeFailed(request2, e);
            }
        }
    }

    protected class requestDispatcher
    implements DiskAccessRequestListener {
        private DiskManagerWriteRequest request;
        private DiskManagerWriteRequestListener listener;
        private DirectByteBuffer buffer;
        private List chunks;
        private int chunk_index;

        protected requestDispatcher(DiskManagerWriteRequest _request, DiskManagerWriteRequestListener _listener, DirectByteBuffer _buffer, List _chunks) {
            this.request = _request;
            this.listener = _listener;
            this.buffer = _buffer;
            this.chunks = _chunks;
            this.dispatch();
        }

        protected void dispatch() {
            try {
                if (this.chunk_index == this.chunks.size()) {
                    this.listener.writeCompleted(this.request);
                } else if (this.chunk_index == 1 && this.chunks.size() > 32) {
                    for (int i = 1; i < this.chunks.size(); ++i) {
                        final AESemaphore sem = new AESemaphore("DMW&C:dispatch:asyncReq");
                        final Throwable[] error = new Throwable[]{null};
                        this.doRequest(new DiskAccessRequestListener(){

                            public void requestComplete(DiskAccessRequest request2) {
                                sem.release();
                            }

                            public void requestCancelled(DiskAccessRequest request2) {
                                Debug.out("shouldn't get here");
                            }

                            public void requestFailed(DiskAccessRequest request2, Throwable cause) {
                                error[0] = cause;
                                sem.release();
                            }

                            public int getPriority() {
                                return -1;
                            }

                            public void requestExecuted(long bytes) {
                            }
                        });
                        sem.reserve();
                        if (error[0] == null) continue;
                        throw error[0];
                    }
                    this.listener.writeCompleted(this.request);
                } else {
                    this.doRequest(this);
                }
            }
            catch (Throwable e) {
                this.failed(e);
            }
        }

        protected void doRequest(final DiskAccessRequestListener l) throws CacheFileManagerException {
            Object[] stuff = (Object[])this.chunks.get(this.chunk_index++);
            final DiskManagerFileInfoImpl file = (DiskManagerFileInfoImpl)stuff[0];
            this.buffer.limit((byte)7, (Integer)stuff[2]);
            if (file.getAccessMode() == 1) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(DMWriterImpl.this.disk_manager, LOGID, "Changing " + file.getFile(true).getName() + " to read/write"));
                }
                file.setAccessMode(2);
            }
            boolean handover_buffer = this.chunk_index == this.chunks.size();
            DiskAccessRequestListener delegate_listener = new DiskAccessRequestListener(){

                public void requestComplete(DiskAccessRequest request2) {
                    l.requestComplete(request2);
                    file.dataWritten(request2.getOffset(), request2.getSize());
                }

                public void requestCancelled(DiskAccessRequest request2) {
                    l.requestCancelled(request2);
                }

                public void requestFailed(DiskAccessRequest request2, Throwable cause) {
                    l.requestFailed(request2, cause);
                }

                public int getPriority() {
                    return -1;
                }

                public void requestExecuted(long bytes) {
                }
            };
            DMWriterImpl.this.disk_access.queueWriteRequest(file.getCacheFile(), (Long)stuff[1], this.buffer, handover_buffer, delegate_listener);
        }

        public void requestComplete(DiskAccessRequest request2) {
            this.dispatch();
        }

        public void requestCancelled(DiskAccessRequest request2) {
            Debug.out("shouldn't get here");
        }

        public void requestFailed(DiskAccessRequest request2, Throwable cause) {
            this.failed(cause);
        }

        public int getPriority() {
            return -1;
        }

        public void requestExecuted(long bytes) {
        }

        protected void failed(Throwable cause) {
            this.buffer.returnToPool();
            this.listener.writeFailed(this.request, cause);
        }
    }
}

