/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import java.io.File;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.download.DownloadManagerActivationListener;
import org.gudy.azureus2.core3.download.DownloadManagerDiskListener;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPieceListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.DownloadManagerTrackerListener;
import org.gudy.azureus2.core3.download.ForceRecheckListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;

public interface DownloadManager {
    public static final int STATE_START_OF_DAY = -1;
    public static final int STATE_WAITING = 0;
    public static final int STATE_INITIALIZING = 5;
    public static final int STATE_INITIALIZED = 10;
    public static final int STATE_ALLOCATING = 20;
    public static final int STATE_CHECKING = 30;
    public static final int STATE_READY = 40;
    public static final int STATE_DOWNLOADING = 50;
    public static final int STATE_FINISHING = 55;
    public static final int STATE_SEEDING = 60;
    public static final int STATE_STOPPING = 65;
    public static final int STATE_STOPPED = 70;
    public static final int STATE_CLOSED = 71;
    public static final int STATE_QUEUED = 75;
    public static final int STATE_ERROR = 100;
    public static final int WEALTH_STOPPED = 1;
    public static final int WEALTH_NO_TRACKER = 2;
    public static final int WEALTH_NO_REMOTE = 3;
    public static final int WEALTH_OK = 4;
    public static final int WEALTH_KO = 5;
    public static final int WEALTH_ERROR = 6;

    public void initialize();

    public int getState();

    public int getSubState();

    public void setStateWaiting();

    public void setStateQueued();

    public void startDownload();

    public boolean canForceRecheck();

    public void forceRecheck();

    public void forceRecheck(ForceRecheckListener var1);

    public void resetFile(DiskManagerFileInfo var1);

    public void recheckFile(DiskManagerFileInfo var1);

    public void setPieceCheckingEnabled(boolean var1);

    public void stopIt(int var1, boolean var2, boolean var3);

    public boolean pause();

    public boolean isPaused();

    public void resume();

    public GlobalManager getGlobalManager();

    public DiskManager getDiskManager();

    public DiskManagerFileInfo[] getDiskManagerFileInfo();

    public DiskManagerFileInfoSet getDiskManagerFileInfoSet();

    public PEPeerManager getPeerManager();

    public DownloadManagerState getDownloadState();

    public TOTorrent getTorrent();

    public TRTrackerAnnouncer getTrackerClient();

    public void requestTrackerAnnounce(boolean var1);

    public void requestTrackerScrape(boolean var1);

    public TRTrackerScraperResponse getTrackerScrapeResponse();

    public void setTrackerScrapeResponse(TRTrackerScraperResponse var1);

    public String getDisplayName();

    public String getInternalName();

    public long getSize();

    public String getTorrentFileName();

    public void setTorrentFileName(String var1);

    public File getAbsoluteSaveLocation();

    public File getSaveLocation();

    public void setTorrentSaveDir(String var1);

    public void setTorrentSaveDir(String var1, String var2);

    public boolean isForceStart();

    public void setForceStart(boolean var1);

    public boolean isPersistent();

    public boolean isDownloadComplete(boolean var1);

    public String getTrackerStatus();

    public int getTrackerTime();

    public String getTorrentComment();

    public String getTorrentCreatedBy();

    public long getTorrentCreationDate();

    public int getNbPieces();

    public String getPieceLength();

    public int getNbSeeds();

    public int getNbPeers();

    public boolean filesExist();

    public String getErrorDetails();

    public DownloadManagerStats getStats();

    public int getPosition();

    public void setPosition(int var1);

    public boolean getAssumedComplete();

    public boolean requestAssumedCompleteMode();

    public int getHealthStatus();

    public int getNATStatus();

    public void saveResumeData();

    public void saveDownload();

    public Object getData(String var1);

    public void setData(String var1, Object var2);

    public Object getUserData(Object var1);

    public void setUserData(Object var1, Object var2);

    public boolean isDataAlreadyAllocated();

    public void setDataAlreadyAllocated(boolean var1);

    public void setSeedingRank(int var1);

    public int getSeedingRank();

    public void setMaxUploads(int var1);

    public int getMaxUploads();

    public int getEffectiveMaxUploads();

    public int getEffectiveUploadRateLimitBytesPerSecond();

    public void setCryptoLevel(int var1);

    public int getCryptoLevel();

    public void moveDataFiles(File var1) throws DownloadManagerException;

    public void renameDownload(String var1) throws DownloadManagerException;

    public void moveDataFiles(File var1, String var2) throws DownloadManagerException;

    public void moveTorrentFile(File var1) throws DownloadManagerException;

    public boolean isInDefaultSaveDir();

    public long getCreationTime();

    public void setCreationTime(long var1);

    public void setAnnounceResult(DownloadAnnounceResult var1);

    public void setScrapeResult(DownloadScrapeResult var1);

    public boolean isExtendedMessagingEnabled();

    public void setAZMessagingEnabled(boolean var1);

    public void destroy(boolean var1);

    public boolean isDestroyed();

    public PEPiece[] getCurrentPieces();

    public PEPeer[] getCurrentPeers();

    public boolean seedPieceRecheck();

    public void addRateLimiter(LimitedRateGroup var1, boolean var2);

    public void removeRateLimiter(LimitedRateGroup var1, boolean var2);

    public void addListener(DownloadManagerListener var1, boolean var2);

    public void addListener(DownloadManagerListener var1);

    public void removeListener(DownloadManagerListener var1);

    public void addTrackerListener(DownloadManagerTrackerListener var1);

    public void removeTrackerListener(DownloadManagerTrackerListener var1);

    public void addPeerListener(DownloadManagerPeerListener var1);

    public void addPeerListener(DownloadManagerPeerListener var1, boolean var2);

    public void removePeerListener(DownloadManagerPeerListener var1);

    public void addPieceListener(DownloadManagerPieceListener var1);

    public void addPieceListener(DownloadManagerPieceListener var1, boolean var2);

    public void removePieceListener(DownloadManagerPieceListener var1);

    public void addDiskListener(DownloadManagerDiskListener var1);

    public void removeDiskListener(DownloadManagerDiskListener var1);

    public int getActivationCount();

    public void addActivationListener(DownloadManagerActivationListener var1);

    public void removeActivationListener(DownloadManagerActivationListener var1);

    public void generateEvidence(IndentWriter var1);

    public int[] getStorageType(DiskManagerFileInfo[] var1);

    public boolean canMoveDataFiles();

    public void rename(String var1) throws DownloadManagerException;

    public void renameTorrent(String var1) throws DownloadManagerException;

    public void moveTorrentFile(File var1, String var2) throws DownloadManagerException;

    public void setTorrentFile(File var1, String var2) throws DownloadManagerException;
}

