/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.IntegratedResourceBundle;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import sun.security.action.GetPropertyAction;

public class MessageText {
    public static final Locale LOCALE_ENGLISH = new Locale("en", "");
    public static final Locale LOCALE_DEFAULT;
    private static Locale LOCALE_CURRENT;
    private static final String BUNDLE_NAME = "org.gudy.azureus2.internat.MessagesBundle";
    private static Map pluginLocalizationPaths;
    private static Collection pluginResourceBundles;
    private static IntegratedResourceBundle RESOURCE_BUNDLE;
    private static Set platform_specific_keys;
    private static final Pattern PAT_PARAM_ALPHA;
    private static int bundle_fail_count;
    private static List listeners;
    private static IntegratedResourceBundle DEFAULT_BUNDLE;

    public static void loadBundle() {
        MessageText.loadBundle(false);
    }

    public static void loadBundle(boolean forceReload) {
        Locale old_locale = MessageText.getCurrentLocale();
        String savedLocaleString = COConfigurationManager.getStringParameter("locale");
        String[] savedLocaleStrings = savedLocaleString.split("_", 3);
        Locale savedLocale = savedLocaleStrings.length > 0 && savedLocaleStrings[0].length() == 2 ? (savedLocaleStrings.length == 3 ? new Locale(savedLocaleStrings[0], savedLocaleStrings[1], savedLocaleStrings[2]) : (savedLocaleStrings.length == 2 && savedLocaleStrings[1].length() == 2 ? new Locale(savedLocaleStrings[0], savedLocaleStrings[1]) : new Locale(savedLocaleStrings[0]))) : (savedLocaleStrings.length == 3 && savedLocaleStrings[0].length() == 0 && savedLocaleStrings[2].length() > 0 ? new Locale(savedLocaleStrings[0], savedLocaleStrings[1], savedLocaleStrings[2]) : Locale.getDefault());
        MessageText.changeLocale(savedLocale, forceReload);
        COConfigurationManager.setParameter("locale.set.complete.count", COConfigurationManager.getIntParameter("locale.set.complete.count") + 1);
        Locale new_locale = MessageText.getCurrentLocale();
        if (!old_locale.equals(new_locale) || forceReload) {
            for (int i = 0; i < listeners.size(); ++i) {
                try {
                    ((MessageTextListener)listeners.get(i)).localeChanged(old_locale, new_locale);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public static void addListener(MessageTextListener listener) {
        listeners.add(listener);
    }

    public static void addAndFireListener(MessageTextListener listener) {
        listeners.add(listener);
        listener.localeChanged(MessageText.getCurrentLocale(), MessageText.getCurrentLocale());
    }

    public static void removeListener(MessageTextListener listener) {
        listeners.remove(listener);
    }

    static ResourceBundle getResourceBundle(String name, Locale loc, ClassLoader cl) {
        try {
            return ResourceBundle.getBundle(name, loc, cl);
        }
        catch (Throwable e) {
            if (++bundle_fail_count == 1) {
                e.printStackTrace();
                Logger.log(new LogAlert(true, 3, "Failed to load resource bundle. One possible cause is that you have installed " + Constants.APP_NAME + " into a directory " + "with a '!' in it. If so, please remove the '!'."));
            }
            return new ResourceBundle(){

                public Locale getLocale() {
                    return LOCALE_DEFAULT;
                }

                protected Object handleGetObject(String key) {
                    return null;
                }

                public Enumeration getKeys() {
                    return new Vector().elements();
                }
            };
        }
    }

    private static void setResourceBundle(IntegratedResourceBundle bundle) {
        RESOURCE_BUNDLE = bundle;
        Iterator keys = RESOURCE_BUNDLE.getKeysLight();
        String platform_suffix = MessageText.getPlatformSuffix();
        HashSet<String> platformKeys = new HashSet<String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.endsWith(platform_suffix)) continue;
            platformKeys.add(key);
        }
        platform_specific_keys = platformKeys;
    }

    public static boolean keyExists(String key) {
        try {
            MessageText.getResourceBundleString(key);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static boolean keyExistsForDefaultLocale(String key) {
        try {
            DEFAULT_BUNDLE.getString(key);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static String getString(String key, String sDefault) {
        if (key == null) {
            return "";
        }
        String target_key = key + MessageText.getPlatformSuffix();
        if (!platform_specific_keys.contains(target_key)) {
            target_key = key;
        }
        try {
            return MessageText.getResourceBundleString(target_key);
        }
        catch (MissingResourceException e) {
            return MessageText.getPlatformNeutralString(key, sDefault);
        }
    }

    public static String getString(String key) {
        if (key == null) {
            return "";
        }
        String target_key = key + MessageText.getPlatformSuffix();
        if (!platform_specific_keys.contains(target_key)) {
            target_key = key;
        }
        try {
            return MessageText.getResourceBundleString(target_key);
        }
        catch (MissingResourceException e) {
            return MessageText.getPlatformNeutralString(key);
        }
    }

    public static String getPlatformNeutralString(String key) {
        try {
            return MessageText.getResourceBundleString(key);
        }
        catch (MissingResourceException e) {
            if (key.startsWith("!") && key.endsWith("!")) {
                return key.substring(1, key.length() - 1);
            }
            return '!' + key + '!';
        }
    }

    public static String getPlatformNeutralString(String key, String sDefault) {
        try {
            return MessageText.getResourceBundleString(key);
        }
        catch (MissingResourceException e) {
            return sDefault;
        }
    }

    private static String getResourceBundleString(String key) {
        if (key == null) {
            return "";
        }
        String value = RESOURCE_BUNDLE.getString(key);
        if (value != null && value.indexOf(125) > 0) {
            Matcher matcher = PAT_PARAM_ALPHA.matcher(value);
            while (matcher.find()) {
                key = matcher.group(1);
                try {
                    String text = MessageText.getResourceBundleString(key);
                    if (text == null) continue;
                    value = value.replaceAll("\\Q{" + key + "}\\E", text);
                }
                catch (MissingResourceException missingResourceException) {}
            }
        }
        return value;
    }

    private static String getPlatformSuffix() {
        if (Constants.isOSX) {
            return "._mac";
        }
        if (Constants.isLinux) {
            return "._linux";
        }
        if (Constants.isUnix) {
            return "._unix";
        }
        if (Constants.isFreeBSD) {
            return "._freebsd";
        }
        if (Constants.isSolaris) {
            return "._solaris";
        }
        if (Constants.isWindows) {
            return "._windows";
        }
        return "._unknown";
    }

    public static String getStringForSentence(String sentence) {
        StringTokenizer st = new StringTokenizer(sentence, " ");
        StringBuffer result = new StringBuffer(sentence.length());
        String separator = "";
        while (st.hasMoreTokens()) {
            result.append(separator);
            separator = " ";
            String word = st.nextToken();
            int length = word.length();
            int position = word.lastIndexOf(".");
            if (position == -1 || position + 1 == length) {
                result.append(word);
                continue;
            }
            String translated = MessageText.getString(word);
            if (translated.equals("!" + word + "!")) {
                result.append(word);
                continue;
            }
            result.append(translated);
        }
        return result.toString();
    }

    public static String getString(String key, String[] params) {
        String res = MessageText.getString(key);
        if (params == null) {
            return res;
        }
        for (int i = 0; i < params.length; ++i) {
            String from_str = "%" + (i + 1);
            String to_str = params[i];
            res = MessageText.replaceStrings(res, from_str, to_str);
        }
        return res;
    }

    protected static String replaceStrings(String str, String f_s, String t_s) {
        int pos = 0;
        String res = "";
        while (pos < str.length()) {
            int p1 = str.indexOf(f_s, pos);
            if (p1 == -1) {
                res = res + str.substring(pos);
                break;
            }
            res = res + str.substring(pos, p1) + t_s;
            pos = p1 + f_s.length();
        }
        return res;
    }

    public static String getDefaultLocaleString(String key) {
        try {
            return DEFAULT_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            if (key.startsWith("!") && key.endsWith("!")) {
                return key.substring(1, key.length() - 1);
            }
            return '!' + key + '!';
        }
    }

    public static Locale getCurrentLocale() {
        return LOCALE_DEFAULT.equals(LOCALE_CURRENT) ? LOCALE_ENGLISH : LOCALE_CURRENT;
    }

    public static boolean isCurrentLocale(Locale locale) {
        return LOCALE_ENGLISH.equals(locale) ? LOCALE_CURRENT.equals(LOCALE_DEFAULT) : LOCALE_CURRENT.equals(locale);
    }

    public static Locale[] getLocales() {
        File appDir;
        String[] appBundles;
        String bundleFolder = BUNDLE_NAME.replace('.', '/');
        final String prefix = BUNDLE_NAME.substring(BUNDLE_NAME.lastIndexOf(46) + 1);
        String extension = ".properties";
        String urlString = MessageText.class.getClassLoader().getResource(bundleFolder.concat(".properties")).toExternalForm();
        String[] bundles = null;
        if (urlString.startsWith("jar:file:")) {
            File jar = FileUtil.getJarFileFromURL(urlString);
            if (jar != null) {
                try {
                    JarFile jarFile = new JarFile(jar);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    ArrayList<String> list = new ArrayList<String>(250);
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        if (!jarEntry.getName().startsWith(bundleFolder) || !jarEntry.getName().endsWith(".properties")) continue;
                        list.add(jarEntry.getName().substring(bundleFolder.length() - prefix.length()));
                    }
                    bundles = list.toArray(new String[list.size()]);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        } else {
            File bundleDirectory = new File(URI.create(urlString)).getParentFile();
            bundles = bundleDirectory.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith(prefix) && name.endsWith(".properties");
                }
            });
        }
        HashSet<String> bundleSet = new HashSet<String>();
        File localDir = new File(SystemProperties.getUserPath());
        String[] localBundles = localDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && name.endsWith(".properties");
            }
        });
        if (localBundles != null) {
            bundleSet.addAll(Arrays.asList(localBundles));
        }
        if ((appBundles = (appDir = new File(SystemProperties.getApplicationPath())).list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && name.endsWith(".properties");
            }
        })) != null) {
            bundleSet.addAll(Arrays.asList(appBundles));
        }
        bundleSet.addAll(Arrays.asList(bundles));
        ArrayList<Locale> foundLocalesList = new ArrayList<Locale>(bundleSet.size());
        foundLocalesList.add(LOCALE_ENGLISH);
        for (String sBundle : bundleSet) {
            if (prefix.length() + 1 >= sBundle.length() - ".properties".length()) continue;
            String locale = sBundle.substring(prefix.length() + 1, sBundle.length() - ".properties".length());
            String[] sLocalesSplit = locale.split("_", 3);
            if (sLocalesSplit.length > 0 && sLocalesSplit[0].length() == 2) {
                if (sLocalesSplit.length == 3) {
                    foundLocalesList.add(new Locale(sLocalesSplit[0], sLocalesSplit[1], sLocalesSplit[2]));
                    continue;
                }
                if (sLocalesSplit.length == 2 && sLocalesSplit[1].length() == 2) {
                    foundLocalesList.add(new Locale(sLocalesSplit[0], sLocalesSplit[1]));
                    continue;
                }
                foundLocalesList.add(new Locale(sLocalesSplit[0]));
                continue;
            }
            if (sLocalesSplit.length != 3 || sLocalesSplit[0].length() != 0 || sLocalesSplit[2].length() <= 0) continue;
            foundLocalesList.add(new Locale(sLocalesSplit[0], sLocalesSplit[1], sLocalesSplit[2]));
        }
        Locale[] foundLocales = new Locale[foundLocalesList.size()];
        foundLocalesList.toArray(foundLocales);
        try {
            Arrays.sort(foundLocales, new Comparator(){

                public final int compare(Object a, Object b) {
                    return ((Locale)a).getDisplayName((Locale)a).compareToIgnoreCase(((Locale)b).getDisplayName((Locale)b));
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return foundLocales;
    }

    public static boolean changeLocale(Locale newLocale) {
        return MessageText.changeLocale(newLocale, false);
    }

    private static boolean changeLocale(Locale newLocale, boolean force) {
        Locale.setDefault(newLocale);
        if (!MessageText.isCurrentLocale(newLocale) || force) {
            ResourceBundle newResourceBundle;
            block10: {
                Locale.setDefault(LOCALE_DEFAULT);
                newResourceBundle = null;
                String bundleFolder = BUNDLE_NAME.replace('.', '/');
                String prefix = BUNDLE_NAME.substring(BUNDLE_NAME.lastIndexOf(46) + 1);
                String extension = ".properties";
                if (newLocale.equals(LOCALE_ENGLISH)) {
                    newLocale = LOCALE_DEFAULT;
                }
                try {
                    File userBundleFile = new File(SystemProperties.getUserPath());
                    File appBundleFile = new File(SystemProperties.getApplicationPath());
                    ClassLoader cl = MessageText.class.getClassLoader();
                    String sJar = cl.getResource(bundleFolder + ".properties").toString();
                    sJar = sJar.substring(0, sJar.length() - prefix.length() - ".properties".length());
                    URL jarURL = new URL(sJar);
                    URL[] urls = new URL[]{userBundleFile.toURL(), appBundleFile.toURL(), jarURL};
                    newResourceBundle = MessageText.getResourceBundle("MessagesBundle", newLocale, new URLClassLoader(urls));
                    if (newResourceBundle.getLocale().getLanguage().equals(newLocale.getLanguage()) || newLocale.getCountry().equals("")) break block10;
                    Locale foundLocale = newResourceBundle.getLocale();
                    System.out.println("changeLocale: " + (foundLocale.toString().equals("") ? "*Default Language*" : foundLocale.getDisplayLanguage()) + " != " + newLocale.getDisplayName() + ". Searching without country..");
                    Locale localeJustLang = new Locale(newLocale.getLanguage());
                    newResourceBundle = MessageText.getResourceBundle("MessagesBundle", localeJustLang, new URLClassLoader(urls));
                    if (newResourceBundle != null && newResourceBundle.getLocale().getLanguage().equals(localeJustLang.getLanguage())) break block10;
                    System.out.println("changeLocale: Searching for language " + newLocale.getDisplayLanguage() + " in *any* country..");
                    Locale[] locales = MessageText.getLocales();
                    for (int i = 0; i < locales.length; ++i) {
                        if (locales[i].getLanguage() != newLocale.getLanguage()) continue;
                        newResourceBundle = MessageText.getResourceBundle("MessagesBundle", locales[i], new URLClassLoader(urls));
                        break;
                    }
                }
                catch (MissingResourceException e) {
                    System.out.println("changeLocale: no resource bundle for " + newLocale);
                    Debug.printStackTrace(e);
                    return false;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
            if (newResourceBundle != null) {
                if (!newLocale.equals(LOCALE_DEFAULT) && !newResourceBundle.getLocale().equals(newLocale)) {
                    String sNewLanguage = newResourceBundle.getLocale().getDisplayName();
                    if (sNewLanguage == null || sNewLanguage.trim().equals("")) {
                        sNewLanguage = "English (default)";
                    }
                    System.out.println("changeLocale: no message properties for Locale '" + newLocale.getDisplayName() + "' (" + newLocale + "), using '" + sNewLanguage + "'");
                }
                Locale.setDefault((newLocale = newResourceBundle.getLocale()).equals(LOCALE_DEFAULT) ? LOCALE_ENGLISH : newLocale);
                LOCALE_CURRENT = newLocale;
                MessageText.setResourceBundle(new IntegratedResourceBundle(newResourceBundle, pluginLocalizationPaths));
                if (newLocale.equals(LOCALE_DEFAULT)) {
                    DEFAULT_BUNDLE = RESOURCE_BUNDLE;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean integratePluginMessages(String localizationPath, ClassLoader classLoader) {
        boolean integratedSuccessfully = false;
        if (null != localizationPath && localizationPath.length() != 0 && !pluginLocalizationPaths.containsKey(localizationPath)) {
            Map map = pluginLocalizationPaths;
            synchronized (map) {
                pluginLocalizationPaths.put(localizationPath, classLoader);
            }
            RESOURCE_BUNDLE.addPluginBundle(localizationPath, classLoader);
            MessageText.setResourceBundle(RESOURCE_BUNDLE);
            integratedSuccessfully = true;
        }
        return integratedSuccessfully;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean integratePluginMessages(ResourceBundle bundle) {
        Collection collection = pluginResourceBundles;
        synchronized (collection) {
            pluginResourceBundles.add(bundle);
        }
        RESOURCE_BUNDLE.addResourceMessages(bundle);
        MessageText.setResourceBundle(RESOURCE_BUNDLE);
        return true;
    }

    public static void revertToDefaultLocale() {
        String variant;
        String country;
        String language = AccessController.doPrivileged(new GetPropertyAction("user.language", "en"));
        String region2 = AccessController.doPrivileged(new GetPropertyAction("user.region"));
        if (region2 != null) {
            int i = region2.indexOf(95);
            if (i >= 0) {
                country = region2.substring(0, i);
                variant = region2.substring(i + 1);
            } else {
                country = region2;
                variant = "";
            }
        } else {
            country = AccessController.doPrivileged(new GetPropertyAction("user.country", ""));
            variant = AccessController.doPrivileged(new GetPropertyAction("user.variant", ""));
        }
        MessageText.changeLocale(new Locale(language, country, variant));
        COConfigurationManager.removeParameter("locale");
    }

    public static String resolveLocalizationKey(String localizationKey) {
        if (null == localizationKey) {
            return null;
        }
        if ("az3".equalsIgnoreCase(COConfigurationManager.getStringParameter("ui"))) {
            String v3Key = null;
            v3Key = false == localizationKey.startsWith("v3.") ? "v3." + localizationKey : localizationKey;
            if (MessageText.keyExists(v3Key)) {
                return v3Key;
            }
        }
        return localizationKey;
    }

    public static String resolveAcceleratorKey(String acceleratorKey) {
        if (null == acceleratorKey) {
            return null;
        }
        if ("az3".equalsIgnoreCase(COConfigurationManager.getStringParameter("ui"))) {
            String v3Key = null;
            v3Key = false == acceleratorKey.startsWith("v3.") ? "v3." + acceleratorKey : acceleratorKey;
            if (MessageText.keyExists(v3Key + ".keybinding")) {
                return v3Key;
            }
        }
        return acceleratorKey;
    }

    static {
        LOCALE_CURRENT = LOCALE_DEFAULT = new Locale("", "");
        pluginLocalizationPaths = new HashMap();
        pluginResourceBundles = new ArrayList();
        platform_specific_keys = new HashSet();
        PAT_PARAM_ALPHA = Pattern.compile("\\{([^0-9].+?)\\}");
        bundle_fail_count = 0;
        listeners = new ArrayList();
        MessageText.setResourceBundle(new IntegratedResourceBundle(MessageText.getResourceBundle(BUNDLE_NAME, LOCALE_DEFAULT, MessageText.class.getClassLoader()), pluginLocalizationPaths));
        DEFAULT_BUNDLE = RESOURCE_BUNDLE;
    }

    public static interface MessageTextListener {
        public void localeChanged(Locale var1, Locale var2);
    }
}

