/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.impl.control.PEPeerControlImpl;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.SystemTime;

public class PEPeerManagerStatsImpl
implements PEPeerManagerStats {
    private PEPeerManagerAdapter adapter;
    private long total_data_bytes_received = 0L;
    private long total_protocol_bytes_received = 0L;
    private long total_data_bytes_sent = 0L;
    private long total_protocol_bytes_sent = 0L;
    private long totalDiscarded;
    private long hash_fail_bytes;
    private int last_data_received_seconds;
    private int last_data_sent_seconds;
    private final Average data_receive_speed = Average.getInstance(1000, 10);
    private final Average protocol_receive_speed = Average.getInstance(1000, 10);
    private final Average data_send_speed = Average.getInstance(1000, 10);
    private final Average protocol_send_speed = Average.getInstance(1000, 10);
    private final Average overallSpeed = Average.getInstance(5000, 100);

    public PEPeerManagerStatsImpl(PEPeerControlImpl _manager) {
        this.adapter = _manager.getAdapter();
    }

    public void discarded(PEPeer peer, int length) {
        this.totalDiscarded += (long)length;
        this.adapter.discarded(peer, length);
    }

    public void hashFailed(int length) {
        this.hash_fail_bytes += (long)length;
    }

    public long getTotalHashFailBytes() {
        return this.hash_fail_bytes;
    }

    public void dataBytesReceived(PEPeer peer, int length) {
        this.total_data_bytes_received += (long)length;
        this.data_receive_speed.addValue(length);
        if (length > 0) {
            this.last_data_received_seconds = (int)(SystemTime.getCurrentTime() / 1000L);
        }
        this.adapter.dataBytesReceived(peer, length);
    }

    public void protocolBytesReceived(PEPeer peer, int length) {
        this.total_protocol_bytes_received += (long)length;
        this.protocol_receive_speed.addValue(length);
        this.adapter.protocolBytesReceived(peer, length);
    }

    public void dataBytesSent(PEPeer peer, int length) {
        this.total_data_bytes_sent += (long)length;
        this.data_send_speed.addValue(length);
        if (length > 0) {
            this.last_data_sent_seconds = (int)(SystemTime.getCurrentTime() / 1000L);
        }
        this.adapter.dataBytesSent(peer, length);
    }

    public void protocolBytesSent(PEPeer peer, int length) {
        this.total_protocol_bytes_sent += (long)length;
        this.protocol_send_speed.addValue(length);
        this.adapter.protocolBytesSent(peer, length);
    }

    public void haveNewPiece(int pieceLength) {
        this.overallSpeed.addValue(pieceLength);
    }

    public long getDataReceiveRate() {
        return this.data_receive_speed.getAverage();
    }

    public long getProtocolReceiveRate() {
        return this.protocol_receive_speed.getAverage();
    }

    public long getDataSendRate() {
        return this.data_send_speed.getAverage();
    }

    public long getProtocolSendRate() {
        return this.protocol_send_speed.getAverage();
    }

    public long getTotalDiscarded() {
        return this.totalDiscarded;
    }

    public void setTotalDiscarded(long total) {
        this.totalDiscarded = total;
    }

    public long getTotalDataBytesSent() {
        return this.total_data_bytes_sent;
    }

    public long getTotalProtocolBytesSent() {
        return this.total_protocol_bytes_sent;
    }

    public long getTotalDataBytesReceived() {
        return this.total_data_bytes_received;
    }

    public long getTotalProtocolBytesReceived() {
        return this.total_protocol_bytes_received;
    }

    public long getTotalAverage() {
        return this.overallSpeed.getAverage() + this.getDataReceiveRate();
    }

    public int getTimeSinceLastDataReceivedInSeconds() {
        if (this.last_data_received_seconds == 0) {
            return -1;
        }
        int now = (int)(SystemTime.getCurrentTime() / 1000L);
        if (now < this.last_data_received_seconds) {
            this.last_data_received_seconds = now;
        }
        return now - this.last_data_received_seconds;
    }

    public int getTimeSinceLastDataSentInSeconds() {
        if (this.last_data_sent_seconds == 0) {
            return -1;
        }
        int now = (int)(SystemTime.getCurrentTime() / 1000L);
        if (now < this.last_data_sent_seconds) {
            this.last_data_sent_seconds = now;
        }
        return now - this.last_data_sent_seconds;
    }
}

