/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.control;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.peermanager.control.PeerControlInstance;
import com.aelitis.azureus.core.peermanager.control.PeerControlScheduler;
import com.aelitis.azureus.core.peermanager.control.PeerControlSchedulerFactory;
import com.aelitis.azureus.core.peermanager.nat.PeerNATInitiator;
import com.aelitis.azureus.core.peermanager.nat.PeerNATTraversalAdapter;
import com.aelitis.azureus.core.peermanager.nat.PeerNATTraverser;
import com.aelitis.azureus.core.peermanager.peerdb.PeerDatabase;
import com.aelitis.azureus.core.peermanager.peerdb.PeerDatabaseFactory;
import com.aelitis.azureus.core.peermanager.peerdb.PeerExchangerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItemFactory;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePickerFactory;
import com.aelitis.azureus.core.peermanager.unchoker.DownloadingUnchoker;
import com.aelitis.azureus.core.peermanager.unchoker.SeedingUnchoker;
import com.aelitis.azureus.core.peermanager.unchoker.Unchoker;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadHelper;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSlotManager;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.plugins.net.buddy.tracker.BuddyPluginTracker;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.IPFilterListener;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerManagerStatsImpl;
import org.gudy.azureus2.core3.peer.impl.PEPeerStatsImpl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportFactory;
import org.gudy.azureus2.core3.peer.impl.PEPieceImpl;
import org.gudy.azureus2.core3.peer.impl.PEPieceWriteImpl;
import org.gudy.azureus2.core3.peer.impl.control.SuperSeedPeer;
import org.gudy.azureus2.core3.peer.impl.control.SuperSeedPiece;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.BrokenMd5Hasher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.peers.PeerDescriptor;

public class PEPeerControlImpl
extends LogRelation
implements PEPeerControl,
ParameterListener,
DiskManagerWriteRequestListener,
PeerControlInstance,
PeerNATInitiator,
DiskManagerCheckRequestListener,
IPFilterListener {
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final int WARNINGS_LIMIT = 2;
    private static final int CHECK_REASON_DOWNLOADED = 1;
    private static final int CHECK_REASON_COMPLETE = 2;
    private static final int CHECK_REASON_SCAN = 3;
    private static final int CHECK_REASON_SEEDING_CHECK = 4;
    private static final int CHECK_REASON_BAD_PIECE_CHECK = 5;
    private static final int SEED_CHECK_WAIT_MARKER = 65526;
    private static boolean disconnect_seeds_when_seeding;
    private static boolean enable_seeding_piece_rechecks;
    private static int stalled_piece_timeout;
    private static boolean fast_unchoke_new_peers;
    private static float ban_peer_discard_ratio;
    private static int ban_peer_discard_min_kb;
    private static boolean udp_fallback_for_failed_connection;
    private static boolean udp_fallback_for_dropped_connection;
    private static boolean udp_probe_enabled;
    private static boolean hide_a_piece;
    private static boolean prefer_udp_default;
    private static IpFilter ip_filter;
    private volatile boolean is_running = false;
    private volatile boolean is_destroyed = false;
    private volatile ArrayList peer_transports_cow = new ArrayList();
    private final AEMonitor peer_transports_mon = new AEMonitor("PEPeerControl:PT");
    protected final PEPeerManagerAdapter adapter;
    private final DiskManager disk_mgr;
    private final DiskManagerPiece[] dm_pieces;
    private final PiecePicker piecePicker;
    private long lastNeededUndonePieceChange;
    private boolean seeding_mode;
    private boolean restart_initiated;
    private final int _nbPieces;
    private PEPieceImpl[] pePieces;
    private int nbPiecesActive;
    private int nbPeersSnubbed;
    private PeerIdentityDataID _hash;
    private final byte[] _myPeerId;
    private PEPeerManagerStats _stats;
    private int _seeds;
    private int _peers;
    private int _remotesNoUdpNoLan;
    private long last_remote_time;
    private long _timeStarted;
    private long _timeStartedSeeding = -1L;
    private long _timeFinished;
    private Average _averageReceptionSpeed;
    private long mainloop_loop_count;
    private static final int MAINLOOP_ONE_SECOND_INTERVAL;
    private static final int MAINLOOP_FIVE_SECOND_INTERVAL;
    private static final int MAINLOOP_TEN_SECOND_INTERVAL;
    private static final int MAINLOOP_THIRTY_SECOND_INTERVAL;
    private static final int MAINLOOP_SIXTY_SECOND_INTERVAL;
    private static final int MAINLOOP_TEN_MINUTE_INTERVAL;
    private volatile ArrayList peer_manager_listeners_cow = new ArrayList();
    private final List piece_check_result_list = new ArrayList();
    private final AEMonitor piece_check_result_list_mon = new AEMonitor("PEPeerControl:PCRL");
    private boolean superSeedMode;
    private int superSeedModeCurrentPiece;
    private int superSeedModeNumberOfAnnounces;
    private SuperSeedPiece[] superSeedPieces;
    private final int hidden_piece;
    private final AEMonitor this_mon = new AEMonitor("PEPeerControl");
    private long ip_filter_last_update_time;
    private Map user_data;
    private Unchoker unchoker;
    private List external_rate_limiters_cow;
    private List sweepList = Collections.EMPTY_LIST;
    private int nextPEXSweepIndex = 0;
    private final UploadHelper upload_helper = new UploadHelper(){

        public int getPriority() {
            return 4;
        }

        public ArrayList getAllPeers() {
            ArrayList peer_transports = PEPeerControlImpl.this.peer_transports_cow;
            return peer_transports;
        }

        public boolean isSeeding() {
            return PEPeerControlImpl.this.seeding_mode;
        }
    };
    private PeerDatabase peer_database = PeerDatabaseFactory.createPeerDatabase();
    private int bad_piece_reported = -1;
    private int next_rescan_piece = -1;
    private long rescan_piece_time = -1L;
    private long last_eta;
    private long last_eta_calculation;
    private static final int MAX_UDP_CONNECTIONS = 16;
    private static final int PENDING_NAT_TRAVERSAL_MAX = 32;
    private static final int MAX_UDP_TRAVERSAL_COUNT = 3;
    private static final String PEER_NAT_TRAVERSE_DONE_KEY;
    private Map pending_nat_traversals = new LinkedHashMap(32, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 32;
        }
    };
    private int udp_traversal_count;
    private static final int UDP_RECONNECT_MAX = 16;
    private Map udp_reconnects = new LinkedHashMap(16, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 16;
        }
    };
    private static final int UDP_RECONNECT_MIN_MILLIS = 10000;
    private long last_udp_reconnect;
    private boolean prefer_udp;
    private static final int PREFER_UDP_BLOOM_SIZE = 10000;
    private volatile BloomFilter prefer_udp_bloom;
    private final LimitedRateGroup upload_limited_rate_group = new LimitedRateGroup(){

        public int getRateLimitBytesPerSecond() {
            return PEPeerControlImpl.this.adapter.getUploadRateLimitBytesPerSecond();
        }
    };
    private final LimitedRateGroup download_limited_rate_group = new LimitedRateGroup(){

        public int getRateLimitBytesPerSecond() {
            return PEPeerControlImpl.this.adapter.getDownloadRateLimitBytesPerSecond();
        }
    };

    public PEPeerControlImpl(byte[] _peer_id, PEPeerManagerAdapter _adapter, DiskManager diskManager) {
        this._myPeerId = _peer_id;
        this.adapter = _adapter;
        this.disk_mgr = diskManager;
        this._nbPieces = this.disk_mgr.getNbPieces();
        this.dm_pieces = this.disk_mgr.getPieces();
        this.pePieces = new PEPieceImpl[this._nbPieces];
        int n = this.hidden_piece = hide_a_piece ? (int)(Math.abs(this.adapter.getRandomSeed()) % (long)this._nbPieces) : -1;
        if (this.hidden_piece >= 0) {
            System.out.println("Hidden piece for " + this.getDisplayName() + " = " + this.hidden_piece);
        }
        this.piecePicker = PiecePickerFactory.create(this);
        COConfigurationManager.addParameterListener("Ip Filter Enabled", (ParameterListener)this);
        ip_filter.addListener(this);
    }

    public void start() {
        try {
            this._hash = PeerIdentityManager.createDataID(this.disk_mgr.getTorrent().getHash());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            this._hash = PeerIdentityManager.createDataID(new byte[20]);
        }
        for (int i = 0; i < this._nbPieces; ++i) {
            DiskManagerPiece dmPiece = this.dm_pieces[i];
            if (dmPiece.isDone() || dmPiece.getNbWritten() <= 0) continue;
            this.addPiece(new PEPieceImpl(this, dmPiece, 0), i, true);
        }
        this.peer_transports_cow = new ArrayList();
        this.mainloop_loop_count = 0L;
        this._averageReceptionSpeed = Average.getInstance(1000, 30);
        this._stats = new PEPeerManagerStatsImpl(this);
        this.superSeedMode = COConfigurationManager.getBooleanParameter("Use Super Seeding") && this.getRemaining() == 0L;
        this.superSeedModeCurrentPiece = 0;
        if (this.superSeedMode) {
            this.initialiseSuperSeedMode();
        }
        this.checkFinished(true);
        UploadSlotManager.getSingleton().registerHelper(this.upload_helper);
        this.lastNeededUndonePieceChange = Long.MIN_VALUE;
        this._timeStarted = SystemTime.getCurrentTime();
        this.is_running = true;
        this.adapter.getPeerManagerRegistration().activate(this);
        PeerNATTraverser.getSingleton().register(this);
        PeerControlSchedulerFactory.getSingleton().register(this);
    }

    public void stopAll() {
        this.is_running = false;
        UploadSlotManager.getSingleton().deregisterHelper(this.upload_helper);
        PeerControlSchedulerFactory.getSingleton().unregister(this);
        PeerNATTraverser.getSingleton().unregister(this);
        this.adapter.getPeerManagerRegistration().deactivate();
        this.closeAndRemoveAllPeers("download stopped", false);
        for (int i = 0; i < this._nbPieces; ++i) {
            if (this.pePieces[i] == null) continue;
            this.removePiece(this.pePieces[i], i);
        }
        COConfigurationManager.removeParameterListener("Ip Filter Enabled", this);
        ip_filter.removeListener(this);
        this.piecePicker.destroy();
        ArrayList peer_manager_listeners = this.peer_manager_listeners_cow;
        for (int i = 0; i < peer_manager_listeners.size(); ++i) {
            ((PEPeerManagerListener)peer_manager_listeners.get(i)).destroyed();
        }
        this.is_destroyed = true;
    }

    public boolean isDestroyed() {
        return this.is_destroyed;
    }

    public DiskManager getDiskManager() {
        return this.disk_mgr;
    }

    public PiecePicker getPiecePicker() {
        return this.piecePicker;
    }

    public PEPeerManagerAdapter getAdapter() {
        return this.adapter;
    }

    public String getDisplayName() {
        return this.adapter.getDisplayName();
    }

    public void schedule() {
        try {
            this.updateTrackerAnnounceInterval();
            this.doConnectionChecks();
            this.processPieceChecks();
            if (!this.seeding_mode) {
                this.checkCompletedPieces();
            }
            this.checkBadPieces();
            this.updateStats();
            this.checkInterested();
            this.piecePicker.updateAvailability();
            this.checkCompletionState();
            this.checkSeeds();
            if (!this.seeding_mode) {
                this.checkRequests();
                this.piecePicker.allocateRequests();
                this.checkRescan();
                this.checkSpeedAndReserved();
                this.check99PercentBug();
            }
            this.updatePeersInSuperSeedMode();
            this.doUnchokes();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        ++this.mainloop_loop_count;
    }

    private void analyseTrackerResponse(TRTrackerAnnouncerResponse tracker_response) {
        Map extensions;
        TRTrackerAnnouncerResponsePeer[] peers = tracker_response.getPeers();
        if (peers != null) {
            this.addPeersFromTracker(tracker_response.getPeers());
        }
        if ((extensions = tracker_response.getExtensions()) != null) {
            this.addExtendedPeersFromTracker(extensions);
        }
    }

    public void processTrackerResponse(TRTrackerAnnouncerResponse response) {
        if (this.is_running) {
            this.analyseTrackerResponse(response);
        }
    }

    private void addExtendedPeersFromTracker(Map extensions) {
        Map protocols = (Map)extensions.get("protocols");
        if (protocols != null) {
            System.out.println("PEPeerControl: tracker response contained protocol extensions");
            for (String protocol_name : protocols.keySet()) {
                Map protocol = (Map)protocols.get(protocol_name);
                List transports = PEPeerTransportFactory.createExtendedTransports(this, protocol_name, protocol);
                for (int i = 0; i < transports.size(); ++i) {
                    PEPeer transport = (PEPeer)transports.get(i);
                    this.addPeer(transport);
                }
            }
        }
    }

    public List getPeers() {
        return this.peer_transports_cow;
    }

    public List getPeers(String address) {
        ArrayList<PEPeerTransport> result = new ArrayList<PEPeerTransport>();
        for (PEPeerTransport peer : this.peer_transports_cow) {
            if (!peer.getIp().equals(address)) continue;
            result.add(peer);
        }
        return result;
    }

    public PeerDescriptor[] getPendingPeers(String address) {
        return this.peer_database.getDiscoveredPeers();
    }

    public void addPeer(PEPeer _transport) {
        if (!(_transport instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport transport = (PEPeerTransport)_transport;
        if (!ip_filter.isInRange(transport.getIp(), this.getDisplayName(), this.getTorrentHash())) {
            ArrayList peer_transports = this.peer_transports_cow;
            if (!peer_transports.contains(transport)) {
                this.addToPeerTransports(transport);
                transport.start();
            } else {
                Debug.out("addPeer():: peer_transports.contains(transport): SHOULD NEVER HAPPEN !");
                transport.closeConnection("already connected");
            }
        } else {
            transport.closeConnection("IP address blocked by filters");
        }
    }

    protected byte[] getTorrentHash() {
        try {
            return this.disk_mgr.getTorrent().getHash();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void removePeer(PEPeer _transport) {
        this.removePeer(_transport, "remove peer");
    }

    public void removePeer(PEPeer _transport, String reason) {
        if (!(_transport instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport transport = (PEPeerTransport)_transport;
        this.closeAndRemovePeer(transport, reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndRemovePeer(PEPeerTransport peer, String reason, boolean log_if_not_found) {
        boolean removed = false;
        try {
            this.peer_transports_mon.enter();
            if (this.peer_transports_cow.contains(peer)) {
                ArrayList new_peer_transports = new ArrayList(this.peer_transports_cow);
                new_peer_transports.remove(peer);
                this.peer_transports_cow = new_peer_transports;
                removed = true;
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (removed) {
            peer.closeConnection(reason);
            this.peerRemoved(peer);
        } else if (log_if_not_found) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndRemoveAllPeers(String reason, boolean reconnect) {
        PEPeerTransport peer;
        int i;
        ArrayList peer_transports;
        try {
            this.peer_transports_mon.enter();
            peer_transports = this.peer_transports_cow;
            this.peer_transports_cow = new ArrayList(0);
        }
        finally {
            this.peer_transports_mon.exit();
        }
        for (i = 0; i < peer_transports.size(); ++i) {
            peer = (PEPeerTransport)peer_transports.get(i);
            try {
                peer.closeConnection(reason);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            try {
                this.peerRemoved(peer);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (reconnect) {
            for (i = 0; i < peer_transports.size(); ++i) {
                peer = (PEPeerTransport)peer_transports.get(i);
                PEPeerTransport reconnected_peer = peer.reconnect(false);
            }
        }
    }

    public void addPeer(String ip_address, int tcp_port, int udp_port, boolean use_crypto, Map user_data) {
        byte type = use_crypto ? (byte)1 : 0;
        PeerItem peer_item = PeerItemFactory.createPeerItem(ip_address, tcp_port, PeerItem.convertSourceID("Plugin"), type, udp_port, (byte)1, 0);
        byte crypto_level = 1;
        if (!this.isAlreadyConnected(peer_item)) {
            boolean udp_ok;
            boolean tcp_ok = TCPNetworkManager.TCP_OUTGOING_ENABLED && tcp_port > 0;
            boolean bl = udp_ok = UDPNetworkManager.UDP_OUTGOING_ENABLED && udp_port > 0;
            String fail_reason = tcp_ok && (!this.prefer_udp && !prefer_udp_default || !udp_ok) ? this.makeNewOutgoingConnection("Plugin", ip_address, tcp_port, udp_port, true, use_crypto, crypto_level, user_data) : (udp_ok ? this.makeNewOutgoingConnection("Plugin", ip_address, tcp_port, udp_port, false, use_crypto, crypto_level, user_data) : "No usable protocol");
            if (fail_reason != null) {
                Debug.out("Injected peer " + ip_address + ":" + tcp_port + " was not added - " + fail_reason);
            }
        }
    }

    private void addPeersFromTracker(TRTrackerAnnouncerResponsePeer[] peers) {
        for (int i = 0; i < peers.length; ++i) {
            int http_port;
            TRTrackerAnnouncerResponsePeer peer = peers[i];
            ArrayList peer_transports = this.peer_transports_cow;
            boolean already_connected = false;
            for (int x = 0; x < peer_transports.size(); ++x) {
                boolean same_allowed;
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(x);
                if (!peer.getAddress().equals(transport.getIp())) continue;
                boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || transport.getIp().equals("127.0.0.1");
                if (same_allowed && peer.getPort() != transport.getPort()) continue;
                already_connected = true;
                break;
            }
            if (already_connected) continue;
            if (this.peer_database != null) {
                byte type = peer.getProtocol() == 2 ? (byte)1 : 0;
                byte crypto_level = peer.getAZVersion() < 3 ? (byte)1 : 2;
                PeerItem item = PeerItemFactory.createPeerItem(peer.getAddress(), peer.getPort(), PeerItem.convertSourceID(peer.getSource()), type, peer.getUDPPort(), crypto_level, peer.getUploadSpeed());
                this.peer_database.addDiscoveredPeer(item);
            }
            if ((http_port = peer.getHTTPPort()) == 0) continue;
            this.adapter.addHTTPSeed(peer.getAddress(), http_port);
        }
    }

    private String makeNewOutgoingConnection(String peer_source, String address, int tcp_port, int udp_port, boolean use_tcp, boolean require_crypto, byte crypto_level, Map user_data) {
        boolean same_allowed;
        boolean force;
        if (ip_filter.isInRange(address, this.getDisplayName(), this.getTorrentHash())) {
            return "IPFilter block";
        }
        int needed = this.getMaxNewConnectionsAllowed();
        boolean bl = force = user_data != null && user_data.get(BuddyPluginTracker.PEER_KEY) != null;
        if (!(needed != 0 || peer_source == "Plugin" && this.doOptimisticDisconnect(AddressUtils.isLANLocalAddress(address) != 2, force))) {
            return "Too many connections";
        }
        boolean bl2 = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || address.equals("127.0.0.1");
        if (!same_allowed && PeerIdentityManager.containsIPAddress(this._hash, address)) {
            return "Already connected to IP";
        }
        if (PeerUtils.ignorePeerPort(tcp_port)) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Skipping connect with " + address + ":" + tcp_port + " as peer port is in ignore list."));
            }
            return "TCP port in ignore list";
        }
        PEPeerTransport real = PEPeerTransportFactory.createTransport(this, peer_source, address, tcp_port, udp_port, use_tcp, require_crypto, crypto_level, user_data);
        this.addToPeerTransports(real);
        return null;
    }

    private void checkCompletedPieces() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        for (int i = 0; i < this._nbPieces; ++i) {
            DiskManagerPiece dmPiece = this.dm_pieces[i];
            if (!dmPiece.isNeedsCheck()) continue;
            dmPiece.setChecking();
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(i, new Integer(1));
            req.setAdHoc(false);
            this.disk_mgr.enqueueCheckRequest(req, this);
        }
    }

    private boolean checkEmptyPiece(int pieceNumber) {
        if (this.piecePicker.isInEndGameMode()) {
            return false;
        }
        PEPieceImpl pePiece = this.pePieces[pieceNumber];
        DiskManagerPiece dmPiece = this.dm_pieces[pieceNumber];
        if (pePiece == null || pePiece.isRequested()) {
            return false;
        }
        if (dmPiece.getNbWritten() > 0 || pePiece.getNbUnrequested() < pePiece.getNbBlocks() || pePiece.getReservedBy() != null) {
            return false;
        }
        pePiece.reset();
        this.removePiece(pePiece, pieceNumber);
        return true;
    }

    private void checkSpeedAndReserved() {
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL != 0L) {
            return;
        }
        int nbPieces = this._nbPieces;
        PEPieceImpl[] pieces = this.pePieces;
        for (int i = 0; i < nbPieces; ++i) {
            this.checkEmptyPiece(i);
            PEPieceImpl pePiece = pieces[i];
            if (pePiece == null) continue;
            long timeSinceActivity = pePiece.getTimeSinceLastActivity() / 1000L;
            int pieceSpeed = pePiece.getSpeed();
            if (pieceSpeed > 0 && (double)(timeSinceActivity * (long)pieceSpeed) * 0.25 > 16.0) {
                if (pePiece.getNbUnrequested() > 2) {
                    pePiece.setSpeed(pieceSpeed - 1);
                } else {
                    pePiece.setSpeed(0);
                }
            }
            if (timeSinceActivity <= 120L) continue;
            pePiece.setSpeed(0);
            String reservingPeer = pePiece.getReservedBy();
            if (reservingPeer != null) {
                PEPeerTransport pt = this.getTransportFromAddress(reservingPeer);
                if (this.needsMD5CheckOnCompletion(i)) {
                    this.badPeerDetected(reservingPeer, true);
                } else if (pt != null) {
                    this.closeAndRemovePeer(pt, "Reserved piece data timeout; 120 seconds", true);
                }
                pePiece.setReservedBy(null);
            }
            if (!this.piecePicker.isInEndGameMode()) {
                pePiece.checkRequests();
            }
            this.checkEmptyPiece(i);
        }
    }

    private void check99PercentBug() {
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L) {
            long now = SystemTime.getCurrentTime();
            for (int i = 0; i < this.pePieces.length; ++i) {
                DiskManagerPiece dm_piece;
                PEPieceImpl pe_piece = this.pePieces[i];
                if (pe_piece == null || (dm_piece = this.dm_pieces[i]).isDone() || !pe_piece.isDownloaded() || now - pe_piece.getLastDownloadTime(now) <= (long)stalled_piece_timeout || this.disk_mgr.hasOutstandingWriteRequestForPiece(i) || this.disk_mgr.hasOutstandingReadRequestForPiece(i) || this.disk_mgr.hasOutstandingCheckRequestForPiece(i)) continue;
                Debug.out("Fully downloaded piece stalled pending write, resetting p_piece " + i);
                pe_piece.reset();
            }
        }
    }

    private void checkInterested() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        if (this.lastNeededUndonePieceChange >= this.piecePicker.getNeededUndonePieceChange()) {
            return;
        }
        this.lastNeededUndonePieceChange = this.piecePicker.getNeededUndonePieceChange();
        ArrayList peer_transports = this.peer_transports_cow;
        int cntPeersSnubbed = 0;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            peer.checkInterested();
            if (!peer.isSnubbed()) continue;
            ++cntPeersSnubbed;
        }
        this.setNbPeersSnubbed(cntPeersSnubbed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPieceChecks() {
        if (this.piece_check_result_list.size() > 0) {
            ArrayList pieces;
            try {
                this.piece_check_result_list_mon.enter();
                pieces = new ArrayList(this.piece_check_result_list);
                this.piece_check_result_list.clear();
            }
            finally {
                this.piece_check_result_list_mon.exit();
            }
            for (Object[] data : pieces) {
                this.processPieceCheckResult((DiskManagerCheckRequest)data[0], (Integer)data[1]);
            }
        }
    }

    private void checkBadPieces() {
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L && this.bad_piece_reported != -1) {
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(this.bad_piece_reported, new Integer(5));
            req.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rescanning reported-bad piece " + this.bad_piece_reported));
            }
            this.bad_piece_reported = -1;
            try {
                this.disk_mgr.enqueueCheckRequest(req, this);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private void checkRescan() {
        long piece_size;
        long millis_per_piece;
        if (this.rescan_piece_time == 0L) {
            return;
        }
        if (this.next_rescan_piece == -1) {
            if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL == 0L && this.adapter.isPeriodicRescanEnabled()) {
                this.next_rescan_piece = 0;
            }
        } else if (this.mainloop_loop_count % (long)MAINLOOP_TEN_MINUTE_INTERVAL == 0L && !this.adapter.isPeriodicRescanEnabled()) {
            this.next_rescan_piece = -1;
        }
        if (this.next_rescan_piece == -1) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        if (this.rescan_piece_time > now) {
            this.rescan_piece_time = now;
        }
        if (now - this.rescan_piece_time < (millis_per_piece = (piece_size = (long)this.disk_mgr.getPieceLength()) / 250L)) {
            return;
        }
        while (this.next_rescan_piece != -1) {
            int this_piece = this.next_rescan_piece++;
            if (this.next_rescan_piece == this._nbPieces) {
                this.next_rescan_piece = -1;
            }
            if (this.pePieces[this_piece] != null || this.dm_pieces[this_piece].isDone() || !this.dm_pieces[this_piece].isNeeded()) continue;
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(this_piece, new Integer(3));
            req.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rescanning piece " + this_piece));
            }
            this.rescan_piece_time = 0L;
            try {
                this.disk_mgr.enqueueCheckRequest(req, this);
            }
            catch (Throwable e) {
                this.rescan_piece_time = now;
                Debug.printStackTrace(e);
            }
            break;
        }
    }

    public void badPieceReported(PEPeerTransport originator, int piece_number) {
        Debug.outNoStack(this.getDisplayName() + ": bad piece #" + piece_number + " reported by " + originator.getIp());
        if (piece_number < 0 || piece_number >= this._nbPieces) {
            return;
        }
        this.bad_piece_reported = piece_number;
    }

    private void checkFinished(boolean start_of_day) {
        boolean all_pieces_done;
        boolean bl = all_pieces_done = this.disk_mgr.getRemainingExcludingDND() == 0L;
        if (all_pieces_done) {
            this.seeding_mode = true;
            this.prefer_udp_bloom = null;
            this.piecePicker.clearEndGameChunks();
            if (!start_of_day) {
                this.adapter.setStateFinishing();
            }
            this._timeFinished = SystemTime.getCurrentTime();
            ArrayList peer_transports = this.peer_transports_cow;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
                pc.setSnubbed(false);
            }
            this.setNbPeersSnubbed(0);
            boolean checkPieces = COConfigurationManager.getBooleanParameter("Check Pieces on Completion");
            if (checkPieces && !start_of_day) {
                DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(-1, new Integer(2));
                this.disk_mgr.enqueueCompleteRecheckRequest(req, this);
            }
            this._timeStartedSeeding = SystemTime.getCurrentTime();
            try {
                this.disk_mgr.saveResumeData(false);
            }
            catch (Throwable e) {
                Debug.out("Failed to save resume data", e);
            }
            this.adapter.setStateSeeding(start_of_day);
            this.disk_mgr.downloadEnded();
        } else {
            this.seeding_mode = false;
        }
    }

    protected void checkCompletionState() {
        boolean dm_done;
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        boolean bl = dm_done = this.disk_mgr.getRemainingExcludingDND() == 0L;
        if (this.seeding_mode) {
            if (!dm_done) {
                this.seeding_mode = false;
                this._timeStartedSeeding = -1L;
                this._timeFinished = 0L;
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Turning off seeding mode for PEPeerManager"));
            }
        } else if (dm_done) {
            this.checkFinished(false);
            if (this.seeding_mode) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Turning on seeding mode for PEPeerManager"));
            }
        }
    }

    private void checkRequests() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = peer_transports.size() - 1; i >= 0; --i) {
            int j;
            List expired;
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc.getPeerState() != 30 || (expired = pc.getExpiredRequests()) == null || expired.size() <= 0) continue;
            boolean isSeed = pc.isSeed();
            long timeSinceGoodData = pc.getTimeSinceGoodDataReceived();
            if (timeSinceGoodData < 0L || timeSinceGoodData > 60000L) {
                pc.setSnubbed(true);
            }
            DiskManagerReadRequest request2 = (DiskManagerReadRequest)expired.get(0);
            long timeSinceData = pc.getTimeSinceLastDataMessageReceived();
            boolean noData = timeSinceData < 0L || timeSinceData > (long)(1000 * (isSeed ? 120 : 60));
            long timeSinceOldestRequest = now - request2.getTimeCreated(now);
            int n = j = timeSinceOldestRequest > 120000L && noData ? 0 : 1;
            while (j < expired.size()) {
                request2 = (DiskManagerReadRequest)expired.get(j);
                pc.sendCancel(request2);
                int pieceNumber = request2.getPieceNumber();
                PEPieceImpl pe_piece = this.pePieces[pieceNumber];
                if (pe_piece != null) {
                    pe_piece.clearRequested(request2.getOffset() / 16384);
                }
                if (!this.piecePicker.isInEndGameMode()) {
                    this.checkEmptyPiece(pieceNumber);
                }
                ++j;
            }
        }
    }

    private void updateTrackerAnnounceInterval() {
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL != 0L) {
            return;
        }
        int WANT_LIMIT = 100;
        int num_wanted = this.getMaxNewConnectionsAllowed();
        boolean has_remote = this.adapter.isNATHealthy();
        if (has_remote) {
            num_wanted = (int)((double)num_wanted / 1.5);
        }
        if (num_wanted < 0 || num_wanted > 100) {
            num_wanted = 100;
        }
        int current_connection_count = PeerIdentityManager.getIdentityCount(this._hash);
        TRTrackerScraperResponse tsr = this.adapter.getTrackerScrapeResponse();
        if (tsr != null && tsr.isValid()) {
            int swarm_size;
            int num_seeds = tsr.getSeeds();
            int num_peers = tsr.getPeers();
            if (this.seeding_mode) {
                float ratio = (float)num_peers / (float)(num_seeds + num_peers);
                swarm_size = (int)((float)num_peers * ratio);
            } else {
                swarm_size = num_peers + num_seeds;
            }
            if (swarm_size < num_wanted) {
                num_wanted = swarm_size;
            }
        }
        if (num_wanted < 1) {
            this.adapter.setTrackerRefreshDelayOverrides(100);
            return;
        }
        if (current_connection_count == 0) {
            current_connection_count = 1;
        }
        int current_percent = current_connection_count * 100 / (current_connection_count + num_wanted);
        this.adapter.setTrackerRefreshDelayOverrides(current_percent);
    }

    public boolean hasDownloadablePiece() {
        return this.piecePicker.hasDownloadablePiece();
    }

    public int[] getAvailability() {
        return this.piecePicker.getAvailability();
    }

    public float getMinAvailability() {
        return this.piecePicker.getMinAvailability();
    }

    public float getAvgAvail() {
        return this.piecePicker.getAvgAvail();
    }

    public long getAvailWentBadTime() {
        return this.piecePicker.getAvailWentBadTime();
    }

    public void addPeerTransport(PEPeerTransport transport) {
        if (!ip_filter.isInRange(transport.getIp(), this.getDisplayName(), this.getTorrentHash())) {
            ArrayList peer_transports = this.peer_transports_cow;
            if (!peer_transports.contains(transport)) {
                this.addToPeerTransports(transport);
            } else {
                Debug.out("addPeerTransport():: peer_transports.contains(transport): SHOULD NEVER HAPPEN !");
                transport.closeConnection("already connected");
            }
        } else {
            transport.closeConnection("IP address blocked by filters");
        }
    }

    private void doUnchokes() {
        if (!UploadSlotManager.AUTO_SLOT_ENABLE) {
            if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
                return;
            }
            int max_to_unchoke = this.adapter.getMaxUploads();
            ArrayList peer_transports = this.peer_transports_cow;
            if (this.seeding_mode) {
                if (this.unchoker == null || !(this.unchoker instanceof SeedingUnchoker)) {
                    this.unchoker = new SeedingUnchoker();
                }
            } else if (this.unchoker == null || !(this.unchoker instanceof DownloadingUnchoker)) {
                this.unchoker = new DownloadingUnchoker();
            }
            if (this.mainloop_loop_count % (long)MAINLOOP_TEN_SECOND_INTERVAL == 0L) {
                boolean refresh = this.mainloop_loop_count % (long)MAINLOOP_THIRTY_SECOND_INTERVAL == 0L;
                this.unchoker.calculateUnchokes(max_to_unchoke, peer_transports, refresh, this.adapter.hasBuddies());
                ArrayList chokes = this.unchoker.getChokes();
                ArrayList unchokes = this.unchoker.getUnchokes();
                this.addFastUnchokes(unchokes);
                UnchokerUtil.performChokes(chokes, unchokes);
            } else if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL == 0L) {
                ArrayList unchokes = this.unchoker.getImmediateUnchokes(max_to_unchoke, peer_transports);
                this.addFastUnchokes(unchokes);
                UnchokerUtil.performChokes(null, unchokes);
            }
        }
    }

    private void addFastUnchokes(ArrayList peers_to_unchoke) {
        for (PEPeerTransport peer : this.peer_transports_cow) {
            if (peer.getConnectionState() != 4 || !UnchokerUtil.isUnchokable(peer, true) || peers_to_unchoke.contains(peer)) continue;
            if (peer.isLANLocal()) {
                peers_to_unchoke.add(peer);
                continue;
            }
            if (!fast_unchoke_new_peers || peer.getData("fast_unchoke_done") != null) continue;
            peer.setData("fast_unchoke_done", "");
            peers_to_unchoke.add(peer);
        }
    }

    private void sendHave(int pieceNumber) {
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            pc.sendHave(pieceNumber);
        }
    }

    private void checkSeeds() {
        int i;
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        if (!disconnect_seeds_when_seeding) {
            return;
        }
        ArrayList<PEPeerTransport> to_close = null;
        ArrayList peer_transports = this.peer_transports_cow;
        for (i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc == null || pc.getPeerState() != 30 || (!this.isSeeding() || !pc.isSeed()) && !pc.isRelativeSeed()) continue;
            if (to_close == null) {
                to_close = new ArrayList<PEPeerTransport>();
            }
            to_close.add(pc);
        }
        if (to_close != null) {
            for (i = 0; i < to_close.size(); ++i) {
                this.closeAndRemovePeer((PEPeerTransport)to_close.get(i), "disconnect other seed when seeding", false);
            }
        }
    }

    private void updateStats() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        ArrayList peer_transports = this.peer_transports_cow;
        int new_seeds = 0;
        int new_peers = 0;
        int newTcpRemotes = 0;
        for (PEPeerTransport pc : peer_transports) {
            if (pc.getPeerState() != 30) continue;
            if (pc.isSeed()) {
                ++new_seeds;
            } else {
                ++new_peers;
            }
            if (!pc.isIncoming() || !pc.isTCP() || pc.isLANLocal()) continue;
            ++newTcpRemotes;
        }
        this._seeds = new_seeds;
        this._peers = new_peers;
        this._remotesNoUdpNoLan = newTcpRemotes;
    }

    public void requestCanceled(DiskManagerReadRequest request2) {
        int pieceNumber = request2.getPieceNumber();
        PEPieceImpl pe_piece = this.pePieces[pieceNumber];
        if (pe_piece != null) {
            pe_piece.clearRequested(request2.getOffset() / 16384);
        }
    }

    public PEPeerControl getControl() {
        return this;
    }

    public byte[][] getSecrets(int crypto_level) {
        return this.adapter.getSecrets(crypto_level);
    }

    public byte[] getHash() {
        return this._hash.getDataID();
    }

    public PeerIdentityDataID getPeerIdentityDataID() {
        return this._hash;
    }

    public byte[] getPeerId() {
        return this._myPeerId;
    }

    public long getRemaining() {
        return this.disk_mgr.getRemaining();
    }

    public void discarded(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.discarded(peer, length);
            if (ban_peer_discard_ratio > 0.0f && !this.piecePicker.isInEndGameMode() && !this.piecePicker.hasEndGameModeBeenAbandoned()) {
                long discarded;
                long received = peer.getStats().getTotalDataBytesReceived();
                long non_discarded = received - (discarded = peer.getStats().getTotalBytesDiscarded());
                if (non_discarded < 0L) {
                    non_discarded = 0L;
                }
                if (discarded >= (long)(ban_peer_discard_min_kb * 1024) && (non_discarded == 0L || (float)discarded / (float)non_discarded >= ban_peer_discard_ratio)) {
                    this.badPeerDetected(peer.getIp(), false);
                }
            }
        }
    }

    public void dataBytesReceived(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.dataBytesReceived(peer, length);
            this._averageReceptionSpeed.addValue(length);
        }
    }

    public void protocolBytesReceived(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.protocolBytesReceived(peer, length);
        }
    }

    public void dataBytesSent(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.dataBytesSent(peer, length);
        }
    }

    public void protocolBytesSent(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.protocolBytesSent(peer, length);
        }
    }

    public void writeCompleted(DiskManagerWriteRequest request2) {
        int pieceNumber = request2.getPieceNumber();
        DiskManagerPiece dm_piece = this.dm_pieces[pieceNumber];
        if (!dm_piece.isDone()) {
            PEPieceImpl pePiece = this.pePieces[pieceNumber];
            if (pePiece != null) {
                pePiece.setWritten((PEPeer)request2.getUserData(), request2.getOffset() / 16384);
            } else {
                dm_piece.setWritten(request2.getOffset() / 16384);
            }
        }
    }

    public void writeFailed(DiskManagerWriteRequest request2, Throwable cause) {
    }

    public void writeBlock(int pieceNumber, int offset, DirectByteBuffer data, PEPeer sender, boolean cancel) {
        DiskManagerPiece dmPiece = this.dm_pieces[pieceNumber];
        int blockNumber = offset / 16384;
        if (dmPiece.isWritten(blockNumber)) {
            data.returnToPool();
            return;
        }
        PEPieceImpl pe_piece = this.pePieces[pieceNumber];
        if (pe_piece != null) {
            pe_piece.setDownloaded(offset);
        }
        DiskManagerWriteRequest request2 = this.disk_mgr.createWriteRequest(pieceNumber, offset, data, sender);
        this.disk_mgr.enqueueWriteRequest(request2, this);
        if (this.piecePicker.isInEndGameMode()) {
            this.piecePicker.removeFromEndGameModeChunks(pieceNumber, offset);
        }
        if (cancel || this.piecePicker.isInEndGameMode()) {
            ArrayList peer_transports = this.peer_transports_cow;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport connection = (PEPeerTransport)peer_transports.get(i);
                DiskManagerReadRequest dmr = this.disk_mgr.createReadRequest(pieceNumber, offset, dmPiece.getBlockSize(blockNumber));
                connection.sendCancel(dmr);
            }
        }
    }

    public boolean isWritten(int piece_number, int offset) {
        return this.dm_pieces[piece_number].isWritten(offset / 16384);
    }

    public boolean validateReadRequest(PEPeerTransport originator, int pieceNumber, int offset, int length) {
        if (this.disk_mgr.checkBlockConsistencyForRead(originator.getIp(), pieceNumber, offset, length)) {
            DiskManagerPiece dm_piece;
            int read_count;
            if (enable_seeding_piece_rechecks && this.isSeeding() && (read_count = (dm_piece = this.dm_pieces[pieceNumber]).getReadCount() & 0xFFFF) < 65525) {
                dm_piece.setReadCount((short)(++read_count));
            }
            return true;
        }
        return false;
    }

    public boolean validateHintRequest(PEPeerTransport originator, int pieceNumber, int offset, int length) {
        return this.disk_mgr.checkBlockConsistencyForHint(originator.getIp(), pieceNumber, offset, length);
    }

    public boolean validatePieceReply(PEPeerTransport originator, int pieceNumber, int offset, DirectByteBuffer data) {
        return this.disk_mgr.checkBlockConsistencyForWrite(originator.getIp(), pieceNumber, offset, data);
    }

    public int getAvailability(int pieceNumber) {
        return this.piecePicker.getAvailability(pieceNumber);
    }

    public void havePiece(int pieceNumber, int pieceLength, PEPeer pcOrigin) {
        int availability;
        this.piecePicker.addHavePiece(pcOrigin, pieceNumber);
        this._stats.haveNewPiece(pieceLength);
        if (this.superSeedMode) {
            this.superSeedPieces[pieceNumber].peerHasPiece(pcOrigin);
            if (pieceNumber == pcOrigin.getUniqueAnnounce()) {
                pcOrigin.setUniqueAnnounce(-1);
                --this.superSeedModeNumberOfAnnounces;
            }
        }
        if ((availability = this.piecePicker.getAvailability(pieceNumber) - 1) < 4) {
            if (this.dm_pieces[pieceNumber].isDone()) {
                --availability;
            }
            if (availability <= 0) {
                return;
            }
            ArrayList peer_transports = this.peer_transports_cow;
            for (int i = peer_transports.size() - 1; i >= 0; --i) {
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
                if (pc == pcOrigin || pc.getPeerState() != 30 || !pc.isPieceAvailable(pieceNumber)) continue;
                ((PEPeerStatsImpl)pc.getStats()).statisticalSentPiece(pieceLength / availability);
            }
        }
    }

    public int getPieceLength(int pieceNumber) {
        return this.disk_mgr.getPieceLength(pieceNumber);
    }

    public int getNbPeers() {
        return this._peers;
    }

    public int getNbSeeds() {
        return this._seeds;
    }

    public int getNbRemoteConnectionsExcludingUDP() {
        return this._remotesNoUdpNoLan;
    }

    public long getLastRemoteConnectionTime() {
        return this.last_remote_time;
    }

    public PEPeerManagerStats getStats() {
        return this._stats;
    }

    public int getNbPeersStalledPendingLoad() {
        int res = 0;
        for (PEPeerTransport transport : this.peer_transports_cow) {
            if (!transport.isStalledPendingLoad()) continue;
            ++res;
        }
        return res;
    }

    public long getETA() {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_eta_calculation || now - this.last_eta_calculation > 900L) {
            long result;
            long dataRemaining = this.disk_mgr.getRemainingExcludingDND();
            if (dataRemaining > 0L) {
                int writtenNotChecked = 0;
                for (int i = 0; i < this._nbPieces; ++i) {
                    if (!this.dm_pieces[i].isInteresting()) continue;
                    writtenNotChecked += this.dm_pieces[i].getNbWritten() * 16384;
                }
                if ((dataRemaining -= (long)writtenNotChecked) < 0L) {
                    dataRemaining = 0L;
                }
            }
            if (dataRemaining == 0L) {
                long timeElapsed = (this._timeFinished - this._timeStarted) / 1000L;
                result = timeElapsed > 1L ? timeElapsed * -1L : 0L;
            } else {
                long lETA;
                long averageSpeed = this._averageReceptionSpeed.getAverage();
                long l = lETA = averageSpeed == 0L ? 1827387392L : dataRemaining / averageSpeed;
                if (lETA == 0L) {
                    lETA = 1L;
                }
                result = lETA;
            }
            this.last_eta = result;
            this.last_eta_calculation = now;
        }
        return this.last_eta;
    }

    public boolean isRTA() {
        return this.piecePicker.getRTAProviders().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToPeerTransports(PEPeerTransport peer) {
        List limiters;
        boolean added = false;
        try {
            this.peer_transports_mon.enter();
            if (peer.getPeerState() == 50) {
                return;
            }
            if (this.peer_transports_cow.contains(peer)) {
                Debug.out("Transport added twice");
                return;
            }
            if (this.is_running) {
                ArrayList<PEPeerTransport> new_peer_transports = new ArrayList<PEPeerTransport>(this.peer_transports_cow.size() + 1);
                new_peer_transports.addAll(this.peer_transports_cow);
                new_peer_transports.add(peer);
                this.peer_transports_cow = new_peer_transports;
                added = true;
            }
            limiters = this.external_rate_limiters_cow;
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (added) {
            long connect_time;
            if (peer.isIncoming() && (connect_time = SystemTime.getCurrentTime()) > this.last_remote_time) {
                this.last_remote_time = connect_time;
            }
            if (limiters != null) {
                for (int i = 0; i < limiters.size(); ++i) {
                    Object[] entry = (Object[])limiters.get(i);
                    peer.addRateLimiter((LimitedRateGroup)entry[0], (Boolean)entry[1]);
                }
            }
            this.peerAdded(peer);
        } else {
            peer.closeConnection("PeerTransport added when manager not running");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRateLimiter(LimitedRateGroup group, boolean upload) {
        ArrayList transports;
        try {
            this.peer_transports_mon.enter();
            ArrayList<Object[]> new_limiters = new ArrayList<Object[]>(this.external_rate_limiters_cow == null ? 1 : this.external_rate_limiters_cow.size() + 1);
            if (this.external_rate_limiters_cow != null) {
                new_limiters.addAll(this.external_rate_limiters_cow);
            }
            new_limiters.add(new Object[]{group, new Boolean(upload)});
            this.external_rate_limiters_cow = new_limiters;
            transports = this.peer_transports_cow;
        }
        finally {
            this.peer_transports_mon.exit();
        }
        for (int i = 0; i < transports.size(); ++i) {
            ((PEPeerTransport)transports.get(i)).addRateLimiter(group, upload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRateLimiter(LimitedRateGroup group, boolean upload) {
        ArrayList transports;
        try {
            this.peer_transports_mon.enter();
            if (this.external_rate_limiters_cow != null) {
                ArrayList<Object[]> new_limiters = new ArrayList<Object[]>(this.external_rate_limiters_cow.size() - 1);
                for (int i = 0; i < this.external_rate_limiters_cow.size(); ++i) {
                    Object[] entry = (Object[])this.external_rate_limiters_cow.get(i);
                    if (entry[0] == group) continue;
                    new_limiters.add(entry);
                }
                this.external_rate_limiters_cow = new_limiters.size() == 0 ? null : new_limiters;
            }
            transports = this.peer_transports_cow;
        }
        finally {
            this.peer_transports_mon.exit();
        }
        for (int i = 0; i < transports.size(); ++i) {
            ((PEPeerTransport)transports.get(i)).removeRateLimiter(group, upload);
        }
    }

    public int getUploadRateLimitBytesPerSecond() {
        return this.adapter.getUploadRateLimitBytesPerSecond();
    }

    public int getDownloadRateLimitBytesPerSecond() {
        return this.adapter.getDownloadRateLimitBytesPerSecond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peerConnectionClosed(PEPeerTransport peer, boolean connect_failed, boolean network_failed) {
        boolean connection_found = false;
        boolean tcpReconnect = false;
        try {
            boolean canTryUDP;
            this.peer_transports_mon.enter();
            int udpPort = peer.getUDPListenPort();
            boolean bl = canTryUDP = UDPNetworkManager.UDP_OUTGOING_ENABLED && peer.getUDPListenPort() > 0;
            if (this.is_running) {
                PeerItem peer_item = peer.getPeerItemIdentity();
                PeerItem self_item = this.peer_database.getSelfPeer();
                if (self_item == null || !self_item.equals(peer_item)) {
                    String ip = peer.getIp();
                    String key = ip + ":" + udpPort;
                    if (peer.isTCP()) {
                        if (connect_failed) {
                            if (canTryUDP && udp_fallback_for_failed_connection) {
                                this.pending_nat_traversals.put(key, peer);
                            }
                        } else if (canTryUDP && udp_fallback_for_dropped_connection && network_failed && this.seeding_mode && peer.isInterested() && !peer.isSeed() && !peer.isRelativeSeed() && peer.getStats().getEstimatedSecondsToCompletion() > 60L && FeatureAvailability.isUDPPeerReconnectEnabled()) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)peer, LOGID, 1, "Unexpected stream closure detected, attempting recovery"));
                            }
                            this.udp_reconnects.put(key, peer);
                        } else if (network_failed && peer.isSafeForReconnect() && (!this.seeding_mode || !peer.isSeed() && !peer.isRelativeSeed() && peer.getStats().getEstimatedSecondsToCompletion() >= 60L) && this.getMaxConnections() > 0 && this.getMaxNewConnectionsAllowed() > this.getMaxConnections() / 3 && FeatureAvailability.isGeneralPeerReconnectEnabled()) {
                            tcpReconnect = true;
                        }
                    } else if (connect_failed && udp_fallback_for_failed_connection && peer.getData(PEER_NAT_TRAVERSE_DONE_KEY) == null) {
                        this.pending_nat_traversals.put(key, peer);
                    }
                }
            }
            if (this.peer_transports_cow.contains(peer)) {
                ArrayList new_peer_transports = new ArrayList(this.peer_transports_cow);
                new_peer_transports.remove(peer);
                this.peer_transports_cow = new_peer_transports;
                connection_found = true;
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (connection_found) {
            if (peer.getPeerState() != 50) {
                System.out.println("peer.getPeerState() != PEPeer.DISCONNECTED: " + peer.getPeerState());
            }
            this.peerRemoved(peer);
        }
        if (tcpReconnect) {
            peer.reconnect(false);
        }
    }

    public void peerAdded(PEPeer pc) {
        this.adapter.addPeer(pc);
        ArrayList peer_manager_listeners = this.peer_manager_listeners_cow;
        for (int i = 0; i < peer_manager_listeners.size(); ++i) {
            ((PEPeerManagerListener)peer_manager_listeners.get(i)).peerAdded(this, pc);
        }
    }

    public void peerRemoved(PEPeer pc) {
        String reserved_by;
        PEPieceImpl pe_piece;
        int reserved_piece;
        int piece;
        int udp;
        if (this.is_running && !this.seeding_mode && (this.prefer_udp || prefer_udp_default) && (udp = pc.getUDPListenPort()) != 0 && udp == pc.getTCPListenPort()) {
            BloomFilter filter = this.prefer_udp_bloom;
            if (filter == null) {
                filter = this.prefer_udp_bloom = BloomFilterFactory.createAddOnly(10000);
            }
            if (filter.getEntryCount() < 1000) {
                filter.add(pc.getIp().getBytes());
            }
        }
        if ((piece = pc.getUniqueAnnounce()) != -1 && this.superSeedMode) {
            --this.superSeedModeNumberOfAnnounces;
            this.superSeedPieces[piece].peerLeft();
        }
        if ((reserved_piece = pc.getReservedPieceNumber()) >= 0 && (pe_piece = this.pePieces[reserved_piece]) != null && (reserved_by = pe_piece.getReservedBy()) != null && reserved_by.equals(pc.getIp())) {
            pe_piece.setReservedBy(null);
        }
        this.adapter.removePeer(pc);
        ArrayList peer_manager_listeners = this.peer_manager_listeners_cow;
        for (int i = 0; i < peer_manager_listeners.size(); ++i) {
            ((PEPeerManagerListener)peer_manager_listeners.get(i)).peerRemoved(this, pc);
        }
    }

    public void addPiece(PEPiece piece, int pieceNumber) {
        this.addPiece(piece, pieceNumber, false);
    }

    protected void addPiece(PEPiece piece, int pieceNumber, boolean force_add) {
        this.pePieces[pieceNumber] = (PEPieceImpl)piece;
        ++this.nbPiecesActive;
        if (this.is_running || force_add) {
            this.adapter.addPiece(piece);
        }
    }

    public void removePiece(PEPiece pePiece, int pieceNumber) {
        if (pePiece != null) {
            this.adapter.removePiece(pePiece);
        }
        this.pePieces[pieceNumber] = null;
        --this.nbPiecesActive;
    }

    public int getNbActivePieces() {
        return this.nbPiecesActive;
    }

    public String getElapsedTime() {
        return TimeFormatter.format((SystemTime.getCurrentTime() - this._timeStarted) / 1000L);
    }

    public long getTimeStarted() {
        return this._timeStarted;
    }

    public long getTimeStartedSeeding() {
        return this._timeStartedSeeding;
    }

    private byte[] computeMd5Hash(DirectByteBuffer buffer) {
        BrokenMd5Hasher md5 = new BrokenMd5Hasher();
        md5.reset();
        int position = buffer.position((byte)8);
        md5.update(buffer.getBuffer((byte)8));
        buffer.position((byte)8, position);
        ByteBuffer md5Result = ByteBuffer.allocate(16);
        md5Result.position(0);
        md5.finalDigest(md5Result);
        byte[] result = new byte[16];
        md5Result.position(0);
        for (int i = 0; i < result.length; ++i) {
            result[i] = md5Result.get();
        }
        return result;
    }

    private void MD5CheckPiece(PEPiece piece, boolean correct) {
        String[] writers = piece.getWriters();
        int offset = 0;
        for (int i = 0; i < writers.length; ++i) {
            DirectByteBuffer buffer;
            int length = piece.getBlockSize(i);
            String peer = writers[i];
            if (peer != null && (buffer = this.disk_mgr.readBlock(piece.getPieceNumber(), offset, length)) != null) {
                byte[] hash = this.computeMd5Hash(buffer);
                buffer.returnToPool();
                buffer = null;
                piece.addWrite(i, peer, hash, correct);
            }
            offset += length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(passed ? 1 : 0)});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCancelled(DiskManagerCheckRequest request2) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(2)});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(0)});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    public boolean needsMD5CheckOnCompletion(int pieceNumber) {
        PEPieceImpl piece = this.pePieces[pieceNumber];
        if (piece == null) {
            return false;
        }
        return piece.getPieceWrites().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPieceCheckResult(DiskManagerCheckRequest request2, int outcome) {
        block41: {
            int check_type = (Integer)request2.getUserData();
            try {
                int pieceNumber = request2.getPieceNumber();
                if (check_type == 2) {
                    if (outcome == 0) {
                        Debug.out(this.getDisplayName() + ": Piece #" + pieceNumber + " failed final re-check. Re-downloading...");
                        if (!this.restart_initiated) {
                            this.restart_initiated = true;
                            this.adapter.restartDownload(true);
                        }
                    }
                    return;
                }
                if (check_type == 4 || check_type == 5) {
                    if (outcome == 0) {
                        if (check_type == 4) {
                            Debug.out(this.getDisplayName() + "Piece #" + pieceNumber + " failed recheck while seeding. Re-downloading...");
                        } else {
                            Debug.out(this.getDisplayName() + "Piece #" + pieceNumber + " failed recheck after being reported as bad. Re-downloading...");
                        }
                        Logger.log(new LogAlert((Object)this, true, 3, "Download '" + this.getDisplayName() + "': piece " + pieceNumber + " has been corrupted, re-downloading"));
                        if (!this.restart_initiated) {
                            this.restart_initiated = true;
                            this.adapter.restartDownload(true);
                        }
                    }
                    return;
                }
                PEPieceImpl pePiece = this.pePieces[pieceNumber];
                if (outcome == 1) {
                    try {
                        if (pePiece != null) {
                            List list;
                            if (this.needsMD5CheckOnCompletion(pieceNumber)) {
                                this.MD5CheckPiece(pePiece, true);
                            }
                            if ((list = pePiece.getPieceWrites()).size() > 0) {
                                for (int i = 0; i < pePiece.getNbBlocks(); ++i) {
                                    List listPerBlock = pePiece.getPieceWrites(i);
                                    byte[] correctHash = null;
                                    for (PEPieceWriteImpl write : listPerBlock) {
                                        if (!write.isCorrect()) continue;
                                        correctHash = write.getHash();
                                    }
                                    if (correctHash == null) continue;
                                    for (PEPieceWriteImpl write : listPerBlock) {
                                        if (Arrays.equals(write.getHash(), correctHash)) continue;
                                        this.badPeerDetected(write.getSender(), true);
                                    }
                                }
                            }
                        }
                        break block41;
                    }
                    finally {
                        this.removePiece(pePiece, pieceNumber);
                        this.sendHave(pieceNumber);
                    }
                }
                if (outcome == 0) {
                    if (pePiece != null) {
                        try {
                            this.MD5CheckPiece(pePiece, false);
                            String[] writers = pePiece.getWriters();
                            ArrayList<String> uniqueWriters = new ArrayList<String>();
                            int[] writesPerWriter = new int[writers.length];
                            for (int i = 0; i < writers.length; ++i) {
                                String writer = writers[i];
                                if (writer == null) continue;
                                int writerId = uniqueWriters.indexOf(writer);
                                if (writerId == -1) {
                                    uniqueWriters.add(writer);
                                    writerId = uniqueWriters.size() - 1;
                                }
                                int n = writerId;
                                writesPerWriter[n] = writesPerWriter[n] + 1;
                            }
                            int nbWriters = uniqueWriters.size();
                            if (nbWriters == 1) {
                                String bad_ip = (String)uniqueWriters.get(0);
                                PEPeerTransport bad_peer = this.getTransportFromAddress(bad_ip);
                                if (bad_peer != null) {
                                    bad_peer.sendBadPiece(pieceNumber);
                                }
                                this.badPeerDetected(bad_ip, true);
                                pePiece.reset();
                            } else if (nbWriters > 1) {
                                int i;
                                int maxWrites = 0;
                                String bestWriter = null;
                                PEPeer bestWriter_transport = null;
                                for (i = 0; i < uniqueWriters.size(); ++i) {
                                    String writer;
                                    PEPeerTransport pt;
                                    int writes = writesPerWriter[i];
                                    if (writes <= maxWrites || (pt = this.getTransportFromAddress(writer = (String)uniqueWriters.get(i))) == null || pt.getReservedPieceNumber() != -1 || ip_filter.isInRange(writer, this.getDisplayName(), this.getTorrentHash())) continue;
                                    bestWriter = writer;
                                    maxWrites = writes;
                                    bestWriter_transport = pt;
                                }
                                if (bestWriter != null) {
                                    pePiece.setReservedBy(bestWriter);
                                    bestWriter_transport.setReservedPieceNumber(pePiece.getPieceNumber());
                                    pePiece.setRequestable();
                                    for (i = 0; i < pePiece.getNbBlocks(); ++i) {
                                        if (writers[i] != null && writers[i].equals(bestWriter)) continue;
                                        pePiece.reDownloadBlock(i);
                                    }
                                } else {
                                    pePiece.reset();
                                }
                            } else {
                                pePiece.reset();
                            }
                            this.piecePicker.addEndGameChunks(pePiece);
                            this._stats.hashFailed(pePiece.getLength());
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            pePiece.reset();
                        }
                    } else {
                        Debug.out(this.getDisplayName() + "Piece #" + pieceNumber + " failed check and no active piece, resetting...");
                        this.dm_pieces[pieceNumber].reset();
                    }
                }
            }
            finally {
                if (check_type == 3) {
                    this.rescan_piece_time = SystemTime.getCurrentTime();
                }
                if (!this.seeding_mode) {
                    this.checkFinished(false);
                }
            }
        }
    }

    private void badPeerDetected(String ip, boolean hash_fail) {
        int ps;
        PEPeerTransport peer = this.getTransportFromAddress(ip);
        IpFilterManager filter_manager = IpFilterManagerFactory.getSingleton();
        int nbWarnings = filter_manager.getBadIps().addWarningForIp(ip);
        boolean disconnect_peer = false;
        if (nbWarnings > 2) {
            if (COConfigurationManager.getBooleanParameter("Ip Filter Enable Banning")) {
                if (ip_filter.ban(ip, this.getDisplayName(), false)) {
                    this.checkForBannedConnections();
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)peer, LOGID, 3, ip + " : has been banned and won't be able " + "to connect until you restart azureus"));
                }
                disconnect_peer = true;
            }
        } else if (!hash_fail) {
            disconnect_peer = true;
        }
        if (disconnect_peer && peer != null && (ps = peer.getPeerState()) != 40 && ps != 50) {
            this.closeAndRemovePeer(peer, "has sent too many " + (hash_fail ? "bad pieces" : "discarded blocks") + ", " + 2 + " max.", true);
        }
    }

    public PEPiece[] getPieces() {
        return this.pePieces;
    }

    public PEPiece getPiece(int pieceNumber) {
        return this.pePieces[pieceNumber];
    }

    public PEPeerStats createPeerStats(PEPeer owner) {
        return new PEPeerStatsImpl(owner);
    }

    public DiskManagerReadRequest createDiskManagerRequest(int pieceNumber, int offset, int length) {
        return this.disk_mgr.createReadRequest(pieceNumber, offset, length);
    }

    public boolean requestExists(String peer_ip, int piece_number, int offset, int length) {
        ArrayList peer_transports = this.peer_transports_cow;
        DiskManagerReadRequest request2 = null;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
            if (!conn.getIp().equals(peer_ip)) continue;
            if (request2 == null) {
                request2 = this.createDiskManagerRequest(piece_number, offset, length);
            }
            if (conn.getRequestIndex(request2) == -1) continue;
            return true;
        }
        return false;
    }

    public boolean seedPieceRecheck() {
        DiskManagerPiece dm_piece;
        if (!enable_seeding_piece_rechecks && !this.isSeeding()) {
            return false;
        }
        int max_reads = 0;
        int max_reads_index = 0;
        for (int i = 0; i < this.dm_pieces.length; ++i) {
            DiskManagerPiece dm_piece2 = this.dm_pieces[i];
            if (!dm_piece2.isDone()) continue;
            int num = dm_piece2.getReadCount() & 0xFFFF;
            if (num > 65526) {
                if (--num == 65526) {
                    num = 0;
                }
                dm_piece2.setReadCount((short)num);
                continue;
            }
            if (num <= max_reads) continue;
            max_reads = num;
            max_reads_index = i;
        }
        if (max_reads > 0 && max_reads >= (dm_piece = this.dm_pieces[max_reads_index]).getNbBlocks() * 3) {
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(max_reads_index, new Integer(4));
            req.setAdHoc(true);
            req.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rechecking piece " + max_reads_index + " while seeding as most active"));
            }
            this.disk_mgr.enqueueCheckRequest(req, this);
            dm_piece.setReadCount((short)-1);
            for (int i = 0; i < this.dm_pieces.length; ++i) {
                int num;
                if (i == max_reads_index || (num = this.dm_pieces[i].getReadCount() & 0xFFFF) >= 65526) continue;
                this.dm_pieces[i].setReadCount((short)0);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PEPeerManagerListener l) {
        try {
            this.this_mon.enter();
            ArrayList<PEPeerManagerListener> peer_manager_listeners = new ArrayList<PEPeerManagerListener>(this.peer_manager_listeners_cow.size() + 1);
            peer_manager_listeners.addAll(this.peer_manager_listeners_cow);
            peer_manager_listeners.add(l);
            this.peer_manager_listeners_cow = peer_manager_listeners;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PEPeerManagerListener l) {
        try {
            this.this_mon.enter();
            ArrayList peer_manager_listeners = new ArrayList(this.peer_manager_listeners_cow);
            peer_manager_listeners.remove(l);
            this.peer_manager_listeners_cow = peer_manager_listeners;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void parameterChanged(String parameterName) {
        if (parameterName.equals("Ip Filter Enabled")) {
            this.checkForBannedConnections();
        }
    }

    private void checkForBannedConnections() {
        if (ip_filter.isEnabled()) {
            int i;
            ArrayList<PEPeerTransport> to_close = null;
            ArrayList peer_transports = this.peer_transports_cow;
            String name = this.getDisplayName();
            byte[] hash = this.getTorrentHash();
            for (i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
                if (!ip_filter.isInRange(conn.getIp(), name, hash)) continue;
                if (to_close == null) {
                    to_close = new ArrayList<PEPeerTransport>();
                }
                to_close.add(conn);
            }
            if (to_close != null) {
                for (i = 0; i < to_close.size(); ++i) {
                    this.closeAndRemovePeer((PEPeerTransport)to_close.get(i), "IPFilter banned IP address", true);
                }
            }
        }
    }

    public boolean isSeeding() {
        return this.seeding_mode;
    }

    public boolean isInEndGameMode() {
        return this.piecePicker.isInEndGameMode();
    }

    public boolean isSuperSeedMode() {
        return this.superSeedMode;
    }

    public boolean canToggleSuperSeedMode() {
        if (this.superSeedMode) {
            return true;
        }
        return this.superSeedPieces == null && this.getRemaining() == 0L;
    }

    public void setSuperSeedMode(boolean _superSeedMode) {
        if (_superSeedMode == this.superSeedMode) {
            return;
        }
        boolean kick_peers = false;
        if (_superSeedMode) {
            if (this.superSeedPieces == null && this.getRemaining() == 0L) {
                this.superSeedMode = true;
                this.initialiseSuperSeedMode();
                kick_peers = true;
            }
        } else {
            this.superSeedMode = false;
            kick_peers = true;
        }
        if (kick_peers) {
            ArrayList peer_transports = this.peer_transports_cow;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
                this.closeAndRemovePeer(conn, "Turning on super-seeding", false);
            }
        }
    }

    private void initialiseSuperSeedMode() {
        this.superSeedPieces = new SuperSeedPiece[this._nbPieces];
        for (int i = 0; i < this._nbPieces; ++i) {
            this.superSeedPieces[i] = new SuperSeedPiece(this, i);
        }
    }

    private void updatePeersInSuperSeedMode() {
        if (!this.superSeedMode) {
            return;
        }
        for (int i = 0; i < this.superSeedPieces.length; ++i) {
            this.superSeedPieces[i].updateTime();
        }
        int nbUnchoke = this.adapter.getMaxUploads();
        if (this.superSeedModeNumberOfAnnounces >= 2 * nbUnchoke) {
            return;
        }
        PEPeer selectedPeer = null;
        ArrayList<SuperSeedPeer> sortedPeers = null;
        ArrayList peer_transports = this.peer_transports_cow;
        sortedPeers = new ArrayList<SuperSeedPeer>(peer_transports.size());
        Iterator iter = peer_transports.iterator();
        while (iter.hasNext()) {
            sortedPeers.add(new SuperSeedPeer((PEPeer)iter.next()));
        }
        Collections.sort(sortedPeers);
        iter = sortedPeers.iterator();
        while (iter.hasNext()) {
            PEPeer peer = ((SuperSeedPeer)iter.next()).peer;
            if (peer.getUniqueAnnounce() != -1 || peer.getPeerState() != 30) continue;
            selectedPeer = peer;
            break;
        }
        if (selectedPeer == null || selectedPeer.getPeerState() >= 40) {
            return;
        }
        if (selectedPeer.getUploadHint() == 0) {
            selectedPeer.setUploadHint(31536000);
        }
        boolean found = false;
        SuperSeedPiece piece = null;
        while (!found) {
            piece = this.superSeedPieces[this.superSeedModeCurrentPiece];
            if (piece.getLevel() > 0) {
                piece = null;
                ++this.superSeedModeCurrentPiece;
                if (this.superSeedModeCurrentPiece < this._nbPieces) continue;
                this.superSeedModeCurrentPiece = 0;
                this.superSeedMode = false;
                this.closeAndRemoveAllPeers("quiting SuperSeed mode", true);
                return;
            }
            found = true;
        }
        if (piece == null) {
            return;
        }
        if (selectedPeer.isPieceAvailable(piece.getPieceNumber())) {
            return;
        }
        selectedPeer.setUniqueAnnounce(piece.getPieceNumber());
        ++this.superSeedModeNumberOfAnnounces;
        piece.pieceRevealedToPeer();
        ((PEPeerTransport)selectedPeer).sendHave(piece.getPieceNumber());
    }

    public void updateSuperSeedPiece(PEPeer peer, int pieceNumber) {
        if (!this.superSeedMode) {
            return;
        }
        this.superSeedPieces[pieceNumber].peerHasPiece(null);
        if (peer.getUniqueAnnounce() == pieceNumber) {
            peer.setUniqueAnnounce(-1);
            --this.superSeedModeNumberOfAnnounces;
        }
    }

    public boolean isExtendedMessagingEnabled() {
        return this.adapter.isExtendedMessagingEnabled();
    }

    public boolean isPeerExchangeEnabled() {
        return this.adapter.isPeerExchangeEnabled();
    }

    public LimitedRateGroup getUploadLimitedRateGroup() {
        return this.upload_limited_rate_group;
    }

    public LimitedRateGroup getDownloadLimitedRateGroup() {
        return this.download_limited_rate_group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData(String key) {
        try {
            this.this_mon.enter();
            if (this.user_data == null) {
                Object var2_2 = null;
                return var2_2;
            }
            Object v = this.user_data.get(key);
            return v;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String key, Object value) {
        try {
            this.this_mon.enter();
            if (this.user_data == null) {
                this.user_data = new HashMap();
            }
            if (value == null) {
                if (this.user_data.containsKey(key)) {
                    this.user_data.remove(key);
                }
            } else {
                this.user_data.put(key, value);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void doConnectionChecks() {
        int goal;
        long last_update;
        ArrayList peer_transports;
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL == 0L) {
            int allowed;
            int to_disconnect;
            peer_transports = this.peer_transports_cow;
            int num_waiting_establishments = 0;
            int udp_connections = 0;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(i);
                int state = transport.getConnectionState();
                if (state == 0 || state == 1) {
                    ++num_waiting_establishments;
                }
                if (transport.isTCP()) continue;
                ++udp_connections;
            }
            int allowed_seeds = this.getMaxSeedConnections();
            if (allowed_seeds > 0 && (to_disconnect = this._seeds - allowed_seeds) > 0) {
                for (int i = peer_transports.size() - 1; i >= 0 && to_disconnect > 0; --i) {
                    PEPeerTransport transport = (PEPeerTransport)peer_transports.get(i);
                    if (!transport.isSeed()) continue;
                    this.closeAndRemovePeer(transport, "Too many seeds", false);
                    --to_disconnect;
                }
            }
            if ((allowed = this.getMaxNewConnectionsAllowed()) < 0 || allowed > 1000) {
                allowed = 1000;
            }
            if (this.adapter.isNATHealthy()) {
                int free = this.getMaxConnections() / 20;
                allowed -= free;
            }
            if (allowed > 0) {
                PeerItem item;
                int wanted = TCPConnectionManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS - num_waiting_establishments;
                if (wanted > allowed) {
                    num_waiting_establishments += wanted - allowed;
                }
                int remaining = allowed;
                int tcp_remaining = TCPNetworkManager.getSingleton().getConnectDisconnectManager().getMaxOutboundPermitted();
                int udp_remaining = UDPNetworkManager.getSingleton().getConnectionManager().getMaxOutboundPermitted();
                while (num_waiting_establishments < TCPConnectionManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS && (tcp_remaining > 0 || udp_remaining > 0) && this.is_running && (item = this.peer_database.getNextOptimisticConnectPeer()) != null && this.is_running) {
                    boolean udp_ok;
                    boolean prefer_udp_overall;
                    PeerItem self = this.peer_database.getSelfPeer();
                    if (self != null && self.equals(item) || this.isAlreadyConnected(item)) continue;
                    String source = PeerItem.convertSourceString(item.getSource());
                    boolean use_crypto = item.getHandshakeType() == 1;
                    int tcp_port = item.getTCPPort();
                    int udp_port = item.getUDPPort();
                    if (udp_port == 0 && udp_probe_enabled) {
                        udp_port = tcp_port;
                    }
                    boolean bl = prefer_udp_overall = this.prefer_udp || prefer_udp_default;
                    if (prefer_udp_overall && udp_port == 0) {
                        byte[] address = item.getIP().getBytes();
                        BloomFilter bloom = this.prefer_udp_bloom;
                        if (bloom != null && bloom.contains(address)) {
                            udp_port = tcp_port;
                        }
                    }
                    boolean tcp_ok = TCPNetworkManager.TCP_OUTGOING_ENABLED && tcp_port > 0 && tcp_remaining > 0;
                    boolean bl2 = udp_ok = UDPNetworkManager.UDP_OUTGOING_ENABLED && udp_port > 0 && udp_remaining > 0;
                    if (!(!tcp_ok || prefer_udp_overall && udp_ok)) {
                        if (this.makeNewOutgoingConnection(source, item.getAddressString(), tcp_port, udp_port, true, use_crypto, item.getCryptoLevel(), null) != null) continue;
                        --tcp_remaining;
                        ++num_waiting_establishments;
                        --remaining;
                        continue;
                    }
                    if (!udp_ok || this.makeNewOutgoingConnection(source, item.getAddressString(), tcp_port, udp_port, false, use_crypto, item.getCryptoLevel(), null) != null) continue;
                    --udp_remaining;
                    ++num_waiting_establishments;
                    --remaining;
                }
                if (UDPNetworkManager.UDP_OUTGOING_ENABLED && remaining > 0 && udp_remaining > 0 && udp_connections < 16) {
                    this.doUDPConnectionChecks(remaining);
                }
            }
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL == 0L) {
            peer_transports = this.peer_transports_cow;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(i);
                if (transport.doTimeoutChecks()) continue;
                transport.doKeepAliveCheck();
                transport.doPerformanceTuningCheck();
            }
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_TEN_SECOND_INTERVAL == 0L && (last_update = ip_filter.getLastUpdateTime()) != this.ip_filter_last_update_time) {
            this.ip_filter_last_update_time = last_update;
            this.checkForBannedConnections();
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_THIRTY_SECOND_INTERVAL == 0L && this.getMaxNewConnectionsAllowed() == 0) {
            this.doOptimisticDisconnect(false, false);
        }
        float percentage = ((float)(this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL) + 1.0f) / (1.0f * (float)MAINLOOP_SIXTY_SECOND_INTERVAL);
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L) {
            goal = 0;
            this.sweepList = this.peer_transports_cow;
        } else {
            goal = (int)Math.floor(percentage * (float)this.sweepList.size());
        }
        for (int i = this.nextPEXSweepIndex; i < goal && i < this.sweepList.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)this.sweepList.get(i);
            peer.updatePeerExchange();
        }
        this.nextPEXSweepIndex = goal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUDPConnectionChecks(int number) {
        ArrayList<PEPeerTransport> new_connections = null;
        try {
            this.peer_transports_mon.enter();
            long now = SystemTime.getCurrentTime();
            if (this.udp_reconnects.size() > 0 && now - this.last_udp_reconnect >= 10000L) {
                this.last_udp_reconnect = now;
                Iterator it = this.udp_reconnects.values().iterator();
                PEPeerTransport peer = (PEPeerTransport)it.next();
                it.remove();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)this, LOGID, 0, "Reconnecting to previous failed peer " + peer.getPeerItemIdentity().getAddressString()));
                }
                if (new_connections == null) {
                    new_connections = new ArrayList<PEPeerTransport>();
                }
                new_connections.add(peer);
                if (--number <= 0) {
                    return;
                }
            }
            if (this.pending_nat_traversals.size() == 0) {
                return;
            }
            int max = 3;
            if (this.seeding_mode) {
                max = this._peers > 8 ? 0 : 1;
            } else if (this._seeds > 8) {
                max = 0;
            } else if (this._seeds > 4) {
                max = 1;
            }
            int avail = max - this.udp_traversal_count;
            int to_do = Math.min(number, avail);
            Iterator it = this.pending_nat_traversals.values().iterator();
            while (to_do > 0 && it.hasNext()) {
                --to_do;
                final PEPeerTransport peer = (PEPeerTransport)it.next();
                it.remove();
                PeerNATTraverser.getSingleton().create(this, new InetSocketAddress(peer.getPeerItemIdentity().getAddressString(), peer.getPeerItemIdentity().getUDPPort()), new PeerNATTraversalAdapter(){
                    private boolean done;

                    public void success(InetSocketAddress target) {
                        this.complete();
                        PEPeerTransport newTransport = peer.reconnect(true);
                        if (newTransport != null) {
                            newTransport.setData(PEER_NAT_TRAVERSE_DONE_KEY, "");
                        }
                    }

                    public void failed() {
                        this.complete();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void complete() {
                        try {
                            PEPeerControlImpl.this.peer_transports_mon.enter();
                            if (!this.done) {
                                this.done = true;
                                PEPeerControlImpl.this.udp_traversal_count--;
                            }
                        }
                        finally {
                            PEPeerControlImpl.this.peer_transports_mon.exit();
                        }
                    }
                });
                ++this.udp_traversal_count;
            }
        }
        finally {
            this.peer_transports_mon.exit();
            if (new_connections != null) {
                for (int i = 0; i < new_connections.size(); ++i) {
                    PEPeerTransport peer_item = (PEPeerTransport)new_connections.get(i);
                    peer_item.reconnect(true);
                }
            }
        }
    }

    public boolean doOptimisticDisconnect(boolean pending_lan_local_peer, boolean force) {
        ArrayList peer_transports = this.peer_transports_cow;
        PEPeerTransport max_transport = null;
        PEPeerTransport max_seed_transport = null;
        PEPeerTransport max_non_lan_transport = null;
        long max_time = 0L;
        long max_seed_time = 0L;
        long max_non_lan_time = 0L;
        int lan_peer_count = 0;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            if (peer.getConnectionState() != 4) continue;
            long timeSinceSentData = peer.getTimeSinceLastDataMessageSent();
            long peerTestTime = 0L;
            if (this.seeding_mode) {
                if (timeSinceSentData != -1L) {
                    peerTestTime = timeSinceSentData;
                }
            } else {
                long timeSinceGoodData = peer.getTimeSinceGoodDataReceived();
                long timeSinceConnection = peer.getTimeSinceConnectionEstablished();
                peerTestTime = timeSinceGoodData == -1L ? (peerTestTime += timeSinceConnection) : (peerTestTime += timeSinceGoodData);
                if (!peer.isInteresting()) {
                    peerTestTime = !peer.isInterested() ? (peerTestTime += timeSinceConnection + timeSinceSentData) : (peerTestTime += timeSinceConnection - timeSinceSentData);
                    peerTestTime *= 2L;
                }
                peerTestTime += peer.getSnubbedTime();
            }
            if (!peer.isIncoming()) {
                peerTestTime *= 2L;
            }
            if (peer.isLANLocal()) {
                ++lan_peer_count;
            } else if (peerTestTime > max_non_lan_time) {
                max_non_lan_time = peerTestTime;
                max_non_lan_transport = peer;
            }
            if (!this.seeding_mode) {
                PEPeerStats pestats;
                peerTestTime += peer.getSnubbedTime();
                if (peer.getSnubbedTime() > 120L) {
                    peerTestTime = (long)((double)peerTestTime * 1.5);
                }
                if ((pestats = peer.getStats()).getTotalDataBytesReceived() + pestats.getTotalDataBytesSent() < 524288L) {
                    if (peer.isSnubbed() && pestats.getTotalDataBytesReceived() < pestats.getTotalDataBytesSent()) {
                        peerTestTime = (long)((double)peerTestTime * 1.5);
                    }
                    if (pestats.getTotalDataBytesSent() > pestats.getTotalDataBytesReceived() * 10L) {
                        peerTestTime *= 2L;
                    }
                    if (pestats.getTotalDataBytesReceived() > 0L) {
                        peerTestTime = (long)((double)peerTestTime * (1.0 + (double)pestats.getTotalBytesDiscarded() / (double)pestats.getTotalDataBytesReceived()));
                    }
                }
            }
            if (peerTestTime > max_time) {
                max_time = peerTestTime;
                max_transport = peer;
            }
            if (!peer.isSeed() && !peer.isRelativeSeed() || peerTestTime <= max_seed_time) continue;
            max_seed_time = peerTestTime;
            max_seed_transport = peer;
        }
        if (max_transport != null) {
            int LAN_PEER_MAX = 4;
            if (max_transport.isLANLocal() && lan_peer_count < 4 && max_non_lan_transport != null) {
                max_transport = max_non_lan_transport;
                max_time = max_non_lan_time;
            }
            if (this.getMaxSeedConnections() > 0 && max_seed_transport != null && max_time > 300000L) {
                this.closeAndRemovePeer(max_seed_transport, "timed out by doOptimisticDisconnect()", true);
                return true;
            }
            if (max_transport != null && max_time > 300000L) {
                this.closeAndRemovePeer(max_transport, "timed out by doOptimisticDisconnect()", true);
                return true;
            }
            if (pending_lan_local_peer && lan_peer_count < 4) {
                this.closeAndRemovePeer(max_transport, "making space for LAN peer in doOptimisticDisconnect()", true);
                return true;
            }
            if (force) {
                this.closeAndRemovePeer(max_transport, "force removal of worst peer in doOptimisticDisconnect()", true);
                return true;
            }
        } else if (force && peer_transports.size() > 0) {
            PEPeerTransport pt = (PEPeerTransport)peer_transports.get(new Random().nextInt(peer_transports.size()));
            this.closeAndRemovePeer(pt, "force removal of random peer in doOptimisticDisconnect()", true);
            return true;
        }
        return false;
    }

    public PeerExchangerItem createPeerExchangeConnection(final PEPeerTransport base_peer) {
        if (base_peer.getTCPListenPort() > 0) {
            PeerItem peer = PeerItemFactory.createPeerItem(base_peer.getIp(), base_peer.getTCPListenPort(), (byte)2, base_peer.getPeerItemIdentity().getHandshakeType(), base_peer.getUDPListenPort(), (byte)1, 0);
            return this.peer_database.registerPeerConnection(peer, new PeerExchangerItem.Helper(){

                public boolean isSeed() {
                    return base_peer.isSeed();
                }
            });
        }
        return null;
    }

    private boolean isAlreadyConnected(PeerItem peer_id) {
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            if (!peer.getPeerItemIdentity().equals(peer_id)) continue;
            return true;
        }
        return false;
    }

    public void peerVerifiedAsSelf(PEPeerTransport self) {
        if (self.getTCPListenPort() > 0) {
            PeerItem peer = PeerItemFactory.createPeerItem(self.getIp(), self.getTCPListenPort(), PeerItem.convertSourceID(self.getPeerSource()), self.getPeerItemIdentity().getHandshakeType(), self.getUDPListenPort(), (byte)2, 0);
            this.peer_database.setSelfPeer(peer);
        }
    }

    public boolean canIPBeBanned(String ip) {
        return true;
    }

    public boolean canIPBeBlocked(String ip, byte[] torrent_hash) {
        return true;
    }

    public long getHiddenBytes() {
        if (this.hidden_piece < 0) {
            return 0L;
        }
        return this.dm_pieces[this.hidden_piece].getLength();
    }

    public int getHiddenPiece() {
        return this.hidden_piece;
    }

    public void IPBlockedListChanged(IpFilter filter) {
        Iterator it = this.peer_transports_cow.iterator();
        String name = this.getDisplayName();
        byte[] hash = this.getTorrentHash();
        while (it.hasNext()) {
            try {
                PEPeerTransport peer = (PEPeerTransport)it.next();
                if (!filter.isInRange(peer.getIp(), name, hash)) continue;
                peer.closeConnection("IP address blocked by filters");
            }
            catch (Exception e) {}
        }
    }

    public void IPBanned(BannedIp ip) {
        for (int i = 0; i < this._nbPieces; ++i) {
            if (this.pePieces[i] == null) continue;
            this.pePieces[i].reDownloadBlocks(ip.getIp());
        }
    }

    public int getAverageCompletionInThousandNotation() {
        ArrayList peer_transports = this.peer_transports_cow;
        if (peer_transports != null) {
            long total = this.disk_mgr.getTotalLength();
            int my_completion = total == 0L ? 1000 : (int)(1000L * (total - this.disk_mgr.getRemainingExcludingDND()) / total);
            int sum = my_completion == 1000 ? 0 : my_completion;
            int num = my_completion == 1000 ? 0 : 1;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeer peer = (PEPeer)peer_transports.get(i);
                if (peer.getPeerState() != 30 || peer.isSeed()) continue;
                ++num;
                sum += peer.getPercentDoneInThousandNotation();
            }
            return num > 0 ? sum / num : 0;
        }
        return -1;
    }

    public int getMaxConnections() {
        return this.adapter.getMaxConnections();
    }

    public int getMaxSeedConnections() {
        return this.adapter.getMaxSeedConnections();
    }

    public int getMaxNewConnectionsAllowed() {
        int dl_max = this.getMaxConnections();
        int allowed_peers = PeerUtils.numNewConnectionsAllowed(this.getPeerIdentityDataID(), dl_max);
        return allowed_peers;
    }

    public int getSchedulePriority() {
        return this.isSeeding() ? Integer.MAX_VALUE : this.adapter.getPosition();
    }

    public boolean hasPotentialConnections() {
        return this.pending_nat_traversals.size() + this.peer_database.getDiscoveredPeerCount() > 0;
    }

    public String getRelationText() {
        return this.adapter.getLogRelation().getRelationText();
    }

    public Object[] getQueryableInterfaces() {
        return this.adapter.getLogRelation().getQueryableInterfaces();
    }

    public PEPeerTransport getTransportFromIdentity(byte[] peer_id) {
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
            if (!Arrays.equals(peer_id, conn.getId())) continue;
            return conn;
        }
        return null;
    }

    public PEPeerTransport getTransportFromAddress(String peer) {
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport pt = (PEPeerTransport)peer_transports.get(i);
            if (!peer.equals(pt.getIp())) continue;
            return pt;
        }
        return null;
    }

    public void incNbPeersSnubbed() {
        ++this.nbPeersSnubbed;
    }

    public void decNbPeersSnubbed() {
        --this.nbPeersSnubbed;
    }

    public void setNbPeersSnubbed(int n) {
        this.nbPeersSnubbed = n;
    }

    public int getNbPeersSnubbed() {
        return this.nbPeersSnubbed;
    }

    public boolean getPreferUDP() {
        return this.prefer_udp;
    }

    public void setPreferUDP(boolean prefer) {
        this.prefer_udp = prefer;
    }

    public boolean isPeerSourceEnabled(String peer_source) {
        return this.adapter.isPeerSourceEnabled(peer_source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEvidence(IndentWriter writer) {
        writer.println("PeerManager: seeding=" + this.seeding_mode);
        writer.println("    udp_fb=" + this.pending_nat_traversals.size() + ",udp_tc=" + this.udp_traversal_count + ",pd=[" + this.peer_database.getString() + "]");
        String pending_udp = "";
        try {
            this.peer_transports_mon.enter();
            for (PEPeerTransport peer : this.pending_nat_traversals.values()) {
                pending_udp = pending_udp + (pending_udp.length() == 0 ? "" : ",") + peer.getPeerItemIdentity().getAddressString() + ":" + peer.getPeerItemIdentity().getUDPPort();
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (pending_udp.length() > 0) {
            writer.println("    pending_udp=" + pending_udp);
        }
        List traversals = PeerNATTraverser.getSingleton().getTraversals(this);
        String active_udp = "";
        for (InetSocketAddress ad : traversals) {
            active_udp = active_udp + (active_udp.length() == 0 ? "" : ",") + ad.getAddress().getHostAddress() + ":" + ad.getPort();
        }
        if (active_udp.length() > 0) {
            writer.println("    active_udp=" + active_udp);
        }
        if (!this.seeding_mode) {
            int i;
            int num;
            String str;
            writer.println("  Active Pieces");
            int num_active = 0;
            try {
                writer.indent();
                str = "";
                num = 0;
                for (i = 0; i < this.pePieces.length; ++i) {
                    PEPieceImpl piece = this.pePieces[i];
                    if (piece == null) continue;
                    ++num_active;
                    str = str + (str.length() == 0 ? "" : ",") + "#" + i + " " + this.dm_pieces[i].getString() + ": " + piece.getString();
                    if (++num != 20) continue;
                    writer.println(str);
                    str = "";
                    num = 0;
                }
                if (num > 0) {
                    writer.println(str);
                }
            }
            finally {
                writer.exdent();
            }
            if (num_active == 0) {
                writer.println("  Inactive Pieces (excluding done/skipped)");
                try {
                    writer.indent();
                    str = "";
                    num = 0;
                    for (i = 0; i < this.dm_pieces.length; ++i) {
                        DiskManagerPiece dm_piece = this.dm_pieces[i];
                        if (!dm_piece.isInteresting()) continue;
                        str = str + (str.length() == 0 ? "" : ",") + "#" + i + " " + this.dm_pieces[i].getString();
                        if (++num != 20) continue;
                        writer.println(str);
                        str = "";
                        num = 0;
                    }
                    if (num > 0) {
                        writer.println(str);
                    }
                }
                finally {
                    writer.exdent();
                }
            }
            this.piecePicker.generateEvidence(writer);
        }
        try {
            this.peer_transports_mon.enter();
            writer.println("Peers: total = " + this.peer_transports_cow.size());
            writer.indent();
            try {
                writer.indent();
                for (PEPeerTransport peer : this.peer_transports_cow) {
                    peer.generateEvidence(writer);
                }
            }
            finally {
                writer.exdent();
            }
        }
        finally {
            this.peer_transports_mon.exit();
            writer.exdent();
        }
        this.disk_mgr.generateEvidence(writer);
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Disconnect Seed", "Seeding Piece Check Recheck Enable", "peercontrol.stalled.piece.write.timeout", "Peer.Fast.Initial.Unchoke.Enabled", "Ip Filter Ban Discard Ratio", "Ip Filter Ban Discard Min KB", "peercontrol.udp.fallback.connect.fail", "peercontrol.udp.fallback.connect.drop", "peercontrol.udp.probe.enable", "peercontrol.hide.piece", "peercontrol.prefer.udp"}, new ParameterListener(){

            public void parameterChanged(String name) {
                disconnect_seeds_when_seeding = COConfigurationManager.getBooleanParameter("Disconnect Seed");
                enable_seeding_piece_rechecks = COConfigurationManager.getBooleanParameter("Seeding Piece Check Recheck Enable");
                stalled_piece_timeout = COConfigurationManager.getIntParameter("peercontrol.stalled.piece.write.timeout", 60000);
                fast_unchoke_new_peers = COConfigurationManager.getBooleanParameter("Peer.Fast.Initial.Unchoke.Enabled");
                ban_peer_discard_ratio = COConfigurationManager.getFloatParameter("Ip Filter Ban Discard Ratio");
                ban_peer_discard_min_kb = COConfigurationManager.getIntParameter("Ip Filter Ban Discard Min KB");
                udp_fallback_for_failed_connection = COConfigurationManager.getBooleanParameter("peercontrol.udp.fallback.connect.fail");
                udp_fallback_for_dropped_connection = COConfigurationManager.getBooleanParameter("peercontrol.udp.fallback.connect.drop");
                udp_probe_enabled = COConfigurationManager.getBooleanParameter("peercontrol.udp.probe.enable");
                hide_a_piece = COConfigurationManager.getBooleanParameter("peercontrol.hide.piece");
                if (hide_a_piece) {
                    disconnect_seeds_when_seeding = false;
                }
                prefer_udp_default = COConfigurationManager.getBooleanParameter("peercontrol.prefer.udp");
            }
        });
        ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
        MAINLOOP_ONE_SECOND_INTERVAL = 1000 / PeerControlScheduler.SCHEDULE_PERIOD_MILLIS;
        MAINLOOP_FIVE_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 5;
        MAINLOOP_TEN_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 10;
        MAINLOOP_THIRTY_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 30;
        MAINLOOP_SIXTY_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 60;
        MAINLOOP_TEN_MINUTE_INTERVAL = MAINLOOP_SIXTY_SECOND_INTERVAL * 10;
        PEER_NAT_TRAVERSE_DONE_KEY = PEPeerControlImpl.class.getName() + "::nat_trav_done";
    }
}

