/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.util;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtilsListener;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;

public class TRTrackerUtils {
    private static String[] BLACKLISTED_HOSTS = new String[]{"krypt.dyndns.org"};
    private static int[] BLACKLISTED_PORTS = new int[]{81};
    private static String tracker_ip;
    private static Map override_map;
    private static String bind_ip;
    private static String ports_for_url;
    private static String ports_for_url_with_crypto;
    private static CopyOnWriteList listeners;
    private static AEThread2 listener_thread;
    private static Map az_trackers;
    private static Map udp_probe_results;

    private static String computePortsForURL(boolean force_crypto, boolean allow_incoming) {
        int udp_port_num;
        int tcp_port_num;
        boolean socks_peer_inform = COConfigurationManager.getBooleanParameter("Proxy.Data.Enable") && COConfigurationManager.getBooleanParameter("Proxy.Data.SOCKS.inform");
        if (allow_incoming &= !COConfigurationManager.getBooleanParameter("Tracker Client No Port Announce")) {
            if (socks_peer_inform) {
                tcp_port_num = 0;
                udp_port_num = 0;
            } else {
                tcp_port_num = COConfigurationManager.getIntParameter("TCP.Listen.Port");
                udp_port_num = COConfigurationManager.getIntParameter("UDP.Listen.Port");
            }
            String portOverride = COConfigurationManager.getStringParameter("TCP.Listen.Port.Override");
            if (!portOverride.equals("")) {
                try {
                    tcp_port_num = Integer.parseInt(portOverride);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        } else {
            tcp_port_num = 0;
            udp_port_num = 0;
        }
        String port = "";
        if (force_crypto) {
            port = port + "&requirecrypto=1";
            port = port + "&port=0&cryptoport=" + tcp_port_num;
        } else {
            boolean require_crypto = COConfigurationManager.getBooleanParameter("network.transport.encrypted.require");
            port = require_crypto ? port + "&requirecrypto=1" : port + "&supportcrypto=1";
            port = require_crypto && !COConfigurationManager.getBooleanParameter("network.transport.encrypted.fallback.incoming") && COConfigurationManager.getBooleanParameter("network.transport.encrypted.use.crypto.port") ? port + "&port=0&cryptoport=" + tcp_port_num : port + "&port=" + tcp_port_num;
            port = port + "&azudp=" + udp_port_num;
            if (tcp_port_num == 0) {
                port = port + "&hide=1";
            }
            if (COConfigurationManager.getBooleanParameter("HTTP.Data.Listen.Port.Enable")) {
                int http_port = COConfigurationManager.getIntParameter("HTTP.Data.Listen.Port.Override");
                if (http_port == 0) {
                    http_port = COConfigurationManager.getIntParameter("HTTP.Data.Listen.Port");
                }
                port = port + "&azhttp=" + http_port;
            }
        }
        return port;
    }

    public static String getPublicIPOverride() {
        String explicit_ips = COConfigurationManager.getStringParameter("Override Ip", "");
        if (explicit_ips.length() > 0) {
            StringTokenizer tok = new StringTokenizer(explicit_ips, ";");
            while (tok.hasMoreTokens()) {
                String cat;
                String this_address = tok.nextToken().trim();
                if (this_address.length() <= 0 || (cat = AENetworkClassifier.categoriseAddress(this_address)) != "Public") continue;
                return this_address;
            }
        }
        return null;
    }

    static void readConfig() {
        tracker_ip = COConfigurationManager.getStringParameter("Tracker IP", "");
        tracker_ip = UrlUtils.expandIPV6Host(tracker_ip);
        String override_ips = COConfigurationManager.getStringParameter("Override Ip", "");
        StringTokenizer tok = new StringTokenizer(override_ips, ";");
        HashMap<String, String> new_override_map = new HashMap<String, String>();
        while (tok.hasMoreTokens()) {
            String ip = tok.nextToken().trim();
            if (ip.length() <= 0) continue;
            new_override_map.put(AENetworkClassifier.categoriseAddress(ip), ip);
        }
        override_map = new_override_map;
        InetAddress bad = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
        bind_ip = bad == null || bad.isAnyLocalAddress() ? "" : bad.getHostAddress();
    }

    public static boolean isHosting(URL url_in) {
        return tracker_ip.length() > 0 && UrlUtils.expandIPV6Host(url_in.getHost()).equalsIgnoreCase(tracker_ip);
    }

    public static String getTrackerIP() {
        return tracker_ip;
    }

    public static boolean isTrackerEnabled() {
        return TRTrackerUtils.getAnnounceURLs().length > 0;
    }

    public static URL[][] getAnnounceURLs() {
        ArrayList<URL> l;
        String tracker_host = COConfigurationManager.getStringParameter("Tracker IP", "");
        ArrayList urls = new ArrayList();
        if (tracker_host.length() > 0) {
            int i;
            List ports;
            ArrayList<URL> l2;
            int port;
            if (COConfigurationManager.getBooleanParameter("Tracker Port Enable")) {
                port = COConfigurationManager.getIntParameter("Tracker Port", 6969);
                try {
                    l2 = new ArrayList<URL>();
                    l2.add(new URL("http://" + UrlUtils.convertIPV6Host(tracker_host) + ":" + port + "/announce"));
                    ports = TRTrackerUtils.stringToPorts(COConfigurationManager.getStringParameter("Tracker Port Backups"));
                    for (i = 0; i < ports.size(); ++i) {
                        l2.add(new URL("http://" + UrlUtils.convertIPV6Host(tracker_host) + ":" + (Integer)ports.get(i) + "/announce"));
                    }
                    urls.add(l2);
                }
                catch (MalformedURLException e) {
                    Debug.printStackTrace(e);
                }
            }
            if (COConfigurationManager.getBooleanParameter("Tracker Port SSL Enable")) {
                port = COConfigurationManager.getIntParameter("Tracker Port SSL", 7000);
                try {
                    l2 = new ArrayList();
                    l2.add(new URL("https://" + UrlUtils.convertIPV6Host(tracker_host) + ":" + port + "/announce"));
                    ports = TRTrackerUtils.stringToPorts(COConfigurationManager.getStringParameter("Tracker Port SSL Backups"));
                    for (i = 0; i < ports.size(); ++i) {
                        l2.add(new URL("https://" + UrlUtils.convertIPV6Host(tracker_host) + ":" + (Integer)ports.get(i) + "/announce"));
                    }
                    urls.add(l2);
                }
                catch (MalformedURLException e) {
                    Debug.printStackTrace(e);
                }
            }
            if (COConfigurationManager.getBooleanParameter("Tracker Port UDP Enable")) {
                port = COConfigurationManager.getIntParameter("Tracker Port", 6969);
                boolean auth = COConfigurationManager.getBooleanParameter("Tracker Password Enable Torrent");
                try {
                    l = new ArrayList<URL>();
                    l.add(new URL("udp://" + UrlUtils.convertIPV6Host(tracker_host) + ":" + port + "/announce" + (auth ? "?auth" : "")));
                    urls.add(l);
                }
                catch (MalformedURLException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        URL[][] res = new URL[urls.size()][];
        for (int i = 0; i < urls.size(); ++i) {
            l = (ArrayList<URL>)urls.get(i);
            URL[] u = new URL[l.size()];
            l.toArray(u);
            res[i] = u;
        }
        return res;
    }

    protected static List stringToPorts(String str) {
        str = str.replace(',', ';');
        StringTokenizer tok = new StringTokenizer(str, ";");
        ArrayList<Integer> res = new ArrayList<Integer>();
        while (tok.hasMoreTokens()) {
            try {
                res.add(new Integer(tok.nextToken().trim()));
            }
            catch (Throwable e) {
                Debug.out("Invalid port entry in '" + str + "'", e);
            }
        }
        return res;
    }

    public static URL adjustURLForHosting(URL url_in) {
        if (TRTrackerUtils.isHosting(url_in)) {
            String url = url_in.getProtocol() + "://";
            url = bind_ip.length() < 7 ? url + "127.0.0.1" : url + bind_ip;
            int port = url_in.getPort();
            if (port != -1) {
                url = url + ":" + url_in.getPort();
            }
            url = url + url_in.getPath();
            String query = url_in.getQuery();
            if (query != null) {
                url = url + "?" + query;
            }
            try {
                return new URL(url);
            }
            catch (MalformedURLException e) {
                Debug.printStackTrace(e);
            }
        }
        return url_in;
    }

    public static String adjustHostFromHosting(String host_in) {
        if (tracker_ip.length() > 0) {
            String address_type = AENetworkClassifier.categoriseAddress(host_in);
            String target_ip = (String)override_map.get(address_type);
            if (target_ip == null) {
                target_ip = tracker_ip;
            }
            if (host_in.equals("127.0.0.1")) {
                return target_ip;
            }
            if (host_in.equals(bind_ip)) {
                return target_ip;
            }
        }
        return host_in;
    }

    public static boolean isLoopback(String host) {
        return host.equals("127.0.0.1") || host.equals(bind_ip);
    }

    public static void checkForBlacklistedURLs(URL url) throws IOException {
        for (int i = 0; i < BLACKLISTED_HOSTS.length; ++i) {
            if (!url.getHost().equalsIgnoreCase(BLACKLISTED_HOSTS[i]) || url.getPort() != BLACKLISTED_PORTS[i]) continue;
            throw new IOException("http://" + BLACKLISTED_HOSTS[i] + ":" + BLACKLISTED_PORTS[i] + "/ is not a tracker");
        }
    }

    public static Map mergeResponseCache(Map map1, Map map2) {
        return TRTrackerBTAnnouncerImpl.mergeResponseCache(map1, map2);
    }

    public static String getPortsForURL() {
        return ports_for_url;
    }

    public static String getPortsForURLFullCrypto() {
        return ports_for_url_with_crypto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAZTracker(URL tracker_url) {
        String host = tracker_url.getHost();
        if (Constants.isAzureusDomain(host)) {
            return true;
        }
        Map map = az_trackers;
        synchronized (map) {
            return az_trackers.containsKey(host + ":" + tracker_url.getPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAZTracker(URL tracker_url, boolean az_tracker) {
        String key = tracker_url.getHost() + ":" + tracker_url.getPort();
        Map map = az_trackers;
        synchronized (map) {
            boolean changed = false;
            if (az_trackers.get(key) == null) {
                if (az_tracker) {
                    az_trackers.put(key, new Long(SystemTime.getCurrentTime()));
                    changed = true;
                }
            } else if (!az_tracker && az_trackers.remove(key) != null) {
                changed = true;
            }
            if (changed) {
                COConfigurationManager.setParameter("Tracker Client AZ Instances", az_trackers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUDPProbeOK(URL tracker_url) {
        String host = tracker_url.getHost();
        if (Constants.isAzureusDomain(host)) {
            return false;
        }
        Map map = udp_probe_results;
        synchronized (map) {
            return udp_probe_results.containsKey(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUDPProbeResult(URL tracker_url, boolean probe_ok) {
        String key = tracker_url.getHost();
        Map map = udp_probe_results;
        synchronized (map) {
            boolean changed = false;
            if (udp_probe_results.get(key) == null) {
                if (probe_ok) {
                    if (udp_probe_results.size() > 512) {
                        udp_probe_results.clear();
                    }
                    udp_probe_results.put(key, new Long(SystemTime.getCurrentTime()));
                    changed = true;
                }
            } else if (!probe_ok && udp_probe_results.remove(key) != null) {
                changed = true;
            }
            if (changed) {
                COConfigurationManager.setParameter("Tracker Client UDP Probe Results", udp_probe_results);
            }
        }
    }

    public static void addListener(TRTrackerUtilsListener l) {
        listeners.add(l);
    }

    public static void removeListener(TRTrackerUtilsListener l) {
        listeners.remove(l);
    }

    static {
        listeners = new CopyOnWriteList();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Proxy.Data.Enable", "Proxy.Data.SOCKS.inform", "TCP.Listen.Port.Override", "Tracker Client No Port Announce", "network.transport.encrypted.use.crypto.port", "network.transport.encrypted.require", "network.transport.encrypted.fallback.incoming", "TCP.Listen.Port", "UDP.Listen.Port", "HTTP.Data.Listen.Port", "HTTP.Data.Listen.Port.Override", "HTTP.Data.Listen.Port.Enable", "Tracker Client Min Announce Interval"}, new ParameterListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void parameterChanged(String parameterName) {
                String port = TRTrackerUtils.computePortsForURL(false, true);
                String port_with_crypto = TRTrackerUtils.computePortsForURL(true, false);
                if (ports_for_url != null && !ports_for_url.equals(port)) {
                    CopyOnWriteList copyOnWriteList = listeners;
                    synchronized (copyOnWriteList) {
                        if (listener_thread == null) {
                            listener_thread = new AEThread2("TRTrackerUtils:listener", true){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    try {
                                        Thread.sleep(30000L);
                                    }
                                    catch (Throwable e) {
                                        // empty catch block
                                    }
                                    CopyOnWriteList e = listeners;
                                    synchronized (e) {
                                        listener_thread = null;
                                    }
                                    Iterator it = listeners.iterator();
                                    while (it.hasNext()) {
                                        try {
                                            ((TRTrackerUtilsListener)it.next()).announceDetailsChanged();
                                        }
                                        catch (Throwable e2) {
                                            Debug.printStackTrace(e2);
                                        }
                                    }
                                }
                            };
                            listener_thread.start();
                        }
                    }
                }
                ports_for_url = port;
                ports_for_url_with_crypto = port_with_crypto;
            }
        });
        az_trackers = COConfigurationManager.getMapParameter("Tracker Client AZ Instances", new HashMap());
        udp_probe_results = COConfigurationManager.getMapParameter("Tracker Client UDP Probe Results", new HashMap());
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                TRTrackerUtils.readConfig();
            }
        });
        NetworkAdmin.getSingleton().addPropertyChangeListener(new NetworkAdminPropertyChangeListener(){

            public void propertyChanged(String property) {
                if (property == "Default Bind IP") {
                    TRTrackerUtils.readConfig();
                }
            }
        });
        TRTrackerUtils.readConfig();
    }
}

