/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.instancemanager.AZInstance;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;

public class AddressUtils {
    public static final byte LAN_LOCAL_MAYBE = 0;
    public static final byte LAN_LOCAL_YES = 1;
    public static final byte LAN_LOCAL_NO = 2;
    private static AZInstanceManager instance_manager;
    private static Map host_map;

    public static URL adjustURL(URL url) {
        String rewrite;
        url = AEProxyFactory.getAddressMapper().internalise(url);
        if (host_map != null && (rewrite = (String)host_map.get(url.getHost())) != null) {
            String str = url.toExternalForm();
            try {
                int pos = str.indexOf("//") + 2;
                int pos2 = str.indexOf("/", pos);
                String host_bit = str.substring(pos, pos2);
                int pos3 = host_bit.indexOf(58);
                String port_bit = pos3 == -1 ? "" : host_bit.substring(pos3);
                String new_str = str.substring(0, pos) + rewrite + port_bit + str.substring(pos2);
                url = new URL(new_str);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return url;
    }

    public static synchronized void addHostRedirect(String from_host, String to_host) {
        System.out.println("AddressUtils::addHostRedirect - " + from_host + " -> " + to_host);
        HashMap<String, String> new_map = host_map == null ? new HashMap<String, String>() : new HashMap(host_map);
        new_map.put(from_host, to_host);
        host_map = new_map;
    }

    public static InetSocketAddress adjustTCPAddress(InetSocketAddress address, boolean ext_to_lan) {
        return AddressUtils.adjustAddress(address, ext_to_lan, 1);
    }

    public static InetSocketAddress adjustUDPAddress(InetSocketAddress address, boolean ext_to_lan) {
        return AddressUtils.adjustAddress(address, ext_to_lan, 2);
    }

    public static InetSocketAddress adjustDHTAddress(InetSocketAddress address, boolean ext_to_lan) {
        return AddressUtils.adjustAddress(address, ext_to_lan, 3);
    }

    private static InetSocketAddress adjustAddress(InetSocketAddress address, boolean ext_to_lan, int port_type) {
        if (instance_manager == null) {
            try {
                instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (instance_manager == null || !instance_manager.isInitialized()) {
            return address;
        }
        InetSocketAddress adjusted_address = ext_to_lan ? instance_manager.getLANAddress(address, port_type) : instance_manager.getExternalAddress(address, port_type);
        if (adjusted_address == null) {
            adjusted_address = address;
        }
        return adjusted_address;
    }

    public static List getLANAddresses(String address) {
        ArrayList<String> result;
        block8: {
            result = new ArrayList<String>();
            result.add(address);
            try {
                InetAddress ad = InetAddress.getByName(address);
                if (AddressUtils.isLANLocalAddress(address) == 2) break block8;
                if (instance_manager == null) {
                    try {
                        instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                if (instance_manager == null || !instance_manager.isInitialized()) {
                    return result;
                }
                AZInstance[] instances = instance_manager.getOtherInstances();
                for (int i = 0; i < instances.length; ++i) {
                    AZInstance instance = instances[i];
                    List addresses = instance.getInternalAddresses();
                    if (!addresses.contains(ad)) continue;
                    for (int j = 0; j < addresses.size(); ++j) {
                        InetAddress ia = (InetAddress)addresses.get(j);
                        String str = ia.getHostAddress();
                        if (result.contains(str)) continue;
                        result.add(str);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public static byte isLANLocalAddress(InetSocketAddress socket_address) {
        InetAddress address = socket_address.getAddress();
        return AddressUtils.isLANLocalAddress(address);
    }

    public static byte isLANLocalAddress(InetAddress address) {
        if (address == null) {
            return 2;
        }
        if (instance_manager == null && AzureusCoreFactory.isCoreAvailable()) {
            try {
                instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (instance_manager == null || !instance_manager.isInitialized()) {
            return 0;
        }
        return instance_manager.isLANAddress(address) ? (byte)1 : 2;
    }

    public static byte isLANLocalAddress(String address) {
        byte is_lan_local = 0;
        try {
            is_lan_local = AddressUtils.isLANLocalAddress(HostNameToIPResolver.syncResolve(address));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return is_lan_local;
    }

    static {
        host_map = null;
    }
}

