/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.LinkedList;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;

public class AsyncDispatcher {
    private AEThread2 thread;
    private LinkedList queue = new LinkedList();
    private AESemaphore queue_sem = new AESemaphore("AsyncDispatcher");
    private int quiesce_after_millis;

    public AsyncDispatcher() {
        this(10000);
    }

    public AsyncDispatcher(int _quiesce_after_millis) {
        this.quiesce_after_millis = _quiesce_after_millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(AERunnable target) {
        AsyncDispatcher asyncDispatcher = this;
        synchronized (asyncDispatcher) {
            this.queue.add(target);
            if (this.thread == null) {
                this.thread = new AEThread2("AsyncDispatcher", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        while (true) {
                            AsyncDispatcher.this.queue_sem.reserve(AsyncDispatcher.this.quiesce_after_millis);
                            AERunnable to_run = null;
                            AsyncDispatcher asyncDispatcher = AsyncDispatcher.this;
                            synchronized (asyncDispatcher) {
                                if (AsyncDispatcher.this.queue.isEmpty()) {
                                    AsyncDispatcher.this.thread = null;
                                    break;
                                }
                                to_run = (AERunnable)AsyncDispatcher.this.queue.removeFirst();
                            }
                            try {
                                to_run.runSupport();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                };
                this.thread.start();
            }
        }
        this.queue_sem.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        AsyncDispatcher asyncDispatcher = this;
        synchronized (asyncDispatcher) {
            return this.queue.size();
        }
    }
}

