/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.unix;

import java.io.File;
import java.net.InetAddress;
import java.util.HashSet;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerListener;
import org.gudy.azureus2.platform.PlatformManagerPingCallback;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class PlatformManagerImpl
implements PlatformManager {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final String ERR_UNSUPPORTED = "Unsupported capability called on platform manager";
    protected static PlatformManagerImpl singleton;
    protected static AEMonitor class_mon;
    private final HashSet capabilitySet = new HashSet();
    private static final Object migrate_lock;

    public static PlatformManagerImpl getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeSingleton() {
        try {
            class_mon.enter();
            singleton = new PlatformManagerImpl();
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Failed to initialize platform manager for Unix Compatable OS", e));
        }
        finally {
            class_mon.exit();
        }
    }

    public PlatformManagerImpl() {
        this.capabilitySet.add(PlatformManagerCapabilities.GetUserDataDirectory);
    }

    public void copyFilePermissions(String from_file_name, String to_file_name) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public void createProcess(String command_line, boolean inherit_handles) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public void dispose() {
    }

    public String getApplicationCommandLine() throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public int getPlatformType() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserDataDirectory() throws PlatformManagerException {
        String userhome = System.getProperty("user.home");
        String temp_user_path = userhome + SystemProperties.SEP + "." + SystemProperties.APPLICATION_NAME.toLowerCase() + SystemProperties.SEP;
        Object object = migrate_lock;
        synchronized (object) {
            String old_home_path;
            File old_home;
            File home = new File(temp_user_path);
            if (!home.exists() && (old_home = new File(old_home_path = userhome + SystemProperties.SEP + "." + SystemProperties.APPLICATION_NAME + SystemProperties.SEP)).exists()) {
                String msg = "Migrating unix user config dir [" + old_home_path + "] ===> [" + temp_user_path + "]";
                System.out.println(msg);
                Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath(Unix): " + msg));
                try {
                    old_home.renameTo(home);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    Logger.log(new LogEvent(LOGID, "migration rename failed:", t));
                }
            }
        }
        return temp_user_path;
    }

    public String getVersion() throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public boolean hasCapability(PlatformManagerCapabilities capability) {
        return this.capabilitySet.contains(capability);
    }

    public boolean isApplicationRegistered() throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public void performRecoverableFileDelete(String file_name) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public void ping(InetAddress interface_address, InetAddress target, PlatformManagerPingCallback callback) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public void registerApplication() throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public void addListener(PlatformManagerListener listener) {
    }

    public void removeListener(PlatformManagerListener listener) {
    }

    public void setTCPTOSEnabled(boolean enabled) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public boolean testNativeAvailability(String name) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public void traceRoute(InetAddress interface_address, InetAddress target, PlatformManagerPingCallback callback) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public File getLocation(long location_id) throws PlatformManagerException {
        switch ((int)location_id) {
            case 1: {
                return new File(this.getUserDataDirectory());
            }
            case 3: {
                return new File(System.getProperty("user.home"));
            }
        }
        return null;
    }

    public boolean isAdditionalFileTypeRegistered(String name, String type) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public void registerAdditionalFileType(String name, String description, String type, String content_type) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public void showFile(String file_name) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public void unregisterAdditionalFileType(String name, String type) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public String getAzComputerID() throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public void requestUserAttention(int type, Object data) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    static {
        class_mon = new AEMonitor("PlatformManager");
        migrate_lock = new Object();
        PlatformManagerImpl.initializeSingleton();
    }
}

